/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00052\u0006\u0010\t\u001a\u0002H\u0005H\u0007\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0007\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0002J'\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0007\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/KtAssert;", "", "()V", "assertEquals", "", "T", "message", "", "expected", "actual", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "assertNotNull", "value", "assertNull", "assertTrue", "", "fail", "test-infrastructure-utils"})
public final class KtAssert {
    @NotNull
    public static final KtAssert INSTANCE = new KtAssert();

    private KtAssert() {
    }

    @JvmStatic
    public static final void fail(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new AssertionError((Object)message);
    }

    @JvmStatic
    public static final void assertNotNull(@NotNull String message, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value2 == null) {
            KtAssert.fail(message);
        }
    }

    @JvmStatic
    public static final void assertNull(@NotNull String message, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value2 != null) {
            KtAssert.fail(message);
        }
    }

    @JvmStatic
    public static final void assertTrue(@NotNull String message, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!value2) {
            KtAssert.fail(message);
        }
    }

    @JvmStatic
    public static final <T> void assertEquals(@NotNull String message, T expected, T actual) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Intrinsics.areEqual(expected, actual)) {
            KtAssert.fail(message);
        }
    }
}

