/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReceiver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceAdaptation;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.InputOutputTypes;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.SuspendConversionStrategy;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.model.AdaptedCallableReferenceIsUsedWithReflection;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceResolutionAtom;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferencesDefaultArgumentUsed;
import org.jetbrains.kotlin.resolve.calls.model.FakeKotlinCallArgumentForCallableReference;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NotCallableMemberReference;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenDescriptor;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.RecursiveCallableReferenceType;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.util.ErrorCandidateReason;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedType;
import org.jetbrains.kotlin.types.error.ErrorScope;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.error.LazyWrappedTypeComputationException;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001SB9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJN\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J&\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\"\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u0010#\u001a\u0004\u0018\u000103H\u0016J\"\u00104\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u0010#\u001a\u0004\u0018\u000103H\u0002J\u0010\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000207H\u0016J.\u00108\u001a\b\u0012\u0004\u0012\u000209022\u0006\u0010 \u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020<H\u0002J0\u0010@\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u0010#\u001a\u0004\u0018\u0001032\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020BH\u0002J,\u0010C\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020:2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010?\u001a\u00020<2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010D\u001a\u00020'2\u0006\u0010E\u001a\u00020\u001fH\u0002J\u001a\u0010F\u001a\u00020'2\b\u0010E\u001a\u0004\u0018\u00010\u001f2\u0006\u0010G\u001a\u00020!H\u0002J\u0018\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u0002032\u0006\u0010J\u001a\u00020'H\u0002J6\u0010K\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010L\u0012\u0004\u0012\u00020M0\u001e2\u0006\u0010N\u001a\u00020L2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020M2\u0006\u0010$\u001a\u00020%H\u0002J\f\u0010R\u001a\u00020'*\u00020LH\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferencesCandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/CallableReferenceResolutionCandidate;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceResolutionAtom;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "baseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "(Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceResolutionAtom;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;)V", "getCallComponents", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/UnwrappedType;", "getKotlinCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceResolutionAtom;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "asReceiverValueForVisibilityChecks", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;", "getAsReceiverValueForVisibilityChecks", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "buildReflectionType", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceAdaptation;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "dispatchReceiver", "extensionReceiver", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "buildTypeWithConversions", "", "createCallableProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/SimpleScopeTowerProcessor;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/DetailedReceiver;", "createCandidate", "towerCandidate", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "extensionReceiverCandidates", "", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "createCandidateInternal", "createErrorCandidate", "reason", "Lorg/jetbrains/kotlin/resolve/calls/util/ErrorCandidateReason;", "createFakeArgumentsForReference", "Lorg/jetbrains/kotlin/resolve/calls/model/FakeKotlinCallArgumentForCallableReference;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expectedArgumentCount", "", "inputOutputTypes", "Lorg/jetbrains/kotlin/resolve/calls/components/InputOutputTypes;", "unboundReceiverCount", "createRecursionTolerantCandidate", "onRecursion", "Lkotlin/Function0;", "getCallableReferenceAdaptation", "hasNonTrivialAdaptation", "callableReferenceAdaptation", "needCompatibilityResolveForCallableReference", "candidate", "toCallableReceiver", "receiver", "isExplicit", "varargParameterTypeByExpectedParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferencesCandidateFactory$VarargMappingState;", "expectedParameterType", "substitutedParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "varargMappingState", "isErrorRecursiveType", "VarargMappingState", "resolution"})
public final class CallableReferencesCandidateFactory
implements CandidateFactory<CallableReferenceResolutionCandidate> {
    @NotNull
    private final CallableReferenceResolutionAtom kotlinCall;
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @Nullable
    private final UnwrappedType expectedType;
    @Nullable
    private final ConstraintStorage baseSystem;
    @NotNull
    private final KotlinResolutionCallbacks resolutionCallbacks;

    public CallableReferencesCandidateFactory(@NotNull CallableReferenceResolutionAtom kotlinCall, @NotNull KotlinCallComponents callComponents, @NotNull ImplicitScopeTower scopeTower, @Nullable UnwrappedType expectedType, @Nullable ConstraintStorage baseSystem, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkNotNullParameter((Object)kotlinCall, (String)"kotlinCall");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        this.kotlinCall = kotlinCall;
        this.callComponents = callComponents;
        this.scopeTower = scopeTower;
        this.expectedType = expectedType;
        this.baseSystem = baseSystem;
        this.resolutionCallbacks = resolutionCallbacks;
    }

    @NotNull
    public final CallableReferenceResolutionAtom getKotlinCall() {
        return this.kotlinCall;
    }

    @NotNull
    public final KotlinCallComponents getCallComponents() {
        return this.callComponents;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @Nullable
    public final UnwrappedType getExpectedType() {
        return this.expectedType;
    }

    private final ReceiverValue getAsReceiverValueForVisibilityChecks(CallableReceiver $this$asReceiverValueForVisibilityChecks) {
        return $this$asReceiverValueForVisibilityChecks.getReceiver().getReceiverValue();
    }

    @Override
    @NotNull
    public CallableReferenceResolutionCandidate createErrorCandidate(@NotNull ErrorCandidateReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        String[] stringArray = new String[]{this.kotlinCall.toString()};
        ErrorScope errorScope = ErrorUtils.createErrorScope(ErrorScopeKind.SCOPE_FOR_ERROR_RESOLUTION_CANDIDATE, stringArray);
        SimpleFunctionDescriptor errorDescriptor = (SimpleFunctionDescriptor)CollectionsKt.first((Iterable)errorScope.getContributedFunctions(this.kotlinCall.getRhsName(), this.scopeTower.getLocation()));
        Pair<UnwrappedType, CallableReferenceAdaptation> pair = this.buildReflectionType(errorDescriptor, null, null, this.expectedType, this.callComponents.getBuiltIns(), this.kotlinCall instanceof CallableReferenceKotlinCallArgument);
        UnwrappedType reflectionCandidateType = (UnwrappedType)pair.component1();
        CallableReferenceAdaptation callableReferenceAdaptation = (CallableReferenceAdaptation)pair.component2();
        CallableReferenceResolutionCandidate candidate2 = new CallableReferenceResolutionCandidate(errorDescriptor, null, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, reflectionCandidateType, callableReferenceAdaptation, this.kotlinCall, this.expectedType, this.callComponents, this.scopeTower, this.resolutionCallbacks, this.baseSystem);
        switch (WhenMappings.$EnumSwitchMapping$0[reason.ordinal()]) {
            case 1: {
                candidate2.addDiagnostic(RecursiveCallableReferenceType.INSTANCE);
            }
        }
        return candidate2;
    }

    private final boolean isErrorRecursiveType(KotlinType $this$isErrorRecursiveType) {
        KotlinType unwrapped = $this$isErrorRecursiveType instanceof WrappedType && ((WrappedType)$this$isErrorRecursiveType).isComputed() ? (KotlinType)$this$isErrorRecursiveType.unwrap() : $this$isErrorRecursiveType;
        return unwrapped instanceof ErrorType && ((ErrorType)unwrapped).getKind() == ErrorTypeKind.RECURSIVE_TYPE;
    }

    private final CallableReferenceResolutionCandidate createCandidateInternal(CandidateWithBoundDispatchReceiver towerCandidate, ExplicitReceiverKind explicitReceiverKind, ReceiverValueWithSmartCastInfo extensionReceiver) {
        CallableReceiver callableReceiver;
        CallableReceiver callableReceiver2;
        ReceiverValueWithSmartCastInfo it;
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = towerCandidate.getDispatchReceiver();
        if (receiverValueWithSmartCastInfo != null) {
            it = receiverValueWithSmartCastInfo;
            boolean bl = false;
            callableReceiver2 = this.toCallableReceiver(it, explicitReceiverKind == ExplicitReceiverKind.DISPATCH_RECEIVER);
        } else {
            callableReceiver2 = null;
        }
        CallableReceiver dispatchCallableReceiver = callableReceiver2;
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo2 = extensionReceiver;
        if (receiverValueWithSmartCastInfo2 != null) {
            it = receiverValueWithSmartCastInfo2;
            boolean bl = false;
            callableReceiver = this.toCallableReceiver(it, explicitReceiverKind == ExplicitReceiverKind.EXTENSION_RECEIVER);
        } else {
            callableReceiver = null;
        }
        CallableReceiver extensionCallableReceiver = callableReceiver;
        CallableDescriptor candidateDescriptor = towerCandidate.getDescriptor();
        SmartList<KotlinCallDiagnostic> diagnostics2 = new SmartList<KotlinCallDiagnostic>();
        Pair<UnwrappedType, CallableReferenceAdaptation> pair = this.buildReflectionType(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, this.expectedType, this.callComponents.getBuiltIns(), this.kotlinCall instanceof CallableReferenceKotlinCallArgument);
        UnwrappedType reflectionCandidateType = (UnwrappedType)pair.component1();
        CallableReferenceAdaptation callableReferenceAdaptation = (CallableReferenceAdaptation)pair.component2();
        if (this.callComponents.getStatelessCallbacks().isHiddenInResolution((DeclarationDescriptor)candidateDescriptor, this.kotlinCall.getCall(), this.resolutionCallbacks)) {
            diagnostics2.add(HiddenDescriptor.INSTANCE);
            return CallableReferencesCandidateFactory.createCandidateInternal$createCallableReferenceCallCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, this, (List<? extends KotlinCallDiagnostic>)diagnostics2);
        }
        if (this.needCompatibilityResolveForCallableReference(callableReferenceAdaptation, candidateDescriptor)) {
            ResolvedCallAtomsKt.markCandidateForCompatibilityResolve(this, diagnostics2);
        }
        if (callableReferenceAdaptation != null && this.expectedType != null && this.hasNonTrivialAdaptation(callableReferenceAdaptation) && !FunctionTypesKt.isFunctionType(this.expectedType) && !FunctionTypesKt.isSuspendFunctionType(this.expectedType)) {
            diagnostics2.add(new AdaptedCallableReferenceIsUsedWithReflection(this.kotlinCall));
        }
        if (callableReferenceAdaptation != null && callableReferenceAdaptation.getDefaults() != 0 && !this.callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.FunctionReferenceWithDefaultValueAsOtherType)) {
            diagnostics2.add(new CallableReferencesDefaultArgumentUsed(this.kotlinCall, candidateDescriptor, callableReferenceAdaptation.getDefaults()));
        }
        if (!(candidateDescriptor instanceof CallableMemberDescriptor)) {
            return CallableReferencesCandidateFactory.createCandidateInternal$createCallableReferenceCallCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, this, CollectionsKt.listOf((Object)new NotCallableMemberReference(this.kotlinCall, candidateDescriptor)));
        }
        diagnostics2.addAll((Collection<KotlinCallDiagnostic>)towerCandidate.getDiagnostics());
        return CallableReferencesCandidateFactory.createCandidateInternal$createCallableReferenceCallCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, this, (List<? extends KotlinCallDiagnostic>)diagnostics2);
    }

    @Override
    @NotNull
    public CallableReferenceResolutionCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable ReceiverValueWithSmartCastInfo extensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)towerCandidate, (String)"towerCandidate");
        Intrinsics.checkNotNullParameter((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        return this.createRecursionTolerantCandidate(towerCandidate, explicitReceiverKind, extensionReceiver, (Function0<CallableReferenceResolutionCandidate>)((Function0)new Function0<CallableReferenceResolutionCandidate>(this){
            final /* synthetic */ CallableReferencesCandidateFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CallableReferenceResolutionCandidate invoke() {
                return this.this$0.createErrorCandidate(ErrorCandidateReason.TYPE_COMPUTATION_RECURSION);
            }
        }));
    }

    private final CallableReferenceResolutionCandidate createRecursionTolerantCandidate(CandidateWithBoundDispatchReceiver towerCandidate, ExplicitReceiverKind explicitReceiverKind, ReceiverValueWithSmartCastInfo extensionReceiver, Function0<CallableReferenceResolutionCandidate> onRecursion) {
        CallableReferenceResolutionCandidate callableReferenceResolutionCandidate;
        try {
            CallableReferenceResolutionCandidate resolutionCandidate = this.createCandidateInternal(towerCandidate, explicitReceiverKind, extensionReceiver);
            KotlinType returnType2 = resolutionCandidate.getCandidate().getReturnType();
            callableReferenceResolutionCandidate = returnType2 == null || !this.isErrorRecursiveType(returnType2) ? resolutionCandidate : (CallableReferenceResolutionCandidate)onRecursion.invoke();
        }
        catch (LazyWrappedTypeComputationException e) {
            callableReferenceResolutionCandidate = (CallableReferenceResolutionCandidate)onRecursion.invoke();
        }
        return callableReferenceResolutionCandidate;
    }

    @Override
    @NotNull
    public CallableReferenceResolutionCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull List<ReceiverValueWithSmartCastInfo> extensionReceiverCandidates) {
        Intrinsics.checkNotNullParameter((Object)towerCandidate, (String)"towerCandidate");
        Intrinsics.checkNotNullParameter((Object)((Object)explicitReceiverKind), (String)"explicitReceiverKind");
        Intrinsics.checkNotNullParameter(extensionReceiverCandidates, (String)"extensionReceiverCandidates");
        throw new IllegalStateException((Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + " doesn't support candidates with multiple extension receiver candidates").toString());
    }

    @NotNull
    public final SimpleScopeTowerProcessor<CallableReferenceResolutionCandidate> createCallableProcessor(@Nullable DetailedReceiver explicitReceiver) {
        return ScopeTowerProcessorsKt.createCallableReferenceProcessor(this.scopeTower, this.kotlinCall.getRhsName(), this, explicitReceiver);
    }

    private final boolean needCompatibilityResolveForCallableReference(CallableReferenceAdaptation callableReferenceAdaptation, CallableDescriptor candidate2) {
        DeclarationDescriptor declarationDescriptor = candidate2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"candidate.containingDeclaration");
        if (DescriptorUtilsKt.isCompanionObject(declarationDescriptor) && this.kotlinCall.getLhsResult() instanceof LHSResult.Type) {
            return true;
        }
        if (callableReferenceAdaptation == null) {
            return false;
        }
        return this.hasNonTrivialAdaptation(callableReferenceAdaptation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNonTrivialAdaptation(CallableReferenceAdaptation callableReferenceAdaptation) {
        ResolvedCallArgument it;
        if (callableReferenceAdaptation.getDefaults() != 0) return true;
        if (callableReferenceAdaptation.getSuspendConversionStrategy() != SuspendConversionStrategy.NO_CONVERSION) return true;
        if (callableReferenceAdaptation.getCoercionStrategy() != CoercionStrategy.NO_COERCION) return true;
        Iterable $this$any$iv = callableReferenceAdaptation.getMappedArguments().values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ResolvedCallArgument)element$iv;
            boolean bl = false;
        } while (!(it instanceof ResolvedCallArgument.VarargArgument));
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final CallableReferenceAdaptation getCallableReferenceAdaptation(FunctionDescriptor descriptor, UnwrappedType expectedType, int unboundReceiverCount, KotlinBuiltIns builtins) {
        block25: {
            block24: {
                if (expectedType == null || TypeUtils.noExpectedType(expectedType)) {
                    return null;
                }
                if (ReflectionTypes.Companion.hasKCallableTypeFqName(expectedType)) {
                    return null;
                }
                v0 = CallableReferenceResolutionKt.extractInputOutputTypesFromCallableReferenceExpectedType(expectedType);
                if (v0 == null) {
                    return null;
                }
                inputOutputTypes = v0;
                expectedArgumentCount = inputOutputTypes.getInputTypes().size() - unboundReceiverCount;
                if (expectedArgumentCount < 0) {
                    return null;
                }
                fakeArguments = this.createFakeArgumentsForReference(descriptor, expectedArgumentCount, inputOutputTypes, unboundReceiverCount);
                argumentMapping = this.callComponents.getArgumentsToParametersMapper().mapArguments(fakeArguments, null, descriptor);
                $this$any$iv = argumentMapping.getDiagnostics();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (KotlinCallDiagnostic)element$iv;
                        $i$a$-any-CallableReferencesCandidateFactory$getCallableReferenceAdaptation$1 = false;
                        if (!(CandidateApplicabilityKt.isSuccess(it.getCandidateApplicability()) == false)) continue;
                        v1 = true;
                        break block24;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                return null;
            }
            defaults = 0;
            varargMappingState = VarargMappingState.UNMAPPED;
            mappedArguments = new LinkedHashMap<ValueParameterDescriptor, ResolvedCallArgument.VarargArgument>();
            mappedVarargElements = new LinkedHashMap<K, V>();
            mappedArgumentTypes = new KotlinType[fakeArguments.size()];
            for (Map.Entry<ValueParameterDescriptor, ResolvedCallArgument> var15_18 : argumentMapping.getParameterToCallArgumentMap().entrySet()) {
                valueParameter = var15_18.getKey();
                resolvedArgument = var15_18.getValue();
                for (KotlinCallArgument fakeArgument : resolvedArgument.getArguments()) {
                    Intrinsics.checkNotNull((Object)fakeArgument, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.FakeKotlinCallArgumentForCallableReference");
                    index = ((FakeKotlinCallArgumentForCallableReference)fakeArgument).getIndex();
                    v2 = descriptor.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"descriptor.valueParameters");
                    if ((ValueParameterDescriptor)CollectionsKt.getOrNull(v2, (int)valueParameter.getIndex()) == null) continue;
                    mappedArgument = null;
                    if (ArgumentsUtilsKt.isVararg(substitutedParameter)) {
                        var23_36 = this.varargParameterTypeByExpectedParameter(inputOutputTypes.getInputTypes().get(index + unboundReceiverCount), substitutedParameter, varargMappingState, builtins);
                        varargType = (KotlinType)var23_36.component1();
                        varargMappingState = newVarargMappingState = (VarargMappingState)var23_36.component2();
                        mappedArgument = varargType;
                        switch (WhenMappings.$EnumSwitchMapping$1[newVarargMappingState.ordinal()]) {
                            case 1: {
                                ((Map)mappedArguments).put(valueParameter, new ResolvedCallArgument.SimpleArgument(fakeArgument));
                                break;
                            }
                            case 2: {
                                $this$getOrPut$iv = mappedVarargElements;
                                $i$f$getOrPut = false;
                                value$iv = $this$getOrPut$iv.get(valueParameter);
                                if (value$iv == null) {
                                    $i$a$-getOrPut-CallableReferencesCandidateFactory$getCallableReferenceAdaptation$2 = false;
                                    answer$iv = new ArrayList<E>();
                                    $this$getOrPut$iv.put(valueParameter, answer$iv);
                                    v3 /* !! */  = answer$iv;
                                } else {
                                    v3 /* !! */  = value$iv;
                                }
                                ((List)v3 /* !! */ ).add(fakeArgument);
                            }
                        }
                    } else {
                        mappedArgument = substitutedParameter.getType();
                        ((Map)mappedArguments).put(valueParameter, resolvedArgument);
                    }
                    mappedArgumentTypes[index] = mappedArgument;
                }
                if (!Intrinsics.areEqual((Object)resolvedArgument, (Object)ResolvedCallArgument.DefaultArgument.INSTANCE)) continue;
                ++defaults;
                ((Map)mappedArguments).put(valueParameter, resolvedArgument);
            }
            $this$any$iv = mappedArgumentTypes;
            $i$f$any = false;
            resolvedArgument = $this$any$iv.length;
            for (valueParameter = 0; valueParameter < resolvedArgument; ++valueParameter) {
                it = element$iv = $this$any$iv[valueParameter];
                $i$a$-any-CallableReferencesCandidateFactory$getCallableReferenceAdaptation$3 = false;
                if (!(it == null)) continue;
                v4 = true;
                break block25;
            }
            v4 = false;
        }
        if (v4) {
            return null;
        }
        for (Map.Entry $i$f$any : ((Map)mappedVarargElements).entrySet()) {
            valueParameter = (ValueParameterDescriptor)$i$f$any.getKey();
            varargElements = (List)$i$f$any.getValue();
            ((Map)mappedArguments).put(valueParameter, new ResolvedCallArgument.VarargArgument(varargElements));
        }
        for (ValueParameterDescriptor valueParameter : descriptor.getValueParameters()) {
            Intrinsics.checkNotNullExpressionValue((Object)valueParameter, (String)"valueParameter");
            if (!ArgumentsUtilsKt.isVararg(valueParameter)) continue;
            mappedArguments.putIfAbsent(valueParameter.getOriginal(), new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
        }
        returnExpectedType = inputOutputTypes.getOutputType();
        if (!TypeUtilsKt.isUnit(returnExpectedType)) ** GOTO lbl-1000
        v5 = descriptor.getReturnType();
        v6 = v5 != null ? !TypeUtilsKt.isUnit(v5) : false;
        if (v6) {
            v7 = CoercionStrategy.COERCION_TO_UNIT;
        } else lbl-1000:
        // 2 sources

        {
            v7 = CoercionStrategy.NO_COERCION;
        }
        coercion = v7;
        adaptedArguments = ReflectionTypes.Companion.isBaseTypeForNumberedReferenceTypes(expectedType) != false ? MapsKt.emptyMap() : (Map)mappedArguments;
        suspendConversionStrategy = descriptor.isSuspend() == false && FunctionTypesKt.isSuspendFunctionType(expectedType) != false ? SuspendConversionStrategy.SUSPEND_CONVERSION : SuspendConversionStrategy.NO_CONVERSION;
        return new CallableReferenceAdaptation(mappedArgumentTypes, coercion, defaults, adaptedArguments, suspendConversionStrategy);
    }

    /*
     * Unable to fully structure code
     */
    private final List<FakeKotlinCallArgumentForCallableReference> createFakeArgumentsForReference(FunctionDescriptor descriptor, int expectedArgumentCount, InputOutputTypes inputOutputTypes, int unboundReceiverCount) {
        afterVararg = false;
        varargComponentType = null;
        vararg = false;
        $this$map$iv = (Iterable)RangesKt.until((int)0, (int)expectedArgumentCount);
        $i$f$map = false;
        var10_10 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        var13_13 = $this$mapTo$iv$iv.iterator();
        while (var13_13.hasNext()) {
            var15_15 = item$iv$iv = ((IntIterator)var13_13).nextInt();
            var20_20 = destination$iv$iv;
            $i$a$-map-CallableReferencesCandidateFactory$createFakeArgumentsForReference$1 = false;
            inputType = (UnwrappedType)CollectionsKt.getOrNull(inputOutputTypes.getInputTypes(), (int)(index + unboundReceiverCount));
            if (vararg && !Intrinsics.areEqual(varargComponentType, (Object)inputType)) {
                afterVararg = true;
            }
            v0 = descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"descriptor.valueParameters");
            valueParameter = (ValueParameterDescriptor)CollectionsKt.getOrNull(v0, (int)index);
            if (!afterVararg) ** GOTO lbl-1000
            v1 = valueParameter;
            v2 = v1 != null ? v1.declaresDefaultValue() : false;
            if (v2) {
                v3 = valueParameter.getName();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            name = v3;
            v4 = valueParameter;
            v5 = v4 != null ? ArgumentsUtilsKt.isVararg(v4) : false;
            if (v5) {
                varargComponentType = inputType;
                vararg = true;
            }
            var20_20.add(new FakeKotlinCallArgumentForCallableReference((int)index, name));
        }
        return (List)destination$iv$iv;
    }

    private final Pair<KotlinType, VarargMappingState> varargParameterTypeByExpectedParameter(KotlinType expectedParameterType, ValueParameterDescriptor substitutedParameter, VarargMappingState varargMappingState, KotlinBuiltIns builtins) {
        Pair pair;
        KotlinType kotlinType = substitutedParameter.getVarargElementType();
        if (kotlinType == null) {
            throw new IllegalStateException(("Vararg parameter " + substitutedParameter + " does not have vararg type").toString());
        }
        KotlinType elementType = kotlinType;
        switch (WhenMappings.$EnumSwitchMapping$1[varargMappingState.ordinal()]) {
            case 3: {
                if (KotlinBuiltIns.isArrayOrPrimitiveArray(expectedParameterType) || expectedParameterType.getConstructor() instanceof TypeVariableTypeConstructor) {
                    SimpleType simpleType2 = builtins.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType);
                    if (simpleType2 == null) {
                        simpleType2 = builtins.getArrayType(Variance.OUT_VARIANCE, elementType);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"builtins.getPrimitiveArr\u2026UT_VARIANCE, elementType)");
                    SimpleType arrayType = simpleType2;
                    pair = TuplesKt.to((Object)arrayType, (Object)((Object)VarargMappingState.MAPPED_WITH_ARRAY));
                    break;
                }
                pair = TuplesKt.to((Object)elementType, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                break;
            }
            case 2: {
                if (KotlinBuiltIns.isArrayOrPrimitiveArray(expectedParameterType)) {
                    pair = TuplesKt.to(null, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                    break;
                }
                pair = TuplesKt.to((Object)elementType, (Object)((Object)VarargMappingState.MAPPED_WITH_PLAIN_ARGS));
                break;
            }
            case 1: {
                pair = TuplesKt.to(null, (Object)((Object)VarargMappingState.MAPPED_WITH_ARRAY));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<UnwrappedType, CallableReferenceAdaptation> buildReflectionType(CallableDescriptor descriptor, CallableReceiver dispatchReceiver, CallableReceiver extensionReceiver, UnwrappedType expectedType, KotlinBuiltIns builtins, boolean buildTypeWithConversions) {
        block17: {
            block16: {
                argumentsAndReceivers = new ArrayList<UnwrappedType>(descriptor.getValueParameters().size() + 2 + descriptor.getContextReceiverParameters().size());
                v0 = descriptor.getContextReceiverParameters();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"descriptor.contextReceiverParameters");
                $this$map$iv = v0;
                $i$f$map = false;
                var11_11 = $this$map$iv;
                destination$iv$iv = (String[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var16_26 = (ReceiverParameterDescriptor)item$iv$iv;
                    var19_29 = destination$iv$iv;
                    $i$a$-map-CallableReferencesCandidateFactory$buildReflectionType$contextReceiversTypes$1 = false;
                    var19_29.add(it.getType());
                }
                contextReceiversTypes = (List)destination$iv$iv;
                argumentsAndReceivers.addAll(contextReceiversTypes);
                if (dispatchReceiver instanceof CallableReceiver.UnboundReference) {
                    argumentsAndReceivers.add(ArgumentsUtilsKt.getStableType(((CallableReceiver.UnboundReference)dispatchReceiver).getReceiver()));
                }
                if (extensionReceiver instanceof CallableReceiver.UnboundReference) {
                    argumentsAndReceivers.add(ArgumentsUtilsKt.getStableType(((CallableReceiver.UnboundReference)extensionReceiver).getReceiver()));
                }
                if ((v1 = descriptor.getReturnType()) == null) {
                    destination$iv$iv = new String[]{descriptor.toString()};
                    v1 = ErrorUtils.createErrorType(ErrorTypeKind.RETURN_TYPE, destination$iv$iv);
                }
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"descriptor.returnType\n  \u2026E, descriptor.toString())");
                descriptorReturnType = v1;
                var10_10 = descriptor;
                if (!(var10_10 instanceof PropertyDescriptor)) break block16;
                if (!((PropertyDescriptor)descriptor).isVar()) ** GOTO lbl-1000
                $this$buildReflectionType_u24lambda_u2d9 = this;
                $i$a$-run-CallableReferencesCandidateFactory$buildReflectionType$mutable$1 = false;
                setter = ((PropertyDescriptor)descriptor).getSetter();
                if (setter == null) ** GOTO lbl-1000
                v2 = dispatchReceiver;
                if (DescriptorVisibilities.isVisible(v2 != null ? $this$buildReflectionType_u24lambda_u2d9.getAsReceiverValueForVisibilityChecks(v2) : null, setter, $this$buildReflectionType_u24lambda_u2d9.scopeTower.getLexicalScope().getOwnerDescriptor(), false)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                mutable = v4;
                v5 = TuplesKt.to((Object)this.callComponents.getReflectionTypes().getKPropertyType(Annotations.Companion.getEMPTY(), (List<? extends KotlinType>)argumentsAndReceivers, descriptorReturnType, mutable), null);
                break block17;
            }
            if (var10_10 instanceof FunctionDescriptor) {
                callableReferenceAdaptation = this.getCallableReferenceAdaptation((FunctionDescriptor)descriptor, expectedType, argumentsAndReceivers.size(), builtins);
                if (callableReferenceAdaptation == null || !buildTypeWithConversions) {
                    v6 = ((FunctionDescriptor)descriptor).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(v6, (String)"descriptor.valueParameters");
                    $this$mapTo$iv = v6;
                    $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        $i$a$-map-CallableReferencesCandidateFactory$buildReflectionType$contextReceiversTypes$1 = (ValueParameterDescriptor)item$iv;
                        var19_29 = argumentsAndReceivers;
                        $i$a$-mapTo-CallableReferencesCandidateFactory$buildReflectionType$returnType$1 = false;
                        var19_29.add(it.getType());
                    }
                    (Collection)argumentsAndReceivers;
                    v7 = descriptorReturnType;
                } else {
                    arguments = callableReferenceAdaptation.getArgumentTypes();
                    coercion = callableReferenceAdaptation.getCoercionStrategy();
                    CollectionsKt.addAll((Collection)argumentsAndReceivers, (Object[])arguments);
                    if (coercion == CoercionStrategy.COERCION_TO_UNIT) {
                        v8 = DescriptorUtilsKt.getBuiltIns(descriptor).getUnitType();
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"descriptor.builtIns.unitType");
                        v7 = v8;
                    } else {
                        v7 = descriptorReturnType;
                    }
                }
                returnType = v7;
                v9 = callableReferenceAdaptation;
                suspendConversionStrategy = v9 != null ? v9.getSuspendConversionStrategy() : null;
                isSuspend = ((FunctionDescriptor)descriptor).isSuspend() != false || suspendConversionStrategy == SuspendConversionStrategy.SUSPEND_CONVERSION && buildTypeWithConversions != false;
                v5 = TuplesKt.to((Object)this.callComponents.getReflectionTypes().getKFunctionType(Annotations.Companion.getEMPTY(), null, CollectionsKt.emptyList(), (List<? extends KotlinType>)argumentsAndReceivers, null, returnType, DescriptorUtilsKt.getBuiltIns(descriptor), isSuspend), (Object)callableReferenceAdaptation);
            } else {
                v10 = var11_13 = DescriptorUtilKt.isSupportedForCallableReference(descriptor) == false;
                if (_Assertions.ENABLED && !var11_13) {
                    $i$a$-assert-CallableReferencesCandidateFactory$buildReflectionType$1 = false;
                    var12_17 = Reflection.getOrCreateKotlinClass(descriptor.getClass()) + " isn't supported to use in callable references actually, but it's listed in `isSupportedForCallableReference` method";
                    throw new AssertionError((Object)var12_17);
                }
                var11_14 = new String[]{descriptor.toString()};
                v5 = TuplesKt.to((Object)ErrorUtils.createErrorType(ErrorTypeKind.UNSUPPORTED_CALLABLE_REFERENCE_TYPE, var11_14), null);
            }
        }
        return v5;
    }

    static /* synthetic */ Pair buildReflectionType$default(CallableReferencesCandidateFactory callableReferencesCandidateFactory, CallableDescriptor callableDescriptor, CallableReceiver callableReceiver, CallableReceiver callableReceiver2, UnwrappedType unwrappedType, KotlinBuiltIns kotlinBuiltIns, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return callableReferencesCandidateFactory.buildReflectionType(callableDescriptor, callableReceiver, callableReceiver2, unwrappedType, kotlinBuiltIns, bl);
    }

    private final CallableReceiver toCallableReceiver(ReceiverValueWithSmartCastInfo receiver, boolean isExplicit) {
        CallableReceiver callableReceiver;
        if (!isExplicit) {
            return new CallableReceiver.ScopeReceiver(receiver);
        }
        LHSResult lhsResult = this.kotlinCall.getLhsResult();
        if (lhsResult instanceof LHSResult.Expression) {
            callableReceiver = new CallableReceiver.ExplicitValueReceiver(receiver);
        } else if (lhsResult instanceof LHSResult.Type) {
            Receiver receiver2 = ((LHSResult.Type)lhsResult).getQualifier();
            callableReceiver = Intrinsics.areEqual((Object)(receiver2 != null && (receiver2 = receiver2.getClassValueReceiver()) != null ? receiver2.getType() : null), (Object)receiver.getReceiverValue().getType()) ? (CallableReceiver)new CallableReceiver.BoundValueReference(receiver) : (CallableReceiver)new CallableReceiver.UnboundReference(receiver);
        } else if (lhsResult instanceof LHSResult.Object) {
            callableReceiver = new CallableReceiver.BoundValueReference(receiver);
        } else {
            throw new IllegalStateException("Unsupported kind of lhsResult: " + lhsResult);
        }
        return callableReceiver;
    }

    private static final CallableReferenceResolutionCandidate createCandidateInternal$createCallableReferenceCallCandidate(CallableDescriptor candidateDescriptor, CallableReceiver dispatchCallableReceiver, CallableReceiver extensionCallableReceiver, ExplicitReceiverKind $explicitReceiverKind, UnwrappedType reflectionCandidateType, CallableReferenceAdaptation callableReferenceAdaptation, CallableReferencesCandidateFactory this$0, List<? extends KotlinCallDiagnostic> diagnostics2) {
        CallableReferenceResolutionCandidate callableReferenceResolutionCandidate;
        CallableReferenceResolutionCandidate it = callableReferenceResolutionCandidate = new CallableReferenceResolutionCandidate(candidateDescriptor, dispatchCallableReceiver, extensionCallableReceiver, $explicitReceiverKind, reflectionCandidateType, callableReferenceAdaptation, this$0.kotlinCall, this$0.expectedType, this$0.callComponents, this$0.scopeTower, this$0.resolutionCallbacks, this$0.baseSystem);
        boolean bl = false;
        Iterable $this$forEach$iv = diagnostics2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallDiagnostic p0 = (KotlinCallDiagnostic)element$iv;
            boolean bl2 = false;
            it.addDiagnostic(p0);
        }
        return callableReferenceResolutionCandidate;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferencesCandidateFactory$VarargMappingState;", "", "(Ljava/lang/String;I)V", "UNMAPPED", "MAPPED_WITH_PLAIN_ARGS", "MAPPED_WITH_ARRAY", "resolution"})
    private static final class VarargMappingState
    extends Enum<VarargMappingState> {
        public static final /* enum */ VarargMappingState UNMAPPED = new VarargMappingState();
        public static final /* enum */ VarargMappingState MAPPED_WITH_PLAIN_ARGS = new VarargMappingState();
        public static final /* enum */ VarargMappingState MAPPED_WITH_ARRAY = new VarargMappingState();
        private static final /* synthetic */ VarargMappingState[] $VALUES;

        public static VarargMappingState[] values() {
            return (VarargMappingState[])$VALUES.clone();
        }

        public static VarargMappingState valueOf(String value2) {
            return Enum.valueOf(VarargMappingState.class, value2);
        }

        static {
            $VALUES = varargMappingStateArray = new VarargMappingState[]{VarargMappingState.UNMAPPED, VarargMappingState.MAPPED_WITH_PLAIN_ARGS, VarargMappingState.MAPPED_WITH_ARRAY};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ErrorCandidateReason.values().length];
            nArray[ErrorCandidateReason.TYPE_COMPUTATION_RECURSION.ordinal()] = 1;
            nArray[ErrorCandidateReason.OTHER.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VarargMappingState.values().length];
            nArray[VarargMappingState.MAPPED_WITH_ARRAY.ordinal()] = 1;
            nArray[VarargMappingState.MAPPED_WITH_PLAIN_ARGS.ordinal()] = 2;
            nArray[VarargMappingState.UNMAPPED.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

