/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u001c\u0010\u001a\u001a\u00020\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002012\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002072\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u0010\t\u001a\u0002092\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020;2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0014\u0010<\u001a\u00020=*\u00020\u00032\u0006\u0010>\u001a\u00020?H\u0002J\f\u0010@\u001a\u00020=*\u00020AH\u0002\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "binaryOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "operator", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "data", "postfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "prefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "toDoubleConst", "", "f", "", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "context", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isThisReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
public final class IrElementToJsExpressionTransformer
implements BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    private final boolean isClassInlineLike(JsGenerationContext $this$isClassInlineLike, IrClass irClass2) {
        return $this$isClassInlineLike.getStaticContext().getBackendContext().getInlineClassesUtils().isClassInlineLike(irClass2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int size = expression2.getStatements().size();
        if (size == 0) {
            String string2 = "Empty IrComposite is not supported";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        JsExpression first = (JsExpression)expression2.getStatements().get(0).accept(this, data);
        if (size == 1) {
            return first;
        }
        Iterable $this$fold$iv = expression2.getStatements();
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = first;
        for (Object element$iv : $this$fold$iv) {
            void right;
            IrStatement irStatement = (IrStatement)element$iv;
            JsExpression left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.COMMA, left, (JsExpression)right.accept(this, data));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        boolean $this$none$iv2;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$none$iv2 = expression2.getElements();
            boolean $i$f$none = false;
            if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv2) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = $this$none$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$none$iv2) {
            String $i$f$none = "Assertion failed";
            throw new AssertionError((Object)$i$f$none);
        }
        Iterable $this$map$iv = expression2.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsExpression)it.accept(this, context));
        }
        List list2 = (List)destination$iv$iv;
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsArrayLiteral(list2), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (JsExpression)body2.getExpression().accept(this, context);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrSimpleFunction irFunction2 = expression2.getFunction();
        Object r = irFunction2.accept(new IrFunctionToJsTransformer(), context);
        JsFunction $this$visitFunctionExpression_u24lambda_u2d3 = (JsFunction)r;
        boolean bl = false;
        $this$visitFunctionExpression_u24lambda_u2d3.setName(null);
        return (JsExpression)r;
    }

    @Override
    @NotNull
    public JsExpression visitConst(@NotNull IrConst<?> expression2, @NotNull JsGenerationContext context) {
        JsLiteral.JsValueLiteral jsValueLiteral;
        IrConstKind<?> kind;
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrConstKind<?> irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            jsValueLiteral = new JsStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsValueLiteral = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            jsValueLiteral = new JsBooleanLiteral((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Byte) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else {
            if (irConstKind instanceof IrConstKind.Long) {
                CompilationExceptionKt.compilationException("Long const should have been lowered at this point", expression2);
                throw null;
            }
            if (irConstKind instanceof IrConstKind.Char) {
                CompilationExceptionKt.compilationException("Char const should have been lowered at this point", expression2);
                throw null;
            }
            if (irConstKind instanceof IrConstKind.Float) {
                jsValueLiteral = new JsDoubleLiteral(this.toDoubleConst(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                jsValueLiteral = new JsDoubleLiteral(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)jsValueLiteral, expression2, context);
    }

    private final double toDoubleConst(float f) {
        return Float.isInfinite(f) || Float.isNaN(f) ? (double)f : Double.parseDouble(String.valueOf(f));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context) {
        Sequence tail;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrExpression firstArgument = (IrExpression)CollectionsKt.firstOrNull(expression2.getArguments());
        Object object = firstArgument;
        Pair pair = (object != null && (object = ((IrExpression)object).getType()) != null ? IrTypePredicatesKt.isString((IrType)object) : false) ? new Pair(firstArgument.accept(this, context), (Object)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)expression2.getArguments()), (int)1)) : new Pair((Object)new JsStringLiteral(""), (Object)CollectionsKt.asSequence((Iterable)expression2.getArguments()));
        JsExpression head = (JsExpression)pair.component1();
        Sequence $this$fold$iv = tail = (Sequence)pair.component2();
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = head;
        for (Object element$iv : $this$fold$iv) {
            void irExpr;
            IrExpression irExpression = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept(this, context));
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrFieldSymbol symbol2 = expression2.getSymbol();
        IrField field2 = (IrField)symbol2.getOwner();
        IrDeclarationParent fieldParent = field2.getParent();
        if (fieldParent instanceof IrClass && IrUtilsKt.isEffectivelyExternal(field2)) {
            boolean bl = IrUtilsKt.isEnumClass((IrClass)fieldParent);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = RenderIrElementKt.render(field2) + " in non-external class " + RenderIrElementKt.render(fieldParent);
                throw new AssertionError((Object)string2);
            }
            Object object = expression2.getReceiver();
            if (object == null || (object = (JsExpression)object.accept(this, context)) == null) {
                CompilationExceptionKt.compilationException("Expect expression.receiver to not be null", expression2);
                throw null;
            }
            Object receiver = object;
            return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsNameRef(AnnotationUtilsKt.getJsNameOrKotlinName(field2).getIdentifier(), (JsExpression)receiver), expression2, context);
        }
        if (fieldParent instanceof IrClass && this.isClassInlineLike(context, (IrClass)fieldParent)) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            return (JsExpression)JsAstUtilsKt.withSource((JsNode)irExpression.accept(this, context), expression2, context);
        }
        JsName fieldName = context.getNameForField(field2);
        IrExpression irExpression = expression2.getReceiver();
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        if (this.isThisReceiver(owner)) {
            return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsThisRef(), expression2, context);
        }
        JsNode jsNode = JsAstUtilsKt.withSource((JsNode)context.getNameForValueDeclaration(owner).makeRef(), expression2, context);
        Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"context.getNameForValueD\u2026urce(expression, context)");
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrClass obj = (IrClass)expression2.getSymbol().getOwner();
        boolean bl2 = bl = obj.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = IrUtilsKt.isEffectivelyExternal(obj);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string3 = "Non external IrGetObjectValue must be lowered";
            throw new AssertionError((Object)string3);
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)context.getRefForExternalClass(obj), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        JsName fieldName = context.getNameForField(field2);
        String string2 = fieldName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fieldName.ident");
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(string2, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept(this, context);
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.jsAssignment(dest, source), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueDeclaration field2 = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context.getNameForValueDeclaration(field2));
        JsExpression value2 = (JsExpression)expression2.getValue().accept(this, context);
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsBinaryOperation(JsBinaryOperator.ASG, ref, value2), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsNameRef jsNameRef = context.getNameForConstructor((IrConstructor)expression2.getSymbol().getOwner()).makeRef();
        Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForConstr\u2026n.symbol.owner).makeRef()");
        JsNameRef classNameRef = jsNameRef;
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)classNameRef);
        boolean fromPrimary = context.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction2 = context.getCurrentFunction();
            Intrinsics.checkNotNull((Object)irFunction2);
            JsNameRef jsNameRef2 = context.getNameForValueDeclaration((IrDeclarationWithName)CollectionsKt.last(irFunction2.getValueParameters())).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"context.getNameForValueD\u2026ameters.last()).makeRef()");
            jsExpression = jsNameRef2;
        }
        JsExpression thisRef = jsExpression;
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context, this);
        IrConstructor constructor2 = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isClassInlineLike(context, IrUtilsKt.getParentAsClass(constructor2))) {
            boolean bl = constructor2.isPrimary();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Delegation to secondary inline constructors must be lowered into simple function calls";
                throw new AssertionError((Object)string2);
            }
            return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsBinaryOperation(JsBinaryOperator.ASG, thisRef, (JsExpression)CollectionsKt.single(arguments2)), expression2, context);
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)(context.getStaticContext().getBackendContext().getEs6mode() ? new JsInvocation((JsExpression)new JsNameRef("super"), arguments2) : new JsInvocation((JsExpression)callFuncRef, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)thisRef), (Iterable)arguments2))), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsNew jsNew;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context, this);
        IrClass klass = IrUtilsKt.getParentAsClass(function2);
        if (!(!this.isClassInlineLike(context, klass))) {
            boolean $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$22 = false;
            String $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$22 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$22.toString());
        }
        if (IrUtilsKt.isEffectivelyExternal(klass)) {
            JsNameRef refForExternalClass = context.getRefForExternalClass(klass);
            int varargParameterIndex = JsAstUtilsKt.varargParameterIndex(expression2.getSymbol().getOwner());
            if (varargParameterIndex == -1) {
                jsNew = new JsNew(refForExternalClass, arguments2);
            } else {
                JsExpression argumentsAsSingleArray = JsAstUtilsKt.argumentsWithVarargAsSingleArray(expression2, context, new JsNullLiteral(), arguments2, varargParameterIndex);
                JsExpression[] jsExpressionArray = new JsExpression[]{refForExternalClass, argumentsAsSingleArray};
                JsNew jsNew2 = new JsNew(new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef("bind", (JsExpression)new JsNameRef("Function"))), jsExpressionArray), CollectionsKt.emptyList());
                jsNew = jsNew2;
            }
        } else {
            JsNameRef jsNameRef = context.getNameForClass(klass).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForClass(klass).makeRef()");
            JsNameRef ref = jsNameRef;
            jsNew = new JsNew(ref, arguments2);
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)jsNew, expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.checkIfJsCode(expression2.getSymbol()) || context.checkIfAnnotatedWithJsFunc(expression2.getSymbol())) {
            return new JsCallTransformer(expression2, context).generateExpression();
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.translateCall(expression2, context, this), expression2, context);
    }

    @Override
    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrBranch lastBranch = (IrBranch)CollectionsKt.lastOrNull(expression2.getBranches());
        JsPrefixOperation implicitElse = lastBranch == null || !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(lastBranch) ? new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0)) : null;
        boolean bl2 = bl = implicitElse == null || IrTypePredicatesKt.isUnit(expression2.getType());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Non unit when-expression must have else branch";
            throw new AssertionError((Object)string2);
        }
        JsNode jsNode = JsAstUtilsKt.toJsNode(expression2, this, context, visitWhen.2.INSTANCE, (JsNode)implicitElse);
        Intrinsics.checkNotNull((Object)jsNode);
        return (JsExpression)jsNode;
    }

    @Override
    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()] != 1) {
            CompilationExceptionKt.compilationException("All type operator calls except REINTERPRET_CAST should be lowered at this point", expression2);
            throw null;
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)((JsExpression)expression2.getArgument().accept(this, data)), expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)JsAstUtilsKt.jsElementAccess(expression2.getMemberName(), (JsExpression)expression2.getReceiver().accept(this, data)), expression2, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                jsExpression = this.prefixOperation(JsUnaryOperator.POS, expression2, data);
                break;
            }
            case 2: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NEG, expression2, data);
                break;
            }
            case 3: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NOT, expression2, data);
                break;
            }
            case 4: {
                jsExpression = this.prefixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 5: {
                jsExpression = this.prefixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 6: {
                jsExpression = this.postfixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 7: {
                jsExpression = this.postfixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 8: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ADD, expression2, data);
                break;
            }
            case 9: {
                jsExpression = this.binaryOperation(JsBinaryOperator.SUB, expression2, data);
                break;
            }
            case 10: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MUL, expression2, data);
                break;
            }
            case 11: {
                jsExpression = this.binaryOperation(JsBinaryOperator.DIV, expression2, data);
                break;
            }
            case 12: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MOD, expression2, data);
                break;
            }
            case 13: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GT, expression2, data);
                break;
            }
            case 14: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LT, expression2, data);
                break;
            }
            case 15: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GTE, expression2, data);
                break;
            }
            case 16: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LTE, expression2, data);
                break;
            }
            case 17: {
                jsExpression = this.binaryOperation(JsBinaryOperator.EQ, expression2, data);
                break;
            }
            case 18: {
                jsExpression = this.binaryOperation(JsBinaryOperator.NEQ, expression2, data);
                break;
            }
            case 19: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_EQ, expression2, data);
                break;
            }
            case 20: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_NEQ, expression2, data);
                break;
            }
            case 21: {
                jsExpression = this.binaryOperation(JsBinaryOperator.AND, expression2, data);
                break;
            }
            case 22: {
                jsExpression = this.binaryOperation(JsBinaryOperator.OR, expression2, data);
                break;
            }
            case 23: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG, expression2, data);
                break;
            }
            case 24: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_ADD, expression2, data);
                break;
            }
            case 25: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_SUB, expression2, data);
                break;
            }
            case 26: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MUL, expression2, data);
                break;
            }
            case 27: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_DIV, expression2, data);
                break;
            }
            case 28: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MOD, expression2, data);
                break;
            }
            case 29: {
                jsExpression = new JsArrayAccess((JsExpression)IrExpressionsKt.getLeft(expression2).accept(this, data), (JsExpression)IrExpressionsKt.getRight(expression2).accept(this, data));
                break;
            }
            case 30: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = expression2.getArguments();
                JsExpression jsExpression2 = (JsExpression)expression2.getReceiver().accept(this, data);
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((JsExpression)it.accept(this, data));
                }
                List list2 = (List)destination$iv$iv;
                JsExpression jsExpression3 = jsExpression2;
                jsExpression = new JsInvocation(jsExpression3, list2);
                break;
            }
            default: {
                CompilationExceptionKt.compilationException("Unexpected operator " + (Object)((Object)expression2.getOperator()), expression2);
                throw null;
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)jsExpression, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (function2 instanceof IrConstructor) {
            jsName = data.getNameForConstructor((IrConstructor)function2);
        } else if (function2 instanceof IrSimpleFunction) {
            jsName = data.getNameForStaticFunction((IrSimpleFunction)function2);
        } else {
            CompilationExceptionKt.compilationException("Unexpected function kind", expression2);
            throw null;
        }
        JsName name2 = jsName;
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsNameRef(name2), expression2, data);
    }

    private final JsPrefixOperation prefixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPrefixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsPostfixOperation postfixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPostfixOperation(operator, (JsExpression)expression2.getReceiver().accept(this, data));
    }

    private final JsBinaryOperation binaryOperation(JsBinaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsBinaryOperation(operator, (JsExpression)IrExpressionsKt.getLeft(expression2).accept(this, data), (JsExpression)IrExpressionsKt.getRight(expression2).accept(this, data));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
        if ($this$isThisReceiver instanceof IrVariable) return false;
        IrDeclarationParent p = $this$isThisReceiver.getParent();
        if (p instanceof IrSimpleFunction) {
            if ($this$isThisReceiver != ((IrSimpleFunction)p).getDispatchReceiverParameter()) return false;
            return true;
        }
        if (!(p instanceof IrClass)) return false;
        if ($this$isThisReceiver != ((IrClass)p).getThisReceiver()) return false;
        return true;
    }

    @Override
    @NotNull
    public JsExpression visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsExpression visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlockBody(@NotNull IrBlockBody body2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBody(@NotNull IrBody body2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsExpression visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstantArray(@NotNull IrConstantArray expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstantObject(@NotNull IrConstantObject expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstantValue(@NotNull IrConstantValue expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitField(@NotNull IrField declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFile(@NotNull IrFile declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitProperty(@NotNull IrProperty declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitScript(@NotNull IrScript declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public JsExpression visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueParameter(@NotNull IrValueParameter declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext data) {
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrDynamicOperator.values().length];
            nArray[IrDynamicOperator.UNARY_PLUS.ordinal()] = 1;
            nArray[IrDynamicOperator.UNARY_MINUS.ordinal()] = 2;
            nArray[IrDynamicOperator.EXCL.ordinal()] = 3;
            nArray[IrDynamicOperator.PREFIX_INCREMENT.ordinal()] = 4;
            nArray[IrDynamicOperator.PREFIX_DECREMENT.ordinal()] = 5;
            nArray[IrDynamicOperator.POSTFIX_INCREMENT.ordinal()] = 6;
            nArray[IrDynamicOperator.POSTFIX_DECREMENT.ordinal()] = 7;
            nArray[IrDynamicOperator.BINARY_PLUS.ordinal()] = 8;
            nArray[IrDynamicOperator.BINARY_MINUS.ordinal()] = 9;
            nArray[IrDynamicOperator.MUL.ordinal()] = 10;
            nArray[IrDynamicOperator.DIV.ordinal()] = 11;
            nArray[IrDynamicOperator.MOD.ordinal()] = 12;
            nArray[IrDynamicOperator.GT.ordinal()] = 13;
            nArray[IrDynamicOperator.LT.ordinal()] = 14;
            nArray[IrDynamicOperator.GE.ordinal()] = 15;
            nArray[IrDynamicOperator.LE.ordinal()] = 16;
            nArray[IrDynamicOperator.EQEQ.ordinal()] = 17;
            nArray[IrDynamicOperator.EXCLEQ.ordinal()] = 18;
            nArray[IrDynamicOperator.EQEQEQ.ordinal()] = 19;
            nArray[IrDynamicOperator.EXCLEQEQ.ordinal()] = 20;
            nArray[IrDynamicOperator.ANDAND.ordinal()] = 21;
            nArray[IrDynamicOperator.OROR.ordinal()] = 22;
            nArray[IrDynamicOperator.EQ.ordinal()] = 23;
            nArray[IrDynamicOperator.PLUSEQ.ordinal()] = 24;
            nArray[IrDynamicOperator.MINUSEQ.ordinal()] = 25;
            nArray[IrDynamicOperator.MULEQ.ordinal()] = 26;
            nArray[IrDynamicOperator.DIVEQ.ordinal()] = 27;
            nArray[IrDynamicOperator.MODEQ.ordinal()] = 28;
            nArray[IrDynamicOperator.ARRAY_ACCESS.ordinal()] = 29;
            nArray[IrDynamicOperator.INVOKE.ordinal()] = 30;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

