/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.InlineClassDeclarationCheckerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInapplicableParameterType", "frontend"})
public final class InlineClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineClassDeclarationChecker INSTANCE = new InlineClassDeclarationChecker();

    private InlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean bl;
        KtModifierList inlineOrValueKeyword;
        BindingTrace trace;
        block21: {
            Annotated annotated;
            PsiElement modalityModifier;
            PsiElement valueKeyword;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration2 instanceof KtClass)) {
                return;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
                return;
            }
            trace = context2.getTrace();
            KtModifierList ktModifierList = ((KtClass)declaration2).getModifierList();
            Object object = valueKeyword = ktModifierList != null ? ktModifierList.getModifier(KtTokens.VALUE_KEYWORD) : null;
            if (valueKeyword != null && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmInlineValueClasses) && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueKeyword, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.JvmInlineValueClasses), (Object)context2.getLanguageVersionSettings())));
                return;
            }
            KtModifierList ktModifierList2 = ((KtClass)declaration2).getModifierList();
            if (ktModifierList2 == null || (ktModifierList2 = ktModifierList2.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
                ktModifierList2 = valueKeyword;
            }
            if (!((inlineOrValueKeyword = ktModifierList2) != null)) {
                boolean $i$a$-require-InlineClassDeclarationChecker$check$22 = false;
                String $i$a$-require-InlineClassDeclarationChecker$check$22 = "Declaration of inline class must have 'inline' keyword";
                throw new IllegalArgumentException($i$a$-require-InlineClassDeclarationChecker$check$22.toString());
            }
            if (((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isLocal(descriptor2)) {
                trace.report(Errors.VALUE_CLASS_NOT_TOP_LEVEL.on((PsiElement)inlineOrValueKeyword));
                return;
            }
            if (!((Collection)((KtClass)declaration2).getContextReceivers()).isEmpty()) {
                KtContextReceiverList contextReceiverList = ((KtClass)declaration2).getContextReceiverList();
                if (contextReceiverList == null) {
                    boolean $i$a$-requireNotNull-InlineClassDeclarationChecker$check$32 = false;
                    String $i$a$-requireNotNull-InlineClassDeclarationChecker$check$32 = "Declaration cannot have context receivers with no context receiver list";
                    throw new IllegalArgumentException($i$a$-requireNotNull-InlineClassDeclarationChecker$check$32.toString());
                }
                trace.report(Errors.INLINE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS.on((KtContextReceiverList)((PsiElement)contextReceiverList)));
            }
            if ((modalityModifier = KtPsiUtilKt.modalityModifier(declaration2)) != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
                trace.report(Errors.VALUE_CLASS_NOT_FINAL.on(modalityModifier));
                return;
            }
            KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration2).getPrimaryConstructor();
            if (primaryConstructor2 == null) {
                trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS.on((PsiElement)inlineOrValueKeyword));
                return;
            }
            KtParameter baseParameter = (KtParameter)CollectionsKt.singleOrNull(primaryConstructor2.getValueParameters());
            if (baseParameter == null) {
                KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration2);
                boolean bl2 = false;
                trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
                return;
            }
            if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
                trace.report(Errors.VALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
                return;
            }
            DeclarationDescriptor $this$safeAs$iv = descriptor2;
            boolean $i$f$safeAs = false;
            Object object2 = $this$safeAs$iv;
            if (!(object2 instanceof ClassDescriptor)) {
                object2 = null;
            }
            KotlinType baseParameterType = (annotated = (ClassDescriptor)object2) != null && (annotated = annotated.getDefaultType()) != null ? InlineClassesUtilsKt.substitutedUnderlyingType((KotlinType)annotated) : null;
            KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
            if (baseParameterType != null && baseParameterTypeReference != null) {
                if (this.isInapplicableParameterType(baseParameterType)) {
                    trace.report(Errors.VALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                    return;
                }
                if (InlineClassesUtilsKt.isRecursiveInlineClassType(baseParameterType)) {
                    trace.report(Errors.VALUE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                    return;
                }
            }
            for (KtSuperTypeListEntry supertypeEntry : ((KtClass)declaration2).getSuperTypeListEntries()) {
                ClassifierDescriptor typeDescriptor;
                KotlinType type2;
                KtTypeReference typeReference;
                if (supertypeEntry.getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                if (supertypeEntry instanceof KtDelegatedSuperTypeEntry) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    KtElement ktElement = ((KtDelegatedSuperTypeEntry)supertypeEntry).getDelegateExpression();
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
                    if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && resolvedCall2.getResultingDescriptor() instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getContainingDeclaration(), (Object)trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, primaryConstructor2))) continue;
                    trace.report(Errors.VALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on((PsiElement)supertypeEntry));
                    return;
                }
                if (type2.getConstructor().getDeclarationDescriptor() == null || DescriptorUtils.isInterface(typeDescriptor)) continue;
                trace.report(Errors.VALUE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
                return;
            }
            Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)StandardNames.FqNames.cloneable) || Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)InlineClassDeclarationCheckerKt.access$getJavaLangCloneable$p()))) continue;
                bl = true;
                break block21;
            }
            bl = false;
        }
        if (bl) {
            trace.report(Errors.VALUE_CLASS_CANNOT_BE_CLONEABLE.on((PsiElement)inlineOrValueKeyword));
            return;
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType) || TypeUtilsKt.isTypeParameter($this$isInapplicableParameterType) || this.isGenericArrayOfTypeParameter($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(KotlinType $this$isGenericArrayOfTypeParameter) {
        if (!KotlinBuiltIns.isArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        TypeProjection argument0 = $this$isGenericArrayOfTypeParameter.getArguments().get(0);
        if (argument0.isStarProjection()) {
            return false;
        }
        KotlinType kotlinType = argument0.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument0.type");
        KotlinType argument0type = kotlinType;
        return TypeUtilsKt.isTypeParameter(argument0type) || this.isGenericArrayOfTypeParameter(argument0type);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        PsiElement psiElement = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)((Object)KtTokens.OPEN_KEYWORD));
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !isOpen;
    }
}

