/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00e8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0000\u001a\u0016\u0010\u0015\u001a\u00020\u0012*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001\u001a2\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e*\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001eH\u0000\u001a\f\u0010&\u001a\u00020\t*\u00020\u0016H\u0000\u001a&\u0010'\u001a\u0004\u0018\u00010(*\u00020)2\u0006\u0010*\u001a\u00020\u00162\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010,0\u001eH\u0000\u001a\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020\u0016H\u0000\u001a\u000e\u0010/\u001a\u0004\u0018\u00010\t*\u00020\u001bH\u0000\u001a\u000e\u00100\u001a\u0004\u0018\u00010.*\u00020\u0016H\u0000\u001a\f\u00101\u001a\u00020\u0016*\u000202H\u0000\u001a\n\u00103\u001a\u00020\u0016*\u00020\u0016\u001a\f\u00104\u001a\u00020\t*\u00020\u0010H\u0000\u001a\u0014\u00105\u001a\u000206*\u0002072\u0006\u00108\u001a\u00020\tH\u0000\u001a\u000e\u00109\u001a\u0004\u0018\u00010:*\u00020\u0016H\u0000\u001a\f\u0010;\u001a\u00020\u0016*\u000207H\u0000\u001a\f\u0010<\u001a\u00020=*\u000202H\u0000\u001a\f\u0010>\u001a\u00020?*\u000202H\u0000\u001a \u0010@\u001a\u00020\u0010*\u00020\u00102\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00100BH\u0000\u001a\u0014\u0010@\u001a\u00020\u0010*\u00020\u00102\u0006\u0010D\u001a\u00020EH\u0000\u001a\u0014\u0010F\u001a\u0004\u0018\u00010\u0010*\u0002022\u0006\u0010G\u001a\u00020H\u001a\u0014\u0010I\u001a\u00020\u0012*\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0001\u001a\f\u0010J\u001a\u00020\u0012*\u00020\u0016H\u0000\u001a\f\u0010K\u001a\u00020\t*\u000207H\u0000\u001a\n\u0010L\u001a\u00020\u0012*\u00020M\u001a\f\u0010N\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010O\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010P\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010Q\u001a\u00020\u0012*\u000207H\u0000\u001a\f\u0010R\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010S\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010T\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a\f\u0010U\u001a\u00020\u0012*\u00020\u0010H\u0000\u001a \u0010V\u001a\u000e\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020Y0W*\u00020\u00182\u0006\u0010Z\u001a\u000202H\u0000\u001a\u001e\u0010[\u001a\b\u0012\u0004\u0012\u0002H]0\\\"\u0004\b\u0000\u0010]*\b\u0012\u0004\u0012\u0002H]0^H\u0000\u001a \u0010_\u001a\u0006\u0012\u0002\b\u00030\\*\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\u0006\u0010`\u001a\u00020\u0010H\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006a"}, d2={"compileTimeAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "getCompileTimeAnnotation", "()Lorg/jetbrains/kotlin/name/FqName;", "contractsDslAnnotation", "getContractsDslAnnotation", "evaluateIntrinsicAnnotation", "getEvaluateIntrinsicAnnotation", "fqName", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getFqName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "getPrimitiveClass", "Ljava/lang/Class;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "accessesTopLevelOrObjectField", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "checkCast", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "annotation", "getArgsForMethodInvocation", "", "", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "methodType", "Ljava/lang/invoke/MethodType;", "args", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "getCapitalizedFileName", "getDefaultWithActualParameters", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "newParent", "actualParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getDispatchReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getEvaluateIntrinsicValue", "getExtensionReceiver", "getFunctionThatContainsDefaults", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getLastOverridden", "getOnlyName", "getOriginalPropertyByName", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "name", "getReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getSingleAbstractMethod", "getSuperEnumCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "getThisReceiver", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getTypeIfReified", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getVarargType", "index", "", "hasAnnotation", "hasFunInterfaceParent", "internalName", "isAccessToObject", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "isFunction", "isKFunction", "isPrimitiveArray", "isSubclassOfThrowable", "isThrowable", "isTypeParameter", "isUnsigned", "isUnsignedArray", "loadReifiedTypeArguments", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KTypeState;", "expression", "toPrimitive", "Lorg/jetbrains/kotlin/ir/interpreter/state/Primitive;", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "toPrimitiveStateArray", "type", "ir.interpreter"})
public final class UtilsKt {
    @NotNull
    private static final FqName compileTimeAnnotation = new FqName("kotlin.CompileTimeCalculation");
    @NotNull
    private static final FqName evaluateIntrinsicAnnotation = new FqName("kotlin.EvaluateIntrinsic");
    @NotNull
    private static final FqName contractsDslAnnotation = new FqName("kotlin.internal.ContractsDsl");

    @NotNull
    public static final FqName getCompileTimeAnnotation() {
        return compileTimeAnnotation;
    }

    @NotNull
    public static final FqName getEvaluateIntrinsicAnnotation() {
        return evaluateIntrinsicAnnotation;
    }

    @NotNull
    public static final FqName getContractsDslAnnotation() {
        return contractsDslAnnotation;
    }

    @NotNull
    public static final String getFqName(@NotNull IrElement $this$fqName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"<this>");
        Object object = $this$fqName instanceof IrDeclarationWithName ? (IrDeclarationWithName)$this$fqName : null;
        if ((object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null ? ((FqName)object).asString() : (string2 = null)) == null) {
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public static final IrValueParameterSymbol getDispatchReceiver(@NotNull IrFunction $this$getDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getDispatchReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getDispatchReceiver.getDispatchReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrValueParameterSymbol getExtensionReceiver(@NotNull IrFunction $this$getExtensionReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtensionReceiver, (String)"<this>");
        IrValueParameter irValueParameter = $this$getExtensionReceiver.getExtensionReceiverParameter();
        return irValueParameter != null ? irValueParameter.getSymbol() : null;
    }

    @Nullable
    public static final IrSymbol getReceiver(@NotNull IrFunction $this$getReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiver, (String)"<this>");
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver($this$getReceiver);
        return irValueParameterSymbol != null ? (IrSymbol)irValueParameterSymbol : (IrSymbol)UtilsKt.getExtensionReceiver($this$getReceiver);
    }

    @NotNull
    public static final IrValueSymbol getThisReceiver(@NotNull IrFunctionAccessExpression $this$getThisReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$getThisReceiver, (String)"<this>");
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(((IrFunctionSymbol)$this$getThisReceiver.getSymbol()).getOwner()).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        return irValueParameter.getSymbol();
    }

    @NotNull
    public static final <T> Primitive<T> toPrimitive(@NotNull IrConst<T> $this$toPrimitive) {
        Primitive<Object> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitive, (String)"<this>");
        if (IrTypePredicatesKt.isByte($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            primitive = new Primitive<Object>(((Number)t).byteValue(), $this$toPrimitive.getType());
        } else if (IrTypePredicatesKt.isShort($this$toPrimitive.getType())) {
            T t = $this$toPrimitive.getValue();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            primitive = new Primitive<Object>(((Number)t).shortValue(), $this$toPrimitive.getType());
        } else {
            primitive = new Primitive<T>($this$toPrimitive.getValue(), $this$toPrimitive.getType());
        }
        return primitive;
    }

    public static final boolean hasAnnotation(@Nullable IrAnnotationContainer $this$hasAnnotation, @NotNull FqName annotation2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        if ($this$hasAnnotation == null) {
            return false;
        }
        if (!((Collection)$this$hasAnnotation.getAnnotations()).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrConstructorCall it = (IrConstructorCall)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), (Object)annotation2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public static final IrConstructorCall getAnnotation(@NotNull IrAnnotationContainer $this$getAnnotation, @NotNull FqName annotation2) {
        IrConstructorCall irConstructorCall;
        Object v0;
        IrConstructorCall it;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
            Iterable $this$firstOrNull$iv = $this$getAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (IrConstructorCall)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), (Object)annotation2)) continue;
                v0 = element$iv2;
                break block3;
            }
            v0 = null;
        }
        if ((irConstructorCall = (IrConstructorCall)v0) == null) {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = ((IrClass)((IrFunction)$this$getAnnotation).getParent()).getAnnotations();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    it = (IrConstructorCall)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(it.getSymbol().getOwner())), (Object)annotation2)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irConstructorCall = (IrConstructorCall)element$iv2;
        }
        return irConstructorCall;
    }

    @Nullable
    public static final String getEvaluateIntrinsicValue(@NotNull IrAnnotationContainer $this$getEvaluateIntrinsicValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getEvaluateIntrinsicValue, (String)"<this>");
        if ($this$getEvaluateIntrinsicValue instanceof IrClass && StringsKt.startsWith$default((String)UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue)), (String)"java", (boolean)false, (int)2, null)) {
            return UtilsKt.getFqName((IrElement)((Object)$this$getEvaluateIntrinsicValue));
        }
        if (!UtilsKt.hasAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation)) {
            return null;
        }
        IrExpression irExpression = UtilsKt.getAnnotation($this$getEvaluateIntrinsicValue, evaluateIntrinsicAnnotation).getValueArgument(0);
        if (irExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
        }
        return String.valueOf(((IrConst)irExpression).getValue());
    }

    @Nullable
    public static final Class<?> getPrimitiveClass(@NotNull IrType irType, boolean asObject) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(irType);
        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
            case 1: {
                if (asObject) {
                    clazz = Boolean.class;
                    break;
                }
                clazz = Boolean.TYPE;
                break;
            }
            case 2: {
                if (asObject) {
                    clazz = Character.class;
                    break;
                }
                clazz = Character.TYPE;
                break;
            }
            case 3: {
                if (asObject) {
                    clazz = Byte.class;
                    break;
                }
                clazz = Byte.TYPE;
                break;
            }
            case 4: {
                if (asObject) {
                    clazz = Short.class;
                    break;
                }
                clazz = Short.TYPE;
                break;
            }
            case 5: {
                if (asObject) {
                    clazz = Integer.class;
                    break;
                }
                clazz = Integer.TYPE;
                break;
            }
            case 6: {
                if (asObject) {
                    clazz = Float.class;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 7: {
                if (asObject) {
                    clazz = Long.class;
                    break;
                }
                clazz = Long.TYPE;
                break;
            }
            case 8: {
                if (asObject) {
                    clazz = Double.class;
                    break;
                }
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = IrTypePredicatesKt.isString(irType) ? String.class : null;
            }
        }
        return clazz;
    }

    public static /* synthetic */ Class getPrimitiveClass$default(IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilsKt.getPrimitiveClass(irType, bl);
    }

    @NotNull
    public static final IrFunction getLastOverridden(@NotNull IrFunction $this$getLastOverridden) {
        Intrinsics.checkNotNullParameter((Object)$this$getLastOverridden, (String)"<this>");
        if (!($this$getLastOverridden instanceof IrSimpleFunction)) {
            return $this$getLastOverridden;
        }
        return (IrFunction)SequencesKt.last((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.generateSequence((Object)CollectionsKt.listOf((Object)$this$getLastOverridden), (Function1)getLastOverridden.1.INSTANCE)));
    }

    @NotNull
    public static final Primitive<?> toPrimitiveStateArray(@NotNull List<? extends Object> $this$toPrimitiveStateArray, @NotNull IrType type2) {
        Primitive<boolean[]> primitive;
        Intrinsics.checkNotNullParameter($this$toPrimitiveStateArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (IrTypePredicatesKt.isByteArray(type2)) {
            int n = 0;
            int n2 = $this$toPrimitiveStateArray.size();
            byte[] byArray = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                Object object = $this$toPrimitiveStateArray.get(n3);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                byArray[n3] = ((Number)object).byteValue();
            }
            IrType irType = type2;
            byte[] byArray2 = byArray;
            primitive = new Primitive<boolean[]>((boolean[])byArray2, irType);
        } else if (IrTypePredicatesKt.isCharArray(type2)) {
            int n = 0;
            int n4 = $this$toPrimitiveStateArray.size();
            char[] cArray = new char[n4];
            while (n < n4) {
                int n5 = n++;
                Object object = $this$toPrimitiveStateArray.get(n5);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                }
                cArray[n5] = ((Character)object).charValue();
            }
            IrType irType = type2;
            char[] cArray2 = cArray;
            primitive = new Primitive<boolean[]>((boolean[])cArray2, irType);
        } else if (IrTypePredicatesKt.isShortArray(type2)) {
            int n = 0;
            int n6 = $this$toPrimitiveStateArray.size();
            short[] sArray = new short[n6];
            while (n < n6) {
                int n7 = n++;
                Object object = $this$toPrimitiveStateArray.get(n7);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                sArray[n7] = ((Number)object).shortValue();
            }
            IrType irType = type2;
            short[] sArray2 = sArray;
            primitive = new Primitive<boolean[]>((boolean[])sArray2, irType);
        } else if (IrTypePredicatesKt.isIntArray(type2)) {
            int n = 0;
            int n8 = $this$toPrimitiveStateArray.size();
            int[] nArray = new int[n8];
            while (n < n8) {
                int n9 = n++;
                Object object = $this$toPrimitiveStateArray.get(n9);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                nArray[n9] = ((Number)object).intValue();
            }
            IrType irType = type2;
            int[] nArray2 = nArray;
            primitive = new Primitive<boolean[]>((boolean[])nArray2, irType);
        } else if (IrTypePredicatesKt.isLongArray(type2)) {
            int n = 0;
            int n10 = $this$toPrimitiveStateArray.size();
            long[] lArray = new long[n10];
            while (n < n10) {
                int n11 = n++;
                Object object = $this$toPrimitiveStateArray.get(n11);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                lArray[n11] = ((Number)object).longValue();
            }
            IrType irType = type2;
            long[] lArray2 = lArray;
            primitive = new Primitive<boolean[]>((boolean[])lArray2, irType);
        } else if (IrTypePredicatesKt.isFloatArray(type2)) {
            int n = 0;
            int n12 = $this$toPrimitiveStateArray.size();
            float[] fArray = new float[n12];
            while (n < n12) {
                int n13 = n++;
                Object object = $this$toPrimitiveStateArray.get(n13);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                fArray[n13] = ((Number)object).floatValue();
            }
            IrType irType = type2;
            float[] fArray2 = fArray;
            primitive = new Primitive<boolean[]>((boolean[])fArray2, irType);
        } else if (IrTypePredicatesKt.isDoubleArray(type2)) {
            int n = 0;
            int n14 = $this$toPrimitiveStateArray.size();
            double[] dArray = new double[n14];
            while (n < n14) {
                int n15 = n++;
                Object object = $this$toPrimitiveStateArray.get(n15);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                dArray[n15] = ((Number)object).doubleValue();
            }
            IrType irType = type2;
            double[] dArray2 = dArray;
            primitive = new Primitive<boolean[]>((boolean[])dArray2, irType);
        } else if (IrTypePredicatesKt.isBooleanArray(type2)) {
            int n = 0;
            int n16 = $this$toPrimitiveStateArray.size();
            boolean[] blArray = new boolean[n16];
            while (n < n16) {
                int n17 = n++;
                Object object = $this$toPrimitiveStateArray.get(n17);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                blArray[n17] = (Boolean)object;
            }
            IrType irType = type2;
            boolean[] blArray2 = blArray;
            primitive = new Primitive<boolean[]>(blArray2, irType);
        } else {
            Collection $this$toTypedArray$iv = $this$toPrimitiveStateArray;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            primitive = new Primitive<Object[]>(objectArray, type2);
        }
        return primitive;
    }

    @Nullable
    public static final IrType getVarargType(@NotNull IrFunctionAccessExpression $this$getVarargType, int index2) {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        IrSimpleType type2;
        Intrinsics.checkNotNullParameter((Object)$this$getVarargType, (String)"<this>");
        IrType irType = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getVarargElementType();
        if (irType == null) {
            return null;
        }
        IrType varargType = irType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(varargType);
        if (irClassSymbol != null) {
            IrClassSymbol it = irClassSymbol;
            boolean bl = false;
            return ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        }
        IrType it = ((IrFunctionSymbol)$this$getVarargType.getSymbol()).getOwner().getValueParameters().get(index2).getType();
        IrSimpleType irSimpleType = it instanceof IrSimpleType ? (IrSimpleType)it : null;
        if (irSimpleType == null) {
            return null;
        }
        IrSimpleType $this$buildSimpleType$iv = type2 = irSimpleType;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$getVarargType_u24lambda_u2d4 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        IrTypeParameter typeParameter = (IrTypeParameter)IrTypesKt.getClassifierOrFail(varargType).getOwner();
        IrType irType2 = $this$getVarargType.getTypeArgument(typeParameter.getIndex());
        Intrinsics.checkNotNull((Object)irType2);
        $this$getVarargType_u24lambda_u2d4.setArguments(CollectionsKt.listOf((Object)IrSimpleTypeImplKt.makeTypeProjection(irType2, Variance.OUT_VARIANCE)));
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    @NotNull
    public static final String getCapitalizedFileName(@NotNull IrFunction $this$getCapitalizedFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getCapitalizedFileName, (String)"<this>");
        return CapitalizeDecapitalizeKt.capitalizeAsciiOnly(StringsKt.replace$default((String)IrFileKt.getName(IrUtilsKt.getFile($this$getCapitalizedFileName)), (String)".kt", (String)"Kt", (boolean)false, (int)4, null));
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsigned, (String)"<this>");
        return IrTypePredicatesKt.getUnsignedType($this$isUnsigned) != null;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        Object object = IrTypesKt.getClass($this$isFunction);
        return object != null && (object = UtilsKt.getFqName((IrElement)object)) != null ? StringsKt.startsWith$default((String)object, (String)"kotlin.Function", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        Object object = IrTypesKt.getClass($this$isKFunction);
        return object != null && (object = UtilsKt.getFqName((IrElement)object)) != null ? StringsKt.startsWith$default((String)object, (String)"kotlin.reflect.KFunction", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"<this>");
        IrClass irClass2 = IrTypesKt.getClass($this$isThrowable);
        return Intrinsics.areEqual((Object)(irClass2 != null ? UtilsKt.getFqName(irClass2) : null), (Object)"kotlin.Throwable");
    }

    public static final boolean isSubclassOfThrowable(@NotNull IrClass $this$isSubclassOfThrowable) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$isSubclassOfThrowable, (String)"<this>");
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)$this$isSubclassOfThrowable, (Function1)isSubclassOfThrowable.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl2 = false;
                if (!UtilsKt.isThrowable(IrUtilsKt.getDefaultType(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedArray, (String)"<this>");
        if (!($this$isUnsignedArray instanceof IrSimpleType) || !(((IrSimpleType)$this$isUnsignedArray).getClassifier() instanceof IrClassSymbol)) {
            return false;
        }
        Object[] objectArray = new String[]{"kotlin.UByteArray", "kotlin.UShortArray", "kotlin.UIntArray", "kotlin.ULongArray"};
        return SetsKt.setOf((Object[])objectArray).contains(UtilsKt.getFqName(((IrSimpleType)$this$isUnsignedArray).getClassifier().getOwner()));
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        Object object = IrTypesKt.getClass($this$isPrimitiveArray);
        if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
            Object it = object;
            boolean bl2 = false;
            bl = StandardNames.isPrimitiveArray((FqNameUnsafe)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String internalName(@NotNull IrClass $this$internalName) {
        Intrinsics.checkNotNullParameter((Object)$this$internalName, (String)"<this>");
        StringBuilder internalName2 = new StringBuilder($this$internalName.getName().asString());
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)($this$internalName instanceof IrDeclarationParent ? (IrDeclarationParent)$this$internalName : null), (Function1)internalName.1.INSTANCE), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            IrDeclarationParent it = (IrDeclarationParent)element$iv;
            boolean bl = false;
            IrDeclarationParent irDeclarationParent = it;
            if (irDeclarationParent instanceof IrClass) {
                internalName2.insert(0, ((IrClass)it).getName().asString() + '$');
                continue;
            }
            if (!(irDeclarationParent instanceof IrPackageFragment)) continue;
            String it2 = string2 = ((IrPackageFragment)it).getFqName().asString();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            String string3 = ((CharSequence)it2).length() > 0 ? string2 : null;
            if (string3 == null) continue;
            it2 = string3;
            boolean bl3 = false;
            internalName2.insert(0, it2 + '.');
        }
        String string4 = internalName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"internalName.toString()");
        return string4;
    }

    public static final boolean checkCast(@Nullable IrFunction $this$checkCast, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if ($this$checkCast == null) {
            return true;
        }
        IrType actualType = $this$checkCast.getReturnType();
        if (!(IrTypesKt.getClassifierOrNull(actualType) instanceof IrTypeParameterSymbol)) {
            return true;
        }
        State state = environment.getCallStack$ir_interpreter().loadState($this$checkCast.getSymbol());
        Object object = state instanceof KTypeState ? (KTypeState)state : null;
        if (object == null || (object = ((KTypeState)object).getIrType()) == null) {
            return true;
        }
        Object expectedType = object;
        if (IrTypesKt.getClassifierOrFail((IrType)expectedType) instanceof IrTypeParameterSymbol) {
            return true;
        }
        State state2 = environment.getCallStack$ir_interpreter().peekState();
        if (state2 == null) {
            return true;
        }
        State actualState = state2;
        if (actualState instanceof Primitive && ((Primitive)actualState).getValue() == null) {
            return true;
        }
        if (!StateKt.isSubtypeOf(actualState, (IrType)expectedType)) {
            String convertibleClassName = UtilsKt.getFqName(environment.getCallStack$ir_interpreter().popState().getIrClass());
            environment.getCallStack$ir_interpreter().dropFrame();
            ExceptionUtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render((IrType)expectedType)), environment);
            return false;
        }
        return true;
    }

    @NotNull
    public static final List<Object> getArgsForMethodInvocation(@NotNull IrFunction $this$getArgsForMethodInvocation, @NotNull CallInterceptor callInterceptor, @NotNull MethodType methodType, @NotNull List<? extends State> args) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgsForMethodInvocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        Intrinsics.checkNotNullParameter((Object)methodType, (String)"methodType");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        List argsValues = CollectionsKt.toMutableList((Collection)ProxyKt.wrap(args, callInterceptor, $this$getArgsForMethodInvocation, methodType));
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull($this$getArgsForMethodInvocation.getValueParameters());
        if ((irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null) {
            Object varargValue = CollectionsKt.last((List)argsValues);
            argsValues.remove(argsValues.size() - 1);
            Object object = varargValue;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Any?>");
            }
            CollectionsKt.addAll((Collection)argsValues, (Object[])((Object[])object));
        }
        return argsValues;
    }

    @NotNull
    public static final String getOnlyName(@NotNull IrType $this$getOnlyName) {
        Intrinsics.checkNotNullParameter((Object)$this$getOnlyName, (String)"<this>");
        if (!($this$getOnlyName instanceof IrSimpleType)) {
            return RenderIrElementKt.render($this$getOnlyName);
        }
        return ((IrDeclarationWithName)IrTypesKt.getClassifierOrFail($this$getOnlyName).getOwner()).getName().asString() + (((IrSimpleType)$this$getOnlyName).getHasQuestionMark() ? "?" : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean accessesTopLevelOrObjectField(@NotNull IrFieldAccessExpression $this$accessesTopLevelOrObjectField) {
        Intrinsics.checkNotNullParameter((Object)$this$accessesTopLevelOrObjectField, (String)"<this>");
        if ($this$accessesTopLevelOrObjectField.getReceiver() == null) return true;
        Object object = $this$accessesTopLevelOrObjectField.getReceiver();
        IrSymbolOwner irSymbolOwner = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassifierOrNull((IrType)object)) != null ? object.getOwner() : null;
        if (!(irSymbolOwner instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irSymbolOwner;
        if (irClass2 == null) return false;
        if (!IrUtilsKt.isObject(irClass2)) return false;
        return true;
    }

    @NotNull
    public static final IrProperty getOriginalPropertyByName(@NotNull IrClass $this$getOriginalPropertyByName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)$this$getOriginalPropertyByName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$single$iv = $this$getOriginalPropertyByName.getDeclarations();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)name2)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        IrProperty property2 = single$iv;
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)UtilsKt.getLastOverridden(irSimpleFunction)).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        return (IrProperty)irPropertySymbol.getOwner();
    }

    @NotNull
    public static final IrFunction getFunctionThatContainsDefaults(@NotNull IrFunctionAccessExpression $this$getFunctionThatContainsDefaults) {
        int element$iv;
        IrFunction irFunction2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getFunctionThatContainsDefaults, (String)"<this>");
            irFunction2 = ((IrFunctionSymbol)$this$getFunctionThatContainsDefaults.getSymbol()).getOwner();
            Iterable $this$first$iv = (Iterable)RangesKt.until((int)0, (int)$this$getFunctionThatContainsDefaults.getValueArgumentsCount());
            boolean $i$f$first = false;
            Iterator iterator2 = $this$first$iv.iterator();
            while (iterator2.hasNext()) {
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                if (!($this$getFunctionThatContainsDefaults.getValueArgument(it) == null)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        int it = element$iv;
        boolean bl = false;
        IrFunction irFunction3 = UtilsKt.getFunctionThatContainsDefaults$lookup(irFunction2.getValueParameters().get(it));
        if (irFunction3 == null) {
            irFunction3 = irFunction2;
        }
        return irFunction3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final IrExpression getDefaultWithActualParameters(@NotNull IrValueParameter $this$getDefaultWithActualParameters, @NotNull IrFunction newParent, @NotNull List<? extends IrValueDeclaration> actualParameters) {
        DeepCopyTypeRemapper typeRemapper$iv;
        IrExpression expression2;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultWithActualParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        Intrinsics.checkNotNullParameter(actualParameters, (String)"actualParameters");
        IrExpressionBody irExpressionBody = $this$getDefaultWithActualParameters.getDefaultValue();
        IrExpression irExpression = expression2 = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (expression2 instanceof IrConst) {
            return expression2;
        }
        IrFunction parameterOwner = (IrFunction)$this$getDefaultWithActualParameters.getParent();
        IrElementTransformerVoid transformer2 = new IrElementTransformerVoid(parameterOwner, newParent, actualParameters){
            final /* synthetic */ IrFunction $parameterOwner;
            final /* synthetic */ IrFunction $newParent;
            final /* synthetic */ List<IrValueDeclaration> $actualParameters;
            {
                this.$parameterOwner = $parameterOwner;
                this.$newParent = $newParent;
                this.$actualParameters = $actualParameters;
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrValueDeclaration irValueDeclaration;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrValueDeclaration irValueDeclaration2 = expression2.getSymbol().getOwner();
                IrValueParameter irValueParameter = irValueDeclaration2 instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration2 : null;
                if (irValueParameter == null) {
                    return super.visitGetValue(expression2);
                }
                IrValueParameter parameter = irValueParameter;
                if (!Intrinsics.areEqual((Object)parameter.getParent(), (Object)this.$parameterOwner)) {
                    return super.visitGetValue(expression2);
                }
                if (parameter.getIndex() == -1) {
                    IrValueParameter irValueParameter2 = this.$newParent.getDispatchReceiverParameter();
                    if (irValueParameter2 == null) {
                        irValueParameter2 = this.$newParent.getExtensionReceiverParameter();
                    }
                    irValueDeclaration = irValueParameter2;
                } else {
                    irValueDeclaration = this.$actualParameters.get(parameter.getIndex());
                }
                IrValueDeclaration newParameter = irValueDeclaration;
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrType irType = expression2.getType();
                IrValueDeclaration irValueDeclaration3 = newParameter;
                Intrinsics.checkNotNull((Object)irValueDeclaration3);
                return new IrGetValueImpl(n, n2, irType, irValueDeclaration3.getSymbol(), null, 16, null);
            }
        };
        IrExpression irExpression2 = expression2;
        IrExpression irExpression3 = irExpression2;
        if (irExpression2 == null) return null;
        IrElement $this$deepCopyWithSymbols_u24default$iv = irExpression3;
        boolean $i$f$deepCopyWithSymbols = false;
        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
        IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
        DeepCopyTypeRemapper deepCopyTypeRemapper = typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv;
        IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
        TypeRemapper typeRemapper = deepCopyTypeRemapper;
        SymbolRemapper p0 = deepCopySymbolRemapper;
        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(new DeepCopyIrTreeWithSymbols(p0, typeRemapper), null), newParent);
        if (irElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        }
        IrExpression irExpression4 = (IrExpression)((IrElement)((IrExpression)irElement2));
        irExpression3 = irExpression4;
        if (irExpression4 == null) return null;
        IrElement irElement3 = irExpression3.transform((IrElementTransformer)transformer2, (Object)null);
        return irElement3;
    }

    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull CallStack callStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getTypeIfReified, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callStack, (String)"callStack");
        return UtilsKt.getTypeIfReified($this$getTypeIfReified, (Function1<? super IrClassifierSymbol, ? extends IrType>)((Function1)new Function1<IrClassifierSymbol, IrType>(callStack){
            final /* synthetic */ CallStack $callStack;
            {
                this.$callStack = $callStack;
                super(1);
            }

            @NotNull
            public final IrType invoke(@NotNull IrClassifierSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ((KTypeState)this.$callStack.loadState(it)).getIrType();
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType getTypeIfReified(@NotNull IrType $this$getTypeIfReified, @NotNull Function1<? super IrClassifierSymbol, ? extends IrType> getType2) {
        IrSimpleTypeBuilder irSimpleTypeBuilder;
        void $this$mapTo$iv$iv;
        IrSymbolOwner owner;
        Intrinsics.checkNotNullParameter((Object)$this$getTypeIfReified, (String)"<this>");
        Intrinsics.checkNotNullParameter(getType2, (String)"getType");
        if (!($this$getTypeIfReified instanceof IrSimpleType)) {
            return $this$getTypeIfReified;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$getTypeIfReified);
        IrSymbolOwner irSymbolOwner = owner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (owner instanceof IrTypeParameter && ((IrTypeParameter)owner).isReified()) {
            IrSimpleTypeBuilder irSimpleTypeBuilder2;
            IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)getType2.invoke((Object)((IrTypeParameter)owner).getSymbol());
            boolean $i$f$buildSimpleType = false;
            IrSimpleTypeBuilder $this$getTypeIfReified_u24lambda_u2d16 = irSimpleTypeBuilder2 = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
            boolean bl = false;
            $this$getTypeIfReified_u24lambda_u2d16.setHasQuestionMark($this$getTypeIfReified_u24lambda_u2d16.getHasQuestionMark() || ((IrSimpleType)$this$getTypeIfReified).getHasQuestionMark());
            return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder2);
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$getTypeIfReified).getArguments();
        boolean $i$f$map = false;
        Iterable $this$getTypeIfReified_u24lambda_u2d16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) {
                object = it;
            } else {
                IrType type2;
                IrClassifierSymbol irClassifierSymbol2 = IrTypesKt.getClassifierOrNull(type2);
                IrSymbolOwner typeOwner = irClassifierSymbol2 != null ? irClassifierSymbol2.getOwner() : null;
                object = typeOwner instanceof IrTypeParameter && !((IrTypeParameter)typeOwner).isReified() ? it : (IrTypeArgument)((Object)UtilsKt.getTypeIfReified(type2, getType2));
            }
            collection.add(object);
        }
        List newArguments2 = (List)destination$iv$iv;
        IrSimpleType $this$buildSimpleType$iv = (IrSimpleType)$this$getTypeIfReified;
        boolean $i$f$buildSimpleType = false;
        IrSimpleTypeBuilder $this$getTypeIfReified_u24lambda_u2d18 = irSimpleTypeBuilder = IrSimpleTypeImplKt.toBuilder($this$buildSimpleType$iv);
        boolean bl = false;
        $this$getTypeIfReified_u24lambda_u2d18.setHasQuestionMark($this$getTypeIfReified_u24lambda_u2d18.getHasQuestionMark() || ((IrSimpleType)$this$getTypeIfReified).getHasQuestionMark());
        $this$getTypeIfReified_u24lambda_u2d18.setArguments(newArguments2);
        return IrSimpleTypeImplKt.buildSimpleType(irSimpleTypeBuilder);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<IrTypeParameterSymbol, KTypeState> loadReifiedTypeArguments(@NotNull IrInterpreterEnvironment $this$loadReifiedTypeArguments, @NotNull IrFunctionAccessExpression expression2) {
        void $this$mapTo$iv$iv;
        IrTypeParameter it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadReifiedTypeArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Iterable $this$filter$iv = ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getTypeParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            if (!it.isReified()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((List)destination$iv$iv, (Function1)new Function1<IrTypeParameterSymbol, KTypeState>(expression2, $this$loadReifiedTypeArguments){
            final /* synthetic */ IrFunctionAccessExpression $expression;
            final /* synthetic */ IrInterpreterEnvironment $this_loadReifiedTypeArguments;
            {
                this.$expression = $expression;
                this.$this_loadReifiedTypeArguments = $receiver;
                super(1);
            }

            @NotNull
            public final KTypeState invoke(@NotNull IrTypeParameterSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IrType irType = this.$expression.getTypeArgument(((IrTypeParameter)it.getOwner()).getIndex());
                Intrinsics.checkNotNull((Object)irType);
                IrType reifiedType = UtilsKt.getTypeIfReified(irType, this.$this_loadReifiedTypeArguments.getCallStack$ir_interpreter());
                return new KTypeState(reifiedType, (IrClass)this.$this_loadReifiedTypeArguments.getKTypeClass$ir_interpreter().getOwner());
            }
        });
    }

    @NotNull
    public static final IrEnumConstructorCall getSuperEnumCall(@NotNull IrFunctionAccessExpression $this$getSuperEnumCall) {
        IrEnumConstructorCall irEnumConstructorCall;
        IrStatement delegatingCall;
        String name2;
        Intrinsics.checkNotNullParameter((Object)$this$getSuperEnumCall, (String)"<this>");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull(((IrFunctionSymbol)$this$getSuperEnumCall.getSymbol()).getOwner());
        String string2 = name2 = irClass2 != null ? UtilsKt.getFqName(irClass2) : null;
        if ($this$getSuperEnumCall instanceof IrEnumConstructorCall && Intrinsics.areEqual((Object)name2, (Object)"kotlin.Enum")) {
            return (IrEnumConstructorCall)$this$getSuperEnumCall;
        }
        Object object = ((IrFunctionSymbol)$this$getSuperEnumCall.getSymbol()).getOwner().getBody();
        IrStatement irStatement = object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null ? (IrStatement)object.get(0) : (delegatingCall = null);
        if (delegatingCall instanceof IrFunctionAccessExpression) {
            irEnumConstructorCall = UtilsKt.getSuperEnumCall((IrFunctionAccessExpression)delegatingCall);
        } else if (delegatingCall instanceof IrTypeOperatorCall) {
            irEnumConstructorCall = UtilsKt.getSuperEnumCall((IrFunctionAccessExpression)((IrTypeOperatorCall)delegatingCall).getArgument());
        } else {
            String string3 = delegatingCall + " is unexpected";
            throw new NotImplementedError("An operation is not implemented: " + string3);
        }
        return irEnumConstructorCall;
    }

    public static final boolean hasFunInterfaceParent(@NotNull IrFunction $this$hasFunInterfaceParent) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFunInterfaceParent, (String)"<this>");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$hasFunInterfaceParent);
        return irClass2 != null ? irClass2.isFun() : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrFunction getSingleAbstractMethod(@NotNull IrClass $this$getSingleAbstractMethod) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSingleAbstractMethod, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getSingleAbstractMethod.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$single$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.ABSTRACT)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (IrFunction)((Object)iterable);
    }

    public static final boolean isAccessToObject(@NotNull IrGetValue $this$isAccessToObject) {
        IrClass expectedClass;
        Intrinsics.checkNotNullParameter((Object)$this$isAccessToObject, (String)"<this>");
        IrValueDeclaration owner = $this$isAccessToObject.getSymbol().getOwner();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$isAccessToObject.getType());
        IrClass irClass2 = expectedClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        if (expectedClass == null || !IrUtilsKt.isObject(expectedClass)) {
            return false;
        }
        return Intrinsics.areEqual((Object)owner.getOrigin(), (Object)IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE) || Intrinsics.areEqual((Object)owner.getName().asString(), (Object)"<this>");
    }

    /*
     * WARNING - void declaration
     */
    private static final IrFunction getFunctionThatContainsDefaults$lookup(IrValueParameter $this$getFunctionThatContainsDefaults_u24lookup) {
        IrElementBase irElementBase;
        block6: {
            Object object;
            IrSimpleFunction irSimpleFunction;
            block7: {
                irElementBase = $this$getFunctionThatContainsDefaults_u24lookup.getDefaultValue();
                if (irElementBase == null) break block7;
                IrExpressionBody it = irElementBase;
                boolean bl = false;
                IrFunction irFunction2 = (IrFunction)$this$getFunctionThatContainsDefaults_u24lookup.getParent();
                irElementBase = irFunction2;
                if (irFunction2 != null) break block6;
            }
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = (object = $this$getFunctionThatContainsDefaults_u24lookup.getParent()) instanceof IrSimpleFunction ? (IrSimpleFunction)object : null;
            if (irSimpleFunction != null && (object = irSimpleFunction.getOverriddenSymbols()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$map = false;
                IrFunction irFunction3 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((IrSimpleFunction)it.getOwner()).getValueParameters().get($this$getFunctionThatContainsDefaults_u24lookup.getIndex()));
                }
                for (IrValueParameter it : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    irFunction3 = UtilsKt.getFunctionThatContainsDefaults$lookup(it);
                    if (irFunction3 == null) continue;
                    irElementBase = irFunction3;
                    break block6;
                }
                irElementBase = null;
            } else {
                irElementBase = null;
            }
        }
        return irElementBase;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

