/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDynamicMemberExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "isEscapedIdentifiersResolved", "", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "transformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ReferenceTransformer", "backend.js"})
public final class EscapedIdentifiersLowering
implements BodyLoweringPass {
    @NotNull
    private final ReferenceTransformer transformer;
    @NotNull
    private final ModuleKind moduleKind;
    private final boolean isEscapedIdentifiersResolved;

    public EscapedIdentifiersLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.transformer = new ReferenceTransformer(context2);
        ModuleKind moduleKind = context2.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)((Object)moduleKind));
        this.moduleKind = moduleKind;
        this.isEscapedIdentifiersResolved = CommonConfigurationKeysKt.getLanguageVersionSettings(context2.getConfiguration()).supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        LowerKt.runOnFilePostfix$default(this, irFile, true, false, 4, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this.transformer);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001b*\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020 *\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "globalThisReceiver", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "getGlobalThisReceiver", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "dummyDispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDummyDispatchReceiverParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "isThisReceiver", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "needToBeWrappedWithGlobalThis", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "wrapInGlobalThis", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "backend.js"})
    private static final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JsIrBackendContext context;

        public ReferenceTransformer(@NotNull JsIrBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @NotNull
        public final JsIrBackendContext getContext() {
            return this.context;
        }

        private final IrCallImpl getGlobalThisReceiver() {
            IrType irType = this.context.getDynamicType();
            IrSimpleFunction irSimpleFunction = ((IrProperty)this.context.getIntrinsics().getGlobalThis().getOwner()).getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return new IrCallImpl(-1, -1, irType, irSimpleFunction.getSymbol(), 0, 0, null, null, 192, null);
        }

        private final IrValueParameter getDummyDispatchReceiverParameter(IrFunction $this$dummyDispatchReceiverParameter) {
            IrValueParameter irValueParameter;
            IrValueParameter it = irValueParameter = this.context.getIrFactory().createValueParameter($this$dummyDispatchReceiverParameter.getStartOffset(), $this$dummyDispatchReceiverParameter.getEndOffset(), $this$dummyDispatchReceiverParameter.getOrigin(), new IrValueParameterSymbolImpl(null, 1, null), SpecialNames.THIS, -1, this.context.getIrBuiltIns().getAnyType(), null, false, false, false, false);
            boolean bl = false;
            it.setParent($this$dummyDispatchReceiverParameter);
            return irValueParameter;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration owner = expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal(owner) || this.isThisReceiver(owner) || !this.needToBeWrappedWithGlobalThis(owner) ? super.visitGetValue(expression2) : (IrExpression)this.wrapInGlobalThis(owner, expression2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration field2 = expression2.getSymbol().getOwner();
            if (!IrUtilsKt.isEffectivelyExternal(field2) || !this.needToBeWrappedWithGlobalThis(field2)) {
                irExpression = super.visitSetValue(expression2);
            } else {
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrDynamicMemberExpression irDynamicMemberExpression = this.wrapInGlobalThis(field2, expression2);
                IrExpression irExpression2 = expression2.getValue();
                IrType irType = expression2.getType();
                IrFieldSymbolImpl irFieldSymbolImpl = new IrFieldSymbolImpl(null, 1, null);
                irExpression = new IrSetFieldImpl(n, n2, (IrFieldSymbol)irFieldSymbolImpl, irDynamicMemberExpression, irExpression2, irType, null, null);
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrClass owner = (IrClass)expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal(owner) || !this.needToBeWrappedWithGlobalThis(owner) ? super.visitGetObjectValue(expression2) : (IrExpression)this.wrapInGlobalThis(owner, expression2);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrCall irCall;
            IrElement property2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrSimpleFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
            Object object = function2.getCorrespondingPropertySymbol();
            IrElement irElement = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (property2 = (IrElement)function2);
            if (expression2.getDispatchReceiver() != null || !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property2) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)property2)) {
                irCall = expression2;
            } else {
                IrCall irCall2;
                IrCall $this$visitCall_u24lambda_u2d1 = irCall2 = expression2;
                boolean bl = false;
                $this$visitCall_u24lambda_u2d1.setDispatchReceiver(this.getGlobalThisReceiver());
                IrCall it = irCall2;
                boolean bl2 = false;
                if (function2.getDispatchReceiverParameter() == null) {
                    function2.setDispatchReceiverParameter(this.getDummyDispatchReceiverParameter(function2));
                }
                irCall = irCall2;
            }
            IrCall updatedCall = irCall;
            return super.visitCall(updatedCall);
        }

        private final boolean needToBeWrappedWithGlobalThis(IrDeclarationWithName $this$needToBeWrappedWithGlobalThis) {
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$needToBeWrappedWithGlobalThis).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJsNameOrKotlinName().toString()");
            return !IdentifierPolicyKt.isValidES5Identifier(string2);
        }

        private final IrDynamicMemberExpression wrapInGlobalThis(IrDeclarationWithName $this$wrapInGlobalThis, IrExpression expression2) {
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            String string2 = AnnotationUtilsKt.getJsNameOrKotlinName($this$wrapInGlobalThis).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJsNameOrKotlinName().asString()");
            return new IrDynamicMemberExpressionImpl(n, n2, irType, string2, this.getGlobalThisReceiver());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
            if ($this$isThisReceiver instanceof IrVariable) return false;
            IrDeclarationParent p = $this$isThisReceiver.getParent();
            if (p instanceof IrSimpleFunction) {
                if ($this$isThisReceiver != ((IrSimpleFunction)p).getDispatchReceiverParameter()) return false;
                return true;
            }
            if (!(p instanceof IrClass)) return false;
            if ($this$isThisReceiver != ((IrClass)p).getThisReceiver()) return false;
            return true;
        }
    }
}

