/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\rH&J\u0010\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0011H&J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0018H&J\u001e\u0010;\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u00010=2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030?H&J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020#H&J\b\u0010B\u001a\u00020CH&J\b\u0010D\u001a\u00020CH&J\b\u0010E\u001a\u00020CH&J\b\u0010F\u001a\u00020CH&J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020IH\u0016J-\u0010J\u001a\u0002HK\"\u0004\b\u0000\u0010K2\u0006\u00108\u001a\u00020\u00112\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HK0M\u00a2\u0006\u0002\u0010NR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0012\u0010%\u001a\u00020&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u001402X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/MutableDiagnosticContext;", "()V", "allErrorsSuppressed", "", "getAllErrorsSuppressed", "()Z", "allInfosSuppressed", "getAllInfosSuppressed", "allWarningsSuppressed", "getAllWarningsSuppressed", "annotationContainers", "", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getAnnotationContainers", "()Ljava/util/List;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "containingFilePath", "", "getContainingFilePath", "()Ljava/lang/String;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "qualifiedAccessOrAnnotationCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getQualifiedAccessOrAnnotationCalls", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "suppressedDiagnostics", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "addAnnotationContainer", "annotationContainer", "addDeclaration", "declaration", "addGetClassCall", "getClassCall", "addImplicitReceiver", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "addQualifiedAccessOrAnnotationCall", "qualifiedAccessOrAnnotationCall", "dropAnnotationContainer", "", "dropDeclaration", "dropGetClassCall", "dropQualifiedAccessOrAnnotationCall", "isDiagnosticSuppressed", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "withDeclaration", "T", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
public abstract class CheckerContext
extends MutableDiagnosticContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract ImplicitReceiverStack getImplicitReceiverStack();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirStatement> getQualifiedAccessOrAnnotationCalls();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract List<FirAnnotationContainer> getAnnotationContainers();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public abstract CheckerContext addImplicitReceiver(@Nullable Name var1, @NotNull ImplicitReceiverValue<?> var2);

    @NotNull
    public abstract CheckerContext addDeclaration(@NotNull FirDeclaration var1);

    public abstract void dropDeclaration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withDeclaration(@NotNull FirDeclaration declaration2, @NotNull Function1<? super CheckerContext, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        CheckerContext newContext = this.addDeclaration(declaration2);
        try {
            Object object = f.invoke((Object)newContext);
            return (T)object;
        }
        finally {
            newContext.dropDeclaration();
        }
    }

    @NotNull
    public abstract CheckerContext addQualifiedAccessOrAnnotationCall(@NotNull FirStatement var1);

    public abstract void dropQualifiedAccessOrAnnotationCall();

    @NotNull
    public abstract CheckerContext addGetClassCall(@NotNull FirGetClassCall var1);

    public abstract void dropGetClassCall();

    @NotNull
    public abstract CheckerContext addAnnotationContainer(@NotNull FirAnnotationContainer var1);

    public abstract void dropAnnotationContainer();

    @Override
    public boolean isDiagnosticSuppressed(@NotNull KtDiagnostic diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        AbstractKtDiagnosticFactory factory2 = diagnostic.getFactory();
        String name2 = factory2.getName();
        switch (WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name2);
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession());
    }

    @Override
    @Nullable
    public String getContainingFilePath() {
        String string2;
        FirDeclaration firDeclaration = (FirDeclaration)CollectionsKt.firstOrNull(this.getContainingDeclarations());
        if (firDeclaration != null) {
            FirDeclaration it = firDeclaration;
            boolean bl = false;
            FirFile firFile = it instanceof FirFile ? (FirFile)it : null;
            string2 = firFile != null ? firFile.getPath() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            nArray[Severity.INFO.ordinal()] = 1;
            nArray[Severity.WARNING.ordinal()] = 2;
            nArray[Severity.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

