/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.InlineTestUtil;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\"#$%&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J*\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nJ2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\nH\u0002J\u001e\u0010\u0019\u001a\u00020\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\bH\u0002J\u0016\u0010!\u001a\u00020\u00172\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil;", "", "()V", "checkInlineMethodNotInvoked", "", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$NotInlinedCall;", "files", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "inlinedMethods", "", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "checkNoCallsToInline", "", "outputFiles", "skipParameterCheckingInDirectives", "", "skippedMethods", "", "checkParametersInlined", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$NotInlinedParameter;", "inlineInfo", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$InlineInfo;", "skipMethods", "doLambdaInliningCheck", "isClassOrPackagePartKind", "klass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "isTopLevelOrInnerOrPackageClass", "classInternalName", "loadBinaryClass", "file", "obtainInlineInfo", "ClassVisitorWithName", "InlineInfo", "MethodInfo", "MethodNodeWithAnonymousObjectCheck", "NotInlinedCall", "NotInlinedParameter", "test-infrastructure-utils"})
public final class InlineTestUtil {
    @NotNull
    public static final InlineTestUtil INSTANCE = new InlineTestUtil();

    private InlineTestUtil() {
    }

    public final void checkNoCallsToInline(@NotNull Iterable<? extends OutputFile> outputFiles, boolean skipParameterCheckingInDirectives, @NotNull Set<String> skippedMethods) {
        boolean skipParameterChecking;
        boolean bl;
        Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
        Intrinsics.checkNotNullParameter(skippedMethods, (String)"skippedMethods");
        InlineInfo inlineInfo = this.obtainInlineInfo(outputFiles);
        Set<MethodInfo> inlineMethods = inlineInfo.getInlineMethods();
        boolean bl2 = bl = !((Collection)inlineMethods).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InlineTestUtil$checkNoCallsToInline$42 = false;
            String $i$a$-assert-InlineTestUtil$checkNoCallsToInline$42 = "There are no inline methods";
            throw new AssertionError((Object)$i$a$-assert-InlineTestUtil$checkNoCallsToInline$42);
        }
        List<NotInlinedCall> notInlinedCalls = this.checkInlineMethodNotInvoked(outputFiles, inlineMethods);
        boolean $i$a$-assert-InlineTestUtil$checkNoCallsToInline$42 = notInlinedCalls.isEmpty();
        if (_Assertions.ENABLED && !$i$a$-assert-InlineTestUtil$checkNoCallsToInline$42) {
            boolean $i$a$-assert-InlineTestUtil$checkNoCallsToInline$52 = false;
            String $i$a$-assert-InlineTestUtil$checkNoCallsToInline$52 = "All inline methods should be inlined but:\n" + CollectionsKt.joinToString$default((Iterable)notInlinedCalls, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new AssertionError((Object)$i$a$-assert-InlineTestUtil$checkNoCallsToInline$52);
        }
        boolean bl3 = skipParameterChecking = skipParameterCheckingInDirectives || !this.doLambdaInliningCheck(outputFiles, inlineInfo);
        if (!skipParameterChecking) {
            ArrayList<NotInlinedParameter> notInlinedParameters = this.checkParametersInlined(outputFiles, inlineInfo, skippedMethods);
            boolean bl4 = notInlinedParameters.isEmpty();
            if (_Assertions.ENABLED && !bl4) {
                boolean bl5 = false;
                String string2 = "All inline parameters should be inlined but:\n" + CollectionsKt.joinToString$default((Iterable)notInlinedParameters, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\nbut if you have not inlined lambdas or anonymous objects enable NO_CHECK_LAMBDA_INLINING directive";
                throw new AssertionError((Object)string2);
            }
        }
    }

    private final InlineInfo obtainInlineInfo(Iterable<? extends OutputFile> files2) {
        HashSet<MethodInfo> inlineMethods = new HashSet<MethodInfo>();
        HashMap binaryClasses2 = new HashMap();
        for (OutputFile outputFile : files2) {
            KotlinJvmBinaryClass binaryClass = this.loadBinaryClass(outputFile);
            Set<String> inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames(binaryClass.getClassHeader());
            ClassVisitorWithName classVisitor2 = new ClassVisitorWithName(inlineFunctions, inlineMethods){
                final /* synthetic */ Set<String> $inlineFunctions;
                final /* synthetic */ HashSet<MethodInfo> $inlineMethods;
                {
                    this.$inlineFunctions = $inlineFunctions;
                    this.$inlineMethods = $inlineMethods;
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    if (this.$inlineFunctions.contains(name2 + desc)) {
                        this.$inlineMethods.add(new MethodInfo(this.getClassName(), name2, desc));
                    }
                    return null;
                }
            };
            new ClassReader(outputFile.asByteArray()).accept((ClassVisitor)classVisitor2, 0);
            ((Map)binaryClasses2).put(classVisitor2.getClassName(), binaryClass);
        }
        return new InlineInfo((Set<MethodInfo>)inlineMethods, binaryClasses2);
    }

    private final boolean doLambdaInliningCheck(Iterable<? extends OutputFile> files2, InlineInfo inlineInfo) {
        Ref.BooleanRef doLambdaInliningCheck2 = new Ref.BooleanRef();
        doLambdaInliningCheck2.element = true;
        for (OutputFile outputFile : files2) {
            KotlinJvmBinaryClass binaryClass = this.loadBinaryClass(outputFile);
            Set<String> inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames(binaryClass.getClassHeader());
            ClassVisitorWithName classVisitor2 = new ClassVisitorWithName(inlineFunctions, inlineInfo, doLambdaInliningCheck2){
                final /* synthetic */ Set<String> $inlineFunctions;
                final /* synthetic */ InlineInfo $inlineInfo;
                final /* synthetic */ Ref.BooleanRef $doLambdaInliningCheck;
                {
                    this.$inlineFunctions = $inlineFunctions;
                    this.$inlineInfo = $inlineInfo;
                    this.$doLambdaInliningCheck = $doLambdaInliningCheck;
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    if (this.$inlineFunctions.contains(name2 + desc)) {
                        return (MethodVisitor)new MethodNodeWithAnonymousObjectCheck(this.$inlineInfo, access, name2, desc, signature2, exceptions, this.$doLambdaInliningCheck){
                            final /* synthetic */ Ref.BooleanRef $doLambdaInliningCheck;
                            {
                                this.$doLambdaInliningCheck = $doLambdaInliningCheck;
                                super($inlineInfo, $access, $name, $desc, $signature, $exceptions);
                            }

                            public void onAnonymousConstructorCallOrSingletonAccess(@NotNull String owner) {
                                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                                this.$doLambdaInliningCheck.element = false;
                            }
                        };
                    }
                    return null;
                }
            };
            new ClassReader(outputFile.asByteArray()).accept((ClassVisitor)classVisitor2, 0);
            if (doLambdaInliningCheck2.element) continue;
            break;
        }
        return doLambdaInliningCheck2.element;
    }

    private final List<NotInlinedCall> checkInlineMethodNotInvoked(Iterable<? extends OutputFile> files2, Set<MethodInfo> inlinedMethods) {
        ArrayList<NotInlinedCall> notInlined = new ArrayList<NotInlinedCall>();
        Iterable<? extends OutputFile> $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        Iterator<? extends OutputFile> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            OutputFile element$iv;
            OutputFile file2 = element$iv = iterator2.next();
            boolean bl = false;
            new ClassReader(file2.asByteArray()).accept((ClassVisitor)new ClassVisitorWithName(inlinedMethods, notInlined){
                private boolean skipMethodsOfThisClass;
                final /* synthetic */ Set<MethodInfo> $inlinedMethods;
                final /* synthetic */ ArrayList<NotInlinedCall> $notInlined;
                {
                    this.$inlinedMethods = $inlinedMethods;
                    this.$notInlined = $notInlined;
                }

                @Nullable
                public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    if (Intrinsics.areEqual((Object)desc, (Object)JvmAnnotationNames.METADATA_DESC)) {
                        return new AnnotationVisitor(this){
                            final /* synthetic */ checkInlineMethodNotInvoked.1.1 this$0;
                            {
                                this.this$0 = $receiver;
                                super(589824);
                            }

                            public void visit(@Nullable String name2, @NotNull Object value2) {
                                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                                if (Intrinsics.areEqual((Object)name2, (Object)"k") && Intrinsics.areEqual((Object)value2, (Object)KotlinClassHeader.Kind.MULTIFILE_CLASS.getId())) {
                                    checkInlineMethodNotInvoked.1.1.access$setSkipMethodsOfThisClass$p(this.this$0, true);
                                }
                            }
                        };
                    }
                    return null;
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    if (this.skipMethodsOfThisClass) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)name2, (Object)"invokeSuspend") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava/lang/Object;)Ljava/lang/Object;")) {
                        return null;
                    }
                    return (MethodVisitor)new MethodNode(access, name2, desc, signature2, exceptions, this.$inlinedMethods, this, this.$notInlined){
                        final /* synthetic */ Set<MethodInfo> $inlinedMethods;
                        final /* synthetic */ checkInlineMethodNotInvoked.1.1 this$0;
                        final /* synthetic */ ArrayList<NotInlinedCall> $notInlined;
                        {
                            this.$inlinedMethods = $inlinedMethods;
                            this.this$0 = $receiver;
                            this.$notInlined = $notInlined;
                            super(589824, $access, $name, $desc, $signature, $exceptions);
                        }

                        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc, boolean itf) {
                            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                            MethodInfo methodCall = new MethodInfo(owner, name2, desc);
                            if (this.$inlinedMethods.contains(methodCall)) {
                                String string2 = this.this$0.getClassName();
                                String string3 = this.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.name");
                                String string4 = this.desc;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.desc");
                                MethodInfo fromCall = new MethodInfo(string2, string3, string4);
                                if (StringsKt.endsWith$default((String)methodCall.getOwner(), (String)"$DefaultImpls", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)fromCall.getOwner(), (Object)methodCall.getOwner())) {
                                    return;
                                }
                                this.$notInlined.add(new NotInlinedCall(fromCall, methodCall));
                            }
                        }
                    };
                }

                public static final /* synthetic */ void access$setSkipMethodsOfThisClass$p(checkInlineMethodNotInvoked.1.1 $this, boolean bl) {
                    $this.skipMethodsOfThisClass = bl;
                }
            }, 0);
        }
        return notInlined;
    }

    private final ArrayList<NotInlinedParameter> checkParametersInlined(Iterable<? extends OutputFile> outputFiles, InlineInfo inlineInfo, Set<String> skipMethods) {
        Set<MethodInfo> inlinedMethods = inlineInfo.getInlineMethods();
        ArrayList<NotInlinedParameter> notInlinedParameters = new ArrayList<NotInlinedParameter>();
        for (OutputFile outputFile : outputFiles) {
            if (!this.isClassOrPackagePartKind(this.loadBinaryClass(outputFile))) continue;
            new ClassReader(outputFile.asByteArray()).accept((ClassVisitor)new ClassVisitorWithName(inlinedMethods, skipMethods, inlineInfo, notInlinedParameters){
                final /* synthetic */ Set<MethodInfo> $inlinedMethods;
                final /* synthetic */ Set<String> $skipMethods;
                final /* synthetic */ InlineInfo $inlineInfo;
                final /* synthetic */ ArrayList<NotInlinedParameter> $notInlinedParameters;
                {
                    this.$inlinedMethods = $inlinedMethods;
                    this.$skipMethods = $skipMethods;
                    this.$inlineInfo = $inlineInfo;
                    this.$notInlinedParameters = $notInlinedParameters;
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                    MethodInfo declaration2 = new MethodInfo(this.getClassName(), name2, desc);
                    if (this.$inlinedMethods.contains(declaration2)) {
                        return null;
                    }
                    if (this.$skipMethods.contains(name2)) {
                        return null;
                    }
                    return (MethodVisitor)new MethodNodeWithAnonymousObjectCheck(this.$inlineInfo, access, name2, desc, signature2, exceptions, this, this.$notInlinedParameters){
                        final /* synthetic */ checkParametersInlined.1 this$0;
                        final /* synthetic */ ArrayList<NotInlinedParameter> $notInlinedParameters;
                        {
                            this.this$0 = $receiver;
                            this.$notInlinedParameters = $notInlinedParameters;
                            super($inlineInfo, $access, $name, $desc, $signature, $exceptions);
                        }

                        public void onAnonymousConstructorCallOrSingletonAccess(@NotNull String owner) {
                            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                            String string2 = this.this$0.getClassName();
                            String string3 = this.name;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.name");
                            String string4 = this.desc;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this.desc");
                            MethodInfo fromCall = new MethodInfo(string2, string3, string4);
                            this.$notInlinedParameters.add(new NotInlinedParameter(owner, fromCall));
                        }
                    };
                }
            }, 0);
        }
        return notInlinedParameters;
    }

    private final boolean isTopLevelOrInnerOrPackageClass(String classInternalName, InlineInfo inlineInfo) {
        if (StringsKt.startsWith$default((String)classInternalName, (String)"kotlin/jvm/internal/", (boolean)false, (int)2, null)) {
            return true;
        }
        return this.isClassOrPackagePartKind((KotlinJvmBinaryClass)MapsKt.getValue(inlineInfo.getBinaryClasses(), (Object)classInternalName));
    }

    private final boolean isClassOrPackagePartKind(KotlinJvmBinaryClass klass) {
        return klass.getClassHeader().getKind() == KotlinClassHeader.Kind.CLASS && !klass.getClassId().isLocal() || klass.getClassHeader().getKind() == KotlinClassHeader.Kind.FILE_FACADE || klass.getClassHeader().getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    private final KotlinJvmBinaryClass loadBinaryClass(OutputFile file2) {
        Object t = FileBasedKotlinClass.create(file2.asByteArray(), loadBinaryClass.1.INSTANCE);
        Intrinsics.checkNotNull(t);
        return (KotlinJvmBinaryClass)t;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$InlineInfo;", "", "inlineMethods", "", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "binaryClasses", "", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "(Ljava/util/Set;Ljava/util/Map;)V", "getBinaryClasses", "()Ljava/util/Map;", "getInlineMethods", "()Ljava/util/Set;", "test-infrastructure-utils"})
    private static final class InlineInfo {
        @NotNull
        private final Set<MethodInfo> inlineMethods;
        @NotNull
        private final Map<String, KotlinJvmBinaryClass> binaryClasses;

        public InlineInfo(@NotNull Set<MethodInfo> inlineMethods, @NotNull Map<String, ? extends KotlinJvmBinaryClass> binaryClasses2) {
            Intrinsics.checkNotNullParameter(inlineMethods, (String)"inlineMethods");
            Intrinsics.checkNotNullParameter(binaryClasses2, (String)"binaryClasses");
            this.inlineMethods = inlineMethods;
            this.binaryClasses = binaryClasses2;
        }

        @NotNull
        public final Set<MethodInfo> getInlineMethods() {
            return this.inlineMethods;
        }

        @NotNull
        public final Map<String, KotlinJvmBinaryClass> getBinaryClasses() {
            return this.binaryClasses;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$NotInlinedCall;", "", "fromCall", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "inlineMethod", "(Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;)V", "getFromCall", "()Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "getInlineMethod", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "test-infrastructure-utils"})
    private static final class NotInlinedCall {
        @NotNull
        private final MethodInfo fromCall;
        @NotNull
        private final MethodInfo inlineMethod;

        public NotInlinedCall(@NotNull MethodInfo fromCall, @NotNull MethodInfo inlineMethod) {
            Intrinsics.checkNotNullParameter((Object)fromCall, (String)"fromCall");
            Intrinsics.checkNotNullParameter((Object)inlineMethod, (String)"inlineMethod");
            this.fromCall = fromCall;
            this.inlineMethod = inlineMethod;
        }

        @NotNull
        public final MethodInfo getFromCall() {
            return this.fromCall;
        }

        @NotNull
        public final MethodInfo getInlineMethod() {
            return this.inlineMethod;
        }

        @NotNull
        public final MethodInfo component1() {
            return this.fromCall;
        }

        @NotNull
        public final MethodInfo component2() {
            return this.inlineMethod;
        }

        @NotNull
        public final NotInlinedCall copy(@NotNull MethodInfo fromCall, @NotNull MethodInfo inlineMethod) {
            Intrinsics.checkNotNullParameter((Object)fromCall, (String)"fromCall");
            Intrinsics.checkNotNullParameter((Object)inlineMethod, (String)"inlineMethod");
            return new NotInlinedCall(fromCall, inlineMethod);
        }

        public static /* synthetic */ NotInlinedCall copy$default(NotInlinedCall notInlinedCall, MethodInfo methodInfo, MethodInfo methodInfo2, int n, Object object) {
            if ((n & 1) != 0) {
                methodInfo = notInlinedCall.fromCall;
            }
            if ((n & 2) != 0) {
                methodInfo2 = notInlinedCall.inlineMethod;
            }
            return notInlinedCall.copy(methodInfo, methodInfo2);
        }

        @NotNull
        public String toString() {
            return "NotInlinedCall(fromCall=" + this.fromCall + ", inlineMethod=" + this.inlineMethod + ')';
        }

        public int hashCode() {
            int result2 = this.fromCall.hashCode();
            result2 = result2 * 31 + this.inlineMethod.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotInlinedCall)) {
                return false;
            }
            NotInlinedCall notInlinedCall = (NotInlinedCall)other;
            if (!Intrinsics.areEqual((Object)this.fromCall, (Object)notInlinedCall.fromCall)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.inlineMethod, (Object)notInlinedCall.inlineMethod);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$NotInlinedParameter;", "", "parameterClassName", "", "fromCall", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;)V", "getFromCall", "()Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "getParameterClassName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "test-infrastructure-utils"})
    private static final class NotInlinedParameter {
        @NotNull
        private final String parameterClassName;
        @NotNull
        private final MethodInfo fromCall;

        public NotInlinedParameter(@NotNull String parameterClassName, @NotNull MethodInfo fromCall) {
            Intrinsics.checkNotNullParameter((Object)parameterClassName, (String)"parameterClassName");
            Intrinsics.checkNotNullParameter((Object)fromCall, (String)"fromCall");
            this.parameterClassName = parameterClassName;
            this.fromCall = fromCall;
        }

        @NotNull
        public final String getParameterClassName() {
            return this.parameterClassName;
        }

        @NotNull
        public final MethodInfo getFromCall() {
            return this.fromCall;
        }

        @NotNull
        public final String component1() {
            return this.parameterClassName;
        }

        @NotNull
        public final MethodInfo component2() {
            return this.fromCall;
        }

        @NotNull
        public final NotInlinedParameter copy(@NotNull String parameterClassName, @NotNull MethodInfo fromCall) {
            Intrinsics.checkNotNullParameter((Object)parameterClassName, (String)"parameterClassName");
            Intrinsics.checkNotNullParameter((Object)fromCall, (String)"fromCall");
            return new NotInlinedParameter(parameterClassName, fromCall);
        }

        public static /* synthetic */ NotInlinedParameter copy$default(NotInlinedParameter notInlinedParameter, String string2, MethodInfo methodInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = notInlinedParameter.parameterClassName;
            }
            if ((n & 2) != 0) {
                methodInfo = notInlinedParameter.fromCall;
            }
            return notInlinedParameter.copy(string2, methodInfo);
        }

        @NotNull
        public String toString() {
            return "NotInlinedParameter(parameterClassName=" + this.parameterClassName + ", fromCall=" + this.fromCall + ')';
        }

        public int hashCode() {
            int result2 = this.parameterClassName.hashCode();
            result2 = result2 * 31 + this.fromCall.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotInlinedParameter)) {
                return false;
            }
            NotInlinedParameter notInlinedParameter = (NotInlinedParameter)other;
            if (!Intrinsics.areEqual((Object)this.parameterClassName, (Object)notInlinedParameter.parameterClassName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fromCall, (Object)notInlinedParameter.fromCall);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodInfo;", "", "owner", "", "name", "desc", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDesc", "()Ljava/lang/String;", "getName", "getOwner", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "test-infrastructure-utils"})
    private static final class MethodInfo {
        @NotNull
        private final String owner;
        @NotNull
        private final String name;
        @NotNull
        private final String desc;

        public MethodInfo(@NotNull String owner, @NotNull String name2, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            this.owner = owner;
            this.name = name2;
            this.desc = desc;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDesc() {
            return this.desc;
        }

        @NotNull
        public final String component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.desc;
        }

        @NotNull
        public final MethodInfo copy(@NotNull String owner, @NotNull String name2, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return new MethodInfo(owner, name2, desc);
        }

        public static /* synthetic */ MethodInfo copy$default(MethodInfo methodInfo, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = methodInfo.owner;
            }
            if ((n & 2) != 0) {
                string3 = methodInfo.name;
            }
            if ((n & 4) != 0) {
                string4 = methodInfo.desc;
            }
            return methodInfo.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "MethodInfo(owner=" + this.owner + ", name=" + this.name + ", desc=" + this.desc + ')';
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.desc.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodInfo)) {
                return false;
            }
            MethodInfo methodInfo = (MethodInfo)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)methodInfo.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)methodInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.desc, (Object)methodInfo.desc);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$ClassVisitorWithName;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "test-infrastructure-utils"})
    private static class ClassVisitorWithName
    extends ClassVisitor {
        public String className;

        public ClassVisitorWithName() {
            super(589824);
        }

        @NotNull
        public final String getClassName() {
            String string2 = this.className;
            if (string2 != null) {
                return string2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
            return null;
        }

        public final void setClassName(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.className = string2;
        }

        public void visit(int version, int access, @NotNull String name2, @Nullable String signature2, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.setClassName(name2);
            super.visit(version, access, name2, signature2, superName, interfaces);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\"\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H&J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J0\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/InlineTestUtil$MethodNodeWithAnonymousObjectCheck;", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "inlineInfo", "Lorg/jetbrains/kotlin/codegen/InlineTestUtil$InlineInfo;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lorg/jetbrains/kotlin/codegen/InlineTestUtil$InlineInfo;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getInlineInfo", "()Lorg/jetbrains/kotlin/codegen/InlineTestUtil$InlineInfo;", "isInlineParameterLikeOwner", "", "owner", "onAnonymousConstructorCallOrSingletonAccess", "", "visitFieldInsn", "opcode", "visitMethodInsn", "itf", "test-infrastructure-utils"})
    private static abstract class MethodNodeWithAnonymousObjectCheck
    extends MethodNode {
        @NotNull
        private final InlineInfo inlineInfo;

        public MethodNodeWithAnonymousObjectCheck(@NotNull InlineInfo inlineInfo, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)inlineInfo, (String)"inlineInfo");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            super(589824, access, name2, desc, signature2, exceptions);
            this.inlineInfo = inlineInfo;
        }

        @NotNull
        public final InlineInfo getInlineInfo() {
            return this.inlineInfo;
        }

        private final boolean isInlineParameterLikeOwner(String owner) {
            return StringsKt.contains$default((CharSequence)owner, (CharSequence)"$", (boolean)false, (int)2, null) && !INSTANCE.isTopLevelOrInnerOrPackageClass(owner, this.inlineInfo);
        }

        public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc, boolean itf) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (Intrinsics.areEqual((Object)"<init>", (Object)name2) && this.isInlineParameterLikeOwner(owner)) {
                this.onAnonymousConstructorCallOrSingletonAccess(owner);
            }
        }

        public abstract void onAnonymousConstructorCallOrSingletonAccess(@NotNull String var1);

        public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            if (opcode == 178 && this.isInlineParameterLikeOwner(owner)) {
                this.onAnonymousConstructorCallOrSingletonAccess(owner);
            }
            super.visitFieldInsn(opcode, owner, name2, desc);
        }
    }
}

