/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.OccurrenceInfo;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\u001a*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\r\u001a4\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\u0005\u001a\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u001a>\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"AT_OUTPUT_FILE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EXPECTED_OCCURRENCES_PATTERN", "JVM_IR_TEMPLATES", "", "JVM_TEMPLATES", "assertTextWasGenerated", "", "expectedOutputFile", "generated", "", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "checkGeneratedTextAgainstExpectedOccurrences", "text", "expectedOccurrences", "", "Lorg/jetbrains/kotlin/codegen/OccurrenceInfo;", "currentBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "reportProblems", "", "parseOccurrenceInfo", "matcher", "Ljava/util/regex/Matcher;", "backend", "readExpectedOccurrences", "filename", "lines", "readExpectedOccurrencesForMultiFileTest", "fileName", "fileContent", "withGeneratedFile", "", "global", "", "test-infrastructure-utils"})
public final class BytecodeTextUtilsKt {
    private static final Pattern AT_OUTPUT_FILE_PATTERN = Pattern.compile("^\\s*//\\s*@(.*):$");
    private static final Pattern EXPECTED_OCCURRENCES_PATTERN = Pattern.compile("^\\s*//\\s*(\\d+)\\s*(.*)$");
    @NotNull
    private static final String JVM_TEMPLATES = "// JVM_TEMPLATES";
    @NotNull
    private static final String JVM_IR_TEMPLATES = "// JVM_IR_TEMPLATES";

    @NotNull
    public static final List<OccurrenceInfo> readExpectedOccurrences(@NotNull String filename) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        List $this$dropLastWhile$iv = FilesKt.readLines$default((File)new File(filename), null, (int)1, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String p0 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)p0).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List lines = list2;
        return BytecodeTextUtilsKt.readExpectedOccurrences(lines);
    }

    @NotNull
    public static final List<OccurrenceInfo> readExpectedOccurrences(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        ArrayList<OccurrenceInfo> result2 = new ArrayList<OccurrenceInfo>();
        TargetBackend backend = TargetBackend.ANY;
        for (String line : lines) {
            Matcher matcher2;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM;
            } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM_IR;
            }
            if (!(matcher2 = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"matcher");
            result2.add(BytecodeTextUtilsKt.parseOccurrenceInfo(matcher2, backend));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void readExpectedOccurrencesForMultiFileTest(@NotNull String fileName, @NotNull String fileContent, @NotNull Map<String, List<OccurrenceInfo>> withGeneratedFile, @NotNull List<OccurrenceInfo> global) {
        void $this$toTypedArray$iv;
        List list2;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter(withGeneratedFile, (String)"withGeneratedFile");
        Intrinsics.checkNotNullParameter(global, (String)"global");
        List currentOccurrenceInfos = global;
        TargetBackend backend = TargetBackend.ANY;
        Object object = fileContent;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        for (String line : stringArray) {
            Matcher expectedOccurrencesMatcher;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM;
            } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM_IR;
            }
            Matcher atOutputFileMatcher = AT_OUTPUT_FILE_PATTERN.matcher(line);
            if (atOutputFileMatcher.matches()) {
                String outputFileName = atOutputFileMatcher.group(1);
                if (withGeneratedFile.containsKey(outputFileName)) {
                    throw new AssertionError((Object)(fileName + ": Expected occurrences for output file " + outputFileName + " were already provided"));
                }
                currentOccurrenceInfos = new ArrayList();
                Intrinsics.checkNotNullExpressionValue((Object)outputFileName, (String)"outputFileName");
                withGeneratedFile.put(outputFileName, currentOccurrenceInfos);
            }
            if (!(expectedOccurrencesMatcher = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)expectedOccurrencesMatcher, (String)"expectedOccurrencesMatcher");
            OccurrenceInfo occurrenceInfo = BytecodeTextUtilsKt.parseOccurrenceInfo(expectedOccurrencesMatcher, backend);
            currentOccurrenceInfos.add(occurrenceInfo);
        }
    }

    private static final OccurrenceInfo parseOccurrenceInfo(Matcher matcher2, TargetBackend backend) {
        int numberOfOccurrences = Integer.parseInt(matcher2.group(1));
        String needle = matcher2.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)needle, (String)"needle");
        return new OccurrenceInfo(numberOfOccurrences, needle, backend);
    }

    public static final void checkGeneratedTextAgainstExpectedOccurrences(@NotNull String text2, @NotNull List<OccurrenceInfo> expectedOccurrences, @NotNull TargetBackend currentBackend, boolean reportProblems, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(expectedOccurrences, (String)"expectedOccurrences");
        Intrinsics.checkNotNullParameter((Object)((Object)currentBackend), (String)"currentBackend");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        StringBuilder expected = new StringBuilder();
        StringBuilder actual = new StringBuilder();
        TargetBackend lastBackend = TargetBackend.ANY;
        for (OccurrenceInfo info : expectedOccurrences) {
            if (lastBackend != info.getBackend()) {
                String string2;
                String string3;
                switch (WhenMappings.$EnumSwitchMapping$0[info.getBackend().ordinal()]) {
                    case 1: {
                        string3 = JVM_TEMPLATES;
                        break;
                    }
                    case 2: {
                        string3 = JVM_IR_TEMPLATES;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Common part should be first one: " + CollectionsKt.joinToString$default((Iterable)expectedOccurrences, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
                    }
                }
                String it = string2 = string3;
                boolean bl = false;
                actual.append('\n' + it + '\n');
                expected.append('\n' + it + '\n');
                lastBackend = info.getBackend();
            }
            expected.append(info).append("\n");
            if (info.getBackend() == TargetBackend.ANY || info.getBackend() == currentBackend) {
                actual.append(info.getActualOccurrence(text2)).append("\n");
                continue;
            }
            actual.append(info).append("\n");
        }
        try {
            assertions.assertEquals(expected.toString(), actual.toString(), (Function0<String>)((Function0)new Function0<String>(text2){
                final /* synthetic */ String $text;
                {
                    this.$text = $text;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$text;
                }
            }));
        }
        catch (Throwable e) {
            if (reportProblems) {
                System.out.println((Object)text2);
            }
            throw e;
        }
    }

    public static final void assertTextWasGenerated(@NotNull String expectedOutputFile, @NotNull Map<String, String> generated, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)expectedOutputFile, (String)"expectedOutputFile");
        Intrinsics.checkNotNullParameter(generated, (String)"generated");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        if (!generated.containsKey(expectedOutputFile)) {
            StringBuilder failMessage = new StringBuilder();
            failMessage.append("Missing output file ").append(expectedOutputFile).append(", got ").append(generated.size()).append(": ");
            for (String generatedFile : generated.keySet()) {
                failMessage.append(generatedFile).append(" ");
            }
            assertions.fail((Function0<String>)((Function0)new Function0<String>(failMessage){
                final /* synthetic */ StringBuilder $failMessage;
                {
                    this.$failMessage = $failMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string2 = this.$failMessage.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"failMessage.toString()");
                    return string2;
                }
            }));
            throw null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TargetBackend.values().length];
            nArray[TargetBackend.JVM.ordinal()] = 1;
            nArray[TargetBackend.JVM_IR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

