/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "name", "", "value", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "sizeInBytes", "getSizeInBytes", "()I", "getValue", "()Ljava/util/List;", "dump", "indent", "startAddress", "toBytes", "", "backend.wasm"})
public final class ConstantDataIntArray
extends ConstantDataElement {
    @NotNull
    private final String name;
    @NotNull
    private final List<WasmSymbol<Integer>> value;
    private final int sizeInBytes;

    public ConstantDataIntArray(@NotNull String name2, @NotNull List<WasmSymbol<Integer>> value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        super(null);
        this.name = name2;
        this.value = value2;
        this.sizeInBytes = this.value.size() * 4;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<WasmSymbol<Integer>> getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toBytes() {
        void $this$fold$iv;
        Iterable iterable = this.value;
        byte[] initial$iv = new byte[]{};
        boolean $i$f$fold = false;
        byte[] accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void el;
            WasmSymbol wasmSymbol = (WasmSymbol)element$iv;
            byte[] acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])ConstantDataKt.toLittleEndianBytes(((Number)el.getOwner()).intValue()));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (this.value.isEmpty()) {
            return "";
        }
        Iterable iterable = this.value;
        StringBuilder stringBuilder2 = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i32[] : ");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WasmSymbol wasmSymbol = (WasmSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)it.getOwner()).intValue());
        }
        String string2 = Arrays.toString(CollectionsKt.toIntArray((Collection)((List)destination$iv$iv)));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append("   ;; ").append(this.name).append('\n').toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

