/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.NumericHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UnsignedProgressionType;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.expressions.IrExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u000b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionHeaderInfo;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/NumericHeaderInfo;", "progressionType", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "first", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "last", "step", "isLastInclusive", "", "isReversed", "canOverflow", "direction", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionDirection;", "additionalStatements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "originalLastInclusive", "(Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;ZZLjava/lang/Boolean;Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionDirection;Ljava/util/List;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getAdditionalStatements", "()Ljava/util/List;", "getCanOverflow", "()Z", "canOverflow$delegate", "Lkotlin/Lazy;", "getOriginalLastInclusive", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "asReversed", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "revertToLastInclusive", "ir.backend.common"})
public final class ProgressionHeaderInfo
extends NumericHeaderInfo {
    @NotNull
    private final List<IrStatement> additionalStatements;
    @Nullable
    private final IrExpression originalLastInclusive;
    @NotNull
    private final Lazy canOverflow$delegate;

    public ProgressionHeaderInfo(@NotNull ProgressionType progressionType, @NotNull IrExpression first, @NotNull IrExpression last, @NotNull IrExpression step2, boolean isLastInclusive, boolean isReversed, @Nullable Boolean canOverflow2, @NotNull ProgressionDirection direction, @NotNull List<? extends IrStatement> additionalStatements2, @Nullable IrExpression originalLastInclusive) {
        Intrinsics.checkNotNullParameter((Object)progressionType, (String)"progressionType");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)last, (String)"last");
        Intrinsics.checkNotNullParameter((Object)step2, (String)"step");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(additionalStatements2, (String)"additionalStatements");
        super(progressionType, first, last, step2, isLastInclusive, true, isReversed, direction, null);
        this.additionalStatements = additionalStatements2;
        this.originalLastInclusive = originalLastInclusive;
        this.canOverflow$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(canOverflow2, step2, direction, progressionType, last){
            final /* synthetic */ Boolean $canOverflow;
            final /* synthetic */ IrExpression $step;
            final /* synthetic */ ProgressionDirection $direction;
            final /* synthetic */ ProgressionType $progressionType;
            final /* synthetic */ IrExpression $last;
            {
                this.$canOverflow = $canOverflow;
                this.$step = $step;
                this.$direction = $direction;
                this.$progressionType = $progressionType;
                this.$last = $last;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block16: {
                    long stepValueAsLong;
                    block15: {
                        if (this.$canOverflow != null) {
                            return this.$canOverflow;
                        }
                        Long l = UtilsKt.getConstLongValue(this.$step);
                        if (l == null) {
                            return true;
                        }
                        stepValueAsLong = l;
                        if (this.$direction == ProgressionDirection.UNKNOWN) {
                            return true;
                        }
                        if (!(this.$progressionType instanceof UnsignedProgressionType)) break block15;
                        Long l2 = UtilsKt.getConstLongValue(this.$last);
                        if (l2 == null) {
                            return true;
                        }
                        long lastValueAsULong = ULong.constructor-impl((long)l2);
                        switch (canOverflow.WhenMappings.$EnumSwitchMapping$0[this.$direction.ordinal()]) {
                            case 1: {
                                long constLimitAsULong = ULong.constructor-impl((long)this.$progressionType.getMinValueAsLong());
                                bl = Long.compareUnsigned(lastValueAsULong, ULong.constructor-impl((long)(constLimitAsULong - ULong.constructor-impl((long)stepValueAsLong)))) < 0;
                                break block16;
                            }
                            case 2: {
                                long constLimitAsULong = ULong.constructor-impl((long)this.$progressionType.getMaxValueAsLong());
                                bl = Long.compareUnsigned(lastValueAsULong, ULong.constructor-impl((long)(constLimitAsULong - ULong.constructor-impl((long)stepValueAsLong)))) > 0;
                                break block16;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected progression direction".toString());
                            }
                        }
                    }
                    Long l = UtilsKt.getConstLongValue(this.$last);
                    if (l == null) {
                        return true;
                    }
                    long lastValueAsLong = l;
                    switch (canOverflow.WhenMappings.$EnumSwitchMapping$0[this.$direction.ordinal()]) {
                        case 1: {
                            long constLimitAsLong = this.$progressionType.getMinValueAsLong();
                            if (lastValueAsLong < constLimitAsLong - stepValueAsLong) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            long constLimitAsLong = this.$progressionType.getMaxValueAsLong();
                            if (lastValueAsLong > constLimitAsLong - stepValueAsLong) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected progression direction".toString());
                        }
                    }
                }
                return bl;
            }
        }));
    }

    public /* synthetic */ ProgressionHeaderInfo(ProgressionType progressionType, IrExpression irExpression, IrExpression irExpression2, IrExpression irExpression3, boolean bl, boolean bl2, Boolean bl3, ProgressionDirection progressionDirection, List list2, IrExpression irExpression4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = null;
        }
        if ((n & 0x100) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            irExpression4 = null;
        }
        this(progressionType, irExpression, irExpression2, irExpression3, bl, bl2, bl3, progressionDirection, list2, irExpression4);
    }

    @NotNull
    public final List<IrStatement> getAdditionalStatements() {
        return this.additionalStatements;
    }

    @Nullable
    public final IrExpression getOriginalLastInclusive() {
        return this.originalLastInclusive;
    }

    @Nullable
    public final ProgressionHeaderInfo revertToLastInclusive() {
        ProgressionHeaderInfo progressionHeaderInfo;
        IrExpression irExpression = this.originalLastInclusive;
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            progressionHeaderInfo = new ProgressionHeaderInfo(this.getProgressionType(), this.getFirst(), this.originalLastInclusive, this.getStep(), true, this.isReversed(), this.getCanOverflow(), this.getDirection(), this.additionalStatements, null);
        } else {
            progressionHeaderInfo = null;
        }
        return progressionHeaderInfo;
    }

    public final boolean getCanOverflow() {
        Lazy lazy = this.canOverflow$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @Nullable
    public HeaderInfo asReversed() {
        HeaderInfo headerInfo;
        if (this.isLastInclusive()) {
            headerInfo = new ProgressionHeaderInfo(this.getProgressionType(), this.getLast(), this.getFirst(), UtilsKt.negate(this.getStep()), false, !this.isReversed(), null, this.getDirection().asReversed(), this.additionalStatements, null, 592, null);
        } else {
            ProgressionHeaderInfo progressionHeaderInfo = this.revertToLastInclusive();
            headerInfo = progressionHeaderInfo != null ? progressionHeaderInfo.asReversed() : null;
        }
        return headerInfo;
    }
}

