/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cJ*\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\"2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver;", "", "()V", "getCallerName", "Lorg/jetbrains/kotlin/name/Name;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getContainingCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getElementsByLabelName", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "labelName", "labelExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "classNameLabelsEnabled", "", "getExpressionUnderLabel", "labeledExpression", "getLabelForFunctionalExpression", "element", "getLabelNamesIfAny", "", "Lcom/intellij/psi/PsiElement;", "addClassNameLabels", "resolveControlLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolveNamedLabel", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveThisOrSuperLabel", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;", "LabeledReceiverResolutionResult", "frontend"})
public final class LabelResolver {
    @NotNull
    public static final LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    private final Set<KtElement> getElementsByLabelName(Name labelName, KtSimpleNameExpression labelExpression, boolean classNameLabelsEnabled) {
        LinkedHashSet<KtExpression> elements = new LinkedHashSet<KtExpression>();
        PsiElement parent2 = labelExpression.getParent();
        while (parent2 != null) {
            List<Name> names2 = this.getLabelNamesIfAny(parent2, classNameLabelsEnabled);
            if (names2.contains(labelName)) {
                PsiElement psiElement = parent2;
                elements.add(this.getExpressionUnderLabel((KtExpression)psiElement));
            }
            parent2 = parent2 instanceof KtCodeFragment ? ((KtCodeFragment)parent2).getContext() : parent2.getParent();
        }
        return elements;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Name> getLabelNamesIfAny(@NotNull PsiElement element, boolean addClassNameLabels) {
        KtProperty ktProperty;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List result2 = new ArrayList();
        PsiElement psiElement = element;
        if (psiElement instanceof KtLabeledExpression) {
            CollectionsKt.addIfNotNull(result2, ((KtLabeledExpression)element).getLabelNameAsName());
        } else {
            if (psiElement instanceof KtFunctionLiteral) {
                PsiElement psiElement2 = ((KtFunctionLiteral)element).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
                return this.getLabelNamesIfAny(psiElement2, false);
            }
            if (psiElement instanceof KtLambdaExpression) {
                CollectionsKt.addIfNotNull(result2, this.getLabelForFunctionalExpression((KtExpression)element));
            }
        }
        Object object = element;
        if (object instanceof KtNamedFunction) {
            Collection collection = result2;
            Name name2 = ((KtNamedFunction)element).getNameAsName();
            if (name2 == null) {
                name2 = this.getLabelForFunctionalExpression((KtExpression)element);
            }
            CollectionsKt.addIfNotNull(collection, name2);
            ktProperty = element;
        } else if (object instanceof KtPropertyAccessor) {
            KtProperty ktProperty2 = ((KtPropertyAccessor)element).getProperty();
            ktProperty = ktProperty2;
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty2, (String)"element.property");
        } else {
            return result2;
        }
        KtProperty functionOrProperty = ktProperty;
        if (addClassNameLabels) {
            void $this$mapNotNullTo$iv;
            Object object2 = ((KtCallableDeclaration)functionOrProperty).getReceiverTypeReference();
            if (object2 != null && (object2 = ((KtTypeReference)object2).nameForReceiverLabel()) != null) {
                Object it = object2;
                boolean bl = false;
                Name name3 = Name.identifier((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(it)");
                result2.add(name3);
            }
            List<KtContextReceiver> list2 = ((KtCallableDeclaration)functionOrProperty).getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"functionOrProperty.contextReceivers");
            object = list2;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name4;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtContextReceiver it = (KtContextReceiver)element$iv;
                boolean bl2 = false;
                if (it.name() != null) {
                    String s;
                    boolean bl3 = false;
                    name4 = Name.identifier(s);
                } else {
                    name4 = null;
                }
                if (name4 == null) continue;
                Name it$iv = name4;
                boolean bl4 = false;
                ((Collection)result2).add(it$iv);
            }
        }
        return result2;
    }

    private final Name getLabelForFunctionalExpression(KtExpression element) {
        Name name2;
        PsiElement parent2 = element.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtLabeledExpression) {
            Intrinsics.checkNotNullExpressionValue((Object)parent2, (String)"parent");
            name2 = (Name)kotlin.collections.CollectionsKt.singleOrNull(this.getLabelNamesIfAny(parent2, false));
        } else {
            name2 = psiElement instanceof KtBinaryExpression ? ((KtBinaryExpression)parent2).getOperationReference().getReferencedNameAsName() : this.getCallerName(element);
        }
        return name2;
    }

    private final KtExpression getExpressionUnderLabel(KtExpression labeledExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(labeledExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"safeDeparenthesize(labeledExpression)");
        KtExpression expression2 = ktExpression2;
        if (expression2 instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression2).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"expression.functionLiteral");
            ktExpression = ktFunctionLiteral;
        } else {
            ktExpression = expression2;
        }
        return ktExpression;
    }

    private final Name getCallerName(KtExpression expression2) {
        KtSimpleNameExpression calleeExpression;
        KtCallExpression ktCallExpression = this.getContainingCallExpression(expression2);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
    }

    private final KtCallExpression getContainingCallExpression(KtExpression expression2) {
        PsiElement call2;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtLambdaArgument && (call2 = ((KtLambdaArgument)parent2).getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            PsiElement psiElement = ((KtValueArgument)parent2).getParent();
            if (psiElement == null) {
                return null;
            }
            PsiElement argList = psiElement;
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public final KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression2, @NotNull ResolutionContext<?> context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        ReservedCheckingKt.checkReservedYield(labelElement, bindingTrace);
        Name labelName = expression2.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        BindingTrace bindingTrace2 = context2.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"context.trace");
        KtElement ktElement = this.resolveNamedLabel(labelName, labelElement, bindingTrace2, false);
        if (ktElement == null) {
            LabelResolver $this$resolveControlLabel_u24lambda_u2d3 = this;
            boolean bl = false;
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)labelElement), labelElement));
            ktElement = null;
        }
        return ktElement;
    }

    private final KtElement resolveNamedLabel(Name labelName, KtSimpleNameExpression labelExpression, BindingTrace trace, boolean classNameLabelsEnabled) {
        Set<KtElement> list2 = this.getElementsByLabelName(labelName, labelExpression, classNameLabelsEnabled);
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)labelExpression)));
        }
        Object object = kotlin.collections.CollectionsKt.first((Iterable)list2);
        KtElement it = (KtElement)object;
        boolean bl = false;
        trace.record(BindingContext.LABEL_TARGET, labelExpression, it);
        return (KtElement)object;
    }

    @NotNull
    public final LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression2, @NotNull ResolutionContext<?> context2, @NotNull Name labelName) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        KtReferenceExpression ktReferenceExpression = expression2.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"expression.instanceReference");
        KtReferenceExpression referenceExpression = ktReferenceExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getTargetLabel();
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(((Object)expression2).toString());
        }
        KtSimpleNameExpression targetLabel = ktSimpleNameExpression;
        LexicalScope lexicalScope = context2.scope;
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"context.scope");
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(lexicalScope, labelName);
        int size = declarationsByLabel.size();
        switch (size) {
            case 1: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)kotlin.collections.CollectionsKt.single((Iterable)declarationsByLabel);
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
                } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
                    receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    receiverParameterDescriptor = ((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else {
                    throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
                }
                ReceiverParameterDescriptor thisReceiver2 = receiverParameterDescriptor;
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    throw new IllegalStateException(("No PSI element for descriptor: " + declarationDescriptor).toString());
                }
                PsiElement element = psiElement;
                context2.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                context2.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context2.scope, context2.trace, (PsiElement)targetLabel, (ClassDescriptor)declarationDescriptor)) {
                    return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                }
                return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver2);
            }
            case 0: {
                BindingTrace bindingTrace = context2.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
                KtElement element = this.resolveNamedLabel(labelName, targetLabel, bindingTrace, expression2 instanceof KtThisExpression && context2.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers));
                DeclarationDescriptor declarationDescriptor = context2.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    Object object;
                    ReceiverParameterDescriptor receiverParameterDescriptor;
                    Multimap labelNameToReceiverMap;
                    CallableMemberDescriptor callableMemberDescriptor;
                    BindingContext bindingContext = context2.trace.getBindingContext();
                    ReadOnlySlice readOnlySlice = BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP;
                    if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)declarationDescriptor).getCorrespondingProperty();
                        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"declarationDescriptor.correspondingProperty");
                        callableMemberDescriptor = propertyDescriptor;
                    } else {
                        callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                    }
                    Multimap multimap = labelNameToReceiverMap = (Multimap)bindingContext.get(readOnlySlice, callableMemberDescriptor);
                    Collection thisReceivers = multimap != null ? multimap.get((Object)labelName.getIdentifier()) : null;
                    Object object2 = thisReceivers;
                    if (object2 == null || object2.isEmpty()) {
                        receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    } else if (thisReceivers.size() == 1) {
                        receiverParameterDescriptor = (ReceiverParameterDescriptor)kotlin.collections.CollectionsKt.single((Iterable)thisReceivers);
                    } else {
                        BindingContextUtils.reportAmbiguousLabel(context2.trace, targetLabel, declarationsByLabel);
                        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                    }
                    ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
                    if (receiverParameterDescriptor2 != null) {
                        Object it = object2 = receiverParameterDescriptor2;
                        boolean bl = false;
                        context2.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context2.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                        object = object2;
                    } else {
                        object = null;
                    }
                    Object thisReceiver3 = object;
                    return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess((ReceiverParameterDescriptor)thisReceiver3);
                }
                context2.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)targetLabel), targetLabel));
                break;
            }
            default: {
                BindingContextUtils.reportAmbiguousLabel(context2.trace, targetLabel, declarationsByLabel);
            }
        }
        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "", "code", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "(Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "getCode", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "getReceiverParameterDescriptor", "success", "", "Code", "Companion", "frontend"})
    public static final class LabeledReceiverResolutionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Code code;
        @Nullable
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        @NotNull
        public final Code getCode() {
            return this.code;
        }

        public final boolean success() {
            return this.code == Code.SUCCESS;
        }

        @Nullable
        public final ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            boolean bl = this.success();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
                throw new AssertionError((Object)string2);
            }
            return this.receiverParameterDescriptor;
        }

        public /* synthetic */ LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor, DefaultConstructorMarker $constructor_marker) {
            this(code, receiverParameterDescriptor);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "", "(Ljava/lang/String;I)V", "LABEL_RESOLUTION_ERROR", "NO_THIS", "SUCCESS", "frontend"})
        public static final class Code
        extends Enum<Code> {
            public static final /* enum */ Code LABEL_RESOLUTION_ERROR = new Code();
            public static final /* enum */ Code NO_THIS = new Code();
            public static final /* enum */ Code SUCCESS = new Code();
            private static final /* synthetic */ Code[] $VALUES;

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String value2) {
                return Enum.valueOf(Code.class, value2);
            }

            static {
                $VALUES = codeArray = new Code[]{Code.LABEL_RESOLUTION_ERROR, Code.NO_THIS, Code.SUCCESS};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Companion;", "", "()V", "labelResolutionFailed", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionSuccess", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "frontend"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
                if (receiverParameterDescriptor == null) {
                    return new LabeledReceiverResolutionResult(Code.NO_THIS, null, null);
                }
                return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor, null);
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionFailed() {
                return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

