/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.PhasedIrDumpHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "Companion", "tests-common-new"})
public final class PhasedIrDumpHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DUMPED_IR_FOLDER_NAME = "dumped_ir";

    public PhasedIrDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module2, @NotNull BinaryArtifacts.Jvm info) {
        Collection destination$iv$iv;
        Object expectedFileName;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES())) {
            return;
        }
        File dumpDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.getTestServices(), DUMPED_IR_FOLDER_NAME);
        File[] fileArray = FilesKt.resolve((File)dumpDirectory, (String)module2.getName()).listFiles();
        if (fileArray == null) {
            return;
        }
        File[] dumpFiles = fileArray;
        TestFile testFile = (TestFile)CollectionsKt.first(module2.getFiles());
        File testDirectory = testFile.getOriginalFile().getParentFile();
        List visitedFiles = new ArrayList();
        for (File actualFile : dumpFiles) {
            String string2;
            StringBuilder stringBuilder2 = new StringBuilder().append(FilesKt.getNameWithoutExtension((File)testFile.getOriginalFile()));
            Intrinsics.checkNotNullExpressionValue((Object)actualFile.getName(), (String)"actualFile.name");
            int n = 0;
            int n2 = 2;
            expectedFileName = stringBuilder2.append(((Object)StringsKt.removeRange((CharSequence)string2, (int)n, (int)n2)).toString()).toString();
            ((Collection)visitedFiles).add(expectedFileName);
            Assertions assertions = this.getAssertions();
            Intrinsics.checkNotNullExpressionValue((Object)testDirectory, (String)"testDirectory");
            File file2 = FilesKt.resolve((File)testDirectory, (String)expectedFileName);
            Intrinsics.checkNotNullExpressionValue((Object)actualFile, (String)"actualFile");
            Assertions.assertEqualsToFile$default(assertions, file2, FilesKt.readText$default((File)actualFile, null, (int)1, null), null, 4, null);
        }
        File[] fileArray2 = testDirectory.listFiles((arg_0, arg_1) -> PhasedIrDumpHandler.processModule$lambda-0(testFile, arg_0, arg_1));
        if (fileArray2 != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            expectedFileName = fileArray2;
            boolean $i$f$filter = false;
            void var13_17 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!visitedFiles.contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return;
        }
        List remainFiles = (List)destination$iv$iv;
        this.getAssertions().assertTrue(remainFiles.isEmpty(), (Function0<String>)((Function0)new Function0<String>((List<? extends File>)remainFiles){
            final /* synthetic */ List<File> $remainFiles;
            {
                this.$remainFiles = $remainFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "There are some files in test directory (" + CollectionsKt.joinToString$default((Iterable)this.$remainFiles, null, null, null, (int)0, null, (Function1)processModule.1.INSTANCE, (int)31, null) + ") that don't have actual dump";
            }
        }));
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private static final boolean processModule$lambda-0(TestFile $testFile, File file2, String name2) {
        Intrinsics.checkNotNullParameter((Object)$testFile, (String)"$testFile");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
        return StringsKt.startsWith$default((String)name2, (String)(FilesKt.getNameWithoutExtension((File)$testFile.getOriginalFile()) + '_'), (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler$Companion;", "", "()V", "DUMPED_IR_FOLDER_NAME", "", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

