/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsCommonCoroutineSymbols;
import org.jetbrains.kotlin.ir.backend.js.JsCommonInlineClassesUtils;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ReflectionSymbols;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H&R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "catchAllThrowableType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getCatchAllThrowableType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "coroutineSymbols", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonCoroutineSymbols;", "getCoroutineSymbols", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonCoroutineSymbols;", "es6mode", "", "getEs6mode", "()Z", "inlineClassesUtils", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "getInlineClassesUtils", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonInlineClassesUtils;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "getMapping", "()Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "reflectionSymbols", "Lorg/jetbrains/kotlin/ir/backend/js/ReflectionSymbols;", "getReflectionSymbols", "()Lorg/jetbrains/kotlin/ir/backend/js/ReflectionSymbols;", "suiteFun", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getSuiteFun", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "testFun", "getTestFun", "createTestContainerFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public interface JsCommonBackendContext
extends CommonBackendContext {
    @Override
    @NotNull
    public JsMapping getMapping();

    @NotNull
    public ReflectionSymbols getReflectionSymbols();

    @Override
    @NotNull
    public JsCommonInlineClassesUtils getInlineClassesUtils();

    @NotNull
    public JsCommonCoroutineSymbols getCoroutineSymbols();

    @NotNull
    public IrType getCatchAllThrowableType();

    public boolean getEs6mode();

    @Nullable
    public IrSimpleFunctionSymbol getSuiteFun();

    @Nullable
    public IrSimpleFunctionSymbol getTestFun();

    @NotNull
    public IrSimpleFunction createTestContainerFun(@NotNull IrFile var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static IrType getCatchAllThrowableType(@NotNull JsCommonBackendContext this_) {
            return this_.getIrBuiltIns().getThrowableType();
        }

        public static boolean getEs6mode(@NotNull JsCommonBackendContext this_) {
            return false;
        }

        @Nullable
        public static IrStatementOrigin getDoWhileCounterLoopOrigin(@NotNull JsCommonBackendContext this_) {
            return CommonBackendContext.DefaultImpls.getDoWhileCounterLoopOrigin(this_);
        }

        @NotNull
        public static IrDeclarationOrigin getInductionVariableOrigin(@NotNull JsCommonBackendContext this_) {
            return CommonBackendContext.DefaultImpls.getInductionVariableOrigin(this_);
        }

        public static boolean getOptimizeLoopsOverUnsignedArrays(@NotNull JsCommonBackendContext this_) {
            return CommonBackendContext.DefaultImpls.getOptimizeLoopsOverUnsignedArrays(this_);
        }

        public static boolean getOptimizeNullChecksUsingKotlinNullability(@NotNull JsCommonBackendContext this_) {
            return CommonBackendContext.DefaultImpls.getOptimizeNullChecksUsingKotlinNullability(this_);
        }

        public static boolean getPreferJavaLikeCounterLoop(@NotNull JsCommonBackendContext this_) {
            return CommonBackendContext.DefaultImpls.getPreferJavaLikeCounterLoop(this_);
        }

        public static void handleDeepCopy(@NotNull JsCommonBackendContext this_, @NotNull Map<IrFileSymbol, IrFileSymbol> fileSymbolMap, @NotNull Map<IrClassSymbol, IrClassSymbol> classSymbolMap, @NotNull Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> functionSymbolMap) {
            Intrinsics.checkNotNullParameter(fileSymbolMap, (String)"fileSymbolMap");
            Intrinsics.checkNotNullParameter(classSymbolMap, (String)"classSymbolMap");
            Intrinsics.checkNotNullParameter(functionSymbolMap, (String)"functionSymbolMap");
            CommonBackendContext.DefaultImpls.handleDeepCopy(this_, fileSymbolMap, classSymbolMap, functionSymbolMap);
        }

        public static boolean isSideEffectFree(@NotNull JsCommonBackendContext this_, @NotNull IrCall call2) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            return CommonBackendContext.DefaultImpls.isSideEffectFree(this_, call2);
        }

        @NotNull
        public static IrExpression throwUninitializedPropertyAccessException(@NotNull JsCommonBackendContext this_, @NotNull IrBuilderWithScope builder2, @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return CommonBackendContext.DefaultImpls.throwUninitializedPropertyAccessException(this_, builder2, name2);
        }
    }
}

