/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrVerifier;
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.test.Assertions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0003J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\nH\u0002J\u001f\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0%H\u0082\bJ\u000e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00192\u0006\u0010*\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0015H\u0016J\u0010\u00104\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00192\u0006\u0010*\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00192\u0006\u0010*\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010*\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010*\u001a\u00020AH\u0016J\u001c\u0010B\u001a\u00020\u0019*\u00020\u00162\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/ir/IrVerifier;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "(Lorg/jetbrains/kotlin/test/Assertions;)V", "elementsAreUniqueChecker", "org/jetbrains/kotlin/ir/IrVerifier$elementsAreUniqueChecker$1", "Lorg/jetbrains/kotlin/ir/IrVerifier$elementsAreUniqueChecker$1;", "errors", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "errorsAsMessage", "getErrorsAsMessage", "()Ljava/lang/String;", "hasErrors", "", "getHasErrors", "()Z", "symbolForDeclaration", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lkotlin/collections/HashMap;", "checkTypeParameters", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "expectedTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "error", "message", "require", "condition", "Lkotlin/Function0;", "verifyWithAssert", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitElement", "element", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "checkBinding", "kind", "irElement", "tests-compiler-utils"})
public final class IrVerifier
implements IrElementVisitorVoid {
    @NotNull
    private final Assertions assertions;
    @NotNull
    private final ArrayList<String> errors;
    @NotNull
    private final HashMap<IrElement, IrSymbol> symbolForDeclaration;
    @NotNull
    private final elementsAreUniqueChecker.1 elementsAreUniqueChecker;

    public IrVerifier(@NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        this.assertions = assertions;
        this.errors = new ArrayList();
        this.symbolForDeclaration = new HashMap();
        this.elementsAreUniqueChecker = new IrElementVisitorVoid(this){
            @NotNull
            private final HashSet<IrElement> elements;
            final /* synthetic */ IrVerifier this$0;
            {
                this.this$0 = $receiver;
                this.elements = new HashSet<E>();
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVerifier irVerifier = this.this$0;
                boolean condition$iv = this.elements.add(element);
                boolean $i$f$require = false;
                if (!condition$iv) {
                    void this_$iv;
                    ArrayList arrayList = IrVerifier.access$getErrors$p((IrVerifier)this_$iv);
                    boolean bl = false;
                    arrayList.add("Non-unique element: " + RenderIrElementKt.render(element));
                }
                IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
            }

            public void visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.visitElement(expression2);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            public void visitField(@NotNull IrField declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitScript(@NotNull IrScript declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
            }

            public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetValue(@NotNull IrSetValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
            }

            public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        };
    }

    public final boolean getHasErrors() {
        return !((Collection)this.errors).isEmpty();
    }

    @NotNull
    public final String getErrorsAsMessage() {
        return CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", (CharSequence)"IR verifier errors:\n", null, (int)0, null, null, (int)60, null);
    }

    private final void error(String message) {
        this.errors.add(message);
    }

    private final void require(boolean condition, Function0<String> message) {
        boolean $i$f$require = false;
        if (!condition) {
            this.errors.add(message.invoke());
        }
    }

    public final void verifyWithAssert(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementVisitorVoidKt.acceptChildrenVoid(irFile, this);
        IrElementVisitorVoidKt.acceptChildrenVoid(irFile, this.elementsAreUniqueChecker);
        this.assertions.assertFalse(this.getHasErrors(), (Function0<String>)((Function0)new Function0<String>(this, irFile){
            final /* synthetic */ IrVerifier this$0;
            final /* synthetic */ IrFile $irFile;
            {
                this.this$0 = $receiver;
                this.$irFile = $irFile;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getErrorsAsMessage() + "\n\n\n" + DumpIrTreeKt.dump$default(this.$irFile, false, false, 3, null);
            }
        }));
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        IrDeclarationParent parent2;
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.checkBinding(declaration2.getSymbol(), "decl", declaration2);
        IrVerifier irVerifier = this;
        boolean condition$iv = Intrinsics.areEqual((Object)declaration2.getSymbol().getOwner(), (Object)declaration2);
        boolean $i$f$require2 = false;
        if (!condition$iv) {
            void this_$iv;
            arrayList = ((IrVerifier)this_$iv).errors;
            boolean bl = false;
            arrayList.add("Symbol is not bound to declaration: " + RenderIrElementKt.render(declaration2));
        }
        DeclarationDescriptor containingDeclarationDescriptor = declaration2.getDescriptor().getContainingDeclaration();
        if (containingDeclarationDescriptor != null && (parent2 = declaration2.getParent()) instanceof IrDeclaration) {
            IrVerifier $i$f$require2 = this;
            boolean condition$iv2 = Intrinsics.areEqual((Object)((IrDeclaration)((Object)parent2)).getDescriptor(), (Object)containingDeclarationDescriptor);
            boolean $i$f$require3 = false;
            if (!condition$iv2) {
                void this_$iv;
                arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl = false;
                arrayList.add("In declaration " + declaration2.getDescriptor() + ": Mismatching parent descriptor (" + ((IrDeclaration)((Object)parent2)).getDescriptor() + ") and containing declaration descriptor (" + containingDeclarationDescriptor + ')');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.visitDeclaration(declaration2);
        IrVerifier irVerifier = this;
        boolean condition$iv = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) == declaration2.isFakeOverride();
        boolean $i$f$require = false;
        if (!condition$iv) {
            void this_$iv;
            ArrayList arrayList = ((IrVerifier)this_$iv).errors;
            boolean bl = false;
            arrayList.add(RenderIrElementKt.render(declaration2) + ": origin: " + declaration2.getOrigin() + "; isFakeOverride: " + declaration2.isFakeOverride());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Iterator $this$mapTo$iv$iv2;
        Collection<ParameterDescriptor> collection;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.visitDeclaration(declaration2);
        FunctionDescriptor functionDescriptor = declaration2.getDescriptor();
        DeclarationDescriptor declarationDescriptor = functionDescriptor;
        IrTypeParametersContainer irTypeParametersContainer = declaration2;
        List<TypeParameterDescriptor> list2 = functionDescriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"functionDescriptor.typeParameters");
        this.checkTypeParameters(declarationDescriptor, irTypeParametersContainer, list2);
        ReceiverParameterDescriptor expectedDispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
        ParameterDescriptor actualDispatchReceiver = irValueParameter != null ? irValueParameter.getDescriptor() : null;
        IrVerifier irVerifier = this;
        boolean condition$iv = Intrinsics.areEqual((Object)expectedDispatchReceiver, (Object)actualDispatchReceiver);
        boolean $i$f$require22 = false;
        if (!condition$iv) {
            void this_$iv;
            collection = ((IrVerifier)this_$iv).errors;
            boolean bl = false;
            ((ArrayList)collection).add((ParameterDescriptor)((Object)(functionDescriptor + ": Dispatch receiver parameter mismatch: expected " + expectedDispatchReceiver + ", actual " + actualDispatchReceiver)));
        }
        ReceiverParameterDescriptor expectedExtensionReceiver = functionDescriptor.getExtensionReceiverParameter();
        IrValueParameter irValueParameter2 = declaration2.getExtensionReceiverParameter();
        ParameterDescriptor actualExtensionReceiver = irValueParameter2 != null ? irValueParameter2.getDescriptor() : null;
        IrVerifier $i$f$require22 = this;
        boolean condition$iv2 = Intrinsics.areEqual((Object)expectedExtensionReceiver, (Object)actualExtensionReceiver);
        boolean $i$f$require = false;
        if (!condition$iv2) {
            void this_$iv;
            collection = ((IrVerifier)this_$iv).errors;
            boolean bl = false;
            ((ArrayList)collection).add((ParameterDescriptor)((Object)(functionDescriptor + ": Extension receiver parameter mismatch: expected " + expectedExtensionReceiver + ", actual " + actualExtensionReceiver)));
        }
        List<ReceiverParameterDescriptor> list3 = functionDescriptor.getContextReceiverParameters();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"functionDescriptor.contextReceiverParameters");
        List<ReceiverParameterDescriptor> expectedContextReceivers = list3;
        Iterable $this$map$iv = CollectionsKt.take((Iterable)declaration2.getValueParameters(), (int)declaration2.getContextReceiverParametersCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getDescriptor());
        }
        List actualContextReceivers = (List)destination$iv$iv;
        if (expectedContextReceivers.size() != actualContextReceivers.size()) {
            this.error(functionDescriptor + ": Context receivers mismatch: " + expectedContextReceivers + " != " + actualContextReceivers);
        } else {
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)expectedContextReceivers, (Iterable)actualContextReceivers);
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                void this_$iv;
                Pair $i$f$mapTo2 = (Pair)element$iv2;
                boolean bl = false;
                ReceiverParameterDescriptor expectedContextReceiver = (ReceiverParameterDescriptor)$i$f$mapTo2.component1();
                ParameterDescriptor actualContextReceiver = (ParameterDescriptor)$i$f$mapTo2.component2();
                IrVerifier bl2 = this;
                boolean condition$iv3 = Intrinsics.areEqual((Object)expectedContextReceiver, (Object)actualContextReceiver);
                boolean $i$f$require3 = false;
                if (condition$iv3) continue;
                ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl3 = false;
                arrayList.add(functionDescriptor + ": Context receivers mismatch: " + expectedContextReceiver + " != " + actualContextReceiver);
            }
        }
        Iterable $this$map$iv2 = CollectionsKt.drop((Iterable)declaration2.getValueParameters(), (int)declaration2.getContextReceiverParametersCount());
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter this_$iv = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getDescriptor());
        }
        List declaredValueParameters = (List)destination$iv$iv2;
        List<ValueParameterDescriptor> list4 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"functionDescriptor.valueParameters");
        List<ValueParameterDescriptor> actualValueParameters = list4;
        if (declaredValueParameters.size() != actualValueParameters.size()) {
            this.error(functionDescriptor + ": Value parameters mismatch: " + declaredValueParameters + " != " + actualValueParameters);
        } else {
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)declaredValueParameters, (Iterable)actualValueParameters);
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                void this_$iv;
                Pair pair = (Pair)element$iv3;
                boolean bl = false;
                ParameterDescriptor declaredValueParameter = (ParameterDescriptor)pair.component1();
                ValueParameterDescriptor actualValueParameter = (ValueParameterDescriptor)pair.component2();
                IrVerifier $i$f$require3 = this;
                boolean condition$iv4 = Intrinsics.areEqual((Object)declaredValueParameter, (Object)actualValueParameter);
                boolean $i$f$require4 = false;
                if (condition$iv4) continue;
                ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl4 = false;
                arrayList.add(functionDescriptor + ": Value parameters mismatch: " + declaredValueParameter + " != " + actualValueParameter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.visitFunction(declaration2);
        IrVerifier irVerifier = this;
        boolean condition$iv = Intrinsics.areEqual((Object)declaration2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) == declaration2.isFakeOverride();
        boolean $i$f$require = false;
        if (!condition$iv) {
            void this_$iv;
            ArrayList arrayList = ((IrVerifier)this_$iv).errors;
            boolean bl = false;
            arrayList.add(RenderIrElementKt.render(declaration2) + ": origin: " + declaration2.getOrigin() + "; isFakeOverride: " + declaration2.isFakeOverride());
        }
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.checkBinding(expression2.getSymbol(), "ref", expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.checkBinding((IrSymbol)expression2.getSymbol(), "ref", expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrFieldSymbol irFieldSymbol = expression2.getField();
            if (irFieldSymbol != null) {
                this.checkBinding(irFieldSymbol, "field", expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            if (irSimpleFunctionSymbol != null) {
                this.checkBinding(irSimpleFunctionSymbol, "getter", expression2);
            }
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getSetter();
            if (irSimpleFunctionSymbol2 == null) break block2;
            this.checkBinding(irSimpleFunctionSymbol2, "setter", expression2);
        }
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.checkBinding(expression2.getDelegate(), "delegate", expression2);
            this.checkBinding(expression2.getGetter(), "getter", expression2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
            if (irSimpleFunctionSymbol == null) break block0;
            this.checkBinding(irSimpleFunctionSymbol, "setter", expression2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBinding(IrSymbol $this$checkBinding, String kind, IrElement irElement) {
        IrSymbol otherSymbol;
        Object object;
        void $this$getOrPut$iv;
        if (!$this$checkBinding.isBound()) {
            this.error($this$checkBinding.getClass().getSimpleName() + " descriptor is unbound @" + kind + ' ' + RenderIrElementKt.render(irElement));
        } else {
            IrDeclaration irDeclaration2;
            IrSymbolOwner irSymbolOwner = $this$checkBinding.getOwner();
            IrDeclaration irDeclaration3 = irDeclaration2 = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
            if (irDeclaration2 != null) {
                try {
                    irDeclaration2.getParent();
                }
                catch (Throwable e) {
                    this.error("Referenced declaration has no parent: " + RenderIrElementKt.render(irDeclaration2));
                }
            }
        }
        Map e = this.symbolForDeclaration;
        IrSymbolOwner key$iv = $this$checkBinding.getOwner();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IrSymbol answer$iv = $this$checkBinding;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if (!Intrinsics.areEqual((Object)$this$checkBinding, (Object)(otherSymbol = (IrSymbol)object))) {
            this.error("Multiple symbols for descriptor of @" + kind + ' ' + RenderIrElementKt.render(irElement));
        }
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        this.visitDeclaration(declaration2);
        DeclarationDescriptor declarationDescriptor = declaration2.getDescriptor();
        IrTypeParametersContainer irTypeParametersContainer = declaration2;
        List<TypeParameterDescriptor> list2 = declaration2.getDescriptor().getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"declaration.descriptor.declaredTypeParameters");
        this.checkTypeParameters(declarationDescriptor, irTypeParametersContainer, list2);
    }

    /*
     * WARNING - void declaration
     */
    @ObsoleteDescriptorBasedAPI
    private final void checkTypeParameters(DeclarationDescriptor descriptor2, IrTypeParametersContainer declaration2, List<? extends TypeParameterDescriptor> expectedTypeParameters) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = declaration2.getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getDescriptor());
        }
        List declaredTypeParameters = (List)destination$iv$iv;
        if (declaredTypeParameters.size() != expectedTypeParameters.size()) {
            this.error(descriptor2 + ": Type parameters mismatch: " + declaredTypeParameters + " != " + expectedTypeParameters);
        } else {
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)declaredTypeParameters, (Iterable)expectedTypeParameters);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                TypeParameterDescriptor declaredTypeParameter = (TypeParameterDescriptor)pair.component1();
                TypeParameterDescriptor expectedTypeParameter = (TypeParameterDescriptor)pair.component2();
                IrVerifier bl2 = this;
                boolean condition$iv = Intrinsics.areEqual((Object)declaredTypeParameter, (Object)expectedTypeParameter);
                boolean $i$f$require = false;
                if (condition$iv) continue;
                ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl3 = false;
                arrayList.add(descriptor2 + ": Type parameters mismatch: " + declaredTypeParameter + " != " + expectedTypeParameter);
            }
        }
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.checkBinding(expression2.getTypeOperandClassifier(), "type operand", expression2);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

