/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001b\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantSingleExpressionStringTemplateChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirStringConcatenationCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "stringParentChildrenCount", "", "Lcom/intellij/lang/LighterASTNode;", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "(Lcom/intellij/lang/LighterASTNode;Lorg/jetbrains/kotlin/KtLightSourceElement;)Ljava/lang/Integer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)Ljava/lang/Integer;", "checkers"})
public final class RedundantSingleExpressionStringTemplateChecker
extends FirExpressionChecker<FirStringConcatenationCall> {
    @NotNull
    public static final RedundantSingleExpressionStringTemplateChecker INSTANCE = new RedundantSingleExpressionStringTemplateChecker();

    private RedundantSingleExpressionStringTemplateChecker() {
    }

    @Override
    public void check(@NotNull FirStringConcatenationCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        for (FirExpression argumentExpression : $this$arguments$iv.getArgumentList().getArguments()) {
            if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(argumentExpression.getTypeRef())), (Object)StandardClassIds.INSTANCE.getString())) continue;
            Integer n = this.stringParentChildrenCount(argumentExpression);
            int n2 = 1;
            if (n == null || n != n2) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argumentExpression.getSource(), FirErrors.INSTANCE.getREDUNDANT_SINGLE_EXPRESSION_STRING_TEMPLATE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final Integer stringParentChildrenCount(FirStatement $this$stringParentChildrenCount) {
        Integer n;
        KtSourceElement source = $this$stringParentChildrenCount.getSource();
        if (source instanceof KtPsiSourceElement) {
            n = this.stringParentChildrenCount(((KtPsiSourceElement)source).getPsi());
        } else if (source instanceof KtLightSourceElement) {
            n = this.stringParentChildrenCount(((KtLightSourceElement)source).getLighterASTNode(), (KtLightSourceElement)source);
        } else if (source == null) {
            n = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Integer stringParentChildrenCount(PsiElement $this$stringParentChildrenCount) {
        if ($this$stringParentChildrenCount.getParent() instanceof KtStringTemplateExpression) {
            PsiElement[] psiElementArray = $this$stringParentChildrenCount.getParent();
            return psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null ? Integer.valueOf(psiElementArray.length) : null;
        }
        PsiElement psiElement = $this$stringParentChildrenCount.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent");
        return this.stringParentChildrenCount(psiElement);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer stringParentChildrenCount(LighterASTNode $this$stringParentChildrenCount, KtLightSourceElement source) {
        Integer n;
        LighterASTNode parent2 = (LighterASTNode)source.getTreeStructure().getParent((Object)$this$stringParentChildrenCount);
        if (parent2 != null && Intrinsics.areEqual((Object)parent2.getTokenType(), (Object)KtNodeTypes.STRING_TEMPLATE)) {
            void $this$filterTo$iv$iv;
            List<LighterASTNode> childrenOfParent = SourceHelpersKt.getChildren(parent2, source.getTreeStructure());
            Iterable $this$filter$iv = childrenOfParent;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LighterASTNode it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof PsiBuilder.Marker)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            LighterASTNode lighterASTNode2 = parent2;
            n = lighterASTNode2 != null ? this.stringParentChildrenCount(lighterASTNode2, source) : null;
        }
        return n;
    }
}

