/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.js.ProduceKind;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.CompilerWithICKt;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.LoweredIr;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController;
import org.jetbrains.kotlin.ir.backend.js.codegen.JsGenerationGranularity;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdateStatus;
import org.jetbrains.kotlin.ir.backend.js.ic.FileUtilKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ICCache;
import org.jetbrains.kotlin.ir.backend.js.ic.IcCacheInfo;
import org.jetbrains.kotlin.ir.backend.js.ic.InvalidationKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleCache;
import org.jetbrains.kotlin.ir.backend.js.ic.PersistentCacheConsumer;
import org.jetbrains.kotlin.ir.backend.js.ic.PersistentCacheProvider;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerTmp;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImplForJsIC;
import org.jetbrains.kotlin.ir.declarations.persistent.PersistentIrFactory;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u001e\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0018\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0!*\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u0019*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "usePerFileInvalidator", "", "addPlatformOptions", "", "toICCacheMap", "", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICCache;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IcCacheInfo;", "write", "Ljava/io/File;", "outputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;
    @NotNull
    private static final Map<String, ProduceKind> produceMap;

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    private final boolean usePerFileInvalidator(CompilerConfiguration configuration2) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ICCache> toICCacheMap(IcCacheInfo $this$toICCacheMap) {
        void $this$mapTo$iv$iv;
        Map<String, SerializedIcData> $this$map$iv = $this$toICCacheMap.getData();
        boolean $i$f$map = false;
        Map<String, SerializedIcData> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)new ICCache(PersistentCacheProvider.Companion.getEMPTY(), PersistentCacheConsumer.Companion.getEMPTY(), (SerializedIcData)it.getValue())));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        ModulesStructure module2;
        ModulesStructure modulesStructure;
        boolean bl;
        CharSequence charSequence2;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)rootDisposable, (String)"rootDisposable");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration2);
        if (pluginLoadResult != ExitCode.OK) {
            return pluginLoadResult;
        }
        if (arguments2.getScript()) {
            Object v2;
            KotlinCoreEnvironment.ProjectEnvironment projectEnv;
            block49: {
                if (!arguments2.getEnableJsScripting()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                configuration2.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration2);
                projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment, configuration2);
                projectEnv.registerExtensionsFromPlugins(configuration2);
                MockProject mockProject = projectEnv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
                List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances((Project)mockProject);
                Iterable iterable = scriptingEvaluators;
                for (Object t : iterable) {
                    ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                    boolean bl2 = false;
                    if (!it.isAccepted(arguments2)) continue;
                    v2 = t;
                    break block49;
                }
                v2 = null;
            }
            ScriptEvaluationExtension scriptingEvaluator = v2;
            if (scriptingEvaluator != null) return scriptingEvaluator.eval(arguments2, configuration2, projectEnv);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getFreeArgs().isEmpty() && !IncrementalCompilation.isEnabledForJs()) {
            if (arguments2.getVersion()) {
                return ExitCode.OK;
            }
            CharSequence environment = arguments2.getIncludes();
            if (environment == null || environment.length() == 0) {
                messageCollector2.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                return ExitCode.COMPILATION_ERROR;
            }
        }
        List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull((Object)arguments2.getIncludes()));
        List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
        List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
        configuration2.put(JSConfigurationKeys.LIBRARIES, libraries);
        configuration2.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
        configuration2.put(JSConfigurationKeys.REPOSITORIES, repositories);
        configuration2.put(JSConfigurationKeys.PARTIAL_LINKAGE, arguments2.getPartialLinkage());
        Object[] commonSourcesArray = arguments2.getCommonSources();
        Object object = commonSourcesArray;
        if (commonSourcesArray == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object commonSources = object;
        for (String arg : arguments2.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration2, arg, commonSources.contains(arg));
        }
        Object[] objectArray = arguments2.getRelativePathBases();
        if (objectArray != null) {
            Object[] it = objectArray;
            boolean bl3 = false;
            configuration2.put(CommonConfigurationKeys.KLIB_RELATIVE_PATH_BASES, ArraysKt.toList((Object[])it));
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        configuration2.put(CommonConfigurationKeys.KLIB_NORMALIZE_ABSOLUTE_PATH, arguments2.getNormalizeAbsolutePath());
        KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JS_CONFIG_FILES);
        Project projectJs = environmentForJS.getProject();
        CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
        List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
        configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        configurationJs.put(JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION, arguments2.getIrPropertyLazyInitialization());
        if (!UtilsKt.checkKotlinPackageUsage(environmentForJS.getConfiguration(), (Collection<? extends KtFile>)sourcesFiles)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFilePath = arguments2.getOutputFile();
        if (outputFilePath == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (messageCollector2.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (sourcesFiles.isEmpty() && !IncrementalCompilation.isEnabledForJs() && ((charSequence2 = (CharSequence)arguments2.getIncludes()) == null || charSequence2.length() == 0)) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "No source files", null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments2.getVerbose()) {
            K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector2, sourcesFiles);
        }
        File outputFile = new File(outputFilePath);
        String string2 = arguments2.getIrModuleName();
        if (string2 == null) {
            String string3 = FileUtil.getNameWithoutExtension((File)outputFile);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(outputFile)");
        }
        String moduleName = string2;
        configurationJs.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
        JsConfig config = new JsConfig(projectJs, configurationJs, CompilerEnvironment.INSTANCE);
        File file2 = outputFile.getParentFile();
        if (file2 == null) {
            File file3 = outputFile.getAbsoluteFile().getParentFile();
            file2 = file3;
            Intrinsics.checkNotNull((Object)file3);
        }
        File outputDir2 = file2;
        try {
            config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
        }
        catch (IOException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
            return ExitCode.COMPILATION_ERROR;
        }
        List mainCallArguments = Intrinsics.areEqual((Object)"noCall", (Object)arguments2.getMain()) ? null : CollectionsKt.emptyList();
        List icCaches = K2JsIrCompiler.Companion.configureLibraries(arguments2.getCacheDirectories());
        if (arguments2.getIrBuildCache()) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "to: " + outputFilePath, null, 4, null);
            String string4 = arguments2.getCacheDirectories();
            if (string4 == null) {
                string4 = "";
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, string4, null, 4, null);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, libraries.toString(), null, 4, null);
            String string5 = arguments2.getIncludes();
            Intrinsics.checkNotNull((Object)string5);
            String includes = string5;
            long start = System.currentTimeMillis();
            CacheUpdateStatus updateStatus2 = InvalidationKt.actualizeCacheForModule(includes, outputFilePath, configurationJs, libraries, icCaches, new IrFactoryImplForJsIC(new WholeWorldStageController()), mainCallArguments, doExecute.updateStatus.1.INSTANCE);
            if (updateStatus2.getUpToDate()) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC per-file cache up-to-date check duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
                return ExitCode.OK;
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC per-file cache building duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            }
            return ExitCode.OK;
        }
        ModulesStructure sourceModule = null;
        String includes = arguments2.getIncludes();
        if (includes == null) {
            AnalysisResult result2;
            do {
                List<KtFile> list2 = environmentForJS.getSourceFiles();
                CompilerConfiguration compilerConfiguration = config.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"config.configuration");
                sourceModule = KlibKt.prepareAnalyzedSourceModule$default(projectJs, list2, configurationJs, libraries, friendLibraries, new AnalyzerWithCompilerReport(compilerConfiguration), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty() ? this.toICCacheMap(FileUtilKt.checkCaches(libraries, icCaches, includes)) : MapsKt.emptyMap(), null, 512, null);
                ModulesStructure modulesStructure2 = sourceModule;
                if (modulesStructure2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                    modulesStructure2 = null;
                }
                if (!((result2 = modulesStructure2.getJsFrontEndResult().getJsAnalysisResult()) instanceof JsAnalysisResult.RetryWithAdditionalRoots)) continue;
                environmentForJS.addKotlinSourceRoots(((JsAnalysisResult.RetryWithAdditionalRoots)result2).getAdditionalKotlinRoots());
            } while (result2 instanceof JsAnalysisResult.RetryWithAdditionalRoots);
            if (!sourceModule.getJsFrontEndResult().getJsAnalysisResult().getShouldGenerateCode()) {
                return ExitCode.OK;
            }
        }
        if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
            if (arguments2.getIrProduceKlibFile() && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)outputFile), (Object)"klib")) {
                boolean $i$a$-require-K2JsIrCompiler$doExecute$32 = false;
                String $i$a$-require-K2JsIrCompiler$doExecute$32 = "Please set up .klib file as output";
                throw new IllegalArgumentException($i$a$-require-K2JsIrCompiler$doExecute$32.toString());
            }
            ModulesStructure modulesStructure3 = sourceModule;
            if (modulesStructure3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                modulesStructure3 = null;
            }
            IrFactory irFactory = IrFactoryImpl.INSTANCE;
            String string6 = outputFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"outputFile.path");
            KlibKt.generateKLib$default(modulesStructure3, irFactory, string6, arguments2.getIrProduceKlibDir(), false, null, arguments2.getIrPerModuleOutputName(), 48, null);
        }
        if (!arguments2.getIrProduceJs()) return ExitCode.OK;
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Produce executable: " + outputFilePath, null, 4, null);
        String string7 = arguments2.getCacheDirectories();
        if (string7 == null) {
            string7 = "";
        }
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, string7, null, 4, null);
        if (!((Collection)icCaches).isEmpty()) {
            long beforeIc2Js = System.currentTimeMillis();
            Map<String, ModuleCache> caches = InvalidationKt.loadModuleCaches(icCaches);
            ModuleKind moduleKind = configurationJs.get(JSConfigurationKeys.MODULE_KIND);
            Intrinsics.checkNotNull((Object)((Object)moduleKind));
            ModuleKind moduleKind2 = moduleKind;
            TranslationMode translationMode = TranslationMode.Companion.fromFlags(false, arguments2.getIrPerModule());
            CompilerResult compiledModule = CompilerWithICKt.generateJsFromAst(moduleName, moduleKind2, SourceMapsInfo.Companion.from(configurationJs), SetsKt.setOf((Object)((Object)translationMode)), caches, true);
            CompilationOutputs outputs = (CompilationOutputs)CollectionsKt.single((Iterable)compiledModule.getOutputs().values());
            this.write(outputFile, outputs);
            Iterable<Pair<String, CompilationOutputs>> iterable = outputs.getDependencies();
            boolean bl4 = false;
            Iterator<Pair<String, CompilationOutputs>> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                Pair<String, CompilationOutputs> element$iv;
                Pair<String, CompilationOutputs> pair = element$iv = iterator2.next();
                boolean bl5 = false;
                String name2 = (String)pair.component1();
                CompilationOutputs content = (CompilationOutputs)pair.component2();
                this.write(FilesKt.resolveSibling((File)outputFile, (String)(name2 + ".js")), content);
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration (IC): " + (System.currentTimeMillis() - beforeIc2Js) + "ms", null, 4, null);
            return ExitCode.OK;
        }
        PhaseConfig phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector2);
        if (includes != null) {
            Object v20;
            String includesPath;
            block50: {
                if (!((Collection)sourcesFiles).isEmpty()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                }
                includesPath = new File(includes).getCanonicalPath();
                Iterable outputs = libraries;
                for (Object t : outputs) {
                    String it = (String)t;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)new File(it).getCanonicalPath(), (Object)includesPath)) continue;
                    v20 = t;
                    break block50;
                }
                v20 = null;
            }
            String string8 = v20;
            if (string8 == null) {
                throw new IllegalStateException(("No library with name " + includes + " (" + includesPath + ") found").toString());
            }
            String mainLibPath = string8;
            MainModule.Klib kLib = new MainModule.Klib(mainLibPath);
            modulesStructure = new ModulesStructure(projectJs, kLib, configurationJs, libraries, friendLibraries, !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty(), !((Collection)icCaches).isEmpty() ? this.toICCacheMap(FileUtilKt.checkCaches(libraries, icCaches, includes)) : MapsKt.emptyMap());
        } else {
            modulesStructure = sourceModule;
            if (modulesStructure == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sourceModule");
                modulesStructure = module2 = null;
            }
        }
        if (arguments2.getWasm()) {
            String string9;
            WasmCompilerResult res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm(module2, new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), IrFactoryImpl.INSTANCE, SetsKt.setOf((Object)new FqName("main")), arguments2.getWasmDebug());
            File file4 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wasm");
            Intrinsics.checkNotNull((Object)file4);
            File outputWasmFile = file4;
            FilesKt.writeBytes((File)outputWasmFile, (byte[])res2.getWasm());
            File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "wat");
            Intrinsics.checkNotNull((Object)file5);
            File outputWatFile = file5;
            FilesKt.writeText$default((File)outputWatFile, (String)res2.getWat(), null, (int)2, null);
            String esmRunner = kotlin.text.StringsKt.trimIndent((String)("\n                    export default WebAssembly.instantiateStreaming(fetch('" + outputWasmFile.getName() + "'), { runtime, js_code }).then((it) => {\n                        wasmInstance = it.instance;\n                        wasmInstance.exports.__init?.();\n                        wasmInstance.exports.startUnitTests?.();\n                        \n                        return it.instance.exports;\n                    });\n                "));
            String nodeRunner = kotlin.text.StringsKt.trimIndent((String)("\n                    const fs = require('fs');\n                    var path = require('path');\n                    const wasmBuffer = fs.readFileSync(path.resolve(__dirname, './" + outputWasmFile.getName() + "'));\n                    \n                    module.exports = WebAssembly.instantiate(wasmBuffer, { runtime, js_code }).then(wasm => {\n                        wasmInstance = wasm.instance;\n                    \n                        wasmInstance.exports.__init?.();\n                        wasmInstance.exports.startUnitTests?.();\n                    \n                        return wasmInstance.exports\n                    });\n                "));
            String string10 = arguments2.getWasmLauncher();
            if (Intrinsics.areEqual((Object)string10, (Object)"esm")) {
                string9 = esmRunner;
            } else {
                if (!Intrinsics.areEqual((Object)string10, (Object)"nodejs")) throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
                string9 = nodeRunner;
            }
            String string11 = string9;
            FilesKt.writeText$default((File)outputFile, (String)(res2.getJs() + '\n' + string11), null, (int)2, null);
            return ExitCode.OK;
        }
        long start = System.currentTimeMillis();
        JsGenerationGranularity granularity = arguments2.getIrPerModule() ? JsGenerationGranularity.PER_MODULE : (arguments2.getIrPerFile() ? JsGenerationGranularity.PER_FILE : JsGenerationGranularity.WHOLE_PROGRAM);
        try {
            CompilerResult compilerResult;
            IrFactory irFactory = arguments2.getIrDceDriven() ? (IrFactory)new PersistentIrFactory() : (arguments2.getIrNewIr2Js() ? (IrFactory)new IrFactoryImplForJsIC(new WholeWorldStageController()) : (IrFactory)IrFactoryImpl.INSTANCE);
            RuntimeDiagnostic runtimeDiagnostic = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector2);
            boolean bl6 = arguments2.getIrDceDriven();
            boolean it = arguments2.getIrBaseClassInMetadata();
            bl = arguments2.getIrSafeExternalBoolean();
            RuntimeDiagnostic runtimeDiagnostic2 = K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrSafeExternalBooleanDiagnostic(), messageCollector2);
            boolean bl7 = arguments2.getIrNewIr2Js();
            LoweredIr ir2 = CompilerKt.compile$default(module2, phaseConfig, irFactory, null, bl6, runtimeDiagnostic, false, false, it, false, bl, runtimeDiagnostic2, null, granularity, bl7, 4296, null);
            if (arguments2.getIrNewIr2Js()) {
                IrModuleToJsTransformerTmp irModuleToJsTransformerTmp = new IrModuleToJsTransformerTmp(ir2.getContext(), mainCallArguments, false, true, null, false, 52, null);
                compilerResult = irModuleToJsTransformerTmp.generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules(), SetsKt.setOf((Object)((Object)TranslationMode.Companion.fromFlags(arguments2.getIrDce(), arguments2.getIrPerModule()))));
            } else {
                IrModuleToJsTransformer irModuleToJsTransformer = new IrModuleToJsTransformer(ir2.getContext(), mainCallArguments, false, null, !arguments2.getIrDce(), arguments2.getIrDce(), arguments2.getIrPerModule(), true, null, false, 780, null);
                compilerResult = irModuleToJsTransformer.generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules());
            }
            CompilerResult compilerResult2 = compilerResult;
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            CompilationOutputs compilationOutputs = (CompilationOutputs)CollectionsKt.single((Iterable)compilerResult2.getOutputs().values());
            this.write(outputFile, compilationOutputs);
            Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = compilationOutputs.getDependencies();
            boolean $i$f$forEach = false;
            for (Object e : $this$forEach$iv) {
                Pair pair = (Pair)e;
                boolean bl8 = false;
                String name3 = (String)pair.component1();
                CompilationOutputs content = (CompilationOutputs)pair.component2();
                this.write(FilesKt.resolveSibling((File)outputFile, (String)(name3 + ".js")), content);
            }
            if (!arguments2.getGenerateDts()) return ExitCode.OK;
            File file6 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension((File)outputFile), "d.ts");
            Intrinsics.checkNotNull((Object)file6);
            File dtsFile = file6;
            String string12 = compilerResult2.getTsDefinitions();
            if (string12 == null) {
                throw new IllegalStateException("No ts definitions".toString());
            }
            FilesKt.writeText$default((File)dtsFile, (String)string12, null, (int)2, null);
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, ExceptionsKt.stackTraceToString((Throwable)e), CompilerMessageLocation.Companion.create(e.getPath(), e.getLine(), e.getColumn(), e.getContent()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final void write(File $this$write, CompilationOutputs outputs) {
        block0: {
            FilesKt.writeText$default((File)$this$write, (String)outputs.getJsCode(), null, (int)2, null);
            String string2 = outputs.getSourceMap();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            File mapFile = FilesKt.resolveSibling((File)$this$write, (String)($this$write.getName() + ".map"));
            FilesKt.appendText$default((File)$this$write, (String)("\n//# sourceMappingURL=" + mapFile.getName()), null, (int)2, null);
            FilesKt.writeText$default((File)mapFile, (String)it, null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        ModuleKind moduleKind;
        String moduleKindName;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual((Object)"v5", (Object)arguments2.getTarget());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("Unsupported ECMA version: ");
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull((Object)string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder2.append(string2).toString();
                throw new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22);
            }
        }
        configuration2.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration2.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                String string3 = arguments2.getSourceMapPrefix();
                Intrinsics.checkNotNull((Object)string3);
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, string3);
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty((String)arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List list2 = StringUtil.split((String)sourceMapSourceRoots, (String)File.pathSeparator);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(sourceMapSourceRoots, File.pathSeparator)");
                List sourceMapSourceRootList = list2;
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration2.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration2.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration2.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            List list3;
            Iterable $this$dropLastWhile$iv;
            Object object = friendModules;
            String string4 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pathSeparator");
            String string5 = string4;
            string5 = new Regex(string5);
            int n = 0;
            object = string5.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration2.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        String string6 = moduleKindName = arguments2.getModuleKind();
        ModuleKind moduleKind2 = moduleKind = string6 != null ? moduleKindMap.get(string6) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration2.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        String string7 = arguments2.getErrorTolerancePolicy();
        if (string7 != null) {
            String it = string7;
            boolean bl = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy(it);
        } else {
            errorTolerancePolicy = null;
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration2.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        ErrorTolerancePolicy errorTolerancePolicy3 = errorTolerancePolicy2;
        boolean bl = errorTolerancePolicy3 != null ? errorTolerancePolicy3.getAllowErrors() : false;
        if (bl) {
            configuration2.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection)sourceMapContentEmbeddingMap.keySet(), (String)", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration2.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration2.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter((Object)versionArray, (String)"versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plain", (Object)((Object)ModuleKind.PLAIN)), TuplesKt.to((Object)"commonjs", (Object)((Object)ModuleKind.COMMON_JS)), TuplesKt.to((Object)"amd", (Object)((Object)ModuleKind.AMD)), TuplesKt.to((Object)"umd", (Object)((Object)ModuleKind.UMD)), TuplesKt.to((Object)"es", (Object)((Object)ModuleKind.ES))};
        moduleKindMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"always", (Object)((Object)SourceMapSourceEmbedding.ALWAYS)), TuplesKt.to((Object)"never", (Object)((Object)SourceMapSourceEmbedding.NEVER)), TuplesKt.to((Object)"inlining", (Object)((Object)SourceMapSourceEmbedding.INLINING))};
        sourceMapContentEmbeddingMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(null, (Object)((Object)ProduceKind.DEFAULT)), TuplesKt.to((Object)"js", (Object)((Object)ProduceKind.JS)), TuplesKt.to((Object)"klib", (Object)((Object)ProduceKind.KLIB))};
        produceMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\f*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "produceMap", "Lorg/jetbrains/kotlin/cli/js/ProduceKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                collection.add(virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)");
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence2 = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            String string3 = string2;
            string3 = new Regex(string3);
            int n = 0;
            List $this$dropLastWhile$iv = string3.split(charSequence2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

