/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import com.intellij.openapi.Disposable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.PrivateForInline;
import org.jetbrains.kotlin.test.FacadeStepBuilder;
import org.jetbrains.kotlin.test.HandlersStepBuilder;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.TestStepBuilder;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.RegisteredDirectivesBuilder;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.impl.TestConfigurationImpl;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.DefaultsDsl;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@DefaultsDsl
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u001a\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u000204JQ\u0010S\u001a\u00020\u001e\"\u000e\b\u0000\u0010T*\b\u0012\u0004\u0012\u0002HT0A2\u0006\u0010U\u001a\u0002042\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HT0W2\u001d\u0010X\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0Y\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J%\u0010Z\u001a\u00020\u001e2\u0017\u0010X\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\u0006\u0010[\u001a\u00020\u001eJh\u0010\\\u001a\u000e\u0012\u0004\u0012\u0002HT\u0012\u0004\u0012\u0002H^0]\"\u000e\b\u0000\u0010T*\b\u0012\u0004\u0012\u0002HT0A\"\u000e\b\u0001\u0010^*\b\u0012\u0004\u0012\u0002H^0A24\u0010_\u001a0\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HT\u0012\u0004\u0012\u0002H^0`0\u0005j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HT\u0012\u0004\u0012\u0002H^0``\bJ'\u0010a\u001a\u00020\u001e2\u0006\u0010b\u001a\u0002042\u0017\u0010c\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010a\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020\u001d2\u0017\u0010c\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010d\u001a\u00020\u001e2\u0006\u0010b\u001a\u0002042\u0017\u0010c\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010d\u001a\u00020\u001e2\u0006\u0010b\u001a\u00020\u001d2\u0017\u0010c\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ%\u0010e\u001a\u00020\u001e2\u0017\u0010X\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000JO\u0010f\u001a\b\u0012\u0004\u0012\u0002HT0Y\"\u000e\b\u0000\u0010T*\b\u0012\u0004\u0012\u0002HT0A2\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HT0W2\u001d\u0010X\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0Y\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000JW\u0010g\u001a\b\u0012\u0004\u0012\u0002HT0Y\"\u000e\b\u0000\u0010T*\b\u0012\u0004\u0012\u0002HT0A2\u0006\u0010U\u001a\u0002042\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HT0W2\u001d\u0010X\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0Y\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\b\u0010h\u001a\u00020\u001eH\u0007J.\u0010i\u001a\u00020\u001e\"\n\b\u0000\u0010j\u0018\u0001*\u00020k2\u0014\b\b\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002Hj0\u0005H\u0086\b\u00f8\u0001\u0000J\u000e\u0010i\u001a\u00020\u001e2\u0006\u0010m\u001a\u00020\nJK\u0010n\u001a\u00020\u001e2>\u0010o\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b\u00a2\u0006\u0002\u0010qJK\u0010r\u001a\u00020\u001e2>\u0010s\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b\u00a2\u0006\u0002\u0010qJK\u0010t\u001a\u00020\u001e2>\u0010+\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b\u00a2\u0006\u0002\u0010qJ(\u0010u\u001a\u00020\u001e2\u001e\u0010v\u001a\u001a\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a0\u0016H\u0007J$\u0010w\u001a\u00020\u001e2\u001c\u0010v\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0\u0005j\b\u0012\u0004\u0012\u00020<`\bJ\u001f\u0010x\u001a\u00020\u001e2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0p\"\u00020*\u00a2\u0006\u0002\u0010yJK\u0010z\u001a\u00020\u001e2>\u0010{\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010qJK\u0010|\u001a\u00020\u001e2>\u0010}\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020/0\u0005j\b\u0012\u0004\u0012\u00020/`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020/0\u0005j\b\u0012\u0004\u0012\u00020/`\b\u00a2\u0006\u0002\u0010qJ\"\u0010~\u001a\u00020\u001e2\u0012\u0010\u007f\u001a\n\u0012\u0006\b\u0001\u0012\u0002010p\"\u000201H\u0007\u00a2\u0006\u0003\u0010\u0080\u0001JM\u0010\u0081\u0001\u001a\u00020\u001e2?\u0010\u0082\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020:0\u0005j\b\u0012\u0004\u0012\u00020:`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020:0\u0005j\b\u0012\u0004\u0012\u00020:`\b\u00a2\u0006\u0002\u0010qJY\u0010\u0083\u0001\u001a\u00020\u001e2?\u0010\u0084\u0001\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b0p\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b2\t\b\u0002\u0010\u0085\u0001\u001a\u00020-\u00a2\u0006\u0003\u0010\u0086\u0001J\u0017\u0010\u0087\u0001\u001a\u000204*\u0002042\u0007\u0010\u0088\u0001\u001a\u000204H\u0086\u0004J\r\u0010\u0089\u0001\u001a\u000204*\u000204H\u0002R*\u0010\u0003\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001b\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010 \u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010+\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020/0\u0005j\b\u0012\u0004\u0012\u00020/`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u0002010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u00102\u001a\u0016\u0012\u0004\u0012\u000204\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u000305038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010\u0002\u001a\u0004\b7\u00108R*\u00109\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020:0\u0005j\b\u0012\u0004\u0012\u00020:`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010;\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020<0\u0005j\b\u0012\u0004\u0012\u00020<`\b0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010=\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020>0\u0005j\b\u0012\u0004\u0012\u00020>`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010?\u001a\u0012\u0012\u0004\u0012\u00020@\u0012\b\u0012\u0006\u0012\u0002\b\u00030A0\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER*\u0010F\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bG\u0010\u0002\u001a\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010O\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u008a\u0001"}, d2={"Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "()V", "additionalMetaInfoProcessors", "", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "Lorg/jetbrains/kotlin/test/Constructor;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "additionalSourceProviders", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "afterAnalysisCheckers", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "assertions", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "getAssertions", "()Lorg/jetbrains/kotlin/test/services/AssertionsService;", "setAssertions", "(Lorg/jetbrains/kotlin/test/services/AssertionsService;)V", "compilerConfigurationProvider", "Lkotlin/Function2;", "Lcom/intellij/openapi/Disposable;", "", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configurationsByNegativeTestDataCondition", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "", "Lkotlin/ExtensionFunctionType;", "configurationsByPositiveTestDataCondition", "defaultRegisteredDirectivesBuilder", "Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "getDefaultRegisteredDirectivesBuilder", "()Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "defaultsProviderBuilder", "Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "getDefaultsProviderBuilder", "()Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "directives", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "environmentConfigurators", "metaInfoHandlerEnabled", "", "metaTestConfigurators", "Lorg/jetbrains/kotlin/test/services/MetaTestConfigurator;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "namedSteps", "", "", "Lorg/jetbrains/kotlin/test/TestStepBuilder;", "getNamedSteps$annotations", "getNamedSteps", "()Ljava/util/Map;", "preAnalysisHandlers", "Lorg/jetbrains/kotlin/test/services/PreAnalysisHandler;", "runtimeClasspathProviders", "Lorg/jetbrains/kotlin/test/services/RuntimeClasspathProvider;", "sourcePreprocessors", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "startingArtifactFactory", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getStartingArtifactFactory", "()Lkotlin/jvm/functions/Function1;", "setStartingArtifactFactory", "(Lkotlin/jvm/functions/Function1;)V", "steps", "getSteps$annotations", "getSteps", "()Ljava/util/List;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "getTestInfo", "()Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "setTestInfo", "(Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;)V", "build", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "testDataPath", "configureNamedHandlersStep", "I", "name", "artifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "init", "Lorg/jetbrains/kotlin/test/HandlersStepBuilder;", "defaultDirectives", "enableMetaInfoHandler", "facadeStep", "Lorg/jetbrains/kotlin/test/FacadeStepBuilder;", "O", "facade", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "forTestsMatching", "pattern", "configuration", "forTestsNotMatching", "globalDefaults", "handlersStep", "namedHandlersStep", "resetModuleStructureTransformers", "useAdditionalService", "T", "Lorg/jetbrains/kotlin/test/services/TestService;", "serviceConstructor", "serviceRegistrationData", "useAdditionalSourceProviders", "providers", "", "([Lkotlin/jvm/functions/Function1;)V", "useAfterAnalysisCheckers", "checkers", "useConfigurators", "useCustomCompilerConfigurationProvider", "provider", "useCustomRuntimeClasspathProvider", "useDirectives", "([Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "useMetaInfoProcessors", "updaters", "useMetaTestConfigurators", "configurators", "useModuleStructureTransformers", "transformers", "([Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;)V", "usePreAnalysisHandlers", "handlers", "useSourcePreprocessor", "preprocessors", "needToPrepend", "([Lkotlin/jvm/functions/Function1;Z)V", "or", "other", "toMatchingRegexString", "tests-common-new"})
public final class TestConfigurationBuilder {
    @NotNull
    private final DefaultsProviderBuilder defaultsProviderBuilder = new DefaultsProviderBuilder();
    public AssertionsService assertions;
    @NotNull
    private final List<TestStepBuilder<?, ?>> steps = new ArrayList();
    @NotNull
    private final Map<String, TestStepBuilder<?, ?>> namedSteps = new LinkedHashMap();
    @NotNull
    private final List<Function1<TestServices, SourceFilePreprocessor>> sourcePreprocessors = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AdditionalMetaInfoProcessor>> additionalMetaInfoProcessors = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, EnvironmentConfigurator>> environmentConfigurators = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, PreAnalysisHandler>> preAnalysisHandlers = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AdditionalSourceProvider>> additionalSourceProviders = new ArrayList();
    @NotNull
    private final List<ModuleStructureTransformer> moduleStructureTransformers = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, MetaTestConfigurator>> metaTestConfigurators = new ArrayList();
    @NotNull
    private final List<Function1<TestServices, AfterAnalysisChecker>> afterAnalysisCheckers = new ArrayList();
    private boolean metaInfoHandlerEnabled;
    @NotNull
    private final List<DirectivesContainer> directives = new ArrayList();
    @NotNull
    private final RegisteredDirectivesBuilder defaultRegisteredDirectivesBuilder = new RegisteredDirectivesBuilder();
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByPositiveTestDataCondition = new ArrayList();
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByNegativeTestDataCondition = new ArrayList();
    @NotNull
    private final List<ServiceRegistrationData> additionalServices = new ArrayList();
    @Nullable
    private Function2<? super Disposable, ? super List<? extends EnvironmentConfigurator>, ? extends CompilerConfigurationProvider> compilerConfigurationProvider;
    @NotNull
    private List<Function1<TestServices, RuntimeClasspathProvider>> runtimeClasspathProviders = new ArrayList();
    public KotlinTestInfo testInfo;
    public Function1<? super TestModule, ? extends ResultingArtifact<?>> startingArtifactFactory;

    @NotNull
    public final DefaultsProviderBuilder getDefaultsProviderBuilder() {
        return this.defaultsProviderBuilder;
    }

    @NotNull
    public final AssertionsService getAssertions() {
        AssertionsService assertionsService = this.assertions;
        if (assertionsService != null) {
            return assertionsService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"assertions");
        return null;
    }

    public final void setAssertions(@NotNull AssertionsService assertionsService) {
        Intrinsics.checkNotNullParameter((Object)assertionsService, (String)"<set-?>");
        this.assertions = assertionsService;
    }

    @NotNull
    public final List<TestStepBuilder<?, ?>> getSteps() {
        return this.steps;
    }

    @PrivateForInline
    public static /* synthetic */ void getSteps$annotations() {
    }

    @NotNull
    public final Map<String, TestStepBuilder<?, ?>> getNamedSteps() {
        return this.namedSteps;
    }

    @PrivateForInline
    public static /* synthetic */ void getNamedSteps$annotations() {
    }

    @NotNull
    public final RegisteredDirectivesBuilder getDefaultRegisteredDirectivesBuilder() {
        return this.defaultRegisteredDirectivesBuilder;
    }

    @NotNull
    public final KotlinTestInfo getTestInfo() {
        KotlinTestInfo kotlinTestInfo = this.testInfo;
        if (kotlinTestInfo != null) {
            return kotlinTestInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
        return null;
    }

    public final void setTestInfo(@NotNull KotlinTestInfo kotlinTestInfo) {
        Intrinsics.checkNotNullParameter((Object)kotlinTestInfo, (String)"<set-?>");
        this.testInfo = kotlinTestInfo;
    }

    @NotNull
    public final Function1<TestModule, ResultingArtifact<?>> getStartingArtifactFactory() {
        Function1<? super TestModule, ? extends ResultingArtifact<?>> function1 = this.startingArtifactFactory;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"startingArtifactFactory");
        return null;
    }

    public final void setStartingArtifactFactory(@NotNull Function1<? super TestModule, ? extends ResultingArtifact<?>> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.startingArtifactFactory = function1;
    }

    public final /* synthetic */ <T extends TestService> void useAdditionalService(Function1<? super TestServices, ? extends T> serviceConstructor) {
        Intrinsics.checkNotNullParameter(serviceConstructor, (String)"serviceConstructor");
        boolean $i$f$useAdditionalService = false;
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.useAdditionalService(new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestService.class), serviceConstructor));
    }

    public final void useAdditionalService(@NotNull ServiceRegistrationData serviceRegistrationData) {
        Intrinsics.checkNotNullParameter((Object)serviceRegistrationData, (String)"serviceRegistrationData");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalServices;
        collection.add(serviceRegistrationData);
    }

    public final void forTestsMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Regex regex = new Regex(this.toMatchingRegexString(pattern));
        this.forTestsMatching(regex, configuration2);
    }

    public final void forTestsNotMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Regex regex = new Regex(this.toMatchingRegexString(pattern));
        this.forTestsNotMatching(regex, configuration2);
    }

    @NotNull
    public final String or(@NotNull String $this$or, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$or + '|' + other;
    }

    private final String toMatchingRegexString(String $this$toMatchingRegexString) {
        String string2 = $this$toMatchingRegexString;
        return Intrinsics.areEqual((Object)string2, (Object)"*") ? ".*" : "^.*/(" + StringsKt.replace$default((String)$this$toMatchingRegexString, (String)"*", (String)".*", (boolean)false, (int)4, null) + ")$";
    }

    public final void forTestsMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        TestConfigurationBuilder testConfigurationBuilder = this;
        ((Collection)testConfigurationBuilder.configurationsByPositiveTestDataCondition).add(TuplesKt.to((Object)pattern, configuration2));
    }

    public final void forTestsNotMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        TestConfigurationBuilder testConfigurationBuilder = this;
        ((Collection)testConfigurationBuilder.configurationsByNegativeTestDataCondition).add(TuplesKt.to((Object)pattern, configuration2));
    }

    public final void globalDefaults(@NotNull Function1<? super DefaultsProviderBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$globalDefaults = false;
        DefaultsProviderBuilder defaultsProviderBuilder = this.getDefaultsProviderBuilder();
        init2.invoke((Object)defaultsProviderBuilder);
    }

    @NotNull
    public final <I extends ResultingArtifact<I>, O extends ResultingArtifact<O>> FacadeStepBuilder<I, O> facadeStep(@NotNull Function1<? super TestServices, ? extends AbstractTestFacade<I, O>> facade) {
        FacadeStepBuilder facadeStepBuilder;
        Intrinsics.checkNotNullParameter(facade, (String)"facade");
        FacadeStepBuilder it = facadeStepBuilder = new FacadeStepBuilder(facade);
        boolean bl = false;
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.getSteps();
        collection.add(it);
        return facadeStepBuilder;
    }

    @NotNull
    public final <I extends ResultingArtifact<I>> HandlersStepBuilder<I> handlersStep(@NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init2) {
        HandlersStepBuilder<I> handlersStepBuilder;
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$handlersStep = false;
        HandlersStepBuilder<I> it = handlersStepBuilder = new HandlersStepBuilder<I>(artifactKind);
        boolean bl = false;
        init2.invoke(it);
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.getSteps();
        collection.add(it);
        return handlersStepBuilder;
    }

    @NotNull
    public final <I extends ResultingArtifact<I>> HandlersStepBuilder<I> namedHandlersStep(@NotNull String name2, @NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init2) {
        HandlersStepBuilder<I> handlersStepBuilder;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$namedHandlersStep = false;
        TestConfigurationBuilder this_$iv = this;
        boolean $i$f$handlersStep = false;
        HandlersStepBuilder<I> it$iv = handlersStepBuilder = new HandlersStepBuilder<I>(artifactKind);
        boolean bl = false;
        init2.invoke(it$iv);
        TestConfigurationBuilder testConfigurationBuilder = this_$iv;
        Collection collection = testConfigurationBuilder.getSteps();
        collection.add(it$iv);
        HandlersStepBuilder<I> step2 = handlersStepBuilder;
        TestStepBuilder previouslyContainedStep = this.getNamedSteps().put(name2, step2);
        if (previouslyContainedStep != null) {
            throw new IllegalStateException(new Function0<String>(name2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Step with name \"" + this.$name + "\" already registered";
                }
            }.toString());
        }
        return step2;
    }

    public final <I extends ResultingArtifact<I>> void configureNamedHandlersStep(@NotNull String name2, @NotNull TestArtifactKind<I> artifactKind, @NotNull Function1<? super HandlersStepBuilder<I>, Unit> init2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$configureNamedHandlersStep = false;
        TestStepBuilder<?, ?> testStepBuilder = this.getNamedSteps().get(name2);
        if (testStepBuilder == null) {
            throw new IllegalStateException(new Function0<String>(name2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Step \"" + this.$name + "\" not found";
                }
            }.toString());
        }
        TestStepBuilder<?, ?> step2 = testStepBuilder;
        boolean bl = step2 instanceof HandlersStepBuilder;
        if (!bl) {
            boolean $i$a$-require-TestConfigurationBuilder$configureNamedHandlersStep$32 = false;
            String $i$a$-require-TestConfigurationBuilder$configureNamedHandlersStep$32 = "Step '" + name2 + "' is not a handlers step";
            throw new IllegalArgumentException($i$a$-require-TestConfigurationBuilder$configureNamedHandlersStep$32.toString());
        }
        bl = Intrinsics.areEqual(((HandlersStepBuilder)step2).getArtifactKind(), artifactKind);
        if (!bl) {
            boolean bl2 = false;
            String string2 = "Step kind: " + ((HandlersStepBuilder)step2).getArtifactKind() + ", passed kind is " + artifactKind;
            throw new IllegalArgumentException(string2.toString());
        }
        HandlersStepBuilder handlersStepBuilder = (HandlersStepBuilder)step2;
        init2.invoke((Object)handlersStepBuilder);
    }

    public final void useSourcePreprocessor(@NotNull Function1<? super TestServices, ? extends SourceFilePreprocessor>[] preprocessors, boolean needToPrepend) {
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        if (needToPrepend) {
            this.sourcePreprocessors.addAll(0, ArraysKt.toList((Object[])preprocessors));
        } else {
            CollectionsKt.addAll((Collection)this.sourcePreprocessors, (Object[])preprocessors);
        }
    }

    public static /* synthetic */ void useSourcePreprocessor$default(TestConfigurationBuilder testConfigurationBuilder, Function1[] function1Array, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        testConfigurationBuilder.useSourcePreprocessor(function1Array, bl);
    }

    public final void useDirectives(DirectivesContainer ... directives2) {
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.directives;
        CollectionsKt.addAll((Collection)collection, (Object[])directives2);
    }

    public final void useConfigurators(Function1<? super TestServices, ? extends EnvironmentConfigurator> ... environmentConfigurators) {
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.environmentConfigurators;
        CollectionsKt.addAll((Collection)collection, (Object[])environmentConfigurators);
    }

    public final void usePreAnalysisHandlers(Function1<? super TestServices, ? extends PreAnalysisHandler> ... handlers2) {
        Intrinsics.checkNotNullParameter(handlers2, (String)"handlers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.preAnalysisHandlers;
        CollectionsKt.addAll((Collection)collection, (Object[])handlers2);
    }

    public final void useMetaInfoProcessors(Function1<? super TestServices, ? extends AdditionalMetaInfoProcessor> ... updaters) {
        Intrinsics.checkNotNullParameter(updaters, (String)"updaters");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalMetaInfoProcessors;
        CollectionsKt.addAll((Collection)collection, (Object[])updaters);
    }

    public final void useAdditionalSourceProviders(Function1<? super TestServices, ? extends AdditionalSourceProvider> ... providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalSourceProviders;
        CollectionsKt.addAll((Collection)collection, (Object[])providers);
    }

    @TestInfrastructureInternals
    public final void resetModuleStructureTransformers() {
        this.moduleStructureTransformers.clear();
    }

    @TestInfrastructureInternals
    public final void useModuleStructureTransformers(ModuleStructureTransformer ... transformers) {
        Intrinsics.checkNotNullParameter((Object)transformers, (String)"transformers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.moduleStructureTransformers;
        CollectionsKt.addAll((Collection)collection, (Object[])transformers);
    }

    @TestInfrastructureInternals
    public final void useCustomCompilerConfigurationProvider(@NotNull Function2<? super Disposable, ? super List<? extends EnvironmentConfigurator>, ? extends CompilerConfigurationProvider> provider2) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        this.compilerConfigurationProvider = provider2;
    }

    public final void useCustomRuntimeClasspathProvider(@NotNull Function1<? super TestServices, ? extends RuntimeClasspathProvider> provider2) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.runtimeClasspathProviders;
        collection.add(provider2);
    }

    public final void useMetaTestConfigurators(Function1<? super TestServices, ? extends MetaTestConfigurator> ... configurators) {
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.metaTestConfigurators;
        CollectionsKt.addAll((Collection)collection, (Object[])configurators);
    }

    public final void useAfterAnalysisCheckers(Function1<? super TestServices, ? extends AfterAnalysisChecker> ... checkers) {
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.afterAnalysisCheckers;
        CollectionsKt.addAll((Collection)collection, (Object[])checkers);
    }

    public final void defaultDirectives(@NotNull Function1<? super RegisteredDirectivesBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$defaultDirectives = false;
        RegisteredDirectivesBuilder registeredDirectivesBuilder = this.getDefaultRegisteredDirectivesBuilder();
        init2.invoke((Object)registeredDirectivesBuilder);
    }

    public final void enableMetaInfoHandler() {
        this.metaInfoHandlerEnabled = true;
    }

    @NotNull
    public final TestConfiguration build(@NotNull String testDataPath) {
        Function1 configuration2;
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)testDataPath, (String)"testDataPath");
        Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair2 = Paths.get(testDataPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"get(path)");
        Iterator<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> iterator2 = pair2.normalize().toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"Path(testDataPath).normalize().toUri().toString()");
        String absoluteTestDataPath = iterator2;
        for (Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair2 : this.configurationsByPositiveTestDataCondition) {
            regex = (Regex)pair2.component1();
            configuration2 = (Function1)pair2.component2();
            if (!regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        for (Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair2 : this.configurationsByNegativeTestDataCondition) {
            regex = (Regex)pair2.component1();
            configuration2 = (Function1)pair2.component2();
            if (regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        return new TestConfigurationImpl(this.getTestInfo(), this.defaultsProviderBuilder.build(), this.getAssertions(), this.steps, this.sourcePreprocessors, this.additionalMetaInfoProcessors, this.environmentConfigurators, this.additionalSourceProviders, this.preAnalysisHandlers, this.moduleStructureTransformers, this.metaTestConfigurators, this.afterAnalysisCheckers, this.compilerConfigurationProvider, this.runtimeClasspathProviders, this.metaInfoHandlerEnabled, this.directives, this.defaultRegisteredDirectivesBuilder.build(), this.getStartingArtifactFactory(), this.additionalServices);
    }
}

