/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/ExceptionHelperCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "helperMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "referenceFunction", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "transformFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "call", "doNotIntrinsify", "", "backend.js"})
public final class ExceptionHelperCallsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> helperMapping;

    public ExceptionHelperCallsTransformer(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        Pair[] pairArray = new Pair[5];
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.context.getIrBuiltIns().getCheckNotNullSymbol();
        FqName fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("ensureNotNull"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinPackageFqn.child(N\u2026ntifier(\"ensureNotNull\"))");
        pairArray[0] = TuplesKt.to((Object)irSimpleFunctionSymbol, (Object)this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = this.context.getIrBuiltIns().getThrowCceSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_CCE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinPackageFqn.child(N\u2026.identifier(\"THROW_CCE\"))");
        pairArray[1] = TuplesKt.to((Object)irSimpleFunctionSymbol2, (Object)this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = this.context.getIrBuiltIns().getThrowIseSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_ISE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinPackageFqn.child(N\u2026.identifier(\"THROW_ISE\"))");
        pairArray[2] = TuplesKt.to((Object)irSimpleFunctionSymbol3, (Object)this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol4 = this.context.getIrBuiltIns().getIllegalArgumentExceptionSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("THROW_IAE"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinPackageFqn.child(N\u2026.identifier(\"THROW_IAE\"))");
        pairArray[3] = TuplesKt.to((Object)irSimpleFunctionSymbol4, (Object)this.referenceFunction(fqName2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol5 = this.context.getIrBuiltIns().getNoWhenBranchMatchedExceptionSymbol();
        fqName2 = IrTypeUtilsKt.getKotlinPackageFqn().child(Name.identifier("noWhenBranchMatchedException"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"kotlinPackageFqn.child(N\u2026BranchMatchedException\"))");
        pairArray[4] = TuplesKt.to((Object)irSimpleFunctionSymbol5, (Object)this.referenceFunction(fqName2));
        this.helperMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    private final IrSimpleFunctionSymbol referenceFunction(FqName fqn) {
        SimpleFunctionDescriptor simpleFunctionDescriptor;
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = (SimpleFunctionDescriptor)CollectionsKt.singleOrNull(this.context.getFunctions(fqn));
        if (simpleFunctionDescriptor2 == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Function not found: ", (Object)fqn));
        }
        SimpleFunctionDescriptor it = simpleFunctionDescriptor = simpleFunctionDescriptor2;
        boolean bl = false;
        return this.context.getSymbolTable().referenceSimpleFunction(it);
    }

    @Override
    @NotNull
    public IrFunctionAccessExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.helperMapping.get(call2.getSymbol());
        if (irSimpleFunctionSymbol == null) {
            irFunctionAccessExpression = call2;
        } else {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2;
            IrSimpleFunctionSymbol it = irSimpleFunctionSymbol2 = irSimpleFunctionSymbol;
            boolean bl = false;
            irFunctionAccessExpression = IrUtilsKt.irCall$default(call2, it, false, false, null, null, 60, null);
        }
        return irFunctionAccessExpression;
    }
}

