/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeLocalVariableNoTypeOrInitializer;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001aF\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010$\u001a\u00020\u0001H\u0000\u001a\u0018\u0010%\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0018\u0010&\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a-\u0010'\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010)H\u0082\b\u001a\u001e\u0010*\u001a\u00020\u0001*\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u001e\u0010+\u001a\u00020\u0001*\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\f\u0010,\u001a\u00020\u0001*\u00020-H\u0000\u001a\f\u0010,\u001a\u00020\u0001*\u00020.H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0018\u0010\f\u001a\u00020\u0001*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u001c\u0010\f\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0010\"\u0018\u0010\u0011\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\"\u001c\u0010\u0011\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006/"}, d2={"canHaveOpenMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getHasAccessorImplementation", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "isEnumEntryInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isLocalMember", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkExpectDeclarationVisibilityAndBody", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkPropertyInitializer", "containingClass", "property", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "isInitialized", "reachable", "isInsideExpectClass", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "isEffectivelyExternal", "isInlineOrValueClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirDeclarationCheckerUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = (FirMemberDeclaration)((Object)klass);
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = (FirMemberDeclaration)((Object)klass);
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context2) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = (FirMemberDeclaration)((Object)klass);
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = (FirMemberDeclaration)((Object)klass);
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInsideSpecificClass(FirClass containingClass, CheckerContext context2, Function1<? super FirClass, Boolean> predicate) {
        boolean bl;
        boolean $i$f$isInsideSpecificClass = false;
        if ((Boolean)predicate.invoke((Object)containingClass) != false) return true;
        Iterable $this$any$iv = CollectionsKt.asReversed(context2.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if (it instanceof FirRegularClass && ((Boolean)predicate.invoke((Object)it)).booleanValue()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExpect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && FirDeclarationCheckerUtilsKt.isInsideExpectClass(containingClass, context2);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context2) {
        block9: {
            block10: {
                boolean bl;
                boolean $i$f$isExternal;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyExternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    FirProperty property2 = (FirProperty)CollectionsKt.last(context2.getContainingDeclarations());
                    return FirDeclarationCheckerUtilsKt.isEffectivelyExternal(property2, containingClass, context2);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor == null) {
                    bl2 = false;
                } else {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor == null) {
                    bl = false;
                } else {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && FirDeclarationCheckerUtilsKt.isInsideExternalClass(containingClass, context2);
    }

    public static final void checkExpectDeclarationVisibilityAndBody(@NotNull FirMemberDeclaration declaration2, @NotNull FirSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            FirMemberDeclaration $this$visibility$iv = declaration2;
            boolean $i$f$getVisibility = false;
            if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), context2, null, 8, null);
            }
            if (declaration2 instanceof FirSimpleFunction) {
                FirFunction $this$hasBody$iv = (FirFunction)declaration2;
                boolean $i$f$getHasBody = false;
                if ($this$hasBody$iv.getBody() != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), context2, null, 8, null);
                }
            }
        }
    }

    public static final void checkPropertyInitializer(@Nullable FirClass containingClass, @NotNull FirProperty property2, @Nullable FirModifierList modifierList2, boolean isInitialized, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, boolean reachable) {
        FirSourceElement it;
        boolean isAbstract;
        Object $this$isInterface$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirClass firClass2 = containingClass;
        if (firClass2 == null) {
            bl = false;
        } else {
            $this$isInterface$iv = firClass2;
            boolean $i$f$isInterface = false;
            ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
            boolean $i$f$isInterface2 = false;
            bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        }
        boolean inInterface = bl;
        $this$isInterface$iv = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isInterface$iv, (String)"ABSTRACT_KEYWORD");
        boolean hasAbstractModifier = FirKeywordUtilsKt.contains(modifierList2, (KtModifierKeywordToken)((Object)$this$isInterface$iv));
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        boolean bl2 = isAbstract = $this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT || hasAbstractModifier;
        if (isAbstract) {
            FirTypeRef returnTypeRef = property2.getReturnTypeRef();
            if (property2.getInitializer() == null && property2.getDelegate() == null && returnTypeRef instanceof FirErrorTypeRef && ((FirErrorTypeRef)returnTypeRef).getDiagnostic() instanceof ConeLocalVariableNoTypeOrInitializer && ($i$f$isAbstract = property2.getSource()) != null) {
                FirSourceElement $i$f$isInterface2;
                FirSourceElement it2 = $i$f$isInterface2 = $i$f$isAbstract;
                boolean bl3 = false;
                DiagnosticReporterKt.reportOn$default(reporter, it2, FirErrors.INSTANCE.getPROPERTY_WITH_NO_TYPE_NO_INITIALIZER(), context2, null, 8, null);
            }
            return;
        }
        boolean backingFieldRequired = DeclarationAttributesKt.getHasBackingField(property2);
        if (inInterface && backingFieldRequired && FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2) && ($i$f$isAbstract = property2.getSource()) != null) {
            FirSourceElement $i$f$isInterface2;
            it = $i$f$isInterface2 = $i$f$isAbstract;
            boolean bl4 = false;
            DiagnosticReporterKt.reportOn$default(reporter, it, FirErrors.INSTANCE.getBACKING_FIELD_IN_INTERFACE(), context2, null, 8, null);
        }
        boolean isExpect = FirDeclarationCheckerUtilsKt.isEffectivelyExpect(property2, containingClass, context2);
        if (property2.getInitializer() != null) {
            FirExpression $i$f$isInterface2 = property2.getInitializer();
            if ($i$f$isInterface2 != null && (it = $i$f$isInterface2.getSource()) != null) {
                FirSourceElement bl4;
                FirSourceElement it3 = bl4 = it;
                boolean bl5 = false;
                if (inInterface) {
                    DiagnosticReporterKt.reportOn$default(reporter, it3, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_IN_INTERFACE(), context2, null, 8, null);
                } else if (isExpect) {
                    DiagnosticReporterKt.reportOn$default(reporter, it3, FirErrors.INSTANCE.getEXPECTED_PROPERTY_INITIALIZER(), context2, null, 8, null);
                } else if (!backingFieldRequired) {
                    DiagnosticReporterKt.reportOn$default(reporter, it3, FirErrors.INSTANCE.getPROPERTY_INITIALIZER_NO_BACKING_FIELD(), context2, null, 8, null);
                } else if (property2.getReceiverTypeRef() != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, it3, FirErrors.INSTANCE.getEXTENSION_PROPERTY_WITH_BACKING_FIELD(), context2, null, 8, null);
                }
            }
        } else if (property2.getDelegate() != null) {
            FirExpression $i$f$isInterface2 = property2.getDelegate();
            if ($i$f$isInterface2 != null && (it = $i$f$isInterface2.getSource()) != null) {
                FirSourceElement bl4;
                FirSourceElement it4 = bl4 = it;
                boolean bl6 = false;
                if (inInterface) {
                    DiagnosticReporterKt.reportOn$default(reporter, it4, FirErrors.INSTANCE.getDELEGATED_PROPERTY_IN_INTERFACE(), context2, null, 8, null);
                } else if (isExpect) {
                    DiagnosticReporterKt.reportOn$default(reporter, it4, FirErrors.INSTANCE.getEXPECTED_DELEGATED_PROPERTY(), context2, null, 8, null);
                }
            }
        } else {
            boolean $i$f$isLateInit;
            it = property2.getSource();
            if (it == null) {
                return;
            }
            FirSourceElement propertySource = it;
            boolean isExternal = FirDeclarationCheckerUtilsKt.isEffectivelyExternal(property2, containingClass, context2);
            if (backingFieldRequired && !inInterface) {
                FirMemberDeclaration $this$isLateInit$iv = property2;
                $i$f$isLateInit = false;
                if (!($this$isLateInit$iv.getStatus().isLateInit() || isExpect || isInitialized || isExternal)) {
                    if (property2.getReceiverTypeRef() != null && !FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2)) {
                        DiagnosticReporterKt.reportOn$default(reporter, propertySource, FirErrors.INSTANCE.getEXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT(), context2, null, 8, null);
                    } else if (reachable) {
                        if (containingClass == null || FirDeclarationCheckerUtilsKt.getHasAccessorImplementation(property2)) {
                            DiagnosticReporterKt.reportOn$default(reporter, propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED(), context2, null, 8, null);
                        } else {
                            DiagnosticReporterKt.reportOn$default(reporter, propertySource, FirErrors.INSTANCE.getMUST_BE_INITIALIZED_OR_BE_ABSTRACT(), context2, null, 8, null);
                        }
                    }
                }
            }
            FirMemberDeclaration $this$isLateInit$iv = property2;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                if (isExpect) {
                    DiagnosticReporterKt.reportOn$default(reporter, propertySource, FirErrors.INSTANCE.getEXPECTED_LATEINIT_PROPERTY(), context2, null, 8, null);
                }
                if (backingFieldRequired && !inInterface && isInitialized) {
                    DiagnosticReporterKt.reportOn$default(reporter, propertySource, FirErrors.INSTANCE.getUNNECESSARY_LATEINIT(), context2, null, 8, null);
                }
            }
        }
    }

    public static /* synthetic */ void checkPropertyInitializer$default(FirClass firClass2, FirProperty firProperty, FirModifierList firModifierList, boolean bl, DiagnosticReporter diagnosticReporter, CheckerContext checkerContext, boolean bl2, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        FirDeclarationCheckerUtilsKt.checkPropertyInitializer(firClass2, firProperty, firModifierList, bl, diagnosticReporter, checkerContext, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getHasAccessorImplementation(FirProperty $this$hasAccessorImplementation) {
        boolean $i$f$getHasBody;
        FirPropertyAccessor $this$hasBody$iv;
        FirPropertyAccessor firPropertyAccessor;
        if (!($this$hasAccessorImplementation.getGetter() instanceof FirDefaultPropertyAccessor)) {
            boolean bl;
            firPropertyAccessor = $this$hasAccessorImplementation.getGetter();
            if (firPropertyAccessor == null) {
                bl = false;
            } else {
                $this$hasBody$iv = firPropertyAccessor;
                $i$f$getHasBody = false;
                if ($this$hasBody$iv.getBody() != null) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
        }
        if ($this$hasAccessorImplementation.getSetter() instanceof FirDefaultPropertyAccessor) return false;
        firPropertyAccessor = $this$hasAccessorImplementation.getSetter();
        if (firPropertyAccessor == null) {
            return false;
        }
        $this$hasBody$iv = firPropertyAccessor;
        $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveOpenMembers, (String)"<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOrValueClass(@NotNull FirRegularClass $this$isInlineOrValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOrValueClass, (String)"<this>");
        if ($this$isInlineOrValueClass.getClassKind() != ClassKind.CLASS) {
            return false;
        }
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOrValueClass;
        boolean $i$f$isInline = false;
        if ($this$isInline$iv.getStatus().isInline()) return true;
        FirElement firElement = $this$isInlineOrValueClass;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VALUE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"VALUE_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) return false;
        return true;
    }

    public static final boolean isInlineOrValueClass(@NotNull FirRegularClassSymbol $this$isInlineOrValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOrValueClass, (String)"<this>");
        if ($this$isInlineOrValueClass.getClassKind() != ClassKind.CLASS) {
            return false;
        }
        FirRegularClassSymbol $this$isInline$iv = $this$isInlineOrValueClass;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getResolvedStatus().isInline();
    }

    public static final boolean isEnumEntryInitializer(@NotNull FirDeclaration $this$isEnumEntryInitializer) {
        ClassKind classKind;
        ConeClassLookupTagWithFixedSymbol coneClassLookupTagWithFixedSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$isEnumEntryInitializer, (String)"<this>");
        if (!($this$isEnumEntryInitializer instanceof FirConstructor) || !((FirConstructor)$this$isEnumEntryInitializer).isPrimary()) {
            return false;
        }
        Object object = ClassMembersKt.getContainingClassForStaticMemberAttr((FirCallableDeclaration)$this$isEnumEntryInitializer);
        ConeClassLookupTagWithFixedSymbol coneClassLookupTagWithFixedSymbol2 = coneClassLookupTagWithFixedSymbol = object instanceof ConeClassLookupTagWithFixedSymbol ? (ConeClassLookupTagWithFixedSymbol)object : null;
        if (coneClassLookupTagWithFixedSymbol == null) {
            classKind = null;
        } else {
            object = coneClassLookupTagWithFixedSymbol.getSymbol();
            classKind = ((FirClassSymbol)object).getClassKind();
        }
        return classKind == ClassKind.ENUM_ENTRY;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocalMember, (String)"<this>");
        FirDeclaration firDeclaration = $this$isLocalMember;
        if (firDeclaration instanceof FirProperty) {
            bl = ((FirProperty)$this$isLocalMember).isLocal();
        } else if (firDeclaration instanceof FirRegularClass) {
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getSymbol().getClassId().isLocal();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            FirCallableSymbol $this$visibility$iv$iv = $this$isLocal$iv;
            boolean $i$f$getVisibility = false;
            bl = Intrinsics.areEqual((Object)$this$visibility$iv$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableDeclaration $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter((Object)$this$isExtensionMember, (String)"<this>");
        return $this$isExtensionMember.getReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, (String)"<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }
}

