/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001al\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0012\b\u0002\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\t2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"checkUpperBoundViolated", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "typeArguments", "", "typeArgumentRefsAndSources", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "isTypeAlias", "", "isIgnoreTypeParameters", "checkers"})
public final class FirUpperBoundViolatedHelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkUpperBoundViolated(@Nullable FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable List<FirTypeParameterSymbol> typeParameters2, @Nullable List<? extends Object> typeArguments2, @Nullable List<FirTypeRefSource> typeArgumentRefsAndSources, boolean isTypeAlias, boolean isIgnoreTypeParameters) {
        List<FirTypeParameterSymbol> typeParameterSymbols;
        List<FirTypeParameterSymbol> list2;
        int typeArgumentsCount;
        ConeKotlinType coneKotlinType;
        List<FirTypeParameterSymbol> $this$coneTypeSafe$iv;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        List<? extends Object> list3 = typeRef;
        if (list3 == null) {
            coneKotlinType2 = null;
        } else {
            $this$coneTypeSafe$iv = list3;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)((Object)$this$coneTypeSafe$iv) : null;
            coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = coneKotlinType = null;
            }
        }
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType type2 = coneKotlinType;
        list3 = typeArguments2;
        int n = typeArgumentsCount = list3 == null ? type2.getTypeArguments().length : list3.size();
        if (typeArgumentsCount == 0) {
            return;
        }
        $this$coneTypeSafe$iv = typeParameters2;
        if ($this$coneTypeSafe$iv == null) {
            if (type2 instanceof ConeClassLikeType) {
                FirRegularClassSymbol firRegularClassSymbol;
                ConeClassLikeType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, context2.getSession(), null, 2, null);
                FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(fullyExpandedType2.getLookupTag(), context2.getSession());
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol prototypeClassSymbol = firRegularClassSymbol;
                if (!Intrinsics.areEqual((Object)type2, (Object)fullyExpandedType2)) {
                    FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(typeRef, context2, reporter, prototypeClassSymbol.getTypeParameterSymbols(), ArraysKt.toList((Object[])fullyExpandedType2.getTypeArguments()), null, true, isIgnoreTypeParameters);
                    return;
                }
                list2 = prototypeClassSymbol.getTypeParameterSymbols();
            } else {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            list2 = typeParameterSymbols = $this$coneTypeSafe$iv;
        }
        if (typeParameterSymbols.isEmpty()) {
            return;
        }
        int fullyExpandedType2 = typeParameterSymbols.size();
        int count = Math.min(fullyExpandedType2, typeArgumentsCount);
        Map substitution = new LinkedHashMap();
        int prototypeClassSymbol = 0;
        while (prototypeClassSymbol < count) {
            Object object;
            Object object2;
            Object object3;
            int index2 = prototypeClassSymbol++;
            List<? extends Object> list4 = typeArguments2;
            if (list4 == null) {
                object3 = type2.getTypeArguments()[index2];
            } else {
                object2 = list4;
                object3 = object2.get(index2);
            }
            Object typeArgument = object3;
            FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index2);
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                object2 = substitution;
                object = FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)typeArgument).getTypeRef());
                object2.put(typeParameterSymbol, object);
                continue;
            }
            if (typeArgument instanceof ConeKotlinType) {
                object2 = substitution;
                object = ((ConeKotlinType)typeArgument).getType();
                object2.put(typeParameterSymbol, object);
                continue;
            }
            if (!(typeArgument instanceof ConeTypeProjection)) continue;
            ConeKotlinType typeArgumentType = ConeTypesKt.getType((ConeTypeProjection)typeArgument);
            if (typeArgumentType != null) {
                object = substitution;
                object.put(typeParameterSymbol, typeArgumentType);
                continue;
            }
            object = substitution;
            ConeStubType coneStubType = new ConeStubType(new ConeTypeVariable("", typeParameterSymbol.toLookupTag()), ConeNullability.NOT_NULL);
            object.put(typeParameterSymbol, coneStubType);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(substitution, context2.getSession());
        ConeInferenceContext typeSystemContext2 = SessionUtilsKt.getTypeContext(context2.getSession());
        int n2 = 0;
        while (n2 < count) {
            Object extractedTypeArgumentRefAndSource;
            Object typeArgumentRefAndSource;
            Object localTypeArgument;
            int index3 = n2++;
            ConeKotlinType typeArgument = null;
            FirTypeRef typeArgumentTypeRef = null;
            FirSourceElement typeArgumentSource = null;
            if (typeArguments2 != null) {
                localTypeArgument = typeArguments2.get(index3);
                if (localTypeArgument instanceof FirTypeProjectionWithVariance) {
                    typeArgumentTypeRef = ((FirTypeProjectionWithVariance)localTypeArgument).getTypeRef();
                    typeArgument = FirTypeUtilsKt.getConeType(typeArgumentTypeRef);
                    typeArgumentSource = ((FirTypeProjectionWithVariance)localTypeArgument).getSource();
                } else if (localTypeArgument instanceof ConeKotlinType) {
                    typeArgument = (ConeKotlinType)localTypeArgument;
                    typeArgumentSource = typeRef.getSource();
                }
            } else {
                Object object;
                localTypeArgument = type2.getTypeArguments()[index3];
                if (localTypeArgument instanceof ConeKotlinType) {
                    typeArgument = (ConeKotlinType)localTypeArgument;
                } else if (localTypeArgument instanceof ConeKotlinTypeProjection) {
                    typeArgument = ((ConeKotlinTypeProjection)localTypeArgument).getType();
                }
                List<FirTypeRefSource> list5 = typeArgumentRefsAndSources;
                if (list5 == null) {
                    object = null;
                } else {
                    List<FirTypeRefSource> list6 = list5;
                    object = typeArgumentRefAndSource = (FirTypeRefSource)CollectionsKt.getOrNull(list6, (int)index3);
                }
                if (typeArgumentRefAndSource != null) {
                    typeArgumentTypeRef = ((FirTypeRefSource)typeArgumentRefAndSource).getTypeRef();
                    typeArgumentSource = ((FirTypeRefSource)typeArgumentRefAndSource).getSource();
                } else {
                    extractedTypeArgumentRefAndSource = FirHelpersKt.extractArgumentTypeRefAndSource(typeRef, index3);
                    if (extractedTypeArgumentRefAndSource != null) {
                        typeArgumentTypeRef = ((FirTypeRefSource)extractedTypeArgumentRefAndSource).getTypeRef();
                        typeArgumentSource = ((FirTypeRefSource)extractedTypeArgumentRefAndSource).getSource();
                    }
                }
            }
            if (typeArgument == null || typeArgumentSource == null) continue;
            if (!isIgnoreTypeParameters || ((ConeTypeProjection[])(localTypeArgument = typeArgument.getTypeArguments())).length == 0 && !(typeArgument instanceof ConeTypeParameterType)) {
                ConeKotlinType intersection;
                Collection<ConeKotlinType> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                extractedTypeArgumentRefAndSource = typeParameterSymbols.get(index3).getResolvedBounds();
                ConeInferenceContext coneInferenceContext = typeSystemContext2;
                boolean $i$f$map = false;
                void var24_36 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ConeKotlinType coneKotlinType3 = FirTypeUtilsKt.getConeType((FirTypeRef)it);
                    collection.add(coneKotlinType3);
                }
                collection = (List)destination$iv$iv;
                typeArgumentRefAndSource = coneInferenceContext.intersectTypes((List<? extends KotlinTypeMarker>)collection);
                ConeKotlinType coneKotlinType4 = intersection = typeArgumentRefAndSource instanceof ConeKotlinType ? (ConeKotlinType)typeArgumentRefAndSource : null;
                if (intersection != null) {
                    ConeKotlinType upperBound = substitutor2.substituteOrSelf(intersection);
                    if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(typeSystemContext2, (KotlinTypeMarker)typeArgument.getType(), (KotlinTypeMarker)upperBound, true)) {
                        FirDiagnosticFactory2<ConeKotlinType, ConeKotlinType> factory2 = isTypeAlias ? FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION() : FirErrors.INSTANCE.getUPPER_BOUND_VIOLATED();
                        DiagnosticReporterKt.reportOn$default(reporter, typeArgumentSource, factory2, (Object)upperBound, (Object)typeArgument.getType(), context2, null, 32, null);
                        if (isTypeAlias) {
                            return;
                        }
                    }
                }
            }
            FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated$default(typeArgumentTypeRef, context2, reporter, null, null, null, false, isIgnoreTypeParameters, 120, null);
        }
    }

    public static /* synthetic */ void checkUpperBoundViolated$default(FirTypeRef firTypeRef, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, List list2, List list3, List list4, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            list4 = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        FirUpperBoundViolatedHelpersKt.checkUpperBoundViolated(firTypeRef, checkerContext, diagnosticReporter, list2, list3, list4, bl, bl2);
    }
}

