/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.sourceProviders;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "produceAdditionalFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "tests-common-new"})
public final class MainFunctionForBlackBoxTestsSourceProvider
extends AdditionalSourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PACKAGE_REGEXP = new Regex("package ([\\w.]+)");
    @NotNull
    private static final Regex START_BOX_METHOD_REGEX = new Regex("^fun box\\(\\)");
    @NotNull
    private static final Regex MIDDLE_BOX_METHOD_REGEX = new Regex("\\nfun box\\(\\)");
    @NotNull
    public static final String BOX_MAIN_FILE_NAME = "Generated_Box_Main.kt";

    public MainFunctionForBlackBoxTestsSourceProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module2) {
        Object v0;
        Object $this$firstOrNull$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            TestJdkKind testJdkKind = DirectiveKt.singleOrZeroValue(module2.getDirectives(), JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (testJdkKind == null) {
                return CollectionsKt.emptyList();
            }
            TestJdkKind jdkKind = testJdkKind;
            if (!jdkKind.getRequiresSeparateProcess()) {
                return CollectionsKt.emptyList();
            }
            $this$firstOrNull$iv = module2.getFiles();
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                TestFile it = (TestFile)element$iv;
                boolean bl = false;
                if (!Companion.containsBoxMethod(it)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        TestFile testFile = v0;
        if (testFile == null) {
            return CollectionsKt.emptyList();
        }
        TestFile fileWithBox = testFile;
        Object $this$produceAdditionalFiles_u24lambda_u2d2 = $this$firstOrNull$iv = new StringBuilder();
        boolean bl = false;
        String string2 = Companion.detectPackage(fileWithBox);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u2d2).append(Intrinsics.stringPlus((String)"package ", (Object)it));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        }
        StringBuilder stringBuilder4 = ((StringBuilder)$this$produceAdditionalFiles_u24lambda_u2d2).append("fun main() {\n    val res = box()\n    if (res != \"OK\") throw AssertionError(res)\n}");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        String string4 = ((StringBuilder)$this$firstOrNull$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String code = string4;
        File file2 = FilesKt.resolve((File)TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.getTestServices()).getOrCreateTempDirectory("src"), (String)BOX_MAIN_FILE_NAME);
        FilesKt.writeText$default((File)file2, (String)code, null, (int)2, null);
        return CollectionsKt.listOf((Object)this.toTestFile(file2));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/MainFunctionForBlackBoxTestsSourceProvider$Companion;", "", "()V", "BOX_MAIN_FILE_NAME", "", "MIDDLE_BOX_METHOD_REGEX", "Lkotlin/text/Regex;", "PACKAGE_REGEXP", "START_BOX_METHOD_REGEX", "containsBoxMethod", "", "fileContent", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "detectPackage", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String detectPackage(@NotNull TestFile file2) {
            MatchGroupCollection matchGroupCollection;
            MatchGroup matchGroup;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            MatchResult matchResult = Regex.find$default((Regex)PACKAGE_REGEXP, (CharSequence)file2.getOriginalContent(), (int)0, (int)2, null);
            return matchResult == null ? null : ((matchGroup = (matchGroupCollection = matchResult.getGroups()).get(1)) == null ? null : matchGroup.getValue());
        }

        public final boolean containsBoxMethod(@NotNull TestFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.containsBoxMethod(file2.getOriginalContent());
        }

        public final boolean containsBoxMethod(@NotNull String fileContent) {
            Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
            return START_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent) || MIDDLE_BOX_METHOD_REGEX.containsMatchIn((CharSequence)fileContent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

