/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\nH\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/test/services/SourceFileProviderImpl;", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "preprocessors", "", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "contentOfFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "", "javaBinaryDirectory", "Ljava/io/File;", "getJavaBinaryDirectory", "()Ljava/io/File;", "javaSourceDirectory", "getJavaSourceDirectory", "kotlinSourceDirectory", "getKotlinSourceDirectory", "getPreprocessors", "()Ljava/util/List;", "realFileMap", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "generateFinalContent", "testFile", "getContentOfSourceFile", "getRealFileForBinaryFile", "getRealFileForSourceFile", "test-infrastructure"})
public final class SourceFileProviderImpl
extends SourceFileProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<SourceFilePreprocessor> preprocessors;
    @NotNull
    private final File kotlinSourceDirectory;
    @NotNull
    private final File javaSourceDirectory;
    @NotNull
    private final File javaBinaryDirectory;
    @NotNull
    private final Map<TestFile, String> contentOfFiles;
    @NotNull
    private final Map<TestFile, File> realFileMap;

    public SourceFileProviderImpl(@NotNull TestServices testServices, @NotNull List<? extends SourceFilePreprocessor> preprocessors) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        this.testServices = testServices;
        this.preprocessors = preprocessors;
        this.kotlinSourceDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "kotlin-files");
        this.javaSourceDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "java-files");
        this.javaBinaryDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "java-binary-files");
        this.contentOfFiles = new LinkedHashMap();
        this.realFileMap = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final List<SourceFilePreprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    @Override
    @NotNull
    public File getKotlinSourceDirectory() {
        return this.kotlinSourceDirectory;
    }

    @Override
    @NotNull
    public File getJavaSourceDirectory() {
        return this.javaSourceDirectory;
    }

    @Override
    @NotNull
    public File getJavaBinaryDirectory() {
        return this.javaBinaryDirectory;
    }

    @Override
    @NotNull
    public String getContentOfSourceFile(@NotNull TestFile testFile) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, String> $this$getOrPut$iv = this.contentOfFiles;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = this.generateFinalContent(testFile);
            $this$getOrPut$iv.put(testFile, answer$iv);
            string2 = answer$iv;
        } else {
            string2 = value$iv;
        }
        return string2;
    }

    @Override
    @NotNull
    public File getRealFileForSourceFile(@NotNull TestFile testFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file3;
            File file4;
            boolean bl = false;
            if (SourceFileProviderKt.isKtFile(testFile)) {
                file4 = this.getKotlinSourceDirectory();
            } else if (SourceFileProviderKt.isJavaFile(testFile)) {
                file4 = this.getJavaSourceDirectory();
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown file type: ", (Object)testFile.getName()).toString());
            }
            File directory = file4;
            File it = file3 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file3;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file2 = answer$iv;
        } else {
            file2 = value$iv;
        }
        return file2;
    }

    @Override
    @NotNull
    public File getRealFileForBinaryFile(@NotNull TestFile testFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file3;
            boolean bl = false;
            if (!SourceFileProviderKt.isJavaFile(testFile)) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown file type: ", (Object)testFile.getName()).toString());
            }
            File directory = this.getJavaBinaryDirectory();
            File it = file3 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl2 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file3;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file2 = answer$iv;
        } else {
            file2 = value$iv;
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFinalContent(TestFile testFile) {
        void $this$fold$iv;
        Iterable iterable = this.preprocessors;
        String initial$iv = testFile.getOriginalContent();
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void preprocessor;
            SourceFilePreprocessor sourceFilePreprocessor = (SourceFilePreprocessor)element$iv;
            String content = accumulator$iv;
            boolean bl = false;
            accumulator$iv = preprocessor.process(testFile, content);
        }
        return accumulator$iv;
    }
}

