/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyInferenceSession;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.InferenceSessionForExistingCandidates;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.OperatorCallChecker;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.EmptySubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutorByConstructorMap;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionResultCallInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StubTypeForProvideDelegateReceiver;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001hBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J0\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J(\u00101\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0002J \u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00107\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010\u001f\u001a\u00020 2\u0006\u00106\u001a\u00020\u001cH\u0002Jf\u00108\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u00162\n\b\u0002\u0010;\u001a\u0004\u0018\u0001032\n\b\u0002\u0010<\u001a\u0004\u0018\u00010(H\u0002J@\u0010=\u001a\u0004\u0018\u00010\u001c2\u0006\u0010>\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u000200JH\u0010B\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010A\u001a\u0004\u0018\u000100H\u0002J.\u0010B\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020(H\u0002J(\u0010E\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002JJ\u0010F\u001a\u00020\u001a2\u0006\u00104\u001a\u0002052\u0006\u0010>\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\"2\u0006\u00106\u001a\u00020\u001c2\b\u0010G\u001a\u0004\u0018\u00010\u001c2\u0006\u0010H\u001a\u00020.2\u0006\u0010A\u001a\u000200H\u0002J*\u0010I\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0014\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0002J.\u0010K\u001a\u00020\u001e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020*2\u0006\u0010M\u001a\u00020N2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u00020SH\u0002J.\u0010T\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010U\u001a\u00020R2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u00104\u001a\u000205H\u0002J0\u0010W\u001a\u00020\u001e2\u0006\u0010U\u001a\u00020R2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00109\u001a\u00020\u0016H\u0002J>\u0010X\u001a\u00020\u001e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010M\u001a\u00020N2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00109\u001a\u00020\u0016H\u0002J>\u0010Y\u001a\u00020\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010Z\u001a\u00020[2\u0006\u0010>\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u000200J@\u0010\\\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00109\u001a\u00020\u0016H\u0002J@\u0010]\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u000200H\u0002J>\u0010^\u001a\u00020\u001e2\u0006\u0010_\u001a\u00020.2\u0006\u0010Z\u001a\u00020[2\u0006\u0010>\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010`\u001a\u00020,2\u0006\u0010A\u001a\u0002002\u0006\u0010\u001f\u001a\u00020 J@\u0010a\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010b\u001a\u0002052\u0006\u0010?\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u000200H\u0002J8\u0010c\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010@\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J:\u0010d\u001a\u0004\u0018\u00010\u001c2\u0006\u00104\u001a\u0002052\u0006\u0010>\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u000200H\u0002J\f\u0010e\u001a\u000205*\u00020fH\u0002J\f\u0010g\u001a\u00020\u0016*\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "psiCallResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;", "postponedArgumentsAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;", "kotlinConstraintSystemCompleter", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/resolve/calls/tower/PSICallResolver;Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "isOperatorProvideDelegateSupported", "", "()Z", "buildSubstitutionMapOfNonFixedVariables", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "completeNotComputedDelegateType", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "traceToResolveDelegatedProperty", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "conventionMethodFound", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "createContextForGetSetValueMethods", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "inferenceExtension", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "createContextForProvideDelegateMethod", "createReceiverForGetSetValueMethods", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "delegateType", "extractResolvedDelegateType", "getGetSetValueMethod", "isGet", "isComplete", "knownReceiver", "knownContext", "getGetValueMethodReturnType", "variableDescriptor", "byExpressionType", "initializerScope", "inferenceSession", "getProvideDelegateMethod", "delegateExpressionType", "context", "getResolvedDelegateType", "inferDelegateTypeFromGetSetValueMethods", "delegateTypeForProperType", "delegateDataFlow", "inverseSubstitution", "substitutionMap", "recordDelegateOperatorResults", "result", "accessor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "renderCall", "", "call", "Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "reportDelegateErrorIfCandidateExists", "delegateOperatorCall", "delegateOperatorResults", "reportDelegateFunctionMissing", "reportGetSetValueResolutionError", "resolveDelegateExpression", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "resolveGetSetValueMethod", "resolveGetValueMethod", "resolvePropertyDelegate", "outerDataFlowInfo", "propertyHeaderScope", "resolveProvideDelegateMethod", "byExpression", "resolveSetValueMethod", "resolveWithNewInference", "createExpressionForProperty", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "isProperType", "ConstraintSystemCompleterImpl", "frontend"})
public final class DelegatedPropertyResolver {
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final PSICallResolver psiCallResolver;
    @NotNull
    private final PostponedArgumentsAnalyzer postponedArgumentsAnalyzer;
    @NotNull
    private final KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter;
    @NotNull
    private final KotlinCallComponents callComponents;

    public DelegatedPropertyResolver(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull PSICallResolver psiCallResolver, @NotNull PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, @NotNull KotlinConstraintSystemCompleter kotlinConstraintSystemCompleter, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)fakeCallResolver, (String)"fakeCallResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        Intrinsics.checkNotNullParameter((Object)psiCallResolver, (String)"psiCallResolver");
        Intrinsics.checkNotNullParameter((Object)postponedArgumentsAnalyzer, (String)"postponedArgumentsAnalyzer");
        Intrinsics.checkNotNullParameter((Object)kotlinConstraintSystemCompleter, (String)"kotlinConstraintSystemCompleter");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.psiCallResolver = psiCallResolver;
        this.postponedArgumentsAnalyzer = postponedArgumentsAnalyzer;
        this.kotlinConstraintSystemCompleter = kotlinConstraintSystemCompleter;
        this.callComponents = callComponents;
    }

    public final void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull LexicalScope propertyHeaderScope, @NotNull InferenceSession inferenceSession, @NotNull BindingTrace trace) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)outerDataFlowInfo, (String)"outerDataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)propertyHeaderScope, (String)"propertyHeaderScope");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtPropertyAccessor ktPropertyAccessor = property2.getGetter();
        if (ktPropertyAccessor != null) {
            object2 = ktPropertyAccessor;
            KtPropertyAccessor getter2 = object2;
            boolean bl = false;
            if (getter2.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
        }
        ktPropertyAccessor = property2.getSetter();
        if (ktPropertyAccessor != null) {
            object2 = ktPropertyAccessor;
            KtPropertyAccessor setter2 = object2;
            boolean bl = false;
            if (setter2.hasBody()) {
                trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            object2 = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, (PropertyDescriptor)variableDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"makeScopeForPropertyInit\u2026cope, variableDescriptor)");
            object = object2;
        } else {
            object = propertyHeaderScope;
        }
        LexicalScope initializerScope = object;
        KotlinType byExpressionType = this.resolveDelegateExpression(delegateExpression2, property2, variableDescriptor, initializerScope, trace, outerDataFlowInfo, inferenceSession);
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression2, byExpressionType, trace, initializerScope, outerDataFlowInfo, inferenceSession);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression2, byExpressionType, trace);
        this.resolveGetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, outerDataFlowInfo, inferenceSession);
        if (property2.isVar()) {
            this.resolveSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, outerDataFlowInfo);
        }
    }

    private final KotlinType getResolvedDelegateType(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType byExpressionType, BindingTrace trace) {
        ResolvedCall provideDelegateResolvedCall = (ResolvedCall)trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
        if (provideDelegateResolvedCall != null) {
            KotlinType kotlinType = ((FunctionDescriptor)provideDelegateResolvedCall.getResultingDescriptor()).getReturnType();
            if (kotlinType == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"No return type fore 'provideDelegate' of ", (Object)delegateExpression2.getText()));
            }
            return kotlinType;
        }
        return byExpressionType;
    }

    @Nullable
    public final KotlinType getGetValueMethodReturnType(@NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull KotlinType byExpressionType, @NotNull BindingTrace trace, @NotNull LexicalScope initializerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        KotlinType kotlinType;
        ResolvedCall resolvedCall2;
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)byExpressionType, (String)"byExpressionType");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)initializerScope, (String)"initializerScope");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        this.resolveProvideDelegateMethod(variableDescriptor, delegateExpression2, byExpressionType, trace, initializerScope, dataFlowInfo, inferenceSession);
        KotlinType delegateType = this.getResolvedDelegateType(variableDescriptor, delegateExpression2, byExpressionType, trace);
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, true);
        ResolvedCall resolvedCall3 = resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, variableDescriptor.getGetter());
        if (resolvedCall3 == null) {
            kotlinType = null;
        } else {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)resolvedCall3.getResultingDescriptor();
            kotlinType = functionDescriptor.getReturnType();
        }
        return kotlinType;
    }

    private final boolean isOperatorProvideDelegateSupported() {
        return this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate);
    }

    private final void resolveGetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType returnType2 = this.getGetValueMethodReturnType(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, inferenceSession);
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"variableDescriptor.type");
        KotlinType propertyType = kotlinType;
        if (!(propertyType instanceof DeferredType) && returnType2 != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, propertyType)) {
            Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, variableDescriptor.getGetter());
            if (call2 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Call should exists for ", (Object)variableDescriptor.getGetter()));
            }
            Object object = call2;
            Call call3 = object;
            PsiElement psiElement = (PsiElement)delegateExpression2;
            object = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"trace.bindingContext");
            trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)psiElement, this.renderCall(call3, (BindingContext)object), variableDescriptor.getType(), returnType2));
        }
    }

    private final void resolveSetValueMethod(VariableDescriptorWithAccessors variableDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo) {
        this.resolveGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, false);
    }

    private final KtExpression createExpressionForProperty(KtPsiFactory $this$createExpressionForProperty) {
        return $this$createExpressionForProperty.createExpression("null as " + StandardNames.FqNames.kPropertyFqName.asString() + "<*>");
    }

    private final void resolveGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, boolean isGet) {
        VariableAccessorDescriptor variableAccessorDescriptor;
        VariableAccessorDescriptor variableAccessorDescriptor2 = variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression2.getText()));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor) != null) {
            return;
        }
        OverloadResolutionResults functionResults = DelegatedPropertyResolver.getGetSetValueMethod$default(this, propertyDescriptor, delegateExpression2, delegateType, trace, initializerScope, dataFlowInfo, isGet, true, null, null, 768, null);
        if (functionResults.isSuccess()) {
            this.recordDelegateOperatorResults(functionResults, propertyDescriptor, accessor, trace);
        } else {
            this.reportGetSetValueResolutionError(functionResults, accessor, delegateExpression2, delegateType, trace, isGet);
        }
    }

    private final void recordDelegateOperatorResults(OverloadResolutionResults<FunctionDescriptor> result2, VariableDescriptorWithAccessors propertyDescriptor, VariableAccessorDescriptor accessor, BindingTrace trace) {
        KtPropertyDelegate delegate2;
        PsiElement declaration2;
        FunctionDescriptor functionDescriptor = result2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"result.resultingDescriptor");
        FunctionDescriptor resultingDescriptor = functionDescriptor;
        ResolvedCall<FunctionDescriptor> resolvedCall2 = result2.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"result.resultingCall");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        if (!resultingDescriptor.isOperator() && (declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor)) instanceof KtProperty && (delegate2 = ((KtProperty)declaration2).getDelegate()) != null) {
            PsiElement byKeyword = delegate2.getByKeywordNode().getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)byKeyword, (String)"byKeyword");
            OperatorCallChecker.Companion.report(byKeyword, resultingDescriptor, trace);
        }
        trace.record(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor, resultingCall);
    }

    private final void reportGetSetValueResolutionError(OverloadResolutionResults<FunctionDescriptor> result2, VariableAccessorDescriptor accessor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        Call call2 = (Call)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_CALL, accessor);
        if (call2 == null) {
            throw new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call");
        }
        Call call3 = call2;
        Call call4 = call3;
        boolean errorReportedForCandidate = this.reportDelegateErrorIfCandidateExists(trace, call4, result2, delegateExpression2);
        if (!errorReportedForCandidate) {
            this.reportDelegateFunctionMissing(call4, delegateExpression2, delegateType, trace, isGet);
        }
    }

    private final void reportDelegateFunctionMissing(Call delegateOperatorCall, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, boolean isGet) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
        String delegateKind = isGet ? "delegate" : "delegate for var (read-write property)";
        trace.report(Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.on((KtExpression)((PsiElement)delegateExpression2), expectedFunction, delegateType, delegateKind));
    }

    private final boolean reportDelegateErrorIfCandidateExists(BindingTrace trace, Call delegateOperatorCall, OverloadResolutionResults<FunctionDescriptor> delegateOperatorResults, KtExpression delegateExpression2) {
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<Object>>> resolutionErrorFactory = delegateOperatorResults.isSingleResult() || delegateOperatorResults.isIncomplete() || delegateOperatorResults.getResultCode() == OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES ? Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE : (delegateOperatorResults.isAmbiguity() ? Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY : null);
        DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> diagnosticFactory2 = resolutionErrorFactory;
        if (diagnosticFactory2 != null) {
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> diagnosticFactory22;
            DiagnosticFactory2<KtExpression, String, Collection<ResolvedCall<?>>> it = diagnosticFactory22 = diagnosticFactory2;
            boolean bl = false;
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            String expectedFunction = this.renderCall(delegateOperatorCall, bindingContext);
            trace.report(it.on((KtExpression)((PsiElement)delegateExpression2), expectedFunction, delegateOperatorResults.getResultingCalls()));
        }
        return resolutionErrorFactory != null;
    }

    private final void resolveProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression byExpression, KotlinType byExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        if (!this.isOperatorProvideDelegateSupported()) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor) != null) {
            return;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "trace to resolve provideDelegate method");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(trace, \"trace to \u2026 provideDelegate method\")");
        TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace;
        OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(propertyDescriptor, byExpression, byExpressionType, traceForProvideDelegate, initializerScope, dataFlowInfo, inferenceSession);
        if (!provideDelegateResults.isSuccess()) {
            Call call2 = (Call)traceForProvideDelegate.getBindingContext().get(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor);
            if (call2 == null) {
                throw new AssertionError((Object)"'getDelegatedPropertyConventionMethod' didn't record a call");
            }
            Call call3 = call2;
            Call call4 = call3;
            boolean shouldCommitTrace = this.reportDelegateErrorIfCandidateExists(traceForProvideDelegate, call4, provideDelegateResults, byExpression);
            if (shouldCommitTrace) {
                traceForProvideDelegate.commit();
            }
            return;
        }
        traceForProvideDelegate.commit();
        FunctionDescriptor shouldCommitTrace = provideDelegateResults.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)shouldCommitTrace, (String)"provideDelegateResults.resultingDescriptor");
        FunctionDescriptor resultingDescriptor = shouldCommitTrace;
        if (!resultingDescriptor.isOperator()) {
            return;
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = provideDelegateResults.getResultingCall();
        Intrinsics.checkNotNullExpressionValue(resolvedCall2, (String)"provideDelegateResults.resultingCall");
        ResolvedCall<FunctionDescriptor> resultingCall = resolvedCall2;
        trace.record(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor, resultingCall);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getGetSetValueMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, boolean isGet, boolean isComplete, ExpressionReceiver knownReceiver, ExpressionTypingContext knownContext) {
        ExpressionReceiver expressionReceiver;
        Object object;
        ExpressionTypingContext expressionTypingContext;
        VariableAccessorDescriptor variableAccessorDescriptor;
        LexicalScope lexicalScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"makeScopeForDelegateConv\u2026gate, propertyDescriptor)");
        LexicalScope delegateFunctionsScope = lexicalScope;
        VariableAccessorDescriptor variableAccessorDescriptor2 = variableAccessorDescriptor = isGet ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw new AssertionError((Object)("Delegated property should have getter/setter " + propertyDescriptor + ' ' + delegateExpression2.getText()));
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        KotlinType kotlinType = isComplete && isGet && !(propertyDescriptor.getType() instanceof DeferredType) ? propertyDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (isComplete && isGet \u2026         NO_EXPECTED_TYPE");
        KotlinType expectedType2 = kotlinType;
        ExpressionTypingContext expressionTypingContext2 = knownContext;
        if (expressionTypingContext2 == null) {
            ExpressionTypingContext expressionTypingContext3 = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, expectedType2, this.languageVersionSettings, this.dataFlowValueFactory);
            Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext3, (String)"newContext(\n            \u2026alueFactory\n            )");
            expressionTypingContext = expressionTypingContext3;
        } else {
            expressionTypingContext = expressionTypingContext2;
        }
        ExpressionTypingContext context2 = expressionTypingContext;
        boolean hasThis = propertyDescriptor.getExtensionReceiverParameter() != null || propertyDescriptor.getDispatchReceiverParameter() != null;
        ArrayList arguments2 = Lists.newArrayList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression2, false);
        arguments2.add(psiFactory.createExpression(hasThis ? "this" : "null"));
        arguments2.add(this.createExpressionForProperty(psiFactory));
        if (!isGet) {
            KtExpression ktExpression = ExpressionTypingUtils.createFakeExpressionOfType(delegateExpression2.getProject(), trace, Intrinsics.stringPlus((String)"fakeArgument", (Object)arguments2.size()), propertyDescriptor.getType());
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            }
            KtReferenceExpression fakeArgument = (KtReferenceExpression)ktExpression;
            arguments2.add(fakeArgument);
            object = accessor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accessor.valueParameters");
            Object valueParameters2 = object;
            trace.record(BindingContext.REFERENCE_TARGET, fakeArgument, valueParameters2.get(0));
        }
        Name functionName = isGet ? OperatorNameConventions.GET_VALUE : OperatorNameConventions.SET_VALUE;
        object = knownReceiver;
        if (object == null) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            expressionReceiver = ExpressionReceiver.Companion.create(delegateExpression2, delegateType, bindingContext);
        } else {
            expressionReceiver = object;
        }
        ExpressionReceiver receiver = expressionReceiver;
        ReceiverValue receiverValue = receiver;
        ResolutionContext resolutionContext = context2;
        Intrinsics.checkNotNullExpressionValue((Object)arguments2, (String)"arguments");
        Pair resolutionResult = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiverValue, resolutionContext, arguments2, functionName, delegateExpression2, null, null, 96, null);
        trace.record(BindingContext.DELEGATED_PROPERTY_CALL, accessor, resolutionResult.getFirst());
        return (OverloadResolutionResults)resolutionResult.getSecond();
    }

    static /* synthetic */ OverloadResolutionResults getGetSetValueMethod$default(DelegatedPropertyResolver delegatedPropertyResolver, VariableDescriptorWithAccessors variableDescriptorWithAccessors, KtExpression ktExpression, KotlinType kotlinType, BindingTrace bindingTrace, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, boolean bl, boolean bl2, ExpressionReceiver expressionReceiver, ExpressionTypingContext expressionTypingContext, int n, Object object) {
        if ((n & 0x100) != 0) {
            expressionReceiver = null;
        }
        if ((n & 0x200) != 0) {
            expressionTypingContext = null;
        }
        return delegatedPropertyResolver.getGetSetValueMethod(variableDescriptorWithAccessors, ktExpression, kotlinType, bindingTrace, lexicalScope, dataFlowInfo, bl, bl2, expressionReceiver, expressionTypingContext);
    }

    private final ExpressionReceiver createReceiverForGetSetValueMethods(KtExpression delegateExpression2, KotlinType delegateType, BindingTrace trace) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        return ExpressionReceiver.Companion.create(delegateExpression2, delegateType, bindingContext);
    }

    private final ExpressionTypingContext createContextForGetSetValueMethods(VariableDescriptorWithAccessors propertyDescriptor, LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        Object object = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForDelegate, propertyDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"makeScopeForDelegateConv\u2026gate, propertyDescriptor)");
        LexicalScope delegateFunctionsScope = object;
        object = ExpressionTypingContext.newContext(trace, delegateFunctionsScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newContext(\n            \u2026erenceExtension\n        )");
        return object;
    }

    private final ExpressionTypingContext createContextForProvideDelegateMethod(LexicalScope scopeForDelegate, DataFlowInfo dataFlowInfo, BindingTrace trace, InferenceSession inferenceExtension) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, scopeForDelegate, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, ContextDependency.INDEPENDENT, StatementFilter.NONE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceExtension);
        Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"newContext(\n            \u2026erenceExtension\n        )");
        return expressionTypingContext;
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateExpressionType, BindingTrace trace, LexicalScope initializerScope, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, initializerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"newContext(\n            \u2026nferenceSession\n        )");
        ExpressionTypingContext context2 = expressionTypingContext;
        return this.getProvideDelegateMethod(propertyDescriptor, delegateExpression2, delegateExpressionType, context2);
    }

    private final OverloadResolutionResults<FunctionDescriptor> getProvideDelegateMethod(VariableDescriptorWithAccessors propertyDescriptor, KtExpression delegateExpression2, KotlinType delegateExpressionType, ExpressionTypingContext context2) {
        KtPsiFactory ktPsiFactory;
        boolean propertyHasReceiver = propertyDescriptor.getDispatchReceiverParameter() != null;
        KtPsiFactory $this$getProvideDelegateMethod_u24lambda_u2d3 = ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)delegateExpression2, false);
        boolean bl = false;
        Object[] objectArray = new KtExpression[]{$this$getProvideDelegateMethod_u24lambda_u2d3.createExpression(propertyHasReceiver ? "this" : "null"), this.createExpressionForProperty($this$getProvideDelegateMethod_u24lambda_u2d3)};
        List arguments2 = CollectionsKt.listOf((Object[])objectArray);
        Name functionName = OperatorNameConventions.PROVIDE_DELEGATE;
        BindingContext bindingContext = context2.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(delegateExpression2, delegateExpressionType, bindingContext);
        bindingContext = FakeCallResolver.makeAndResolveFakeCallInContext$default(this.fakeCallResolver, receiver, context2, arguments2, functionName, delegateExpression2, null, null, 96, null);
        Call provideDelegateCall = (Call)bindingContext.component1();
        OverloadResolutionResults provideDelegateResults = (OverloadResolutionResults)bindingContext.component2();
        if (provideDelegateResults.isSingleResult()) {
            context2.trace.record(BindingContext.DELEGATE_EXPRESSION_TO_PROVIDE_DELEGATE_CALL, delegateExpression2, provideDelegateCall);
        }
        context2.trace.record(BindingContext.PROVIDE_DELEGATE_CALL, propertyDescriptor, provideDelegateCall);
        return provideDelegateResults;
    }

    private final String renderCall(Call call2, BindingContext context2) {
        Object object = call2.getCalleeExpression();
        if (object == null) {
            throw new AssertionError((Object)"CalleeExpression should exists for fake call of convention method");
        }
        Object object2 = object;
        KtExpression calleeExpression = object2;
        object2 = call2.getValueArguments();
        object = Intrinsics.stringPlus((String)calleeExpression.getText(), (Object)"(");
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"valueArguments");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)", ", (CharSequence)((CharSequence)object), (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<ValueArgument, CharSequence>(context2){
            final /* synthetic */ BindingContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(ValueArgument argument2) {
                KtExpression ktExpression = argument2.getArgumentExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                KotlinType kotlinType = this.$context.getType(ktExpression);
                Intrinsics.checkNotNull((Object)kotlinType);
                KotlinType kotlinType2 = kotlinType;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"context.getType(argument\u2026ArgumentExpression()!!)!!");
                KotlinType type2 = kotlinType2;
                return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(type2);
            }
        }), (int)24, null);
    }

    @NotNull
    public final KotlinType resolveDelegateExpression(@NotNull KtExpression delegateExpression2, @NotNull KtProperty property2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull InferenceSession inferenceSession) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)scopeForDelegate, (String)"scopeForDelegate");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkNotNullParameter((Object)inferenceSession, (String)"inferenceSession");
        KotlinType kotlinType = property2.getTypeReference() != null ? variableDescriptor.getType() : (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (property.typeReferen\u2026ype else NO_EXPECTED_TYPE");
        KotlinType propertyExpectedType = kotlinType;
        kotlinType = this.resolveWithNewInference(delegateExpression2, variableDescriptor, scopeForDelegate, trace, dataFlowInfo, inferenceSession);
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            boolean bl = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(trace, \"Trace to \u2026olve delegated property\")");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        ConstraintSystemCompleterImpl completer = new ConstraintSystemCompleterImpl(property2, propertyExpectedType, variableDescriptor, delegateExpression2, scopeForDelegate, trace, dataFlowInfo);
        KtExpression it = CallUtilKt.getCalleeExpressionIfAny(delegateExpression2);
        if (it != null) {
            object = it;
            KtExpression it2 = object;
            boolean bl = false;
            WritableSlice<KtElement, ConstraintSystemCompleter> writableSlice = BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            Intrinsics.checkNotNullExpressionValue(writableSlice, (String)"CONSTRAINT_SYSTEM_COMPLETER");
            traceToResolveDelegatedProperty.record(writableSlice, it2, completer);
        }
        object = this.expressionTypingServices.safeGetType(scopeForDelegate, delegateExpression2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expressionTypingServices\u2026legatedProperty\n        )");
        Object delegateType = object;
        traceToResolveDelegatedProperty.commit(DelegatedPropertyResolver::resolveDelegateExpression$lambda-6, true);
        return delegateType;
    }

    private final void completeNotComputedDelegateType(BindingTrace trace, TemporaryBindingTrace traceToResolveDelegatedProperty) {
        Diagnostic diagnostic;
        block2: {
            Iterable<Diagnostic> iterable = traceToResolveDelegatedProperty.getBindingContext().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"traceToResolveDelegatedP\u2026indingContext.diagnostics");
            Iterable<Diagnostic> iterable2 = iterable = (Iterable)iterable;
            Iterator<Diagnostic> iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Diagnostic diagnostic2;
                Diagnostic it = diagnostic2 = iterator2.next();
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual(it.getFactory(), Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.getErrorFactory()) || Intrinsics.areEqual(it.getFactory(), Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.getWarningFactory());
                if (!bl2) continue;
                diagnostic = diagnostic2;
                break block2;
            }
            diagnostic = null;
        }
        Diagnostic ranIntoRecursionDiagnostic = diagnostic;
        if (ranIntoRecursionDiagnostic != null) {
            trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(this.languageVersionSettings, (KtExpression)((PsiElement)((KtExpression)ranIntoRecursionDiagnostic.getPsiElement()))));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType resolveWithNewInference(KtExpression delegateExpression2, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, BindingTrace trace, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession) {
        KotlinType delegateTypeForProperType;
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
            return null;
        }
        KotlinType kotlinType = trace.getType(delegateExpression2);
        if (kotlinType != null) {
            KotlinType kotlinType2;
            KotlinType it = kotlinType2 = kotlinType;
            boolean bl = false;
            return it;
        }
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace, "Trace to resolve delegated property");
        Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace, (String)"create(trace, \"Trace to \u2026olve delegated property\")");
        TemporaryBindingTrace traceToResolveDelegatedProperty = temporaryBindingTrace;
        KotlinTypeInfo it = this.expressionTypingServices.getTypeInfo(scopeForDelegate, delegateExpression2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, inferenceSession, traceToResolveDelegatedProperty, false, delegateExpression2, ContextDependency.DEPENDENT);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"expressionTypingServices\u2026dency.DEPENDENT\n        )");
        KotlinTypeInfo delegateTypeInfo = it;
        KotlinType bl = delegateTypeInfo.getType();
        if (bl == null) {
            DelegatedPropertyResolver delegatedPropertyResolver;
            DelegatedPropertyResolver $this$resolveWithNewInference_u24lambda_u2d9 = delegatedPropertyResolver = this;
            boolean bl2 = false;
            $this$resolveWithNewInference_u24lambda_u2d9.completeNotComputedDelegateType(trace, traceToResolveDelegatedProperty);
            return null;
        }
        KotlinType delegateType = bl;
        Object delegateDataFlow = delegateTypeInfo.getDataFlowInfo();
        TypeConstructor delegateTypeConstructor = delegateType.getConstructor();
        if (delegateTypeConstructor instanceof IntegerLiteralTypeConstructor) {
            delegateType = ((IntegerLiteralTypeConstructor)delegateTypeConstructor).getApproximatedType();
        }
        KotlinType kotlinType3 = delegateTypeForProperType = this.isProperType(delegateType) ? delegateType : null;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.OperatorProvideDelegate)) {
            NewTypeSubstitutor newTypeSubstitutor;
            TemporaryBindingTrace temporaryBindingTrace2 = TemporaryBindingTrace.create(traceToResolveDelegatedProperty, "Trace to resolve provide delegate");
            Intrinsics.checkNotNullExpressionValue((Object)temporaryBindingTrace2, (String)"create(traceToResolveDel\u2026esolve provide delegate\")");
            TemporaryBindingTrace traceForProvideDelegate = temporaryBindingTrace2;
            Map<UnwrappedType, UnwrappedType> substitutionMap = this.buildSubstitutionMapOfNonFixedVariables(delegateType);
            if (substitutionMap != null) {
                Map map;
                void $this$mapKeysTo$iv$iv;
                Map<UnwrappedType, UnwrappedType> $this$mapKeys$iv = substitutionMap;
                boolean $i$f$mapKeys = false;
                Map<UnwrappedType, UnwrappedType> map2 = $this$mapKeys$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    void it2;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    map = destination$iv$iv;
                    boolean bl3 = false;
                    TypeConstructor typeConstructor2 = ((UnwrappedType)it2.getKey()).getConstructor();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    TypeConstructor typeConstructor3 = typeConstructor2;
                    Map map3 = map;
                    boolean bl4 = false;
                    entry = it$iv$iv.getValue();
                    map3.put(typeConstructor3, entry);
                }
                Map map4 = map = destination$iv$iv;
                newTypeSubstitutor = new NewTypeSubstitutorByConstructorMap(map4);
            } else {
                newTypeSubstitutor = EmptySubstitutor.INSTANCE;
            }
            NewTypeSubstitutor nonFixedVariablesToStubTypesSubstitutor = newTypeSubstitutor;
            UnwrappedType delegateTypeWithoutNonFixedVariables = nonFixedVariablesToStubTypesSubstitutor.safeSubstitute(delegateType.unwrap());
            ExpressionTypingContext contextForProvideDelegate = this.createContextForProvideDelegateMethod(scopeForDelegate, (DataFlowInfo)delegateDataFlow, traceForProvideDelegate, new InferenceSessionForExistingCandidates(substitutionMap != null, inferenceSession));
            OverloadResolutionResults<FunctionDescriptor> provideDelegateResults = this.getProvideDelegateMethod(variableDescriptor, delegateExpression2, delegateTypeWithoutNonFixedVariables, contextForProvideDelegate);
            if (provideDelegateResults.isSuccess()) {
                Object object = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"provideDelegateResults.resultingDescriptor");
                FunctionDescriptor provideDelegateDescriptor = object;
                if (provideDelegateDescriptor.isOperator()) {
                    object = this.inverseSubstitution(provideDelegateDescriptor.getReturnType(), substitutionMap);
                    if (object == null) {
                        return null;
                    }
                    delegateType = (KotlinType)object;
                    object = provideDelegateResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"provideDelegateResults.r\u2026foForArguments.resultInfo");
                    delegateDataFlow = object;
                }
                if (substitutionMap == null) {
                    object = BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PROVIDE_DELEGATE_RESOLVED_CALL");
                    traceForProvideDelegate.record(object, variableDescriptor, provideDelegateResults.getResultingCall());
                    traceForProvideDelegate.commit();
                }
            }
        }
        return this.inferDelegateTypeFromGetSetValueMethods(delegateExpression2, variableDescriptor, scopeForDelegate, traceToResolveDelegatedProperty, delegateType, delegateTypeForProperType, (DataFlowInfo)delegateDataFlow, inferenceSession);
    }

    private final UnwrappedType inverseSubstitution(KotlinType type2, Map<UnwrappedType, ? extends UnwrappedType> substitutionMap) {
        if (type2 == null) {
            return null;
        }
        if (substitutionMap == null) {
            return type2.unwrap();
        }
        HashMap invertedMap = new HashMap();
        Object object = substitutionMap;
        Iterator<Map.Entry<UnwrappedType, ? extends UnwrappedType>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = object = iterator2.next();
            UnwrappedType variable2 = (UnwrappedType)object2.getKey();
            Object object3 = object;
            UnwrappedType stubType = (UnwrappedType)object3.getValue();
            object3 = invertedMap;
            TypeConstructor typeConstructor2 = stubType.getConstructor();
            object3.put(typeConstructor2, variable2);
        }
        return new NewTypeSubstitutorByConstructorMap(invertedMap).safeSubstitute(type2.unwrap());
    }

    private final Map<UnwrappedType, UnwrappedType> buildSubstitutionMapOfNonFixedVariables(KotlinType type2) {
        if (type2.getConstructor() instanceof NewTypeVariableConstructor) {
            return null;
        }
        Ref.ObjectRef substitutionMap = new Ref.ObjectRef();
        TypeUtilsKt.contains(type2, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((Ref.ObjectRef<Map<UnwrappedType, UnwrappedType>>)substitutionMap){
            final /* synthetic */ Ref.ObjectRef<Map<UnwrappedType, UnwrappedType>> $substitutionMap;
            {
                this.$substitutionMap = $substitutionMap;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull UnwrappedType innerType) {
                Intrinsics.checkNotNullParameter((Object)innerType, (String)"innerType");
                TypeConstructor constructor2 = innerType.getConstructor();
                if (constructor2 instanceof NewTypeVariableConstructor) {
                    if (this.$substitutionMap.element == null) {
                        this.$substitutionMap.element = new HashMap<K, V>();
                    }
                    Object object = this.$substitutionMap.element;
                    Intrinsics.checkNotNull((Object)object);
                    Map map = (Map)object;
                    Object object2 = map;
                    if (!object2.containsKey(innerType)) {
                        Object object3 = this.$substitutionMap.element;
                        Intrinsics.checkNotNull((Object)object3);
                        map = (Map)object3;
                        object2 = new StubTypeForProvideDelegateReceiver(constructor2, innerType.isMarkedNullable(), null, 4, null);
                        map.put(innerType, object2);
                    }
                }
                return false;
            }
        }));
        return (Map)substitutionMap.element;
    }

    private final UnwrappedType inferDelegateTypeFromGetSetValueMethods(KtExpression delegateExpression2, VariableDescriptorWithAccessors variableDescriptor, LexicalScope scopeForDelegate, TemporaryBindingTrace trace, KotlinType delegateType, KotlinType delegateTypeForProperType, DataFlowInfo delegateDataFlow, InferenceSession inferenceSession) {
        UnwrappedType expectedType2 = !(variableDescriptor.getType() instanceof DeferredType) ? variableDescriptor.getType().unwrap() : null;
        DelegatedPropertyInferenceSession newInferenceSession = new DelegatedPropertyInferenceSession(variableDescriptor, expectedType2, this.psiCallResolver, this.postponedArgumentsAnalyzer, this.kotlinConstraintSystemCompleter, this.callComponents, this.builtIns, inferenceSession);
        ExpressionReceiver receiver = this.createReceiverForGetSetValueMethods(delegateExpression2, delegateType, trace);
        ExpressionTypingContext context2 = this.createContextForGetSetValueMethods(variableDescriptor, scopeForDelegate, delegateDataFlow, trace, newInferenceSession);
        this.getGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, scopeForDelegate, delegateDataFlow, true, true, receiver, context2);
        if (variableDescriptor.isVar() && !(variableDescriptor.getReturnType() instanceof DeferredType)) {
            this.getGetSetValueMethod(variableDescriptor, delegateExpression2, delegateType, trace, scopeForDelegate, delegateDataFlow, false, true, receiver, context2);
        }
        Call call2 = CallMaker.makeCall(delegateExpression2, receiver);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(delegateExpression, receiver)");
        Call call3 = call2;
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2, call3, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)basicCallResolutionContext, (String)"create(context, call, Ch\u2026de.CHECK_VALUE_ARGUMENTS)");
        BasicCallResolutionContext resolutionContext = basicCallResolutionContext;
        KotlinResolutionCallbacksImpl resolutionCallbacks = this.psiCallResolver.createResolutionCallbacks(trace, newInferenceSession, resolutionContext);
        List resolutionResults = newInferenceSession.resolveCandidates(resolutionCallbacks);
        Object object2 = new Pair[]{TuplesKt.to((Object)OperatorNameConventions.GET_VALUE, (Object)true), TuplesKt.to((Object)OperatorNameConventions.SET_VALUE, (Object)false)};
        for (Object object2 : CollectionsKt.listOf((Object[])object2)) {
            ResolutionResultCallInfo resolutionResultCallInfo;
            ResolutionResultCallInfo result2;
            Object v1;
            boolean isGet;
            block5: {
                Name name2 = (Name)object2.component1();
                isGet = (Boolean)object2.component2();
                Iterable $this$firstOrNull$iv = resolutionResults;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Name name3;
                    ResolutionResultCallInfo it = (ResolutionResultCallInfo)element$iv;
                    boolean bl = false;
                    ResolvedCallAtom resolvedCallAtom = ResolutionAtomsKt.resultCallAtom(it.getResolutionResult());
                    if (resolvedCallAtom == null) {
                        name3 = null;
                    } else {
                        KotlinCall kotlinCall = resolvedCallAtom.getAtom();
                        name3 = kotlinCall.getName();
                    }
                    if (!Intrinsics.areEqual(name3, (Object)name2)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            ResolutionResultCallInfo resolutionResultCallInfo2 = result2 = (ResolutionResultCallInfo)v1;
            if (resolutionResultCallInfo2 == null) continue;
            ResolutionResultCallInfo it = resolutionResultCallInfo = resolutionResultCallInfo2;
            boolean bl = false;
            DelegatedPropertyResolver.inferDelegateTypeFromGetSetValueMethods$recordResolvedDelegateOrReportError(variableDescriptor, this, trace, delegateExpression2, delegateType, it.getOverloadResolutionResults(), isGet);
        }
        KotlinType resolvedDelegateType = this.extractResolvedDelegateType(delegateExpression2, trace, delegateType);
        object2 = delegateTypeForProperType;
        trace.recordType(delegateExpression2, object2 == null ? resolvedDelegateType : object2);
        trace.commit();
        return resolvedDelegateType.unwrap();
    }

    private final KotlinType extractResolvedDelegateType(KtExpression delegateExpression2, BindingTrace trace, KotlinType delegateType) {
        Object object;
        ResolvedCall<? extends CallableDescriptor> it;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3;
        KotlinType kotlinType;
        KtElement ktElement = delegateExpression2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        Call call2 = CallUtilKt.getCall(ktElement, bindingContext);
        ResolvedCall<? extends CallableDescriptor> resolvedCall4 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedCall4, (String)"trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall5 = CallUtilKt.getResolvedCall(call2, (BindingContext)((Object)resolvedCall4));
        if (resolvedCall5 == null) {
            kotlinType = null;
        } else {
            resolvedCall4 = resolvedCall5.getResultingDescriptor();
            kotlinType = resolvedCall4.getReturnType();
        }
        KotlinType pretendReturnType = kotlinType;
        resolvedCall4 = pretendReturnType;
        if (resolvedCall4 == null) {
            resolvedCall3 = null;
        } else {
            it = resolvedCall2 = resolvedCall4;
            boolean bl = false;
            resolvedCall3 = resolvedCall5 = this.isProperType((KotlinType)((Object)it)) ? resolvedCall2 : null;
        }
        if (resolvedCall5 == null) {
            it = resolvedCall2 = delegateType;
            boolean bl = false;
            ResolvedCall<? extends CallableDescriptor> resolvedCall6 = resolvedCall4 = this.isProperType((KotlinType)((Object)it)) ? resolvedCall2 : null;
            if (resolvedCall4 == null) {
                resolvedCall2 = ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Type for ", (Object)delegateExpression2.getText()));
                Intrinsics.checkNotNullExpressionValue((Object)resolvedCall2, (String)"createErrorType(\"Type fo\u2026elegateExpression.text}\")");
                object = (KotlinType)((Object)resolvedCall2);
            } else {
                object = resolvedCall4;
            }
        } else {
            object = resolvedCall5;
        }
        return object;
    }

    private final boolean isProperType(KotlinType $this$isProperType) {
        return !TypeUtilsKt.contains($this$isProperType, (Function1<? super UnwrappedType, Boolean>)((Function1)isProperType.1.INSTANCE));
    }

    private final boolean conventionMethodFound(OverloadResolutionResults<FunctionDescriptor> results) {
        return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
    }

    private static final boolean resolveDelegateExpression$lambda-6(WritableSlice slice, Object $noName_1) {
        return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
    }

    private static final void inferDelegateTypeFromGetSetValueMethods$recordResolvedDelegateOrReportError(VariableDescriptorWithAccessors $variableDescriptor, DelegatedPropertyResolver this$0, TemporaryBindingTrace $trace, KtExpression $delegateExpression, KotlinType $delegateType, OverloadResolutionResults<FunctionDescriptor> result2, boolean isGet) {
        VariableAccessorDescriptor variableAccessorDescriptor;
        boolean bl = isGet;
        if (bl) {
            variableAccessorDescriptor = $variableDescriptor.getGetter();
        } else if (!bl) {
            variableAccessorDescriptor = $variableDescriptor.getSetter();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        VariableAccessorDescriptor accessor = variableAccessorDescriptor;
        if (accessor == null) {
            boolean bl2 = false;
            String string2 = "Delegated property should have getter/setter " + $variableDescriptor + ' ' + $delegateExpression.getText();
            throw new IllegalArgumentException(string2.toString());
        }
        if (result2.isSuccess()) {
            this$0.recordDelegateOperatorResults(result2, $variableDescriptor, accessor, $trace);
        } else {
            this$0.reportGetSetValueResolutionError(result2, accessor, $delegateExpression, $delegateType, $trace, isGet);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&H\u0002J\u001c\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0016J(\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver$ConstraintSystemCompleterImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemCompleter;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "scopeForDelegate", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "(Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDelegateExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVariableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "addConstraintForThisValue", "", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "typeVariableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "dispatchReceiverOnly", "", "completeConstraintSystem", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getDelegateType", "byExpressionType", "traceToResolveConventionMethods", "Lorg/jetbrains/kotlin/resolve/TemporaryBindingTrace;", "frontend"})
    public final class ConstraintSystemCompleterImpl
    implements ConstraintSystemCompleter {
        @NotNull
        private final KtProperty property;
        @NotNull
        private final KotlinType expectedType;
        @NotNull
        private final VariableDescriptorWithAccessors variableDescriptor;
        @NotNull
        private final KtExpression delegateExpression;
        @NotNull
        private final LexicalScope scopeForDelegate;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        public ConstraintSystemCompleterImpl(@NotNull KtProperty property2, @NotNull KotlinType expectedType2, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KtExpression delegateExpression2, @NotNull LexicalScope scopeForDelegate, @NotNull BindingTrace trace, DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)DelegatedPropertyResolver.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter((Object)expectedType2, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
            Intrinsics.checkNotNullParameter((Object)delegateExpression2, (String)"delegateExpression");
            Intrinsics.checkNotNullParameter((Object)scopeForDelegate, (String)"scopeForDelegate");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            this.property = property2;
            this.expectedType = expectedType2;
            this.variableDescriptor = variableDescriptor;
            this.delegateExpression = delegateExpression2;
            this.scopeForDelegate = scopeForDelegate;
            this.trace = trace;
            this.dataFlowInfo = dataFlowInfo;
        }

        @NotNull
        public final KtProperty getProperty() {
            return this.property;
        }

        @NotNull
        public final KotlinType getExpectedType() {
            return this.expectedType;
        }

        @NotNull
        public final VariableDescriptorWithAccessors getVariableDescriptor() {
            return this.variableDescriptor;
        }

        @NotNull
        public final KtExpression getDelegateExpression() {
            return this.delegateExpression;
        }

        @NotNull
        public final BindingTrace getTrace() {
            return this.trace;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        @Override
        public void completeConstraintSystem(@NotNull ConstraintSystem.Builder constraintSystem, @NotNull ResolvedCall<?> resolvedCall2) {
            KotlinType returnTypeInSystem;
            KotlinType kotlinType;
            Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Object object = resolvedCall2.getCandidateDescriptor().getReturnType();
            if (object == null) {
                return;
            }
            KotlinType returnType2 = kotlinType = object;
            Map<CallHandle, TypeSubstitutor> map = constraintSystem.getTypeVariableSubstitutors();
            Object object2 = resolvedCall2.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resolvedCall.call");
            object = map.get(TypeVariableKt.toHandle((Call)object2));
            if (object == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"No substitutor in the system for call: ", (Object)resolvedCall2.getCall()));
            }
            Object typeVariableSubstitutor = object;
            object2 = TemporaryBindingTrace.create(this.trace, "Trace to resolve delegated property convention methods");
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(trace, \"Trace to \u2026erty convention methods\")");
            Object traceToResolveConventionMethods = object2;
            KotlinType delegateType = this.getDelegateType(returnType2, constraintSystem, (TypeSubstitutor)typeVariableSubstitutor, (TemporaryBindingTrace)traceToResolveConventionMethods);
            OverloadResolutionResults getValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, (BindingTrace)traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, true, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(getValueResults)) {
                Object d = getValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, (String)"getValueResults.resultingDescriptor");
                FunctionDescriptor getValueDescriptor = (FunctionDescriptor)d;
                KotlinType getValueReturnType = getValueDescriptor.getReturnType();
                if (getValueReturnType != null && !TypeUtils.noExpectedType(this.expectedType) && (returnTypeInSystem = ((TypeSubstitutor)typeVariableSubstitutor).substitute(getValueReturnType, Variance.INVARIANT)) != null) {
                    constraintSystem.addSubtypeConstraint(returnTypeInSystem, this.expectedType, ConstraintPositionKind.FROM_COMPLETER.position());
                }
                ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, (TypeSubstitutor)typeVariableSubstitutor, getValueDescriptor, false, 8, null);
            }
            if (!this.variableDescriptor.isVar()) {
                return;
            }
            if (this.variableDescriptor.getReturnType() instanceof DeferredType) {
                return;
            }
            OverloadResolutionResults setValueResults = DelegatedPropertyResolver.getGetSetValueMethod$default(DelegatedPropertyResolver.this, this.variableDescriptor, this.delegateExpression, delegateType, (BindingTrace)traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, false, false, null, null, 768, null);
            if (DelegatedPropertyResolver.this.conventionMethodFound(setValueResults)) {
                returnTypeInSystem = setValueResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)returnTypeInSystem, (String)"setValueResults.resultingDescriptor");
                FunctionDescriptor setValueDescriptor = (FunctionDescriptor)((Object)returnTypeInSystem);
                List<ValueParameterDescriptor> list2 = setValueDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"setValueDescriptor.valueParameters");
                List<ValueParameterDescriptor> setValueParameters = list2;
                if (setValueParameters.size() == 3) {
                    if (!TypeUtils.noExpectedType(this.expectedType)) {
                        KotlinType kotlinType2 = setValueParameters.get(2).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"setValueParameters[2].type");
                        KotlinType thisParameterType = kotlinType2;
                        KotlinType substitutedThisParameterType = ((TypeSubstitutor)typeVariableSubstitutor).substitute(thisParameterType, Variance.INVARIANT);
                        constraintSystem.addSubtypeConstraint(this.expectedType, substitutedThisParameterType, ConstraintPositionKind.FROM_COMPLETER.position());
                    }
                    ConstraintSystemCompleterImpl.addConstraintForThisValue$default(this, constraintSystem, (TypeSubstitutor)typeVariableSubstitutor, setValueDescriptor, false, 8, null);
                }
            }
        }

        private final KotlinType getDelegateType(KotlinType byExpressionType, ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, TemporaryBindingTrace traceToResolveConventionMethods) {
            OverloadResolutionResults provideDelegateResults;
            if (DelegatedPropertyResolver.this.isOperatorProvideDelegateSupported() && DelegatedPropertyResolver.this.conventionMethodFound(provideDelegateResults = DelegatedPropertyResolver.this.getProvideDelegateMethod(this.variableDescriptor, this.delegateExpression, byExpressionType, traceToResolveConventionMethods, this.scopeForDelegate, this.dataFlowInfo, null))) {
                Object d = provideDelegateResults.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, (String)"provideDelegateResults.resultingDescriptor");
                FunctionDescriptor provideDelegateDescriptor = (FunctionDescriptor)d;
                KotlinType provideDelegateReturnType = provideDelegateDescriptor.getReturnType();
                if (provideDelegateDescriptor.isOperator()) {
                    this.addConstraintForThisValue(constraintSystem, typeVariableSubstitutor, provideDelegateDescriptor, true);
                    KotlinType kotlinType = provideDelegateReturnType;
                    if (kotlinType == null) {
                        throw new AssertionError((Object)Intrinsics.stringPlus((String)"No return type fore 'provideDelegate' of ", (Object)this.delegateExpression.getText()));
                    }
                    return kotlinType;
                }
            }
            return byExpressionType;
        }

        private final void addConstraintForThisValue(ConstraintSystem.Builder constraintSystem, TypeSubstitutor typeVariableSubstitutor, FunctionDescriptor resultingDescriptor, boolean dispatchReceiverOnly) {
            ReceiverParameterDescriptor receiverParameterDescriptor;
            ReceiverParameterDescriptor receiverParameterDescriptor2;
            ReceiverParameterDescriptor extensionReceiver = this.variableDescriptor.getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.variableDescriptor.getDispatchReceiverParameter();
            Object object = dispatchReceiverOnly ? ((receiverParameterDescriptor2 = dispatchReceiver) == null ? null : receiverParameterDescriptor2.getType()) : ((receiverParameterDescriptor2 = extensionReceiver) == null ? ((receiverParameterDescriptor = dispatchReceiver) == null ? null : receiverParameterDescriptor.getType()) : receiverParameterDescriptor2.getType());
            Object object2 = object;
            KotlinType kotlinType = object2 == null ? (KotlinType)DelegatedPropertyResolver.this.builtIns.getNullableNothingType() : object2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"if (dispatchReceiverOnly\u2026ltIns.nullableNothingType");
            KotlinType typeOfThis = kotlinType;
            object2 = resultingDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resultingDescriptor.valueParameters");
            Object valueParameters2 = object2;
            if (valueParameters2.isEmpty()) {
                return;
            }
            ValueParameterDescriptor valueParameterForThis = (ValueParameterDescriptor)valueParameters2.get(0);
            constraintSystem.addSubtypeConstraint(typeOfThis, typeVariableSubstitutor.substitute(valueParameterForThis.getType(), Variance.INVARIANT), ConstraintPositionKind.FROM_COMPLETER.position());
        }

        static /* synthetic */ void addConstraintForThisValue$default(ConstraintSystemCompleterImpl constraintSystemCompleterImpl, ConstraintSystem.Builder builder2, TypeSubstitutor typeSubstitutor2, FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            constraintSystemCompleterImpl.addConstraintForThisValue(builder2, typeSubstitutor2, functionDescriptor, bl);
        }
    }
}

