/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001bJ\u0006\u0010$\u001a\u00020\"J\u0006\u0010%\u001a\u00020\"R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001aj\b\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "deserializeBodies", "", "allowErrorNodes", "deserializeInlineFunctions", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;ZZZLorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;)V", "declarationDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "fileDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getFileDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "reachableTopLevels", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/LinkedHashSet;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "addIdSignature", "", "key", "deserializeAllFileReachableTopLevel", "enqueueAllDeclarations", "ir.serialization.common"})
public final class FileDeserializationState {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final IrFileDeserializer fileDeserializer;
    @NotNull
    private final LinkedHashSet<IdSignature> reachableTopLevels;

    public FileDeserializationState(@NotNull KotlinIrLinker linker, @NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IrLibraryFile fileReader, @NotNull IrFile fileProto, boolean deserializeBodies, boolean allowErrorNodes, boolean deserializeInlineFunctions, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)fileProto, (String)"fileProto");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        this.linker = linker;
        ReferenceSymbolTable referenceSymbolTable = this.linker.getSymbolTable();
        IrFileSymbol irFileSymbol = file2.getSymbol();
        List<Serializable> list2 = fileProto.getActualList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fileProto.actualList");
        this.symbolDeserializer = new IrSymbolDeserializer(referenceSymbolTable, fileReader, irFileSymbol, list2, (Function1)new Function1<IdSignature, Unit>((Object)this){

            public final void invoke(@NotNull IdSignature p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FileDeserializationState)this.receiver).addIdSignature(p0);
            }

            @NotNull
            public final String getSignature() {
                return "addIdSignature(Lorg/jetbrains/kotlin/ir/util/IdSignature;)V";
            }

            @NotNull
            public final String getName() {
                return "addIdSignature";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(FileDeserializationState.class);
            }
        }, (Function2)new Function2<IdSignature, IrSymbol, IrSymbol>((Object)this.linker){

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature p0, @NotNull IrSymbol p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((KotlinIrLinker)this.receiver).handleExpectActualMapping(p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "handleExpectActualMapping(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "handleExpectActualMapping";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinIrLinker.class);
            }
        }, false, null, (Function2)new Function2<IdSignature, BinarySymbolData.SymbolKind, IrSymbol>(moduleDeserializer, this){
            final /* synthetic */ IrModuleDeserializer $moduleDeserializer;
            final /* synthetic */ FileDeserializationState this$0;
            {
                this.$moduleDeserializer = $moduleDeserializer;
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                IrModuleDeserializer irModuleDeserializer;
                Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
                Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
                IdSignature topLevelSig = idSig.topLevelSignature();
                IrModuleDeserializer irModuleDeserializer2 = BasicIrModuleDeserializerKt.findModuleDeserializerForTopLevelId(this.$moduleDeserializer, topLevelSig);
                if (irModuleDeserializer2 == null) {
                    FileDeserializationState fileDeserializationState = this.this$0;
                    IrModuleDeserializer irModuleDeserializer3 = this.$moduleDeserializer;
                    FileDeserializationState $this$invoke_u24lambda_u2d0 = fileDeserializationState;
                    boolean bl = false;
                    irModuleDeserializer = $this$invoke_u24lambda_u2d0.getLinker().handleSignatureIdNotFoundInModuleWithDependencies(idSig, irModuleDeserializer3);
                } else {
                    irModuleDeserializer = irModuleDeserializer2;
                }
                IrModuleDeserializer actualModuleDeserializer = irModuleDeserializer;
                return actualModuleDeserializer.deserializeIrSymbol(idSig, symbolKind);
            }
        }, 192, null);
        this.declarationDeserializer = new IrDeclarationDeserializer(this.linker.getBuiltIns(), this.linker.getSymbolTable(), this.linker.getSymbolTable().getIrFactory(), fileReader, file2, allowErrorNodes, deserializeInlineFunctions, deserializeBodies, this.symbolDeserializer, this.linker.getFakeOverrideBuilder().getPlatformSpecificClassFilter(), this.linker.getFakeOverrideBuilder(), false, null, false, moduleDeserializer.getCompatibilityMode(), false, false, 112640, null);
        this.fileDeserializer = new IrFileDeserializer(file2, fileReader, fileProto, this.symbolDeserializer, this.declarationDeserializer);
        this.reachableTopLevels = new LinkedHashSet();
        list2 = fileProto.getExplicitlyExportedToCompilerList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fileProto.explicitlyExportedToCompilerList");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Long it = (Long)element$iv;
            boolean bl2 = false;
            IrSymbolDeserializer irSymbolDeserializer = this.getSymbolDeserializer();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            long symbolData = irSymbolDeserializer.parseSymbolData-9x8F8T0(it);
            IdSignature sig = this.getSymbolDeserializer().deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            boolean bl3 = bl = !sig.isPackageSignature();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.addIdSignature(sig.topLevelSignature());
        }
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrFileDeserializer getFileDeserializer() {
        return this.fileDeserializer;
    }

    public final void addIdSignature(@NotNull IdSignature key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.reachableTopLevels.add(key);
    }

    public final void enqueueAllDeclarations() {
        this.reachableTopLevels.addAll((Collection<IdSignature>)this.fileDeserializer.getReversedSignatureIndex().keySet());
    }

    public final void deserializeAllFileReachableTopLevel() {
        while (!((Collection)this.reachableTopLevels).isEmpty()) {
            IdSignature reachableKey = (IdSignature)CollectionsKt.first((Iterable)this.reachableTopLevels);
            IrSymbol existedSymbol = this.symbolDeserializer.getDeserializedSymbols().get(reachableKey);
            if (existedSymbol == null || !existedSymbol.isBound()) {
                this.fileDeserializer.deserializeDeclaration(reachableKey);
            }
            this.reachableTopLevels.remove(reachableKey);
        }
    }
}

