/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoRenderer;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005J\u0006\u0010\u0016\u001a\u00020\u0013J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u001d*\u00060\u001ej\u0002`\u001f2\u0006\u0010\u0014\u001a\u00020\nH\u0002R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\tX\u0082.\u00a2\u0006\u0002\n\u0000R,\u0010\f\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "processors", "", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "existingInfosPerFile", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "existingInfosPerFilePerInfoCache", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/codeMetaInfo/model/CodeMetaInfo;", "infosPerFile", "", "addMetadataInfosForFile", "", "file", "codeMetaInfos", "compareAllMetaDataInfos", "getExistingMetaInfosForActualMetadata", "metaInfo", "getExistingMetaInfosForFile", "getReportedMetaInfosForFile", "parseExistingMetadataInfosFromAllSources", "stripAdditionalEmptyLines", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "test-infrastructure"})
public final class GlobalMetadataInfoHandler
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<AdditionalMetaInfoProcessor> processors;
    private Map<TestFile, ? extends List<ParsedCodeMetaInfo>> existingInfosPerFile;
    @NotNull
    private final Map<TestFile, List<CodeMetaInfo>> infosPerFile;
    @NotNull
    private final Map<Pair<TestFile, CodeMetaInfo>, List<ParsedCodeMetaInfo>> existingInfosPerFilePerInfoCache;

    public GlobalMetadataInfoHandler(@NotNull TestServices testServices, @NotNull List<? extends AdditionalMetaInfoProcessor> processors) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        this.testServices = testServices;
        this.processors = processors;
        this.infosPerFile = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)infosPerFile.1.INSTANCE);
        this.existingInfosPerFilePerInfoCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final void parseExistingMetadataInfosFromAllSources() {
        void $this$flatMapTo$iv$iv;
        Map map;
        Map map2 = map = MapsKt.createMapBuilder();
        GlobalMetadataInfoHandler globalMetadataInfoHandler = this;
        boolean bl = false;
        Iterable $this$flatMap$iv = TestModuleStructureKt.getModuleStructure(this.testServices).getModules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TestModule it = (TestModule)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (TestFile file2 : (List)destination$iv$iv) {
            void $this$parseExistingMetadataInfosFromAllSources_u24lambda_u2d1;
            $this$parseExistingMetadataInfosFromAllSources_u24lambda_u2d1.put(file2, CodeMetaInfoParser.INSTANCE.getCodeMetaInfoFromText(file2.getOriginalContent()));
        }
        Unit unit2 = Unit.INSTANCE;
        globalMetadataInfoHandler.existingInfosPerFile = MapsKt.build((Map)map);
    }

    @NotNull
    public final List<ParsedCodeMetaInfo> getExistingMetaInfosForFile(@NotNull TestFile file2) {
        Map<TestFile, ? extends List<ParsedCodeMetaInfo>> map;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Map<TestFile, ? extends List<ParsedCodeMetaInfo>> map2 = this.existingInfosPerFile;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"existingInfosPerFile");
            map = null;
        } else {
            map = map2;
        }
        return (List)MapsKt.getValue(map, (Object)file2);
    }

    @NotNull
    public final List<CodeMetaInfo> getReportedMetaInfosForFile(@NotNull TestFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (List)MapsKt.getValue(this.infosPerFile, (Object)file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ParsedCodeMetaInfo> getExistingMetaInfosForActualMetadata(@NotNull TestFile file2, @NotNull CodeMetaInfo metaInfo) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)metaInfo, (String)"metaInfo");
        Map<Pair<TestFile, CodeMetaInfo>, List<ParsedCodeMetaInfo>> map = this.existingInfosPerFilePerInfoCache;
        Pair key$iv = TuplesKt.to((Object)file2, (Object)metaInfo);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.getExistingMetaInfosForFile(file2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)metaInfo)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    public final void addMetadataInfosForFile(@NotNull TestFile file2, @NotNull List<? extends CodeMetaInfo> codeMetaInfos) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(codeMetaInfos, (String)"codeMetaInfos");
        Map<TestFile, List<CodeMetaInfo>> $this$getOrPut$iv = this.infosPerFile;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(file2);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(file2, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        List infos = list2;
        Collection collection = infos;
        CollectionsKt.addAll((Collection)collection, (Iterable)codeMetaInfos);
    }

    public final void compareAllMetaDataInfos() {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.testServices);
        StringBuilder builder2 = new StringBuilder();
        for (TestModule module2 : moduleStructure.getModules()) {
            for (TestFile file2 : module2.getFiles()) {
                if (file2.isAdditional()) continue;
                Iterable $this$forEach$iv = this.processors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AdditionalMetaInfoProcessor it = (AdditionalMetaInfoProcessor)element$iv;
                    boolean bl = false;
                    it.processMetaInfos(module2, file2);
                }
                List codeMetaInfos = (List)MapsKt.getValue(this.infosPerFile, (Object)file2);
                StringBuilder fileBuilder = new StringBuilder();
                CodeMetaInfoRenderer.INSTANCE.renderTagsToText(fileBuilder, codeMetaInfos, SourceFileProviderKt.getSourceFileProvider(this.testServices).getContentOfSourceFile(file2));
                builder2.append(this.stripAdditionalEmptyLines(fileBuilder, file2));
            }
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        String actualText = string2;
        Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions(this.testServices), (File)CollectionsKt.single(moduleStructure.getOriginalTestDataFiles()), actualText, null, 4, null);
    }

    private final CharSequence stripAdditionalEmptyLines(StringBuilder $this$stripAdditionalEmptyLines, TestFile file2) {
        CharSequence charSequence2;
        if (file2.getStartLineNumberInOriginalFile() != 0) {
            charSequence2 = StringsKt.removePrefix((CharSequence)$this$stripAdditionalEmptyLines, (CharSequence)CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, file2.getStartLineNumberInOriginalFile())), (CharSequence)"", null, null, (int)0, null, (Function1)stripAdditionalEmptyLines.1.INSTANCE, (int)30, null));
        } else {
            String string2 = $this$stripAdditionalEmptyLines.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            this.toString()\n        }");
            charSequence2 = string2;
        }
        return charSequence2;
    }
}

