/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractDiagnosticsTestWithJsStdLib;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib")
@TestDataPath(value="$PROJECT_ROOT")
public class DiagnosticsTestWithJsStdLibGenerated
extends AbstractDiagnosticsTestWithJsStdLib {
    @Test
    public void testAllFilesPresentInTestsWithJsStdLib() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
    }

    @Test
    @TestMetadata(value="funConstructorCallJS.kt")
    public void testFunConstructorCallJS() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/funConstructorCallJS.kt");
    }

    @Test
    @TestMetadata(value="implementingFunction.kt")
    public void testImplementingFunction() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/implementingFunction.kt");
    }

    @Test
    @TestMetadata(value="localClassMetadata.kt")
    public void testLocalClassMetadata() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/localClassMetadata.kt");
    }

    @Test
    @TestMetadata(value="noImpl.kt")
    public void testNoImpl() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/noImpl.kt");
    }

    @Test
    @TestMetadata(value="platformDependent.kt")
    public void testPlatformDependent() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/platformDependent.kt");
    }

    @Test
    @TestMetadata(value="runtimeAnnotations.kt")
    public void testRuntimeAnnotations() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/runtimeAnnotations.kt");
    }

    @Test
    @TestMetadata(value="unsafeCastFunctionOnDynamicType.kt")
    public void testUnsafeCastFunctionOnDynamicType() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/unsafeCastFunctionOnDynamicType.kt");
    }

    @Test
    @TestMetadata(value="wrongMultipleInheritance.kt")
    public void testWrongMultipleInheritance() throws Exception {
        this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/wrongMultipleInheritance.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/reflection")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Reflection {
        @Test
        public void testAllFilesPresentInReflection() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/reflection"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="reflectionApi.kt")
        public void testReflectionApi() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/reflection/reflectionApi.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/qualifier")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Qualifier {
        @Test
        public void testAllFilesPresentInQualifier() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/qualifier"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jsQualifierNonExternal.kt")
        public void testJsQualifierNonExternal() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/qualifier/jsQualifierNonExternal.kt");
        }

        @Test
        @TestMetadata(value="wrongQualifier.kt")
        public void testWrongQualifier() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/qualifier/wrongQualifier.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Native {
        @Test
        public void testAllFilesPresentInNative() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousInitializer.kt")
        public void testAnonymousInitializer() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/anonymousInitializer.kt");
        }

        @Test
        @TestMetadata(value="body.kt")
        public void testBody() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/body.kt");
        }

        @Test
        @TestMetadata(value="delegatedConstructorCall.kt")
        public void testDelegatedConstructorCall() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/delegatedConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="delegation.kt")
        public void testDelegation() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/delegation.kt");
        }

        @Test
        @TestMetadata(value="enumEntry.kt")
        public void testEnumEntry() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/enumEntry.kt");
        }

        @Test
        @TestMetadata(value="extensionFunctionAndProperty.kt")
        public void testExtensionFunctionAndProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/extensionFunctionAndProperty.kt");
        }

        @Test
        @TestMetadata(value="extensionFunctionArgumentOrReturnType.kt")
        public void testExtensionFunctionArgumentOrReturnType() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/extensionFunctionArgumentOrReturnType.kt");
        }

        @Test
        @TestMetadata(value="externalFunInterface.kt")
        public void testExternalFunInterface() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/externalFunInterface.kt");
        }

        @Test
        @TestMetadata(value="externalInterfaceNested.kt")
        public void testExternalInterfaceNested() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/externalInterfaceNested.kt");
        }

        @Test
        @TestMetadata(value="inheritance.kt")
        public void testInheritance() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/inheritance.kt");
        }

        @Test
        @TestMetadata(value="inline.kt")
        public void testInline() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/inline.kt");
        }

        @Test
        @TestMetadata(value="inlineClass.kt")
        public void testInlineClass() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/inlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassAsParameterOrReturnType.kt.kt")
        public void testInlineClassAsParameterOrReturnType_kt() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/inlineClassAsParameterOrReturnType.kt.kt");
        }

        @Test
        @TestMetadata(value="inlineExtensionToNative.kt")
        public void testInlineExtensionToNative() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/inlineExtensionToNative.kt");
        }

        @Test
        @TestMetadata(value="innerClass.kt")
        public void testInnerClass() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/innerClass.kt");
        }

        @Test
        @TestMetadata(value="nested.kt")
        public void testNested() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nested.kt");
        }

        @Test
        @TestMetadata(value="nonAbstractMembersOfInterface.kt")
        public void testNonAbstractMembersOfInterface() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nonAbstractMembersOfInterface.kt");
        }

        @Test
        @TestMetadata(value="overrideOptionalParam.kt")
        public void testOverrideOptionalParam() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/overrideOptionalParam.kt");
        }

        @Test
        @TestMetadata(value="privateMembers.kt")
        public void testPrivateMembers() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/privateMembers.kt");
        }

        @Test
        @TestMetadata(value="propertyParameter.kt")
        public void testPropertyParameter() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/propertyParameter.kt");
        }

        @Test
        @TestMetadata(value="wrongTarget.kt")
        public void testWrongTarget() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/wrongTarget.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class UnusedParam {
            @Test
            public void testAllFilesPresentInUnusedParam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="native.kt")
            public void testNative() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam/native.kt");
            }

            @Test
            @TestMetadata(value="nativeGetter.kt")
            public void testNativeGetter() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam/nativeGetter.kt");
            }

            @Test
            @TestMetadata(value="nativeInvoke.kt")
            public void testNativeInvoke() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam/nativeInvoke.kt");
            }

            @Test
            @TestMetadata(value="nativeSetter.kt")
            public void testNativeSetter() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/unusedParam/nativeSetter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/rtti")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Rtti {
            @Test
            public void testAllFilesPresentInRtti() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="castToNativeInterface.kt")
            public void testCastToNativeInterface() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti/castToNativeInterface.kt");
            }

            @Test
            @TestMetadata(value="checkForNativeInterface.kt")
            public void testCheckForNativeInterface() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti/checkForNativeInterface.kt");
            }

            @Test
            @TestMetadata(value="nativeInterfaceAsReifiedTypeArgument.kt")
            public void testNativeInterfaceAsReifiedTypeArgument() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti/nativeInterfaceAsReifiedTypeArgument.kt");
            }

            @Test
            @TestMetadata(value="nativeInterfaceClassLiteral.kt")
            public void testNativeInterfaceClassLiteral() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti/nativeInterfaceClassLiteral.kt");
            }

            @Test
            @TestMetadata(value="whenIsNativeInterface.kt")
            public void testWhenIsNativeInterface() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/rtti/whenIsNativeInterface.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OptionlBody {
            @Test
            public void testAllFilesPresentInOptionlBody() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="native.kt")
            public void testNative() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody/native.kt");
            }

            @Test
            @TestMetadata(value="nativeGetter.kt")
            public void testNativeGetter() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody/nativeGetter.kt");
            }

            @Test
            @TestMetadata(value="nativeInvoke.kt")
            public void testNativeInvoke() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody/nativeInvoke.kt");
            }

            @Test
            @TestMetadata(value="nativeSetter.kt")
            public void testNativeSetter() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/optionlBody/nativeSetter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NativeSetter {
            @Test
            public void testAllFilesPresentInNativeSetter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="onLocalExtensionFun.kt")
            public void testOnLocalExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onLocalExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onLocalNonNativeClassMembers.kt")
            public void testOnLocalNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onLocalNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onLocalOtherDeclarations.kt")
            public void testOnLocalOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onLocalOtherDeclarations.kt");
            }

            @Test
            @TestMetadata(value="onNativeClassMembers.kt")
            public void testOnNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNativeClass.kt")
            public void testOnNestedDeclarationsInsideNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onNestedDeclarationsInsideNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNonNativeClass.kt")
            public void testOnNestedDeclarationsInsideNonNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onNestedDeclarationsInsideNonNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNonNativeClassMembers.kt")
            public void testOnNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onToplevelExtensionFun.kt")
            public void testOnToplevelExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onToplevelExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onToplevelOtherDeclarations.kt")
            public void testOnToplevelOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeSetter/onToplevelOtherDeclarations.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NativeInvoke {
            @Test
            public void testAllFilesPresentInNativeInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="onLocalExtensionFun.kt")
            public void testOnLocalExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onLocalExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onLocalNonNativeClassMembers.kt")
            public void testOnLocalNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onLocalNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onLocalOtherDeclarations.kt")
            public void testOnLocalOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onLocalOtherDeclarations.kt");
            }

            @Test
            @TestMetadata(value="onNativeClassMembers.kt")
            public void testOnNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNativeClass.kt")
            public void testOnNestedDeclarationsInsideNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onNestedDeclarationsInsideNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNonNativeClass.kt")
            public void testOnNestedDeclarationsInsideNonNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onNestedDeclarationsInsideNonNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNonNativeClassMembers.kt")
            public void testOnNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onToplevelExtensionFun.kt")
            public void testOnToplevelExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onToplevelExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onToplevelOtherDeclarations.kt")
            public void testOnToplevelOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeInvoke/onToplevelOtherDeclarations.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NativeGetter {
            @Test
            public void testAllFilesPresentInNativeGetter() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
            }

            @Test
            @TestMetadata(value="onLocalExtensionFun.kt")
            public void testOnLocalExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onLocalExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onLocalNonNativeClassMembers.kt")
            public void testOnLocalNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onLocalNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onLocalOtherDeclarations.kt")
            public void testOnLocalOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onLocalOtherDeclarations.kt");
            }

            @Test
            @TestMetadata(value="onNativeClassMembers.kt")
            public void testOnNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNativeClass.kt")
            public void testOnNestedDeclarationsInsideNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onNestedDeclarationsInsideNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNestedDeclarationsInsideNonNativeClass.kt")
            public void testOnNestedDeclarationsInsideNonNativeClass() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onNestedDeclarationsInsideNonNativeClass.kt");
            }

            @Test
            @TestMetadata(value="onNonNativeClassMembers.kt")
            public void testOnNonNativeClassMembers() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onNonNativeClassMembers.kt");
            }

            @Test
            @TestMetadata(value="onToplevelExtensionFun.kt")
            public void testOnToplevelExtensionFun() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onToplevelExtensionFun.kt");
            }

            @Test
            @TestMetadata(value="onToplevelOtherDeclarations.kt")
            public void testOnToplevelOtherDeclarations() throws Exception {
                DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/native/nativeGetter/onToplevelOtherDeclarations.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/name")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Name {
        @Test
        public void testAllFilesPresentInName() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/name"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="bridgeClash.kt")
        public void testBridgeClash() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/bridgeClash.kt");
        }

        @Test
        @TestMetadata(value="builtinClash.kt")
        public void testBuiltinClash() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/builtinClash.kt");
        }

        @Test
        @TestMetadata(value="classAndFunction.kt")
        public void testClassAndFunction() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/classAndFunction.kt");
        }

        @Test
        @TestMetadata(value="classAndTypealias.kt")
        public void testClassAndTypealias() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/classAndTypealias.kt");
        }

        @Test
        @TestMetadata(value="classLevelMethodAndProperty.kt")
        public void testClassLevelMethodAndProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/classLevelMethodAndProperty.kt");
        }

        @Test
        @TestMetadata(value="conflictingNamesFromSuperclass.kt")
        public void testConflictingNamesFromSuperclass() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/conflictingNamesFromSuperclass.kt");
        }

        @Test
        @TestMetadata(value="declarationClash.kt")
        public void testDeclarationClash() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/declarationClash.kt");
        }

        @Test
        @TestMetadata(value="extensionPropertyAndMethod.kt")
        public void testExtensionPropertyAndMethod() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/extensionPropertyAndMethod.kt");
        }

        @Test
        @TestMetadata(value="illegalName.kt")
        public void testIllegalName() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/illegalName.kt");
        }

        @Test
        @TestMetadata(value="illegalPackageName.kt")
        public void testIllegalPackageName() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/illegalPackageName.kt");
        }

        @Test
        @TestMetadata(value="jsNameAndOverridden.kt")
        public void testJsNameAndOverridden() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameAndOverridden.kt");
        }

        @Test
        @TestMetadata(value="jsNameClash.kt")
        public void testJsNameClash() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameClash.kt");
        }

        @Test
        @TestMetadata(value="jsNameClashWithDefault.kt")
        public void testJsNameClashWithDefault() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameClashWithDefault.kt");
        }

        @Test
        @TestMetadata(value="jsNameMissingOnAccessors.kt")
        public void testJsNameMissingOnAccessors() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameMissingOnAccessors.kt");
        }

        @Test
        @TestMetadata(value="jsNameOnAccessors.kt")
        public void testJsNameOnAccessors() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameOnAccessors.kt");
        }

        @Test
        @TestMetadata(value="jsNameOnOverride.kt")
        public void testJsNameOnOverride() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameOnOverride.kt");
        }

        @Test
        @TestMetadata(value="jsNameOnPropertyAndAccessor.kt")
        public void testJsNameOnPropertyAndAccessor() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameOnPropertyAndAccessor.kt");
        }

        @Test
        @TestMetadata(value="jsNamePrihibitedOnPrimaryConstructor.kt")
        public void testJsNamePrihibitedOnPrimaryConstructor() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNamePrihibitedOnPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="jsNameProhibitedOnExtensionProperty.kt")
        public void testJsNameProhibitedOnExtensionProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameProhibitedOnExtensionProperty.kt");
        }

        @Test
        @TestMetadata(value="jsNameUseTargetOnProperty.kt")
        public void testJsNameUseTargetOnProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameUseTargetOnProperty.kt");
        }

        @Test
        @TestMetadata(value="jsNameWithoutParameter.kt")
        public void testJsNameWithoutParameter() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/jsNameWithoutParameter.kt");
        }

        @Test
        @TestMetadata(value="methodAndMethod.kt")
        public void testMethodAndMethod() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/methodAndMethod.kt");
        }

        @Test
        @TestMetadata(value="nameSwapInOverride.kt")
        public void testNameSwapInOverride() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/nameSwapInOverride.kt");
        }

        @Test
        @TestMetadata(value="overrideOverloadedNativeFunction.kt")
        public void testOverrideOverloadedNativeFunction() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/overrideOverloadedNativeFunction.kt");
        }

        @Test
        @TestMetadata(value="packageAndMethod.kt")
        public void testPackageAndMethod() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/packageAndMethod.kt");
        }

        @Test
        @TestMetadata(value="packageAndProperty.kt")
        public void testPackageAndProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/packageAndProperty.kt");
        }

        @Test
        @TestMetadata(value="privateJsNameClash.kt")
        public void testPrivateJsNameClash() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/privateJsNameClash.kt");
        }

        @Test
        @TestMetadata(value="propertyAndMethodInImplementor.kt")
        public void testPropertyAndMethodInImplementor() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/propertyAndMethodInImplementor.kt");
        }

        @Test
        @TestMetadata(value="propertyAndMethodInSubclass.kt")
        public void testPropertyAndMethodInSubclass() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/propertyAndMethodInSubclass.kt");
        }

        @Test
        @TestMetadata(value="topLevelMethodAndJsNameConstructor.kt")
        public void testTopLevelMethodAndJsNameConstructor() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/topLevelMethodAndJsNameConstructor.kt");
        }

        @Test
        @TestMetadata(value="topLevelMethodAndProperty.kt")
        public void testTopLevelMethodAndProperty() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/name/topLevelMethodAndProperty.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/module")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Module {
        @Test
        public void testAllFilesPresentInModule() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/module"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="dualModuleFromUmd.kt")
        public void testDualModuleFromUmd() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/dualModuleFromUmd.kt");
        }

        @Test
        @TestMetadata(value="incompleteReifiedArg.kt")
        public void testIncompleteReifiedArg() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/incompleteReifiedArg.kt");
        }

        @Test
        @TestMetadata(value="jsModuleNonExternal.kt")
        public void testJsModuleNonExternal() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/jsModuleNonExternal.kt");
        }

        @Test
        @TestMetadata(value="jsModuleWithoutParameters.kt")
        public void testJsModuleWithoutParameters() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/jsModuleWithoutParameters.kt");
        }

        @Test
        @TestMetadata(value="jsVarProhibited.kt")
        public void testJsVarProhibited() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/jsVarProhibited.kt");
        }

        @Test
        @TestMetadata(value="nestedProhibited.kt")
        public void testNestedProhibited() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/nestedProhibited.kt");
        }

        @Test
        @TestMetadata(value="prohibitedOnNonNative.kt")
        public void testProhibitedOnNonNative() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/prohibitedOnNonNative.kt");
        }

        @Test
        @TestMetadata(value="wrongCallToModule.kt")
        public void testWrongCallToModule() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/wrongCallToModule.kt");
        }

        @Test
        @TestMetadata(value="wrongCallToNonModule.kt")
        public void testWrongCallToNonModule() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/module/wrongCallToNonModule.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/jvmDeclarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class JvmDeclarations {
        @Test
        public void testAllFilesPresentInJvmDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/jvmDeclarations"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jvmDeclarations/cloneable.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/jsCode")
    @TestDataPath(value="$PROJECT_ROOT")
    public class JsCode {
        @Test
        public void testAllFilesPresentInJsCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/jsCode"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="argumentIsLiteral.kt")
        public void testArgumentIsLiteral() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/argumentIsLiteral.kt");
        }

        @Test
        @TestMetadata(value="badAssignment.kt")
        public void testBadAssignment() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/badAssignment.kt");
        }

        @Test
        @TestMetadata(value="deleteOperation.kt")
        public void testDeleteOperation() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/deleteOperation.kt");
        }

        @Test
        @TestMetadata(value="error.kt")
        public void testError() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/error.kt");
        }

        @Test
        @TestMetadata(value="noJavaScriptProduced.kt")
        public void testNoJavaScriptProduced() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/noJavaScriptProduced.kt");
        }

        @Test
        @TestMetadata(value="warning.kt")
        public void testWarning() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/jsCode/warning.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/inline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/inline"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="Reified.kt")
        public void testReified() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/inline/Reified.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/export")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Export {
        @Test
        public void testAllFilesPresentInExport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/export"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="extendingNonExportedType.kt")
        public void testExtendingNonExportedType() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/extendingNonExportedType.kt");
        }

        @Test
        @TestMetadata(value="jsExportOnNestedDeclarations.kt")
        public void testJsExportOnNestedDeclarations() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/jsExportOnNestedDeclarations.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorWithoutJsName.kt")
        public void testSecondaryConstructorWithoutJsName() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/secondaryConstructorWithoutJsName.kt");
        }

        @Test
        @TestMetadata(value="unexportableTypesInSignature.kt")
        public void testUnexportableTypesInSignature() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/unexportableTypesInSignature.kt");
        }

        @Test
        @TestMetadata(value="unexportableTypesInTypeParameters.kt")
        public void testUnexportableTypesInTypeParameters() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/unexportableTypesInTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="wrongExportedDeclaration.kt")
        public void testWrongExportedDeclaration() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/wrongExportedDeclaration.kt");
        }

        @Test
        @TestMetadata(value="wrongExportedDeclarationInExportedFile.kt")
        public void testWrongExportedDeclarationInExportedFile() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/export/wrongExportedDeclarationInExportedFile.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DynamicTypes {
        @Test
        public void testAllFilesPresentInDynamicTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="allowedDynamicFunctionType.kt")
        public void testAllowedDynamicFunctionType() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/allowedDynamicFunctionType.kt");
        }

        @Test
        @TestMetadata(value="assignment.kt")
        public void testAssignment() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/assignment.kt");
        }

        @Test
        @TestMetadata(value="block.kt")
        public void testBlock() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/block.kt");
        }

        @Test
        @TestMetadata(value="callableReferences.kt")
        public void testCallableReferences() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/callableReferences.kt");
        }

        @Test
        @TestMetadata(value="capturedDynamic.kt")
        public void testCapturedDynamic() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/capturedDynamic.kt");
        }

        @Test
        @TestMetadata(value="capturedDynamicNI.kt")
        public void testCapturedDynamicNI() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/capturedDynamicNI.kt");
        }

        @Test
        @TestMetadata(value="classDelegateBy.kt")
        public void testClassDelegateBy() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/classDelegateBy.kt");
        }

        @Test
        @TestMetadata(value="comparisonToNull.kt")
        public void testComparisonToNull() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/comparisonToNull.kt");
        }

        @Test
        @TestMetadata(value="conditions.kt")
        public void testConditions() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/conditions.kt");
        }

        @Test
        @TestMetadata(value="conventions.kt")
        public void testConventions() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/conventions.kt");
        }

        @Test
        @TestMetadata(value="destructuring.kt")
        public void testDestructuring() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/destructuring.kt");
        }

        @Test
        @TestMetadata(value="dynamicCalls.kt")
        public void testDynamicCalls() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicCalls.kt");
        }

        @Test
        @TestMetadata(value="dynamicCallsWithLambdas.kt")
        public void testDynamicCallsWithLambdas() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicCallsWithLambdas.kt");
        }

        @Test
        @TestMetadata(value="dynamicCastTarget.kt")
        public void testDynamicCastTarget() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicCastTarget.kt");
        }

        @Test
        @TestMetadata(value="dynamicExtension.kt")
        public void testDynamicExtension() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicExtension.kt");
        }

        @Test
        @TestMetadata(value="dynamicSafeCalls.kt")
        public void testDynamicSafeCalls() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicSafeCalls.kt");
        }

        @Test
        @TestMetadata(value="dynamicVsGeneric.kt")
        public void testDynamicVsGeneric() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/dynamicVsGeneric.kt");
        }

        @Test
        @TestMetadata(value="extensionVals.kt")
        public void testExtensionVals() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/extensionVals.kt");
        }

        @Test
        @TestMetadata(value="extensionVars.kt")
        public void testExtensionVars() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/extensionVars.kt");
        }

        @Test
        @TestMetadata(value="extensions.kt")
        public void testExtensions() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/extensions.kt");
        }

        @Test
        @TestMetadata(value="extensionsToDynamic.kt")
        public void testExtensionsToDynamic() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/extensionsToDynamic.kt");
        }

        @Test
        @TestMetadata(value="implicitDynamicReceiver.kt")
        public void testImplicitDynamicReceiver() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/implicitDynamicReceiver.kt");
        }

        @Test
        @TestMetadata(value="inExpression.kt")
        public void testInExpression() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/inExpression.kt");
        }

        @Test
        @TestMetadata(value="indexedAccess.kt")
        public void testIndexedAccess() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/indexedAccess.kt");
        }

        @Test
        @TestMetadata(value="inference.kt")
        public void testInference() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/inference.kt");
        }

        @Test
        @TestMetadata(value="membersOfAny.kt")
        public void testMembersOfAny() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/membersOfAny.kt");
        }

        @Test
        @TestMetadata(value="namedArguments.kt")
        public void testNamedArguments() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/namedArguments.kt");
        }

        @Test
        @TestMetadata(value="noUnsupportedInLocals.kt")
        public void testNoUnsupportedInLocals() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/noUnsupportedInLocals.kt");
        }

        @Test
        @TestMetadata(value="nullable.kt")
        public void testNullable() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/nullable.kt");
        }

        @Test
        @TestMetadata(value="overloading.kt")
        public void testOverloading() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/overloading.kt");
        }

        @Test
        @TestMetadata(value="overloadingAmbiguity.kt")
        public void testOverloadingAmbiguity() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/overloadingAmbiguity.kt");
        }

        @Test
        @TestMetadata(value="overrides.kt")
        public void testOverrides() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/overrides.kt");
        }

        @Test
        @TestMetadata(value="propertyDelegateBy.kt")
        public void testPropertyDelegateBy() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/propertyDelegateBy.kt");
        }

        @Test
        @TestMetadata(value="protected.kt")
        public void testProtected() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/protected.kt");
        }

        @Test
        @TestMetadata(value="rangeExpression.kt")
        public void testRangeExpression() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/rangeExpression.kt");
        }

        @Test
        @TestMetadata(value="reified.kt")
        public void testReified() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/reified.kt");
        }

        @Test
        @TestMetadata(value="smartCast.kt")
        public void testSmartCast() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/smartCast.kt");
        }

        @Test
        @TestMetadata(value="spreadOperator.kt")
        public void testSpreadOperator() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/spreadOperator.kt");
        }

        @Test
        @TestMetadata(value="staticCallsInDynamicContext.kt")
        public void testStaticCallsInDynamicContext() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/staticCallsInDynamicContext.kt");
        }

        @Test
        @TestMetadata(value="staticExtensions.kt")
        public void testStaticExtensions() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/staticExtensions.kt");
        }

        @Test
        @TestMetadata(value="substitution.kt")
        public void testSubstitution() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/substitution.kt");
        }

        @Test
        @TestMetadata(value="supertypesAndBounds.kt")
        public void testSupertypesAndBounds() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/supertypesAndBounds.kt");
        }

        @Test
        @TestMetadata(value="typealiasExpandingToDynamic.kt")
        public void testTypealiasExpandingToDynamic() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/typealiasExpandingToDynamic.kt");
        }

        @Test
        @TestMetadata(value="typealiasWithAnnotatedDynamic.kt")
        public void testTypealiasWithAnnotatedDynamic() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/typealiasWithAnnotatedDynamic.kt");
        }

        @Test
        @TestMetadata(value="typealiasWithDynamic.kt")
        public void testTypealiasWithDynamic() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/typealiasWithDynamic.kt");
        }

        @Test
        @TestMetadata(value="varargs.kt")
        public void testVarargs() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/dynamicTypes/varargs.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJsStdLib/classLiteral")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ClassLiteral {
        @Test
        public void testAllFilesPresentInClassLiteral() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJsStdLib/classLiteral"), Pattern.compile("^(.+)\\.kt$"), null, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrays_after.kt")
        public void testArrays_after() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/classLiteral/arrays_after.kt");
        }

        @Test
        @TestMetadata(value="arrays_before.kt")
        public void testArrays_before() throws Exception {
            DiagnosticsTestWithJsStdLibGenerated.this.runTest("compiler/testData/diagnostics/testsWithJsStdLib/classLiteral/arrays_before.kt");
        }
    }
}

