/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ModulePath;
import org.jetbrains.kotlin.resolve.ModuleStructureOracle;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 G2\u00020\u0001:\u0002FGB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J@\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001fH\u0002J@\u0010 \u001a\u00020\r2\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J(\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020)H\u0002JP\u0010*\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001fH\u0002J@\u0010.\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010/\u001a\u0002002\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001fH\u0002J0\u00101\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-H\u0002J&\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u0001032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\"\u0010;\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J,\u0010?\u001a\u00020\u0019*\u00020\u00172\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"H\u0002J\f\u0010@\u001a\u00020\u0019*\u00020\u0017H\u0002J\u0012\u0010A\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170#H\u0002J\f\u0010B\u001a\u00020\u0019*\u00020\u0017H\u0002J\"\u0010C\u001a\u00020\r*\u00020-2\u0006\u0010&\u001a\u00020\u00172\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00170EH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "moduleStructureOracle", "Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "argumentExtractors", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "(Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;Ljava/lang/Iterable;)V", "getArgumentExtractors", "()Ljava/lang/Iterable;", "getModuleStructureOracle", "()Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkActualDeclarationHasExpected", "reportOn", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkActualModifier", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleVisibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/multiplatform/ModuleFilter;", "checkAmbiguousExpects", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "checkAnnotationConstructors", "expected", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "actual", "Lcom/intellij/psi/PsiElement;", "checkExpectedDeclarationHasAtLeastOneActual", "module", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkExpectedDeclarationHasAtMostOneActual", "path", "Lorg/jetbrains/kotlin/resolve/ModulePath;", "checkExpectedDeclarationHasProperActuals", "getActualAnnotationParameterValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "actualParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnderlyingPropertyOfInlineClass", "reportMissingActualModifier", "requireActualModifier", "sourceFile", "Ljava/io/File;", "hasNoActualWithDiagnostic", "isActualOrSomeContainerIsActual", "isCompatibleOrWeakCompatible", "isExplicitActualDeclaration", "reportExpectActual", "actualMembers", "Lkotlin/sequences/Sequence;", "ActualAnnotationArgumentExtractor", "Companion", "frontend"})
public final class ExpectedActualDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleStructureOracle moduleStructureOracle;
    @NotNull
    private final Iterable<ActualAnnotationArgumentExtractor> argumentExtractors;

    public ExpectedActualDeclarationChecker(@NotNull ModuleStructureOracle moduleStructureOracle, @NotNull Iterable<? extends ActualAnnotationArgumentExtractor> argumentExtractors) {
        Intrinsics.checkNotNullParameter((Object)moduleStructureOracle, (String)"moduleStructureOracle");
        Intrinsics.checkNotNullParameter(argumentExtractors, (String)"argumentExtractors");
        this.moduleStructureOracle = moduleStructureOracle;
        this.argumentExtractors = argumentExtractors;
    }

    @NotNull
    public final ModuleStructureOracle getModuleStructureOracle() {
        return this.moduleStructureOracle;
    }

    @NotNull
    public final Iterable<ActualAnnotationArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean checkActualModifier;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExpectActualLinker()).booleanValue()) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (!(declaration2 instanceof KtNamedDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || DescriptorUtils.isEnumEntry(descriptor2)) {
            return;
        }
        boolean bl = checkActualModifier = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getMultiPlatformDoNotCheckActual()) == false;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            this.checkExpectedDeclarationHasProperActuals((KtNamedDeclaration)declaration2, (MemberDescriptor)descriptor2, context2.getTrace(), checkActualModifier, context2.getExpectActualTracker());
        } else if (this.isActualOrSomeContainerIsActual((MemberDescriptor)descriptor2)) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.moduleStructureOracle.findAllDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it = (ModulePath)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getNodes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            HashSet allImplementedModules = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            this.checkActualDeclarationHasExpected((KtNamedDeclaration)declaration2, (MemberDescriptor)descriptor2, checkActualModifier, context2.getTrace(), (Function1<? super ModuleDescriptor, Boolean>)((Function1)new Function1<ModuleDescriptor, Boolean>((HashSet<ModuleDescriptor>)allImplementedModules){
                final /* synthetic */ HashSet<ModuleDescriptor> $allImplementedModules;
                {
                    this.$allImplementedModules = $allImplementedModules;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allImplementedModules.contains(it);
                }
            }));
        }
    }

    private final boolean isActualOrSomeContainerIsActual(MemberDescriptor $this$isActualOrSomeContainerIsActual) {
        MemberDescriptor declaration2 = $this$isActualOrSomeContainerIsActual;
        while (!declaration2.isActual()) {
            MemberDescriptor memberDescriptor;
            DeclarationDescriptor declarationDescriptor = declaration2.getContainingDeclaration();
            MemberDescriptor memberDescriptor2 = memberDescriptor = declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null;
            if (memberDescriptor == null) {
                return false;
            }
            declaration2 = memberDescriptor;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasProperActuals(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, boolean checkActualModifier, ExpectActualTracker expectActualTracker) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        List<ModulePath> allActualizationPaths = this.moduleStructureOracle.findAllReversedDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
        Object $this$groupBy$iv = allActualizationPaths;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ModulePath it = (ModulePath)element$iv$iv;
            boolean bl = false;
            key$iv$iv = (ModuleDescriptor)CollectionsKt.last(it.getNodes());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues2 = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$flatMap$iv = (Iterable)it.getValue();
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it2 = (ModulePath)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv = it2.getNodes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            map2.put(k2, set);
        }
        Map leafModuleToVisibleModules = destination$iv$iv;
        for (Map.Entry $i$f$mapValues2 : leafModuleToVisibleModules.entrySet()) {
            ModuleDescriptor leafModule = (ModuleDescriptor)$i$f$mapValues2.getKey();
            Set modulesVisibleFromLeaf = (Set)$i$f$mapValues2.getValue();
            this.checkExpectedDeclarationHasAtLeastOneActual(reportOn, descriptor2, trace, leafModule, checkActualModifier, expectActualTracker, (Function1<? super ModuleDescriptor, Boolean>)((Function1)new Function1<ModuleDescriptor, Boolean>((Set<? extends ModuleDescriptor>)modulesVisibleFromLeaf){
                final /* synthetic */ Set<ModuleDescriptor> $modulesVisibleFromLeaf;
                {
                    this.$modulesVisibleFromLeaf = $modulesVisibleFromLeaf;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$modulesVisibleFromLeaf.contains(it);
                }
            }));
        }
        for (ModulePath path2 : allActualizationPaths) {
            Set modulesOnThisPath = CollectionsKt.toSet((Iterable)path2.getNodes());
            this.checkExpectedDeclarationHasAtMostOneActual(reportOn, descriptor2, trace, path2, (Function1<? super ModuleDescriptor, Boolean>)((Function1)new Function1<ModuleDescriptor, Boolean>((Set<? extends ModuleDescriptor>)modulesOnThisPath){
                final /* synthetic */ Set<ModuleDescriptor> $modulesOnThisPath;
                {
                    this.$modulesOnThisPath = $modulesOnThisPath;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$modulesOnThisPath.contains(it);
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasAtMostOneActual(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, ModulePath path2, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Iterable $this$filterKeys$iv;
        void $this$fold$iv;
        Iterable $this$ifEmpty$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection $this$mapNotNull$iv;
        Iterable iterable = path2.getNodes();
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void var12_15 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        for (Object element$iv$iv$iv : var12_15) {
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map;
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            ModuleDescriptor it = (ModuleDescriptor)element$iv$iv;
            boolean bl2 = false;
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map2 = ExpectedActualResolver.INSTANCE.findActualForExpected(descriptor2, it, moduleVisibilityFilter);
            if (map2 == null) continue;
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> it$iv$iv = map = map2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            return;
        }
        $this$ifEmpty$iv = $this$ifEmpty$iv;
        Map initial$iv = new LinkedHashMap();
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object t : $this$fold$iv) {
            void partialMap;
            Map $i$f$forEach22 = (Map)t;
            LinkedHashMap resultMap = accumulator$iv;
            boolean bl2 = false;
            Object $this$checkExpectedDeclarationHasAtMostOneActual_u24lambda_u2d7_u24lambda_u2d6 = element$iv$iv = resultMap;
            boolean bl4 = false;
            ((HashMap)$this$checkExpectedDeclarationHasAtMostOneActual_u24lambda_u2d7_u24lambda_u2d6).putAll(partialMap);
            accumulator$iv = element$iv$iv;
        }
        LinkedHashMap compatibility = accumulator$iv;
        initial$iv = compatibility;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            ExpectActualCompatibility it = (ExpectActualCompatibility)entry.getKey();
            boolean bl = false;
            if (!this.isCompatibleOrWeakCompatible(it)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        List atLeastWeaklyCompatibleActuals = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)((Map)result$iv).values()));
        if (atLeastWeaklyCompatibleActuals.size() > 1) {
            void $this$sortedBy$iv;
            Collection<ModuleDescriptor> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            $this$filterKeys$iv = atLeastWeaklyCompatibleActuals;
            MemberDescriptor memberDescriptor = descriptor2;
            PsiElement psiElement = reportOn;
            DiagnosticFactory2<KtNamedDeclaration, DeclarationDescriptor, Collection<ModuleDescriptor>> diagnosticFactory2 = Errors.AMBIGUOUS_ACTUALS;
            BindingTrace bindingTrace = trace;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MemberDescriptor bl2 = (MemberDescriptor)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)it);
                collection.add(moduleDescriptor);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = collection;
            boolean $i$f$sortedBy = false;
            bindingTrace.report(diagnosticFactory2.on((KtNamedDeclaration)psiElement, memberDescriptor, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ModuleDescriptor it = (ModuleDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName().asString());
                    it = (ModuleDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string2 = it.getName().asString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            })));
        }
    }

    private final void checkExpectedDeclarationHasAtLeastOneActual(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, ModuleDescriptor module2, boolean checkActualModifier, ExpectActualTracker expectActualTracker, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Object object;
        if (!(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return;
        }
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findActualForExpected(descriptor2, module2, moduleVisibilityFilter);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> compatibility = map;
        if (Companion.allStrongIncompatibilities(compatibility) && OptionalAnnotationUtil.isOptionalAnnotationClass(descriptor2)) {
            return;
        }
        if (Companion.allStrongIncompatibilities(compatibility) || !(object = compatibility).containsKey(ExpectActualCompatibility.Compatible.INSTANCE) && this.hasNoActualWithDiagnostic(descriptor2, compatibility)) {
            boolean $this$all$iv2;
            block10: {
                boolean bl;
                Iterable $this$all$iv2 = compatibility.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible) continue;
                        bl = false;
                        break block10;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> incompatibility = compatibility;
            trace.report(Errors.NO_ACTUAL_FOR_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, module2, incompatibility));
            return;
        }
        Sequence actualMembers2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)((Function1)new Function1<Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>>, Boolean>(this){
            final /* synthetic */ ExpectedActualDeclarationChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ExpectedActualDeclarationChecker.access$isCompatibleOrWeakCompatible(this.this$0, it.getKey());
            }
        })), (Function1)checkExpectedDeclarationHasAtLeastOneActual.actualMembers.2.INSTANCE);
        if (checkActualModifier) {
            Sequence $this$forEach$iv = actualMembers2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MemberDescriptor it = (MemberDescriptor)element$iv;
                boolean bl = false;
                this.reportMissingActualModifier(it, null, trace);
            }
        }
        this.reportExpectActual(expectActualTracker, descriptor2, (Sequence<? extends MemberDescriptor>)actualMembers2);
    }

    private final void reportMissingActualModifier(MemberDescriptor actual, KtNamedDeclaration reportOn, BindingTrace trace) {
        KtNamedDeclaration reportOn2;
        KtNamedDeclaration ktNamedDeclaration;
        if (actual.isActual()) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration2 = reportOn;
        if (ktNamedDeclaration2 == null) {
            KtNamedDeclaration ktNamedDeclaration3;
            KotlinSourceElement kotlinSourceElement;
            SourceElement $this$safeAs$iv = actual.getSource();
            boolean $i$f$safeAs = false;
            SourceElement sourceElement = $this$safeAs$iv;
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KtElement $this$safeAs$iv2 = (kotlinSourceElement = (KotlinSourceElement)sourceElement) == null ? null : kotlinSourceElement.getPsi();
            boolean $i$f$safeAs2 = false;
            KtElement ktElement = $this$safeAs$iv2;
            if (!(ktElement instanceof KtNamedDeclaration)) {
                ktElement = null;
            }
            if ((ktNamedDeclaration3 = (KtNamedDeclaration)ktElement) == null) {
                return;
            }
            ktNamedDeclaration = ktNamedDeclaration3;
        } else {
            ktNamedDeclaration = reportOn2 = ktNamedDeclaration2;
        }
        if (this.requireActualModifier(actual)) {
            trace.report(Errors.ACTUAL_MISSING.on((KtNamedDeclaration)((PsiElement)reportOn2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoActualWithDiagnostic(MemberDescriptor $this$hasNoActualWithDiagnostic, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility) {
        boolean bl;
        block4: {
            void destination$iv;
            void $this$flatMapTo$iv;
            Iterable iterable = compatibility.values();
            Collection collection = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                List it = (List)element$iv;
                boolean bl2 = false;
                Iterable list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Iterable $this$all$iv = (Iterable)destination$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MemberDescriptor actual = (MemberDescriptor)element$iv;
                    boolean bl3 = false;
                    Map expectedOnes = ExpectedActualResolver.findExpectedForActual$default(ExpectedActualResolver.INSTANCE, actual, DescriptorUtilsKt.getModule($this$hasNoActualWithDiagnostic), null, 4, null);
                    if (expectedOnes != null && expectedOnes.keySet().contains(ExpectActualCompatibility.Compatible.INSTANCE)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void reportExpectActual(ExpectActualTracker $this$reportExpectActual, MemberDescriptor expected, Sequence<? extends MemberDescriptor> actualMembers2) {
        if ($this$reportExpectActual instanceof ExpectActualTracker.DoNothing) {
            return;
        }
        File file2 = this.sourceFile(expected);
        if (file2 == null) {
            return;
        }
        File expectedFile = file2;
        for (MemberDescriptor actual : actualMembers2) {
            File file3 = this.sourceFile(actual);
            if (file3 == null) continue;
            File actualFile = file3;
            $this$reportExpectActual.report(expectedFile, actualFile);
        }
    }

    private final File sourceFile(MemberDescriptor descriptor2) {
        File file2;
        PsiSourceFile psiSourceFile;
        SourceFile $this$safeAs$iv = descriptor2.getSource().getContainingFile();
        boolean $i$f$safeAs = false;
        SourceFile sourceFile = $this$safeAs$iv;
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((psiSourceFile = (PsiSourceFile)sourceFile) == null) {
            file2 = null;
        } else {
            PsiSourceFile psiSourceFile2;
            PsiSourceFile $this$sourceFile_u24lambda_u2d15 = psiSourceFile2 = psiSourceFile;
            boolean bl = false;
            file2 = VfsUtilCore.virtualToIoFile((VirtualFile)$this$sourceFile_u24lambda_u2d15.getPsiFile().getVirtualFile());
        }
        return file2;
    }

    private final void checkActualDeclarationHasExpected(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, boolean checkActualModifier, BindingTrace trace, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Object it;
        boolean $i$f$any;
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findExpectedForActual(descriptor2, DescriptorUtilsKt.getModule(descriptor2), moduleVisibilityFilter);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> compatibility = map;
        this.checkAmbiguousExpects(compatibility, trace, reportOn, descriptor2);
        if (checkActualModifier && !(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            boolean bl;
            block26: {
                Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> $this$any$iv = compatibility;
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    for (Map.Entry<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> element$iv : $this$any$iv.entrySet()) {
                        it = element$iv;
                        boolean bl2 = false;
                        if (!this.isCompatibleOrWeakCompatible(it.getKey())) continue;
                        bl = true;
                        break block26;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.reportMissingActualModifier(descriptor2, reportOn, trace);
            }
        }
        if (!PsiUtilsKt.hasActualModifier(reportOn) && Companion.allStrongIncompatibilities(compatibility)) {
            return;
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.firstOrNull((Iterable)compatibility.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            ClassifierDescriptor $this$filterNotTo$iv$iv;
            boolean bl = $i$f$any = descriptor2 instanceof ClassDescriptor || descriptor2 instanceof TypeAliasDescriptor;
            if (_Assertions.ENABLED && !$i$f$any) {
                boolean $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = false;
                String $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = Intrinsics.stringPlus((String)"Incompatible.ClassScopes is only possible for a class or a typealias: ", (Object)descriptor2);
                throw new AssertionError((Object)$i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32);
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot2 = false;
            it = $this$filterNot$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo2 = false;
            Object object = $this$filterNotTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                Pair p0 = (Pair)element$iv$iv;
                boolean bl3 = false;
                if (ExpectedActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(this, (Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>>)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                ClassifierDescriptor classifierDescriptor;
                Object object2 = destination$iv$iv = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                if (destination$iv$iv == null) {
                    classifierDescriptor = null;
                } else {
                    SimpleType $i$f$filterNotTo2 = destination$iv$iv.getExpandedType();
                    object = $i$f$filterNotTo2.getConstructor();
                    classifierDescriptor = object.getDeclarationDescriptor();
                }
                $this$filterNotTo$iv$iv = classifierDescriptor;
                ClassDescriptor $i$f$filterNot2 = $this$filterNotTo$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)$this$filterNotTo$iv$iv : null;
                ClassDescriptor classDescriptor = $i$f$filterNot2 == null ? (ClassDescriptor)descriptor2 : $i$f$filterNot2;
                trace.report(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS.on((KtNamedDeclaration)((PsiElement)reportOn), classDescriptor, nonTrivialUnfulfilled));
            }
        } else {
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> $i$f$filterNot2 = compatibility;
            if (!$i$f$filterNot2.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
                boolean $this$all$iv2;
                block27: {
                    boolean bl;
                    Iterable $this$all$iv2 = compatibility.keySet();
                    boolean $i$f$all = false;
                    if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv2) {
                            ExpectActualCompatibility it2 = (ExpectActualCompatibility)element$iv;
                            boolean bl4 = false;
                            if (it2 instanceof ExpectActualCompatibility.Incompatible) continue;
                            bl = false;
                            break block27;
                        }
                        bl = $this$all$iv2 = true;
                    }
                }
                if (_Assertions.ENABLED && !$this$all$iv2) {
                    String $i$f$all = "Assertion failed";
                    throw new AssertionError((Object)$i$f$all);
                }
                Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> incompatibility = compatibility;
                trace.report(Errors.ACTUAL_WITHOUT_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, incompatibility));
            } else {
                List<MemberDescriptor> list2 = compatibility.get(ExpectActualCompatibility.Compatible.INSTANCE);
                Intrinsics.checkNotNull(list2);
                MemberDescriptor expected = (MemberDescriptor)CollectionsKt.first(list2);
                if (expected instanceof ClassDescriptor && ((ClassDescriptor)expected).getKind() == ClassKind.ANNOTATION_CLASS) {
                    Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map2;
                    Object object;
                    Object object3;
                    Object object4 = object3 = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                    if (object3 == null) {
                        object = null;
                    } else {
                        Collection<ClassConstructorDescriptor> collection = object3.getConstructors();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"constructors");
                        object = $i$f$filterNot2 = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
                    }
                    if ($i$f$filterNot2 == null) {
                        Collection<TypeAliasConstructorDescriptor> collection;
                        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor;
                        Object object5 = object3 = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                        map2 = object3 == null ? null : ((typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)(collection = object3.getConstructors()))) == null ? null : typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor());
                    } else {
                        map2 = $i$f$filterNot2;
                    }
                    Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> actualConstructor = map2;
                    object3 = ((ClassDescriptor)expected).getConstructors();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"expected.constructors");
                    ClassConstructorDescriptor expectedConstructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object3));
                    if (expectedConstructor != null && actualConstructor != null) {
                        this.checkAnnotationConstructors(expectedConstructor, (ConstructorDescriptor)((Object)actualConstructor), trace, reportOn);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility, BindingTrace trace, KtNamedDeclaration reportOn, MemberDescriptor descriptor2) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)((Function1)new Function1<Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>>, Boolean>(this){
            final /* synthetic */ ExpectedActualDeclarationChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>> $dstr$compatibility$_u24__u24) {
                Intrinsics.checkNotNullParameter($dstr$compatibility$_u24__u24, (String)"$dstr$compatibility$_u24__u24");
                ExpectActualCompatibility<? extends MemberDescriptor> compatibility = $dstr$compatibility$_u24__u24.getKey();
                return ExpectedActualDeclarationChecker.access$isCompatibleOrWeakCompatible(this.this$0, compatibility);
            }
        })), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleDescriptor it = (ModuleDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (ModuleDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string2 = it.getName().asString();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            trace.report(Errors.AMBIGUOUS_EXPECTS.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, filesWithAtLeastWeaklyCompatibleExpects2));
        }
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectActualCompatibility<? extends MemberDescriptor> $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(MemberDescriptor descriptor2) {
        return !DescriptorUtilsKt.isAnnotationConstructor(descriptor2) && !DescriptorUtilsKt.isPrimaryConstructorOfInlineClass(descriptor2) && !this.isUnderlyingPropertyOfInlineClass(descriptor2);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(MemberDescriptor descriptor2) {
        return descriptor2 instanceof PropertyDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass((VariableDescriptor)((Object)descriptor2));
    }

    private final boolean isExplicitActualDeclaration(MemberDescriptor $this$isExplicitActualDeclaration) {
        MemberDescriptor memberDescriptor = $this$isExplicitActualDeclaration;
        return memberDescriptor instanceof ConstructorDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor($this$isExplicitActualDeclaration) instanceof KtConstructor : (memberDescriptor instanceof CallableMemberDescriptor ? ((CallableMemberDescriptor)$this$isExplicitActualDeclaration).getKind() == CallableMemberDescriptor.Kind.DECLARATION : true);
    }

    private final void checkAnnotationConstructors(ConstructorDescriptor expected, ConstructorDescriptor actual, BindingTrace trace, PsiElement reportOn) {
        for (ValueParameterDescriptor expectedParameterDescriptor : expected.getValueParameters()) {
            PsiElement psiElement;
            KtExpression ktExpression;
            ConstantValue constantValue;
            KtParameter $i$f$first2;
            Object element$iv2;
            block6: {
                List<ValueParameterDescriptor> list2 = actual.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"actual.valueParameters");
                Iterable $this$first$iv = list2;
                boolean $i$f$first2 = false;
                for (Object element$iv2 : $this$first$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expectedParameterDescriptor.getName())) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ValueParameterDescriptor actualParameterDescriptor = (ValueParameterDescriptor)element$iv2;
            if (!expectedParameterDescriptor.declaresDefaultValue() || !actualParameterDescriptor.declaresDefaultValue()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)expectedParameterDescriptor, (String)"expectedParameterDescriptor");
            Object object = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameterDescriptor);
            KtParameter ktParameter = $i$f$first2 = object instanceof KtParameter ? (KtParameter)object : null;
            if ($i$f$first2 == null) continue;
            KtParameter expectedParameter = $i$f$first2;
            object = (CompileTimeConstant)trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, expectedParameter.getDefaultValue());
            if (object == null) {
                constantValue = null;
            } else {
                element$iv2 = expectedParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(element$iv2, (String)"expectedParameterDescriptor.type");
                constantValue = object.toConstantValue((KotlinType)element$iv2);
            }
            ConstantValue expectedValue = constantValue;
            Intrinsics.checkNotNullExpressionValue((Object)actualParameterDescriptor, (String)"actualParameterDescriptor");
            element$iv2 = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(element$iv2, (String)"trace.bindingContext");
            Object object2 = element$iv2;
            element$iv2 = expectedParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(element$iv2, (String)"expectedParameterDescriptor.type");
            ConstantValue<?> actualValue = this.getActualAnnotationParameterValue(actualParameterDescriptor, (BindingContext)object2, (KotlinType)element$iv2);
            if (Intrinsics.areEqual(expectedValue, actualValue)) continue;
            PsiElement ktParameter2 = DescriptorToSourceUtils.descriptorToDeclaration(actualParameterDescriptor);
            KtNamedDeclarationStub ktNamedDeclarationStub = ktParameter2 instanceof KtParameter ? (KtParameter)ktParameter2 : null;
            KtExpression ktExpression2 = ktExpression = ktNamedDeclarationStub == null ? null : ((KtParameter)ktNamedDeclarationStub).getDefaultValue();
            if (ktExpression == null) {
                PsiElement psiElement2;
                KtNamedDeclarationStub ktNamedDeclarationStub2 = ktNamedDeclarationStub = reportOn instanceof KtTypeAlias ? (KtTypeAlias)reportOn : null;
                psiElement = ktNamedDeclarationStub == null ? reportOn : ((psiElement2 = ((KtTypeParameterListOwnerStub)ktNamedDeclarationStub).getNameIdentifier()) == null ? reportOn : psiElement2);
            } else {
                psiElement = (PsiElement)ktExpression;
            }
            PsiElement psiElement3 = psiElement;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"(ktParameter as? KtParam\u2026ameIdentifier ?: reportOn");
            PsiElement target = psiElement3;
            trace.report(Errors.ACTUAL_ANNOTATION_CONFLICTING_DEFAULT_ARGUMENT_VALUE.on(target, actualParameterDescriptor));
        }
    }

    private final ConstantValue<?> getActualAnnotationParameterValue(ValueParameterDescriptor actualParameter, BindingContext bindingContext, KotlinType expectedType2) {
        PsiElement declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(actualParameter);
        if (declaration2 instanceof KtParameter) {
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, ((KtParameter)declaration2).getDefaultValue());
            return compileTimeConstant == null ? null : compileTimeConstant.toConstantValue(expectedType2);
        }
        for (ActualAnnotationArgumentExtractor extractor : this.argumentExtractors) {
            ConstantValue<?> constantValue;
            ConstantValue<?> constantValue2 = extractor.extractDefaultValue(actualParameter, expectedType2);
            if (constantValue2 == null) continue;
            ConstantValue<?> it = constantValue = constantValue2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(ExpectedActualDeclarationChecker this$0, Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>> expectedWithIncompatibility) {
        Collection collection;
        List list2;
        MemberDescriptor actualMember;
        Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>> pair = expectedWithIncompatibility;
        MemberDescriptor expectedMember = (MemberDescriptor)pair.component1();
        Map incompatibility = (Map)pair.component2();
        Object object = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        MemberDescriptor memberDescriptor = actualMember = object == null ? null : (MemberDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object));
        return actualMember != null && this$0.isExplicitActualDeclaration(actualMember) && !Companion.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((object = ExpectedActualResolver.findExpectedForActual$default(ExpectedActualResolver.INSTANCE, actualMember, DescriptorUtilsKt.getModule(expectedMember), null, 4, null)) == null ? null : ((list2 = (List)CollectionsKt.singleOrNull((Iterable)(collection = object.values()))) == null ? null : (MemberDescriptor)CollectionsKt.singleOrNull((List)list2)), (Object)expectedMember);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(ExpectedActualDeclarationChecker $this, ExpectActualCompatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static interface ActualAnnotationArgumentExtractor {
        @Nullable
        public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor var1, @NotNull KotlinType var2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u001c\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion;", "", "()V", "allStrongIncompatibilities", "", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>> $this$allStrongIncompatibilities) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, (String)"<this>");
                Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

