/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeAliasDescriptor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"toSourceElement", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getToSourceElement", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/SourceElement;", "getSourceElement", "descriptor", "isContainedByCompiledPartOfOurModule", "", "friendPath", "Ljava/io/File;", "frontend.java"})
public final class ModuleVisibilityUtilsKt {
    public static final boolean isContainedByCompiledPartOfOurModule(@NotNull DeclarationDescriptor descriptor2, @Nullable File friendPath) {
        block14: {
            KotlinJvmBinaryClass binaryClass;
            Object object;
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            if (friendPath == null) {
                return false;
            }
            PackageFragmentDescriptor packageFragment = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
            if (!(packageFragment instanceof LazyJavaPackageFragment)) {
                return false;
            }
            SourceElement source = ModuleVisibilityUtilsKt.getSourceElement(descriptor2);
            SourceElement sourceElement = source;
            Object object2 = sourceElement instanceof KotlinJvmBinarySourceElement ? ((KotlinJvmBinarySourceElement)source).getBinaryClass() : (sourceElement instanceof KotlinJvmBinaryPackageSourceElement ? (descriptor2 instanceof DeserializedMemberDescriptor ? ((object = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)descriptor2)) == null ? ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass() : object) : ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass()) : (binaryClass = null));
            if (!(binaryClass instanceof VirtualFileKotlinClass)) break block14;
            VirtualFile file2 = ((VirtualFileKotlinClass)binaryClass).getFile();
            switch (file2.getFileSystem().getProtocol()) {
                case "file": {
                    File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"virtualToIoFile(file)");
                    File ioFile = file3;
                    return ioFile.toPath().startsWith(friendPath.toPath());
                }
                case "jar": {
                    File file4;
                    VirtualFile virtualFile2 = VfsUtilCore.getVirtualFileForJar((VirtualFile)file2);
                    if (virtualFile2 == null) {
                        file4 = null;
                    } else {
                        VirtualFile virtualFile3;
                        VirtualFile p0 = virtualFile3 = virtualFile2;
                        boolean bl = false;
                        file4 = VfsUtilCore.virtualToIoFile((VirtualFile)p0);
                    }
                    File ioFile = file4;
                    return ioFile != null && Intrinsics.areEqual((Object)ioFile.toPath(), (Object)friendPath.toPath());
                }
            }
        }
        return false;
    }

    @NotNull
    public static final SourceElement getSourceElement(@NotNull DeclarationDescriptor descriptor2) {
        SourceElement sourceElement;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getSource() == SourceElement.NO_SOURCE) {
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            sourceElement = ModuleVisibilityUtilsKt.getSourceElement(declarationDescriptor);
        } else if (descriptor2 instanceof DeserializedTypeAliasDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((DeserializedTypeAliasDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            sourceElement = ModuleVisibilityUtilsKt.getSourceElement(declarationDescriptor);
        } else {
            sourceElement = ModuleVisibilityUtilsKt.getToSourceElement(descriptor2);
        }
        return sourceElement;
    }

    @NotNull
    public static final SourceElement getToSourceElement(@NotNull DeclarationDescriptor $this$toSourceElement) {
        SourceElement sourceElement;
        Intrinsics.checkNotNullParameter((Object)$this$toSourceElement, (String)"<this>");
        if ($this$toSourceElement instanceof DeclarationDescriptorWithSource) {
            SourceElement sourceElement2 = ((DeclarationDescriptorWithSource)$this$toSourceElement).getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement2, (String)"source");
            sourceElement = sourceElement2;
        } else {
            SourceElement sourceElement3 = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement3, (String)"NO_SOURCE");
            sourceElement = sourceElement3;
        }
        return sourceElement;
    }
}

