/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.AbstractFirDiagnosticFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactoryKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticRenderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirLightSimpleDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirPsiSimpleDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirSimpleDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.InternalDiagnosticFactoryMethod;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SimpleFirDiagnosticRenderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SourceElementPositioningStrategy;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticFactory0;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/AbstractFirDiagnosticFactory;", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SourceElementPositioningStrategy;Lkotlin/reflect/KClass;)V", "firRenderer", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticRenderer;", "getFirRenderer", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticRenderer;", "on", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirSimpleDiagnostic;", "element", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "positioningStrategy", "checkers"})
public final class FirDiagnosticFactory0
extends AbstractFirDiagnosticFactory {
    @NotNull
    private final FirDiagnosticRenderer firRenderer;

    public FirDiagnosticFactory0(@NotNull String name2, @NotNull Severity severity, @NotNull SourceElementPositioningStrategy defaultPositioningStrategy, @NotNull KClass<?> psiType2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)defaultPositioningStrategy, (String)"defaultPositioningStrategy");
        Intrinsics.checkNotNullParameter(psiType2, (String)"psiType");
        super(name2, severity, defaultPositioningStrategy, psiType2, null);
        this.firRenderer = new SimpleFirDiagnosticRenderer("");
    }

    @Override
    @NotNull
    public FirDiagnosticRenderer getFirRenderer() {
        return this.firRenderer;
    }

    @InternalDiagnosticFactoryMethod
    @NotNull
    public final FirSimpleDiagnostic on(@NotNull FirSourceElement element, @Nullable SourceElementPositioningStrategy positioningStrategy) {
        FirSimpleDiagnostic firSimpleDiagnostic;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FirSourceElement firSourceElement = element;
        if (firSourceElement instanceof FirPsiSourceElement) {
            SourceElementPositioningStrategy sourceElementPositioningStrategy;
            firSimpleDiagnostic = new FirPsiSimpleDiagnostic((FirPsiSourceElement)element, this.getSeverity(), this, (sourceElementPositioningStrategy = positioningStrategy) == null ? this.getDefaultPositioningStrategy() : sourceElementPositioningStrategy);
        } else if (firSourceElement instanceof FirLightSourceElement) {
            SourceElementPositioningStrategy sourceElementPositioningStrategy;
            firSimpleDiagnostic = new FirLightSimpleDiagnostic((FirLightSourceElement)element, this.getSeverity(), this, (sourceElementPositioningStrategy = positioningStrategy) == null ? this.getDefaultPositioningStrategy() : sourceElementPositioningStrategy);
        } else {
            FirDiagnosticFactoryKt.access$incorrectElement(element);
            throw null;
        }
        return firSimpleDiagnostic;
    }
}

