/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirSuspendCallChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnAllowedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isReturnAllowed", "", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "checkers"})
public final class FirReturnAllowedChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirReturnAllowedChecker INSTANCE = new FirReturnAllowedChecker();

    private FirReturnAllowedChecker() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void check(@NotNull FirReturnExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block12: {
            block11: {
                block13: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                        var5_5 = source = expression.getSource();
                        if (Intrinsics.areEqual((Object)(var5_5 == null ? null : var5_5.getKind()), (Object)FirFakeSourceElementKind.ImplicitReturn.INSTANCE)) {
                            return;
                        }
                        targetSymbol = expression.getTarget().getLabeledElement().getSymbol();
                        if (!this.isReturnAllowed(targetSymbol, context)) {
                            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getRETURN_NOT_ALLOWED(), context, null, 8, null);
                        }
                        if (!(targetSymbol instanceof FirAnonymousFunctionSymbol) || ((var7_7 = (label = ((FirAnonymousFunctionSymbol)targetSymbol).getLabel())) == null ? null : ((var8_8 = var7_7.getSource()) == null ? null : var8_8.getKind())) instanceof FirRealSourceElementKind) break block12;
                        var9_9 = var8_8 = (Iterable)CollectionsKt.asReversed(context.getQualifiedAccessOrAnnotationCalls());
                        var10_11 = var9_9.iterator();
                        while (var10_11.hasNext()) {
                            var11_12 = var10_11.next();
                            it = (FirStatement)var11_12;
                            $i$a$-find-FirReturnAllowedChecker$check$functionCall$1 = false;
                            v0 = it instanceof FirFunctionCall && Intrinsics.areEqual((Object)((var17_18 = (var16_17 = (var15_16 = (var14_15 = ((FirFunctionCall)it).getCalleeReference()) instanceof FirResolvedNamedReference != false ? (FirResolvedNamedReference)var14_15 : null) == null ? null : var15_16.getResolvedSymbol()) instanceof FirNamedFunctionSymbol != false ? (FirNamedFunctionSymbol)var16_17 : null) == null ? null : var17_18.getCallableId()), (Object)FirSuspendCallChecker.INSTANCE.getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers());
                            if (!v0) continue;
                            v1 = var11_12;
                            break block10;
                        }
                        v1 = null;
                    }
                    functionCall = v1;
                    if (!(functionCall instanceof FirFunctionCall)) break block12;
                    $this$arguments$iv = (FirCall)functionCall;
                    $i$f$getArguments = false;
                    $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block13;
                    v2 = false;
                    break block11;
                }
                for (T element$iv : $this$any$iv) {
                    it = (FirExpression)element$iv;
                    $i$a$-any-FirReturnAllowedChecker$check$1 = false;
                    if (!(it instanceof FirLambdaArgumentExpression)) ** GOTO lbl-1000
                    var14_15 = ((FirLambdaArgumentExpression)it).getExpression();
                    v3 /* !! */  = var15_16 = var14_15 instanceof FirAnonymousFunctionExpression != false ? (FirAnonymousFunctionExpression)var14_15 : null;
                    if (var15_16 == null) {
                        v4 = null;
                    } else {
                        var14_15 = var15_16.getAnonymousFunction();
                        v4 = var14_15.getSymbol();
                    }
                    if (Intrinsics.areEqual(v4, targetSymbol)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    v2 = true;
                    break block11;
                }
                v2 = false;
            }
            if (v2) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getRETURN_FOR_BUILT_IN_SUSPEND(), context, null, 8, null);
            }
        }
        if ((containingDeclaration = (FirDeclaration)CollectionsKt.last(context.getContainingDeclarations())) instanceof FirFunction && ((FirFunction)containingDeclaration).getBody() instanceof FirSingleExpressionBlock) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY(), context, null, 8, null);
        }
    }

    private final boolean isReturnAllowed(FirFunctionSymbol<?> targetSymbol, CheckerContext context2) {
        for (FirDeclaration containingDeclaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            FirDeclaration firDeclaration = containingDeclaration;
            if (firDeclaration instanceof FirClass) {
                return false;
            }
            if (firDeclaration instanceof FirFunction) {
                if (Intrinsics.areEqual(((FirFunction)containingDeclaration).getSymbol(), targetSymbol)) {
                    return true;
                }
                if (containingDeclaration instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)containingDeclaration).getInlineStatus().getReturnAllowed()) continue;
                    return false;
                }
                return false;
            }
            if (firDeclaration instanceof FirProperty) {
                if (((FirProperty)containingDeclaration).isLocal()) continue;
                return false;
            }
            if (!(firDeclaration instanceof FirValueParameter)) continue;
            return true;
        }
        return true;
    }
}

