/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInvalidAndDangerousCharactersChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "DANGEROUS_CHARS", "", "", "INVALID_CHARS", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkNameAndReport", "name", "Lorg/jetbrains/kotlin/name/Name;", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
public final class FirInvalidAndDangerousCharactersChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirInvalidAndDangerousCharactersChecker INSTANCE = new FirInvalidAndDangerousCharactersChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private FirInvalidAndDangerousCharactersChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSourceElement source = declaration2.getSource();
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirRegularClass) {
            this.checkNameAndReport(((FirRegularClass)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            this.checkNameAndReport(((FirSimpleFunction)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeParameter) {
            this.checkNameAndReport(((FirTypeParameter)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkNameAndReport(((FirProperty)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.checkNameAndReport(((FirTypeAlias)declaration2).getName(), source, context2, reporter);
        } else if (firDeclaration instanceof FirValueParameter) {
            this.checkNameAndReport(((FirValueParameter)declaration2).getName(), source, context2, reporter);
        } else {
            return;
        }
    }

    private final void checkNameAndReport(Name name2, FirSourceElement source, CheckerContext context2, DiagnosticReporter reporter) {
        if (source != null && !(source.getKind() instanceof FirFakeSourceElementKind) && !name2.isSpecial()) {
            boolean bl;
            char it;
            char element$iv;
            int n;
            CharSequence charSequence2;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            String nameString;
            block6: {
                String string2 = name2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
                nameString = string2;
                $this$any$iv = nameString;
                $i$f$any = false;
                charSequence2 = $this$any$iv;
                for (n = 0; n < charSequence2.length(); ++n) {
                    element$iv = charSequence2.charAt(n);
                    it = element$iv;
                    boolean bl2 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getINVALID_CHARACTERS(), (Object)Intrinsics.stringPlus((String)"contains illegal characters: ", (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet((CharSequence)nameString)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null)), context2, null, 16, null);
            } else {
                boolean bl3;
                block7: {
                    $this$any$iv = nameString;
                    $i$f$any = false;
                    charSequence2 = $this$any$iv;
                    for (n = 0; n < charSequence2.length(); ++n) {
                        element$iv = charSequence2.charAt(n);
                        it = element$iv;
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getDANGEROUS_CHARACTERS(), (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet((CharSequence)nameString)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), context2, null, 16, null);
                }
            }
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf((Object[])objectArray);
    }
}

