/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AbstractTypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "dispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "parseIdentityEquals", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "processEquals", "left", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "right", "isNegated", "", "reportOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitBinaryExpression", "data", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitKtElement", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "frontend"})
public final class PsiConditionParser
extends KtVisitor<BooleanExpression, Unit> {
    @NotNull
    private final ContractParsingDiagnosticsCollector collector;
    @NotNull
    private final ContractCallContext callContext;
    @NotNull
    private final PsiContractParserDispatcher dispatcher;

    public PsiConditionParser(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull PsiContractParserDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.collector = collector2;
        this.callContext = callContext;
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public BooleanExpression visitIsExpression(@NotNull KtIsExpression expression2, @NotNull Unit data) {
        boolean reifiedGenericsAllowed;
        KtTypeReference ktTypeReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        VariableReference variableReference = this.dispatcher.parseVariable(expression2.getLeftHandSide());
        if (variableReference == null) {
            return null;
        }
        VariableReference variable2 = variableReference;
        Object object = expression2.getTypeReference();
        if (object == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference = object;
        object = (KotlinType)this.callContext.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (object == null) {
            return null;
        }
        UnwrappedType type2 = ((KotlinType)object).unwrap();
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (type2 instanceof CapturedType) {
            this.collector.badDescription("references to captured types are forbidden in contracts", typeReference);
            return null;
        }
        if (!(!(descriptor2 instanceof AbstractTypeParameterDescriptor) || (reifiedGenericsAllowed = this.callContext.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowReifiedGenericsInContracts)) && ((AbstractTypeParameterDescriptor)descriptor2).isReified())) {
            String message2 = reifiedGenericsAllowed ? "references to not reified type parameters are forbidden in contracts" : "references to type parameters are forbidden in contracts";
            this.collector.badDescription(message2, typeReference);
            return null;
        }
        Object object2 = variable2.getDescriptor().getType();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"variable.descriptor.type");
        KotlinType kotlinType = object2;
        KotlinType kotlinType2 = type2;
        object2 = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, (KotlinTypeChecker)object2)) {
            return null;
        }
        return new IsInstancePredicate(variable2, type2, expression2.isNegated());
    }

    @Override
    @Nullable
    public BooleanExpression visitKtElement(@NotNull KtElement element, @NotNull Unit data) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(element, this.callContext.getBindingContext());
        if (resolvedCall3 == null) {
            return null;
        }
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (descriptor2 instanceof ValueDescriptor) {
            VariableReference variableReference = this.dispatcher.parseVariable(element instanceof KtExpression ? (KtExpression)element : null);
            if (variableReference == null) {
                return null;
            }
            VariableReference booleanVariable = variableReference;
            return booleanVariable instanceof BooleanVariableReference ? (BooleanVariableReference)booleanVariable : null;
        }
        if (PsiContractsUtilsKt.isEqualsDescriptor(descriptor2)) {
            Object object = resolvedCall2.getDispatchReceiver();
            Object object2 = object instanceof ExpressionReceiver ? (ExpressionReceiver)object : null;
            ContractDescriptionValue contractDescriptionValue = this.dispatcher.parseValue(object2 == null ? null : object2.getExpression());
            if (contractDescriptionValue == null) {
                return null;
            }
            ContractDescriptionValue left = contractDescriptionValue;
            object2 = this.dispatcher.parseValue(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall2));
            if (object2 == null) {
                return null;
            }
            Object right = object2;
            object = element instanceof KtBinaryExpression ? (KtBinaryExpression)element : null;
            IElementType iElementType = object == null ? null : ((KtBinaryExpression)object).getOperationToken();
            object = KtTokens.EXCLEQ;
            boolean isNegated = Intrinsics.areEqual((Object)iElementType, (Object)(object == null ? Boolean.valueOf(false) : object));
            return this.processEquals(left, (ContractDescriptionValue)right, isNegated, element);
        }
        this.collector.badDescription("unsupported construction", element);
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ConstantReference constantReference = this.dispatcher.parseConstant(expression2);
        return constantReference instanceof BooleanConstantReference ? (BooleanConstantReference)constantReference : null;
    }

    @Override
    @Nullable
    public BooleanExpression visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.collector.badDescription("call-expressions are not supported yet", expression2);
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull Unit data) {
        BooleanExpression booleanExpression;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Function2 operationConstructor = null;
        IElementType iElementType = expression2.getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ANDAND))) {
            operationConstructor = visitBinaryExpression.1.INSTANCE;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.OROR))) {
            operationConstructor = visitBinaryExpression.2.INSTANCE;
        } else {
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
                return this.parseIdentityEquals(expression2);
            }
            return (BooleanExpression)super.visitBinaryExpression(expression2, data);
        }
        KtExpression ktExpression = expression2.getLeft();
        Object object2 = object = ktExpression == null ? null : (BooleanExpression)ktExpression.accept(this, data);
        if (object == null) {
            return null;
        }
        BooleanExpression left = booleanExpression = object;
        KtExpression ktExpression2 = expression2.getRight();
        KtExpression ktExpression3 = ktExpression = ktExpression2 == null ? null : (BooleanExpression)ktExpression2.accept(this, data);
        if (ktExpression == null) {
            return null;
        }
        Object right = object = ktExpression;
        return (BooleanExpression)operationConstructor.invoke((Object)left, right);
    }

    private final BooleanExpression parseIdentityEquals(KtBinaryExpression expression2) {
        ContractDescriptionValue contractDescriptionValue = this.dispatcher.parseValue(expression2.getLeft());
        if (contractDescriptionValue == null) {
            return null;
        }
        ContractDescriptionValue lhs = contractDescriptionValue;
        ContractDescriptionValue contractDescriptionValue2 = this.dispatcher.parseValue(expression2.getRight());
        if (contractDescriptionValue2 == null) {
            return null;
        }
        ContractDescriptionValue rhs = contractDescriptionValue2;
        return this.processEquals(lhs, rhs, Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EXCLEQEQEQ)), expression2);
    }

    private final BooleanExpression processEquals(ContractDescriptionValue left, ContractDescriptionValue right, boolean isNegated, KtElement reportOn) {
        BooleanExpression booleanExpression;
        if (left instanceof ConstantReference && Intrinsics.areEqual((Object)left, (Object)ConstantReference.Companion.getNULL()) && right instanceof VariableReference) {
            booleanExpression = new IsNullPredicate((VariableReference)right, isNegated);
        } else if (right instanceof ConstantReference && Intrinsics.areEqual((Object)right, (Object)ConstantReference.Companion.getNULL()) && left instanceof VariableReference) {
            booleanExpression = new IsNullPredicate((VariableReference)left, isNegated);
        } else {
            this.collector.badDescription("only equality comparisons with 'null' allowed", reportOn);
            booleanExpression = null;
        }
        return booleanExpression;
    }

    @Override
    @Nullable
    public BooleanExpression visitUnaryExpression(@NotNull KtUnaryExpression expression2, @NotNull Unit data) {
        BooleanExpression booleanExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EXCL))) {
            return (BooleanExpression)super.visitUnaryExpression(expression2, data);
        }
        KtExpression ktExpression = expression2.getBaseExpression();
        BooleanExpression booleanExpression2 = booleanExpression = ktExpression == null ? null : (BooleanExpression)ktExpression.accept(this, data);
        if (booleanExpression == null) {
            return null;
        }
        Object object = booleanExpression;
        Object arg = object;
        if (!(arg instanceof ContractDescriptionValue)) {
            KtExpression ktExpression2 = expression2.getBaseExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            object = ktExpression2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"expression.baseExpression!!");
            this.collector.badDescription("negations in contract description can be applied only to variables/values", (KtElement)object);
        }
        return new LogicalNot((BooleanExpression)arg);
    }

    @Override
    @Nullable
    public BooleanExpression visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(expression2);
        return ktExpression == null ? null : (BooleanExpression)ktExpression.accept(this, data);
    }
}

