/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.LabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/RedundantNopsCleanupMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "recordNopsRequiredForDebugger", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "requiredNops", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "recordNopsRequiredForTryCatchBlocks", "transform", "internalClassName", "", "backend"})
public final class RedundantNopsCleanupMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        new LabelNormalizationMethodTransformer().transform(internalClassName, methodNode);
        HashSet requiredNops = new HashSet();
        this.recordNopsRequiredForTryCatchBlocks(methodNode, requiredNops);
        this.recordNopsRequiredForDebugger(methodNode, requiredNops);
        AbstractInsnNode current = methodNode.instructions.getFirst();
        while (current != null) {
            if (current.getOpcode() == 0 && !requiredNops.contains(current)) {
                AbstractInsnNode toRemove = current;
                current = current.getNext();
                methodNode.instructions.remove(toRemove);
                continue;
            }
            current = current.getNext();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void recordNopsRequiredForDebugger(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        void $this$filterTo$iv$iv;
        AbstractInsnNode[] abstractInsnNodeArray;
        RedundantNopsCleanupMethodTransformer redundantNopsCleanupMethodTransformer;
        RedundantNopsCleanupMethodTransformer $this$recordNopsRequiredForDebugger_u24lambda_u2d2 = redundantNopsCleanupMethodTransformer = this;
        boolean bl = false;
        AbstractInsnNode[] $this$recordNopsRequiredForDebugger_u24lambda_u2d2_u24lambda_u2d0 = abstractInsnNodeArray = new HashSet();
        boolean $i$a$-apply-RedundantNopsCleanupMethodTransformer$recordNopsRequiredForDebugger$specialLabels$1$localVarLables$22 = false;
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            $this$recordNopsRequiredForDebugger_u24lambda_u2d2_u24lambda_u2d0.add(localVariable.start);
            $this$recordNopsRequiredForDebugger_u24lambda_u2d2_u24lambda_u2d0.add(localVariable.end);
        }
        AbstractInsnNode[] localVarLables = abstractInsnNodeArray;
        abstractInsnNodeArray = methodNode.instructions.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNodeArray, (String)"methodNode.instructions.toArray()");
        Object[] $this$filter$iv = abstractInsnNodeArray;
        boolean $i$f$filter = false;
        Object[] $i$a$-apply-RedundantNopsCleanupMethodTransformer$recordNopsRequiredForDebugger$specialLabels$1$localVarLables$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            AbstractInsnNode it = (AbstractInsnNode)element$iv$iv;
            boolean bl2 = false;
            if (!(kotlin.collections.CollectionsKt.contains((Iterable)((Iterable)localVarLables), (Object)it) || it instanceof LineNumberNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int n = 0;
        List specialLabels = (List)destination$iv$iv;
        int n2 = specialLabels.size() - 2;
        if (n <= n2) {
            int i;
            do {
                i = n++;
                AbstractInsnNode begin = (AbstractInsnNode)specialLabels.get(i);
                AbstractInsnNode end = (AbstractInsnNode)specialLabels.get(i + 1);
                if (!(begin instanceof LineNumberNode)) continue;
                CollectionsKt.addIfNotNull((Collection)requiredNops, RedundantNopsCleanupMethodTransformerKt.getRequiredNopInRange(begin, end));
            } while (i != n2);
        }
    }

    private final void recordNopsRequiredForTryCatchBlocks(MethodNode methodNode, Set<AbstractInsnNode> requiredNops) {
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            AbstractInsnNode nop;
            AbstractInsnNode finger$iv;
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            AbstractInsnNode $this$findNextOrNull$iv = (AbstractInsnNode)labelNode;
            boolean $i$f$findNextOrNull = false;
            for (finger$iv = $this$findNextOrNull$iv.getNext(); finger$iv != null; finger$iv = finger$iv.getNext()) {
                AbstractInsnNode abstractInsnNode;
                AbstractInsnNode it = abstractInsnNode = finger$iv;
                boolean bl = false;
                if (UtilKt.isMeaningful(it)) break;
            }
            if (!((labelNode = (nop = finger$iv)) == null ? false : labelNode.getOpcode() == 0)) continue;
            requiredNops.add(nop);
        }
    }
}

