/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.overrides;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.overrides.DefaultFakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideDeclarationTable;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideFunction;
import org.jetbrains.kotlin.ir.declarations.IrFakeOverrideProperty;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategy;
import org.jetbrains.kotlin.ir.overrides.IrOverridingUtil;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPropertySymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020(2\u0006\u0010)\u001a\u00020\"H\u0002J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020+2\u0006\u0010)\u001a\u00020\"H\u0002J\u001e\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0012J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020(2\u0006\u0010 \u001a\u00020&H\u0014J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020+2\u0006\u0010 \u001a\u00020&H\u0014J\u0006\u0010/\u001a\u00020\u001eJ\u0016\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0012R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "Lorg/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy;", "linker", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "typeSystem", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "platformSpecificClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "fakeOverrideDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;)V", "fakeOverrideCandidates", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "haveFakeOverrides", "", "irOverridingUtil", "Lorg/jetbrains/kotlin/ir/overrides/IrOverridingUtil;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "getPlatformSpecificClassFilter", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "buildFakeOverrideChainsForClass", "", "clazz", "compatibilityMode", "composeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "compatibleMode", "", "declareFunctionFakeOverride", "Lorg/jetbrains/kotlin/ir/declarations/IrFakeOverrideFunction;", "signature", "declarePropertyFakeOverride", "Lorg/jetbrains/kotlin/ir/declarations/IrFakeOverrideProperty;", "enqueueClass", "linkFunctionFakeOverride", "linkPropertyFakeOverride", "provideFakeOverrides", "klass", "ir.serialization.common"})
public final class FakeOverrideBuilder
extends FakeOverrideBuilderStrategy {
    @NotNull
    private final FileLocalAwareLinker linker;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final FakeOverrideClassFilter platformSpecificClassFilter;
    @NotNull
    private final DeclarationTable fakeOverrideDeclarationTable;
    @NotNull
    private final Set<IrClass> haveFakeOverrides;
    @NotNull
    private final IrOverridingUtil irOverridingUtil;
    @NotNull
    private final Map<IrClass, CompatibilityMode> fakeOverrideCandidates;

    public FakeOverrideBuilder(@NotNull FileLocalAwareLinker linker, @NotNull SymbolTable symbolTable, @NotNull KotlinMangler.IrMangler mangler, @NotNull IrTypeSystemContext typeSystem, @NotNull FakeOverrideClassFilter platformSpecificClassFilter, @NotNull DeclarationTable fakeOverrideDeclarationTable) {
        Intrinsics.checkNotNullParameter((Object)linker, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        Intrinsics.checkNotNullParameter((Object)typeSystem, (String)"typeSystem");
        Intrinsics.checkNotNullParameter((Object)platformSpecificClassFilter, (String)"platformSpecificClassFilter");
        Intrinsics.checkNotNullParameter((Object)fakeOverrideDeclarationTable, (String)"fakeOverrideDeclarationTable");
        this.linker = linker;
        this.symbolTable = symbolTable;
        this.platformSpecificClassFilter = platformSpecificClassFilter;
        this.fakeOverrideDeclarationTable = fakeOverrideDeclarationTable;
        this.haveFakeOverrides = new LinkedHashSet();
        this.irOverridingUtil = new IrOverridingUtil(typeSystem, this);
        this.fakeOverrideCandidates = new LinkedHashMap();
    }

    public /* synthetic */ FakeOverrideBuilder(FileLocalAwareLinker fileLocalAwareLinker, SymbolTable symbolTable, KotlinMangler.IrMangler irMangler, IrTypeSystemContext irTypeSystemContext, FakeOverrideClassFilter fakeOverrideClassFilter, DeclarationTable declarationTable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            fakeOverrideClassFilter = DefaultFakeOverrideClassFilter.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            declarationTable = new FakeOverrideDeclarationTable(irMangler, null, 1.INSTANCE, 2, null);
        }
        this(fileLocalAwareLinker, symbolTable, irMangler, irTypeSystemContext, fakeOverrideClassFilter, declarationTable);
    }

    @NotNull
    public final FileLocalAwareLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final FakeOverrideClassFilter getPlatformSpecificClassFilter() {
        return this.platformSpecificClassFilter;
    }

    public final void enqueueClass(@NotNull IrClass clazz, @NotNull IdSignature signature2, @NotNull CompatibilityMode compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        this.fakeOverrideDeclarationTable.assumeDeclarationSignature(clazz, signature2);
        Map<IrClass, CompatibilityMode> map = this.fakeOverrideCandidates;
        map.put(clazz, compatibilityMode);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFakeOverrideChainsForClass(IrClass clazz, CompatibilityMode compatibilityMode) {
        DeclarationTable declarationTable;
        Iterator $this$mapTo$iv$iv;
        if (this.haveFakeOverrides.contains(clazz)) {
            return;
        }
        if (!this.platformSpecificClassFilter.needToConstructFakeOverrides(clazz)) {
            return;
        }
        List<IrType> superTypes2 = clazz.getSuperTypes();
        Iterable $this$map$iv = superTypes2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            IrType irType = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClass irClass2 = IrTypesKt.getClass((IrType)it);
            if (irClass2 == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected super type: ", (Object)it).toString());
            }
            IrClass irClass3 = irClass2;
            collection.add(irClass3);
        }
        List superClasses2 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = superClasses2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrClass superClass = (IrClass)element$iv;
            boolean bl = false;
            CompatibilityMode compatibilityMode2 = this.fakeOverrideCandidates.get(superClass);
            CompatibilityMode mode = compatibilityMode2 == null ? compatibilityMode : compatibilityMode2;
            this.buildFakeOverrideChainsForClass(superClass, mode);
            this.haveFakeOverrides.add(superClass);
        }
        DeclarationTable $this$buildFakeOverrideChainsForClass_u24lambda_u2d2 = declarationTable = this.fakeOverrideDeclarationTable;
        boolean bl = false;
        $this$buildFakeOverrideChainsForClass_u24lambda_u2d2.inFile(IrUtilsKt.getFileOrNull(clazz), (Function0<Unit>)((Function0)new Function0<Unit>(this, clazz, compatibilityMode){
            final /* synthetic */ FakeOverrideBuilder this$0;
            final /* synthetic */ IrClass $clazz;
            final /* synthetic */ CompatibilityMode $compatibilityMode;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                this.$compatibilityMode = $compatibilityMode;
                super(0);
            }

            public final void invoke() {
                FakeOverrideBuilder.access$getIrOverridingUtil$p(this.this$0).buildFakeOverridesForClass(this.$clazz, this.$compatibilityMode.getOldSignatures());
            }
        }));
    }

    @Override
    protected void linkFunctionFakeOverride(@NotNull IrFakeOverrideFunction declaration2, boolean compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IdSignature signature2 = this.composeSignature(declaration2, compatibilityMode);
        this.declareFunctionFakeOverride(declaration2, signature2);
    }

    @Override
    protected void linkPropertyFakeOverride(@NotNull IrFakeOverrideProperty declaration2, boolean compatibilityMode) {
        IrFakeOverrideFunction irFakeOverrideFunction;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Object object2 = new IrPropertySymbolImpl(null, 1, null);
        IrPropertySymbolImpl it = object2;
        boolean bl = false;
        it.bind((IrSymbolOwner)((IrProperty)((Object)declaration2)));
        IrPropertySymbolImpl tempSymbol = object2;
        object2 = declaration2.getGetter();
        if (object2 != null) {
            Object it2 = object = object2;
            boolean bl2 = false;
            ((IrSimpleFunction)it2).setCorrespondingPropertySymbol(tempSymbol);
        }
        object2 = declaration2.getSetter();
        if (object2 != null) {
            Object it3 = object = object2;
            boolean bl3 = false;
            ((IrSimpleFunction)it3).setCorrespondingPropertySymbol(tempSymbol);
        }
        IdSignature signature2 = this.composeSignature(declaration2, compatibilityMode);
        this.declarePropertyFakeOverride(declaration2, signature2);
        object = declaration2.getGetter();
        if (object != null) {
            Object object3;
            Object it4 = object3 = object;
            boolean bl4 = false;
            ((IrSimpleFunction)it4).setCorrespondingPropertySymbol(declaration2.getSymbol());
            IrFakeOverrideFunction irFakeOverrideFunction2 = irFakeOverrideFunction = it4 instanceof IrFakeOverrideFunction ? (IrFakeOverrideFunction)it4 : null;
            if (irFakeOverrideFunction == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected fake override getter: ", (Object)it4).toString());
            }
            this.linkFunctionFakeOverride(irFakeOverrideFunction, compatibilityMode);
        }
        object = declaration2.getSetter();
        if (object != null) {
            Object object4;
            Object it5 = object4 = object;
            boolean bl5 = false;
            ((IrSimpleFunction)it5).setCorrespondingPropertySymbol(declaration2.getSymbol());
            IrFakeOverrideFunction irFakeOverrideFunction3 = irFakeOverrideFunction = it5 instanceof IrFakeOverrideFunction ? (IrFakeOverrideFunction)it5 : null;
            if (irFakeOverrideFunction == null) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unexpected fake override setter: ", (Object)it5).toString());
            }
            this.linkFunctionFakeOverride(irFakeOverrideFunction, compatibilityMode);
        }
    }

    private final IdSignature composeSignature(IrDeclaration declaration2, boolean compatibleMode) {
        return this.fakeOverrideDeclarationTable.getSignaturer().composeSignatureForDeclaration(declaration2, compatibleMode);
    }

    private final void declareFunctionFakeOverride(IrFakeOverrideFunction declaration2, IdSignature signature2) {
        IrClass parent2 = IrUtilsKt.getParentAsClass(declaration2);
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.linker.tryReferencingSimpleFunctionByLocalSignature(parent2, signature2);
        IrSimpleFunctionSymbol symbol2 = irSimpleFunctionSymbol == null ? this.symbolTable.referenceSimpleFunctionFromLinker(signature2) : irSimpleFunctionSymbol;
        this.symbolTable.declareSimpleFunction(signature2, (Function0<? extends IrSimpleFunctionSymbol>)((Function0)new Function0<IrSimpleFunctionSymbol>(symbol2){
            final /* synthetic */ IrSimpleFunctionSymbol $symbol;
            {
                this.$symbol = $symbol;
                super(0);
            }

            @NotNull
            public final IrSimpleFunctionSymbol invoke() {
                return this.$symbol;
            }
        }), (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(symbol2, declaration2){
            final /* synthetic */ IrSimpleFunctionSymbol $symbol;
            final /* synthetic */ IrFakeOverrideFunction $declaration;
            {
                this.$symbol = $symbol;
                this.$declaration = $declaration;
                super(1);
            }

            @NotNull
            public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                boolean bl2 = bl = it == this.$symbol;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return this.$declaration.acquireSymbol(it);
            }
        }));
    }

    private final void declarePropertyFakeOverride(IrFakeOverrideProperty declaration2, IdSignature signature2) {
        IrClass parent2 = IrUtilsKt.getParentAsClass(declaration2);
        IrPropertySymbol irPropertySymbol = this.linker.tryReferencingPropertyByLocalSignature(parent2, signature2);
        IrPropertySymbol symbol2 = irPropertySymbol == null ? this.symbolTable.referencePropertyFromLinker(signature2) : irPropertySymbol;
        this.symbolTable.declareProperty(signature2, (Function0<? extends IrPropertySymbol>)((Function0)new Function0<IrPropertySymbol>(symbol2){
            final /* synthetic */ IrPropertySymbol $symbol;
            {
                this.$symbol = $symbol;
                super(0);
            }

            @NotNull
            public final IrPropertySymbol invoke() {
                return this.$symbol;
            }
        }), (Function1<? super IrPropertySymbol, ? extends IrProperty>)((Function1)new Function1<IrPropertySymbol, IrProperty>(symbol2, declaration2){
            final /* synthetic */ IrPropertySymbol $symbol;
            final /* synthetic */ IrFakeOverrideProperty $declaration;
            {
                this.$symbol = $symbol;
                this.$declaration = $declaration;
                super(1);
            }

            @NotNull
            public final IrProperty invoke(@NotNull IrPropertySymbol it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                boolean bl2 = bl = it == this.$symbol;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return this.$declaration.acquireSymbol(it);
            }
        }));
    }

    public final void provideFakeOverrides(@NotNull IrClass klass, @NotNull CompatibilityMode compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)compatibleMode, (String)"compatibleMode");
        this.buildFakeOverrideChainsForClass(klass, compatibleMode);
        this.irOverridingUtil.clear();
        this.haveFakeOverrides.add(klass);
    }

    public final void provideFakeOverrides() {
        Set<Map.Entry<IrClass, CompatibilityMode>> entries = this.fakeOverrideCandidates.entrySet();
        while (!((Collection)entries).isEmpty()) {
            Map.Entry candidate2 = (Map.Entry)CollectionsKt.last((Iterable)entries);
            entries.remove(candidate2);
            this.provideFakeOverrides((IrClass)candidate2.getKey(), (CompatibilityMode)candidate2.getValue());
        }
    }

    public static final /* synthetic */ IrOverridingUtil access$getIrOverridingUtil$p(FakeOverrideBuilder $this) {
        return $this.irOverridingUtil;
    }
}

