/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\f\u001a\u00020\b*\u00020\u00042\u0006\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\r\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u001a\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u0015"}, d2={"FIR_KT", "", "KT", "firTestDataFile", "Ljava/io/File;", "getFirTestDataFile", "(Ljava/io/File;)Ljava/io/File;", "isFirTestData", "", "(Ljava/io/File;)Z", "originalTestDataFile", "getOriginalTestDataFile", "isDirectiveDefined", "directive", "removeDirectiveFromFile", "", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "withExtension", "extension", "withSuffixAndExtension", "suffix", "tests-common-new"})
public final class FileUtilsKt {
    @NotNull
    private static final String FIR_KT = ".fir.kt";
    @NotNull
    private static final String KT = ".kt";

    public static final boolean isFirTestData(@NotNull File $this$isFirTestData) {
        Intrinsics.checkNotNullParameter((Object)$this$isFirTestData, (String)"<this>");
        String string2 = $this$isFirTestData.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return StringsKt.endsWith$default((String)string2, (String)FIR_KT, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final File getOriginalTestDataFile(@NotNull File $this$originalTestDataFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$originalTestDataFile, (String)"<this>");
        if (FileUtilsKt.isFirTestData($this$originalTestDataFile)) {
            Object object = $this$originalTestDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parentFile");
            File file3 = object;
            object = $this$originalTestDataFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
            file2 = FilesKt.resolve((File)file3, (String)Intrinsics.stringPlus((String)StringsKt.removeSuffix((String)object, (CharSequence)FIR_KT), (Object)KT));
        } else {
            file2 = $this$originalTestDataFile;
        }
        return file2;
    }

    @NotNull
    public static final File getFirTestDataFile(@NotNull File $this$firTestDataFile) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$firTestDataFile, (String)"<this>");
        if (FileUtilsKt.isFirTestData($this$firTestDataFile)) {
            file2 = $this$firTestDataFile;
        } else {
            Object object = $this$firTestDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parentFile");
            File file3 = object;
            object = $this$firTestDataFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
            file2 = FilesKt.resolve((File)file3, (String)Intrinsics.stringPlus((String)StringsKt.removeSuffix((String)object, (CharSequence)KT), (Object)FIR_KT));
        }
        return file2;
    }

    @NotNull
    public static final File withExtension(@NotNull File $this$withExtension, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return FileUtilsKt.withSuffixAndExtension($this$withExtension, "", extension);
    }

    @NotNull
    public static final File withSuffixAndExtension(@NotNull File $this$withSuffixAndExtension, @NotNull String suffix, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$withSuffixAndExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String extension2 = StringsKt.removePrefix((String)extension, (CharSequence)".");
        File file2 = $this$withSuffixAndExtension.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parentFile");
        return FilesKt.resolve((File)file2, (String)(FilesKt.getNameWithoutExtension((File)$this$withSuffixAndExtension) + suffix + '.' + extension2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isDirectiveDefined(@NotNull File $this$isDirectiveDefined, @NotNull String directive2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isDirectiveDefined, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        File $this$useLines$iv = $this$isDirectiveDefined;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines$iv;
        int n = 8192;
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        Object object3 = object2;
        boolean bl4 = false;
        object3 = new FileInputStream((File)object3);
        bl4 = false;
        object2 = new InputStreamReader((InputStream)object3, charset$iv);
        bl3 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        n = 0;
        bl2 = false;
        Throwable throwable = null;
        try {
            boolean bl5;
            block6: {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl6 = false;
                Sequence line = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl7 = false;
                Sequence $this$any$iv = line;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)directive2)) continue;
                    bl5 = true;
                    break block6;
                }
                bl5 = false;
            }
            bl = bl5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return bl;
    }

    public static final void removeDirectiveFromFile(@NotNull File $this$removeDirectiveFromFile, @NotNull Directive directive2) {
        IntRange intRange;
        Intrinsics.checkNotNullParameter((Object)$this$removeDirectiveFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        String directiveName = directive2.getName();
        String string2 = "^// " + directiveName + "(:.*)?$(\n)?";
        RegexOption regexOption = RegexOption.MULTILINE;
        boolean bl = false;
        Regex directiveRegexp = new Regex(string2, regexOption);
        String text2 = FilesKt.readText$default((File)$this$removeDirectiveFromFile, null, (int)1, null);
        Object object = Regex.find$default((Regex)directiveRegexp, (CharSequence)text2, (int)0, (int)2, null);
        IntRange intRange2 = intRange = object == null ? null : object.getRange();
        if (intRange == null) {
            object = "Directive " + directiveName + " was not found in " + $this$removeDirectiveFromFile;
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        IntRange directiveRange = intRange;
        object = text2;
        boolean bl3 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String textWithoutDirective = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)object2), (IntRange)directiveRange)).toString();
        FilesKt.writeText$default((File)$this$removeDirectiveFromFile, (String)textWithoutDirective, null, (int)2, null);
    }
}

