/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorProcessor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

public class DescriptorValidator {
    public static void validate(@NotNull ValidationVisitor validationStrategy, DeclarationDescriptor descriptor2) {
        if (validationStrategy == null) {
            DescriptorValidator.$$$reportNull$$$0(0);
        }
        DiagnosticCollectorForTests collector2 = new DiagnosticCollectorForTests();
        DescriptorValidator.validate(validationStrategy, descriptor2, collector2);
        collector2.done();
    }

    public static void validate(@NotNull ValidationVisitor validator, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticCollector collector2) {
        if (validator == null) {
            DescriptorValidator.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            DescriptorValidator.$$$reportNull$$$0(2);
        }
        if (collector2 == null) {
            DescriptorValidator.$$$reportNull$$$0(3);
        }
        RecursiveDescriptorProcessor.process(descriptor2, collector2, validator);
    }

    private static void report(@NotNull DiagnosticCollector collector2, @NotNull DeclarationDescriptor descriptor2, @NotNull String message2) {
        if (collector2 == null) {
            DescriptorValidator.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            DescriptorValidator.$$$reportNull$$$0(5);
        }
        if (message2 == null) {
            DescriptorValidator.$$$reportNull$$$0(6);
        }
        collector2.report(new ValidationDiagnostic(descriptor2, message2));
    }

    private DescriptorValidator() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DiagnosticCollectorForTests
    implements DiagnosticCollector {
        private boolean errorsFound = false;

        private DiagnosticCollectorForTests() {
        }

        @Override
        public void report(@NotNull ValidationDiagnostic diagnostic) {
            if (diagnostic == null) {
                DiagnosticCollectorForTests.$$$reportNull$$$0(0);
            }
            diagnostic.printStackTrace(System.err);
            this.errorsFound = true;
        }

        public void done() {
            if (this.errorsFound) {
                throw new AssertionError((Object)"Descriptor validation failed (see messages above)");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/test/util/DescriptorValidator$DiagnosticCollectorForTests", "report"));
        }
    }

    public static class ValidationDiagnostic {
        private final DeclarationDescriptor descriptor;
        private final String message;
        private final Throwable stackTrace;

        private ValidationDiagnostic(@NotNull DeclarationDescriptor descriptor2, @NotNull String message2) {
            if (descriptor2 == null) {
                ValidationDiagnostic.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                ValidationDiagnostic.$$$reportNull$$$0(1);
            }
            this.descriptor = descriptor2;
            this.message = message2;
            this.stackTrace = new Throwable();
        }

        @NotNull
        public DeclarationDescriptor getDescriptor() {
            DeclarationDescriptor declarationDescriptor = this.descriptor;
            if (declarationDescriptor == null) {
                ValidationDiagnostic.$$$reportNull$$$0(2);
            }
            return declarationDescriptor;
        }

        @NotNull
        public String getMessage() {
            String string2 = this.message;
            if (string2 == null) {
                ValidationDiagnostic.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @NotNull
        public Throwable getStackTrace() {
            Throwable throwable = this.stackTrace;
            if (throwable == null) {
                ValidationDiagnostic.$$$reportNull$$$0(4);
            }
            return throwable;
        }

        public void printStackTrace(@NotNull PrintStream out) {
            if (out == null) {
                ValidationDiagnostic.$$$reportNull$$$0(5);
            }
            out.println(this.descriptor);
            out.println(this.message);
            this.stackTrace.printStackTrace(out);
        }

        public String toString() {
            return this.descriptor + " > " + this.message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationDiagnostic";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationDiagnostic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStackTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "printStackTrace";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ScopeValidatorVisitor
    implements DeclarationDescriptorVisitor<Void, MemberScope> {
        private final DiagnosticCollector collector;

        public ScopeValidatorVisitor(DiagnosticCollector collector2) {
            this.collector = collector2;
        }

        private void report(DeclarationDescriptor expected, String message2) {
            DescriptorValidator.report(this.collector, expected, message2);
        }

        private void assertFound(@NotNull MemberScope scope2, @NotNull DeclarationDescriptor expected, @Nullable DeclarationDescriptor found, boolean shouldBeSame) {
            if (scope2 == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(0);
            }
            if (expected == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(1);
            }
            if (found == null) {
                this.report(expected, "Not found in " + scope2);
            }
            if (shouldBeSame ? expected != found : !expected.equals(found)) {
                this.report(expected, "Lookup error in " + scope2 + ": " + found);
            }
        }

        private void assertFound(@NotNull MemberScope scope2, @NotNull DeclarationDescriptor expected, @NotNull Collection<? extends DeclarationDescriptor> found) {
            if (scope2 == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(2);
            }
            if (expected == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(3);
            }
            if (found == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(4);
            }
            if (!found.contains(expected)) {
                this.report(expected, "Not found in " + scope2 + ": " + found);
            }
        }

        @Override
        public Void visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor2, MemberScope scope2) {
            return null;
        }

        @Override
        public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor2, MemberScope scope2) {
            return null;
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor2, MemberScope scope2) {
            this.assertFound(scope2, descriptor2, scope2.getContributedVariables(descriptor2.getName(), NoLookupLocation.FROM_TEST));
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor2, MemberScope scope2) {
            this.assertFound(scope2, descriptor2, scope2.getContributedFunctions(descriptor2.getName(), NoLookupLocation.FROM_TEST));
            return null;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor2, MemberScope scope2) {
            this.assertFound(scope2, descriptor2, scope2.getContributedClassifier(descriptor2.getName(), NoLookupLocation.FROM_TEST), true);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor2, MemberScope scope2) {
            this.assertFound(scope2, descriptor2, scope2.getContributedClassifier(descriptor2.getName(), NoLookupLocation.FROM_TEST), true);
            return null;
        }

        @Override
        public Void visitTypeAliasDescriptor(TypeAliasDescriptor descriptor2, MemberScope data) {
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Module found in scope: " + scope2);
            return null;
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Constructor found in scope: " + scope2);
            return null;
        }

        @Override
        public Void visitScriptDescriptor(ScriptDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Script found in scope: " + scope2);
            return null;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor2, MemberScope scope2) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor2, scope2);
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor2, MemberScope scope2) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor2, scope2);
        }

        @Override
        public Void visitPropertyGetterDescriptor(PropertyGetterDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Getter found in scope: " + scope2);
            return null;
        }

        @Override
        public Void visitPropertySetterDescriptor(PropertySetterDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Setter found in scope: " + scope2);
            return null;
        }

        @Override
        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2, MemberScope scope2) {
            this.report(descriptor2, "Receiver parameter found in scope: " + scope2);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "found";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ScopeValidatorVisitor";
            objectArray[2] = "assertFound";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ValidationVisitor
    implements DeclarationDescriptorVisitor<Boolean, DiagnosticCollector> {
        private boolean allowErrorTypes = false;
        private Predicate<DeclarationDescriptor> recursiveFilter = descriptor2 -> true;

        public static ValidationVisitor errorTypesForbidden() {
            return new ValidationVisitor();
        }

        public static ValidationVisitor errorTypesAllowed() {
            return new ValidationVisitor().allowErrorTypes();
        }

        protected ValidationVisitor() {
        }

        @NotNull
        public ValidationVisitor withStepIntoFilter(@NotNull Predicate<DeclarationDescriptor> filter2) {
            if (filter2 == null) {
                ValidationVisitor.$$$reportNull$$$0(0);
            }
            this.recursiveFilter = filter2;
            ValidationVisitor validationVisitor = this;
            if (validationVisitor == null) {
                ValidationVisitor.$$$reportNull$$$0(1);
            }
            return validationVisitor;
        }

        @NotNull
        public ValidationVisitor allowErrorTypes() {
            this.allowErrorTypes = true;
            ValidationVisitor validationVisitor = this;
            if (validationVisitor == null) {
                ValidationVisitor.$$$reportNull$$$0(2);
            }
            return validationVisitor;
        }

        protected void validateScope(DeclarationDescriptor scopeOwner, @NotNull MemberScope scope2, @NotNull DiagnosticCollector collector2) {
            if (scope2 == null) {
                ValidationVisitor.$$$reportNull$$$0(3);
            }
            if (collector2 == null) {
                ValidationVisitor.$$$reportNull$$$0(4);
            }
            for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(scope2)) {
                if (!this.recursiveFilter.test(descriptor2)) continue;
                descriptor2.accept(new ScopeValidatorVisitor(collector2), scope2);
            }
        }

        private void validateType(@NotNull DeclarationDescriptor descriptor2, @Nullable KotlinType type2, @NotNull DiagnosticCollector collector2) {
            if (descriptor2 == null) {
                ValidationVisitor.$$$reportNull$$$0(5);
            }
            if (collector2 == null) {
                ValidationVisitor.$$$reportNull$$$0(6);
            }
            if (type2 == null) {
                DescriptorValidator.report(collector2, descriptor2, "No type");
                return;
            }
            if (!this.allowErrorTypes && KotlinTypeKt.isError(type2)) {
                DescriptorValidator.report(collector2, descriptor2, "Error type: " + type2);
                return;
            }
            this.validateScope(descriptor2, type2.getMemberScope(), collector2);
        }

        private void validateReturnType(CallableDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateType(descriptor2, descriptor2.getReturnType(), collector2);
        }

        private static void validateTypeParameters(DiagnosticCollector collector2, List<TypeParameterDescriptor> parameters2) {
            for (int i = 0; i < parameters2.size(); ++i) {
                TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
                if (typeParameterDescriptor.getIndex() == i) continue;
                DescriptorValidator.report(collector2, typeParameterDescriptor, "Incorrect index: " + typeParameterDescriptor.getIndex() + " but must be " + i);
            }
        }

        private static void validateValueParameters(DiagnosticCollector collector2, List<ValueParameterDescriptor> parameters2) {
            for (int i = 0; i < parameters2.size(); ++i) {
                ValueParameterDescriptor valueParameterDescriptor = parameters2.get(i);
                if (valueParameterDescriptor.getIndex() == i) continue;
                DescriptorValidator.report(collector2, valueParameterDescriptor, "Incorrect index: " + valueParameterDescriptor.getIndex() + " but must be " + i);
            }
        }

        private void validateTypes(DeclarationDescriptor descriptor2, DiagnosticCollector collector2, Collection<KotlinType> types2) {
            for (KotlinType type2 : types2) {
                this.validateType(descriptor2, type2, collector2);
            }
        }

        private void validateCallable(CallableDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateReturnType(descriptor2, collector2);
            ValidationVisitor.validateTypeParameters(collector2, descriptor2.getTypeParameters());
            ValidationVisitor.validateValueParameters(collector2, descriptor2.getValueParameters());
        }

        private static <T> void assertEquals(DeclarationDescriptor descriptor2, DiagnosticCollector collector2, String name2, T expected, T actual) {
            if (!expected.equals(actual)) {
                DescriptorValidator.report(collector2, descriptor2, "Wrong " + name2 + ": " + actual + " must be " + expected);
            }
        }

        private static <T> void assertEqualTypes(DeclarationDescriptor descriptor2, DiagnosticCollector collector2, String name2, KotlinType expected, KotlinType actual) {
            if (KotlinTypeKt.isError(expected) && KotlinTypeKt.isError(actual)) {
                ValidationVisitor.assertEquals(descriptor2, collector2, name2, expected.toString(), actual.toString());
            } else if (!expected.equals(actual)) {
                DescriptorValidator.report(collector2, descriptor2, "Wrong " + name2 + ": " + actual + " must be " + expected);
            }
        }

        private static void validateAccessor(PropertyDescriptor descriptor2, DiagnosticCollector collector2, PropertyAccessorDescriptor accessor, String name2) {
            ValidationVisitor.assertEquals(accessor, collector2, "corresponding property", descriptor2, accessor.getCorrespondingProperty());
        }

        @Override
        public Boolean visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateScope(descriptor2, descriptor2.getMemberScope(), collector2);
            return true;
        }

        @Override
        public Boolean visitPackageViewDescriptor(PackageViewDescriptor descriptor2, DiagnosticCollector collector2) {
            if (!this.recursiveFilter.test(descriptor2)) {
                return false;
            }
            this.validateScope(descriptor2, descriptor2.getMemberScope(), collector2);
            return true;
        }

        @Override
        public Boolean visitVariableDescriptor(VariableDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateReturnType(descriptor2, collector2);
            return true;
        }

        @Override
        public Boolean visitFunctionDescriptor(FunctionDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateCallable(descriptor2, collector2);
            return true;
        }

        @Override
        public Boolean visitTypeParameterDescriptor(TypeParameterDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateTypes(descriptor2, collector2, descriptor2.getUpperBounds());
            this.validateType(descriptor2, descriptor2.getDefaultType(), collector2);
            return true;
        }

        @Override
        public Boolean visitClassDescriptor(ClassDescriptor descriptor2, DiagnosticCollector collector2) {
            ClassDescriptor classDescriptor;
            ClassConstructorDescriptor primaryConstructor2;
            ValidationVisitor.validateTypeParameters(collector2, descriptor2.getDeclaredTypeParameters());
            Collection<KotlinType> supertypes2 = descriptor2.getTypeConstructor().getSupertypes();
            if (supertypes2.isEmpty() && descriptor2.getKind() != ClassKind.INTERFACE && !KotlinBuiltIns.isSpecialClassWithNoSupertypes(descriptor2)) {
                DescriptorValidator.report(collector2, descriptor2, "No supertypes for non-trait");
            }
            this.validateTypes(descriptor2, collector2, supertypes2);
            this.validateType(descriptor2, descriptor2.getDefaultType(), collector2);
            this.validateScope(descriptor2, descriptor2.getUnsubstitutedInnerClassesScope(), collector2);
            ArrayList primary = Lists.newArrayList();
            for (ConstructorDescriptor constructorDescriptor : descriptor2.getConstructors()) {
                if (!constructorDescriptor.isPrimary()) continue;
                primary.add(constructorDescriptor);
            }
            if (primary.size() > 1) {
                DescriptorValidator.report(collector2, descriptor2, "Many primary constructors: " + primary);
            }
            if ((primaryConstructor2 = descriptor2.getUnsubstitutedPrimaryConstructor()) != null && !descriptor2.getConstructors().contains(primaryConstructor2)) {
                DescriptorValidator.report(collector2, primaryConstructor2, "Primary constructor not in getConstructors() result: " + descriptor2.getConstructors());
            }
            if ((classDescriptor = descriptor2.getCompanionObjectDescriptor()) != null && !classDescriptor.isCompanionObject()) {
                DescriptorValidator.report(collector2, classDescriptor, "Companion object should be marked as such");
            }
            return true;
        }

        @Override
        public Boolean visitTypeAliasDescriptor(TypeAliasDescriptor descriptor2, DiagnosticCollector data) {
            return true;
        }

        @Override
        public Boolean visitModuleDeclaration(ModuleDescriptor descriptor2, DiagnosticCollector collector2) {
            return true;
        }

        @Override
        public Boolean visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, DiagnosticCollector collector2) {
            this.visitFunctionDescriptor((FunctionDescriptor)constructorDescriptor, collector2);
            ValidationVisitor.assertEqualTypes(constructorDescriptor, collector2, "return type", constructorDescriptor.getContainingDeclaration().getDefaultType(), constructorDescriptor.getReturnType());
            return true;
        }

        @Override
        public Boolean visitScriptDescriptor(ScriptDescriptor scriptDescriptor, DiagnosticCollector collector2) {
            return true;
        }

        @Override
        public Boolean visitPropertyDescriptor(PropertyDescriptor descriptor2, DiagnosticCollector collector2) {
            PropertySetterDescriptor setter2;
            this.validateCallable(descriptor2, collector2);
            PropertyGetterDescriptor getter2 = descriptor2.getGetter();
            if (getter2 != null) {
                ValidationVisitor.assertEqualTypes(getter2, collector2, "getter return type", descriptor2.getType(), getter2.getReturnType());
                ValidationVisitor.validateAccessor(descriptor2, collector2, getter2, "getter");
            }
            if ((setter2 = descriptor2.getSetter()) != null) {
                ValidationVisitor.assertEquals(setter2, collector2, "setter parameter count", 1, setter2.getValueParameters().size());
                ValidationVisitor.assertEqualTypes(setter2, collector2, "setter parameter type", descriptor2.getType(), setter2.getValueParameters().get(0).getType());
                ValidationVisitor.assertEquals(setter2, collector2, "corresponding property", descriptor2, setter2.getCorrespondingProperty());
            }
            return true;
        }

        @Override
        public Boolean visitValueParameterDescriptor(ValueParameterDescriptor descriptor2, DiagnosticCollector collector2) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor2, collector2);
        }

        @Override
        public Boolean visitPropertyGetterDescriptor(PropertyGetterDescriptor descriptor2, DiagnosticCollector collector2) {
            return this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, collector2);
        }

        @Override
        public Boolean visitPropertySetterDescriptor(PropertySetterDescriptor descriptor2, DiagnosticCollector collector2) {
            return this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, collector2);
        }

        @Override
        public Boolean visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor2, DiagnosticCollector collector2) {
            this.validateType(descriptor2, descriptor2.getType(), collector2);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationVisitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStepIntoFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowErrorTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withStepIntoFilter";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "validateScope";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "validateType";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DiagnosticCollector {
        public void report(@NotNull ValidationDiagnostic var1);
    }
}

