/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.ApplicationEnvironmentDisposer;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0014J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0014J2\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\u0017*\u00020\u0018*\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a2\u0006\u0010\u001b\u001a\u0002H\u0017H\u0082\u0002\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProviderImpl;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "configurators", "", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "(Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "cache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getConfigurators", "()Ljava/util/List;", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "createCompilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "createKotlinCoreEnvironment", "getKotlinCoreEnvironment", "set", "", "T", "", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "value", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;Ljava/lang/Object;)V", "tests-common-new"})
public class CompilerConfigurationProviderImpl
extends CompilerConfigurationProvider {
    @NotNull
    private final Disposable testRootDisposable;
    @NotNull
    private final List<EnvironmentConfigurator> configurators;
    @NotNull
    private final Map<TestModule, KotlinCoreEnvironment> cache;

    public CompilerConfigurationProviderImpl(@NotNull Disposable testRootDisposable, @NotNull List<? extends EnvironmentConfigurator> configurators) {
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        this.testRootDisposable = testRootDisposable;
        this.configurators = configurators;
        boolean bl = false;
        this.cache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.testRootDisposable;
    }

    @NotNull
    public final List<EnvironmentConfigurator> getConfigurators() {
        return this.configurators;
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment getKotlinCoreEnvironment(@NotNull TestModule module2) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Map<TestModule, KotlinCoreEnvironment> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        KotlinCoreEnvironment value$iv = $this$getOrPut$iv.get(module2);
        if (value$iv == null) {
            boolean bl = false;
            KotlinCoreEnvironment answer$iv = this.createKotlinCoreEnvironment(module2);
            $this$getOrPut$iv.put(module2, answer$iv);
            kotlinCoreEnvironment = answer$iv;
        } else {
            kotlinCoreEnvironment = value$iv;
        }
        return kotlinCoreEnvironment;
    }

    @NotNull
    protected KotlinCoreEnvironment createKotlinCoreEnvironment(@NotNull TestModule module2) {
        EnvironmentConfigFiles environmentConfigFiles;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        TargetPlatform platform = module2.getTargetPlatform();
        if (JvmPlatformKt.isJvm(platform)) {
            environmentConfigFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        } else if (JsPlatformKt.isJs(platform)) {
            environmentConfigFiles = EnvironmentConfigFiles.JS_CONFIG_FILES;
        } else if (NativePlatformKt.isNative(platform)) {
            environmentConfigFiles = EnvironmentConfigFiles.NATIVE_CONFIG_FILES;
        } else if (TargetPlatformKt.isCommon(platform)) {
            environmentConfigFiles = EnvironmentConfigFiles.METADATA_CONFIG_FILES;
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unknown platform: ", (Object)platform);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        EnvironmentConfigFiles configFiles = environmentConfigFiles;
        KotlinCoreApplicationEnvironment applicationEnvironment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForTests(ApplicationEnvironmentDisposer.Companion.getROOT_DISPOSABLE(), new CompilerConfiguration());
        KotlinCoreEnvironment.ProjectEnvironment projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(this.getTestRootDisposable(), applicationEnvironment);
        MockProject mockProject = projectEnv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"projectEnv.project");
        MockProject project = mockProject;
        Iterable $this$forEach$iv = this.configurators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnvironmentConfigurator it = (EnvironmentConfigurator)element$iv;
            boolean bl = false;
            it.registerCompilerExtensions((Project)project);
        }
        return KotlinCoreEnvironment.Companion.createForTests(projectEnv, this.createCompilerConfiguration(module2), configFiles);
    }

    @TestInfrastructureInternals
    @NotNull
    public final CompilerConfiguration createCompilerConfiguration(@NotNull TestModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        CompilerConfiguration configuration2 = new CompilerConfiguration();
        this.set(configuration2, CommonConfigurationKeys.MODULE_NAME, module2.getName());
        CompilerConfigurationKey<MessageCollector> compilerConfigurationKey = CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"MESSAGE_COLLECTOR_KEY");
        this.set(configuration2, compilerConfigurationKey, new MessageCollector(){

            public void clear() {
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location2) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                if (severity == CompilerMessageSeverity.ERROR) {
                    String prefix = location2 == null ? "" : '(' + location2.getPath() + ':' + location2.getLine() + ':' + location2.getColumn() + ") ";
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)prefix, (Object)message2));
                }
            }

            public boolean hasErrors() {
                return false;
            }
        });
        CommonConfigurationKeysKt.setLanguageVersionSettings(configuration2, module2.getLanguageVersionSettings());
        Iterable $this$forEach$iv = this.configurators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnvironmentConfigurator it = (EnvironmentConfigurator)element$iv;
            boolean bl = false;
            it.configureCompileConfigurationWithAdditionalConfigurationKeys(configuration2, module2);
        }
        return configuration2;
    }

    private final <T> void set(CompilerConfiguration $this$set, CompilerConfigurationKey<T> key, T value2) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set.put(key, value2);
    }
}

