/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.test.BooleanPatternWithExtractor;
import org.jetbrains.kotlin.test.PatternWithExtractor;
import org.jetbrains.kotlin.test.ValuePatternWithExtractor;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u001aB\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001aR\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\n\"\b\b\u0000\u0010\u001b*\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001c2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u000e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0 H\u0002\u001a2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\n*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001c2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"BOOLEAN_FLAG_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FLAG_CLASSES", "", "Ljava/lang/Class;", "FLAG_NAMESPACE_TO_CLASS", "", "", "patterns", "Lorg/jetbrains/kotlin/test/PatternWithExtractor;", "getPatterns$annotations", "()V", "parseAnalysisFlags", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "", "rawFlags", "tryApplyBooleanFlag", "", "destination", "", "flag", "flagEnabled", "", "flagNamespace", "flagName", "createPattern", "E", "", "directive", "configurationKey", "extractor", "Lkotlin/Function1;", "tests-compiler-utils"})
public final class AnalysisFlagExtractorKt {
    private static final Pattern BOOLEAN_FLAG_PATTERN = Pattern.compile("([+-])(([a-zA-Z_0-9]*)\\.)?([a-zA-Z_0-9]*)");
    @NotNull
    private static final List<PatternWithExtractor<?>> patterns;
    @NotNull
    private static final List<Class<?>> FLAG_CLASSES;
    @NotNull
    private static final Map<String, Class<?>> FLAG_NAMESPACE_TO_CLASS;

    private static /* synthetic */ void getPatterns$annotations() {
    }

    private static final <E> PatternWithExtractor<E> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive2, CompilerConfigurationKey<E> configurationKey, Function1<? super String, ? extends E> extractor) {
        ValuePatternWithExtractor<? extends E> valuePatternWithExtractor = new ValuePatternWithExtractor<E>(directive2, configurationKey, extractor);
        boolean bl = false;
        boolean bl2 = false;
        ValuePatternWithExtractor<? extends E> it = valuePatternWithExtractor;
        boolean bl3 = false;
        Collection collection = $this$createPattern;
        boolean bl4 = false;
        collection.add(it);
        return valuePatternWithExtractor;
    }

    private static final PatternWithExtractor<Boolean> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive2, CompilerConfigurationKey<Boolean> configurationKey) {
        BooleanPatternWithExtractor booleanPatternWithExtractor = new BooleanPatternWithExtractor(directive2, configurationKey);
        boolean bl = false;
        boolean bl2 = false;
        BooleanPatternWithExtractor it = booleanPatternWithExtractor;
        boolean bl3 = false;
        Collection collection = $this$createPattern;
        boolean bl4 = false;
        collection.add(it);
        return booleanPatternWithExtractor;
    }

    @NotNull
    public static final Map<CompilerConfigurationKey<?>, Object> parseAnalysisFlags(@NotNull List<String> rawFlags) {
        Intrinsics.checkNotNullParameter(rawFlags, (String)"rawFlags");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (String flag : rawFlags) {
            Matcher m = BOOLEAN_FLAG_PATTERN.matcher(flag);
            if (m.matches()) {
                boolean flagEnabled = !Intrinsics.areEqual((Object)"-", (Object)m.group(1));
                String flagNamespace = m.group(3);
                String flagName = m.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)flagName, (String)"flagName");
                AnalysisFlagExtractorKt.tryApplyBooleanFlag(result2, flag, flagEnabled, flagNamespace, flagName);
                continue;
            }
            for (PatternWithExtractor<?> pattern : patterns) {
                m = pattern.getPattern().matcher(flag);
                if (!m.matches()) continue;
                Map map = result2;
                CompilerConfigurationKey<?> compilerConfigurationKey = pattern.getConfigurationKey();
                Matcher matcher2 = m;
                Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"m");
                matcher2 = pattern.extract(matcher2);
                boolean bl2 = false;
                map.put(compilerConfigurationKey, matcher2);
            }
        }
        return result2;
    }

    private static final void tryApplyBooleanFlag(Map<CompilerConfigurationKey<?>, Object> destination, String flag, boolean flagEnabled, String flagNamespace, String flagName) {
        block13: {
            Class<?> configurationKeysClass = null;
            Object configurationKeyField = null;
            if (flagNamespace == null) {
                for (Class<?> flagClass : FLAG_CLASSES) {
                    try {
                        configurationKeyField = flagClass.getField(flagName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                Object object;
                configurationKeysClass = FLAG_NAMESPACE_TO_CLASS.get(flagNamespace);
                boolean bl = configurationKeysClass != null;
                boolean flagClass = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = false;
                    String $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = Intrinsics.stringPlus((String)"Expected [+|-][namespace.]configurationKey, got: ", (Object)flag);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42));
                }
                try {
                    Class<?> clazz = configurationKeysClass;
                    Intrinsics.checkNotNull(clazz);
                    object = clazz.getField(flagName);
                }
                catch (Exception e) {
                    object = null;
                }
                configurationKeyField = object;
            }
            boolean bl = configurationKeyField != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus((String)"Expected [+|-][namespace.]configurationKey, got: ", (Object)flag);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            try {
                Field field2 = configurationKeyField;
                Intrinsics.checkNotNull((Object)field2);
                Map<CompilerConfigurationKey<?>, Object> map = field2.get(null);
                if (map == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.config.CompilerConfigurationKey<kotlin.Boolean>");
                }
                CompilerConfigurationKey configurationKey = (CompilerConfigurationKey)((Object)map);
                map = destination;
                Boolean bl4 = flagEnabled;
                boolean bl5 = false;
                map.put(configurationKey, bl4);
            }
            catch (Exception e) {
                bl2 = false;
                boolean bl6 = false;
                if (!_Assertions.ENABLED) break block13;
                boolean bl7 = false;
                String string3 = Intrinsics.stringPlus((String)"Expected [+|-][namespace.]configurationKey, got: ", (Object)flag);
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        List list2 = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        List $this$patterns_u24lambda_u2d0 = list2;
        boolean bl5 = false;
        CompilerConfigurationKey<Object> compilerConfigurationKey = JVMConfigurationKeys.ASSERTIONS_MODE;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"ASSERTIONS_MODE");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "ASSERTIONS_MODE", compilerConfigurationKey, (Function1)new Function1<String, JVMAssertionsMode>((Object)JVMAssertionsMode.Companion){

            @NotNull
            public final JVMAssertionsMode invoke(@Nullable String p0) {
                return ((JVMAssertionsMode.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JVMAssertionsMode;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JVMAssertionsMode.Companion.class);
            }
        });
        compilerConfigurationKey = JVMConfigurationKeys.STRING_CONCAT;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"STRING_CONCAT");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "STRING_CONCAT", compilerConfigurationKey, (Function1)new Function1<String, JvmStringConcat>((Object)JvmStringConcat.Companion){

            @Nullable
            public final JvmStringConcat invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JvmStringConcat.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmStringConcat;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmStringConcat.Companion.class);
            }
        });
        compilerConfigurationKey = JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"CONSTRUCTOR_CALL_NORMALIZATION_MODE");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "CONSTRUCTOR_CALL_NORMALIZATION_MODE", compilerConfigurationKey, (Function1)new Function1<String, JVMConstructorCallNormalizationMode>((Object)JVMConstructorCallNormalizationMode.Companion){

            @Nullable
            public final JVMConstructorCallNormalizationMode invoke(@Nullable String p0) {
                return ((JVMConstructorCallNormalizationMode.Companion)this.receiver).fromStringOrNull(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromStringOrNull(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JVMConstructorCallNormalizationMode;";
            }

            @NotNull
            public final String getName() {
                return "fromStringOrNull";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JVMConstructorCallNormalizationMode.Companion.class);
            }
        });
        compilerConfigurationKey = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"SAM_CONVERSIONS");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "SAM_CONVERSIONS", compilerConfigurationKey, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            @Nullable
            public final JvmClosureGenerationScheme invoke(@Nullable String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmClosureGenerationScheme.Companion.class);
            }
        });
        compilerConfigurationKey = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"LAMBDAS");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "LAMBDAS", compilerConfigurationKey, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            @Nullable
            public final JvmClosureGenerationScheme invoke(@Nullable String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmClosureGenerationScheme.Companion.class);
            }
        });
        compilerConfigurationKey = JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"USE_OLD_INLINE_CLASSES_MANGLING_SCHEME");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u2d0, "USE_OLD_INLINE_CLASSES_MANGLING_SCHEME", compilerConfigurationKey);
        patterns = CollectionsKt.build((List)list2);
        Object[] objectArray = new Class[]{CLIConfigurationKeys.class, JVMConfigurationKeys.class};
        FLAG_CLASSES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"CLI", CLIConfigurationKeys.class), TuplesKt.to((Object)"JVM", JVMConfigurationKeys.class)};
        FLAG_NAMESPACE_TO_CLASS = MapsKt.mapOf((Pair[])objectArray);
    }
}

