/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonBoolean;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\b\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\u0010H\u0002J\u0014\u0010*\u001a\u00020\u00102\n\u0010+\u001a\u00060,j\u0002`-H\u0002J\u0014\u0010.\u001a\u00020\u00102\n\u0010+\u001a\u00060,j\u0002`-H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser;", "", "content", "", "(Ljava/lang/String;)V", "charCode", "", "col", "getContent", "()Ljava/lang/String;", "index", "line", "offset", "wasCR", "", "advance", "", "advanceAndThen", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "error", "", "text", "expectCharAndAdvance", "expected", "", "expectString", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "parseArray", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonArray;", "parseEscapeSequence", "parseHexEscapeSequence", "parseNode", "parseNumber", "", "parseObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "parseString", "skipSpaces", "takeExponentTo", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "takeIntegerDigitsTo", "js.parser"})
final class JsonParser {
    @NotNull
    private final String content;
    private int index;
    private int charCode;
    private int offset;
    private int line;
    private int col;
    private boolean wasCR;

    public JsonParser(@NotNull String content) {
        int n;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.index = -1;
        JsonParser jsonParser = this;
        ++jsonParser.index;
        Character c = StringsKt.getOrNull((CharSequence)this.content, (int)jsonParser.index);
        if (c == null) {
            n = -1;
        } else {
            char c2 = c.charValue();
            n = c2;
        }
        this.charCode = n;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final JsonNode parse() {
        JsonNode result2 = this.parseNode();
        this.skipSpaces();
        if (this.charCode != -1) {
            this.error("End of input expected");
            throw null;
        }
        return result2;
    }

    private final void skipSpaces() {
        block3: while (true) {
            int n = this.charCode;
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.advance();
                    continue block3;
                }
            }
            break;
        }
    }

    private final JsonNode parseNode() {
        JsonNode jsonNode;
        this.skipSpaces();
        int n = this.charCode;
        switch (n) {
            case 91: {
                jsonNode = this.parseArray();
                break;
            }
            case 123: {
                jsonNode = this.parseObject();
                break;
            }
            case 34: {
                jsonNode = new JsonString(this.parseString());
                break;
            }
            case 110: {
                this.expectString("null");
                jsonNode = JsonNull.INSTANCE;
                break;
            }
            case 102: {
                this.expectString("false");
                jsonNode = JsonBoolean.Companion.getFALSE();
                break;
            }
            case 116: {
                this.expectString("true");
                jsonNode = JsonBoolean.Companion.getTRUE();
                break;
            }
            case 45: {
                this.advance();
                jsonNode = new JsonNumber(-this.parseNumber());
                break;
            }
            default: {
                int n2 = this.charCode;
                if (!(48 <= n2 ? n2 <= 57 : false)) {
                    this.error("Unexpected char");
                    throw null;
                }
                jsonNode = new JsonNumber(this.parseNumber());
            }
        }
        return jsonNode;
    }

    private final JsonArray parseArray() {
        this.advance();
        JsonArray result2 = new JsonArray(new JsonNode[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 93) break;
            Object object = result2.getElements();
            boolean bl = false;
            if (!object.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            object = result2;
            Collection collection = ((JsonArray)object).getElements();
            JsonNode jsonNode = this.parseNode();
            boolean bl2 = false;
            collection.add(jsonNode);
        }
        this.advance();
        return result2;
    }

    private final JsonObject parseObject() {
        this.advance();
        JsonObject result2 = new JsonObject(new Pair[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 125) break;
            Map<String, JsonNode> map = result2.getProperties();
            boolean bl = false;
            if (!map.isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            this.skipSpaces();
            String key = this.parseString();
            Map<String, JsonNode> map2 = result2.getProperties();
            boolean bl2 = false;
            Map<String, JsonNode> map3 = map2;
            boolean bl3 = false;
            if (map3.containsKey(key)) {
                this.error(Intrinsics.stringPlus((String)"Duplicate property name: ", (Object)key));
                throw null;
            }
            this.skipSpaces();
            this.expectCharAndAdvance(':');
            map2 = result2.getProperties();
            JsonNode jsonNode = this.parseNode();
            boolean bl4 = false;
            map2.put(key, jsonNode);
        }
        this.advance();
        return result2;
    }

    private final String parseString() {
        this.expectCharAndAdvance('\"');
        StringBuilder sb = new StringBuilder();
        int leftIndex = this.index;
        block4: while (this.index < this.content.length()) {
            Object object;
            this.charCode = this.content.charAt(this.index);
            if (this.charCode < 32) {
                this.error("Invalid character in string literal");
                throw null;
            }
            int n = this.charCode;
            switch (n) {
                case 34: {
                    sb.append(this.content, leftIndex, this.index);
                    this.advance();
                    object = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
                    return object;
                }
                case 92: {
                    sb.append(this.content, leftIndex, this.index);
                    sb.append(this.parseEscapeSequence());
                    leftIndex = this.index;
                    continue block4;
                }
            }
            object = this;
            ++((JsonParser)object).index;
            int cfr_ignored_0 = ((JsonParser)object).index;
        }
        this.error("Unexpected end of file");
        throw null;
    }

    private final char parseEscapeSequence() {
        int n;
        this.advance();
        int n2 = this.charCode;
        switch (n2) {
            case 34: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 34;
                break;
            }
            case 92: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 92;
                break;
            }
            case 47: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 47;
                break;
            }
            case 98: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 8;
                break;
            }
            case 110: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 10;
                break;
            }
            case 114: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 13;
                break;
            }
            case 102: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 12;
                break;
            }
            case 116: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 9;
                break;
            }
            case 117: {
                n = this.parseHexEscapeSequence();
                break;
            }
            default: {
                this.error("Invalid escape sequence");
                throw null;
            }
        }
        return (char)n;
    }

    private final char parseHexEscapeSequence() {
        this.advance();
        int value2 = 0;
        int n = 4;
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            int it = n2;
            boolean bl2 = false;
            value2 *= 16;
            int n5 = this.charCode;
            boolean bl3 = n5 <= 57 ? 48 <= n5 : false;
            if (bl3) {
                n4 = this.charCode - 48;
            } else {
                boolean bl4 = n5 <= 102 ? 97 <= n5 : false;
                if (bl4) {
                    n4 = this.charCode - 97 + 10;
                } else {
                    boolean bl5 = n5 <= 70 ? 65 <= n5 : false;
                    if (bl5) {
                        n4 = this.charCode - 65 + 10;
                    } else {
                        this.error("Invalid escape sequence, hexadecimal char expected");
                        throw null;
                    }
                }
            }
            value2 += n4;
            this.advance();
        }
        return (char)value2;
    }

    private final double parseNumber() {
        double d;
        StringBuilder sb = new StringBuilder();
        this.takeIntegerDigitsTo(sb);
        if (StringsKt.startsWith$default((CharSequence)sb, (char)'0', (boolean)false, (int)2, null) && sb.length() > 1) {
            this.error("Number must not start with zero");
            throw null;
        }
        int n = this.charCode;
        switch (n) {
            case 46: {
                sb.append('.');
                this.advance();
                this.takeIntegerDigitsTo(sb);
                if (this.charCode == 101 || this.charCode == 69) {
                    this.takeExponentTo(sb);
                }
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
                boolean bl = false;
                d = Double.parseDouble(string2);
                break;
            }
            case 69: 
            case 101: {
                this.takeExponentTo(sb);
                String string3 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
                boolean bl = false;
                d = Double.parseDouble(string3);
                break;
            }
            default: {
                String string4 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
                boolean bl = false;
                return Double.parseDouble(string4);
            }
        }
        return d;
    }

    private final void takeIntegerDigitsTo(StringBuilder buffer) {
        int size = 0;
        while (true) {
            int n;
            boolean bl = 48 <= (n = this.charCode) ? n <= 57 : false;
            if (!bl) break;
            buffer.append((char)this.charCode);
            this.advance();
            n = size;
            size = n + 1;
        }
        if (size == 0) {
            this.error("Invalid char, decimal digit expected");
            throw null;
        }
    }

    private final void takeExponentTo(StringBuilder buffer) {
        buffer.append('e');
        this.advance();
        if (this.charCode == 45 || this.charCode == 43) {
            buffer.append((char)this.charCode);
            this.advance();
        }
        this.takeIntegerDigitsTo(buffer);
    }

    private final void expectString(String expected) {
        String string2 = expected;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (this.charCode != c) {
                this.error("Unexpected char, '" + expected + "' expected here");
                throw null;
            }
            this.advance();
        }
    }

    private final void expectCharAndAdvance(char expected) {
        if (this.charCode != expected) {
            this.error("Unexpected char, '" + expected + "' expected here");
            throw null;
        }
        this.advance();
    }

    private final <T> T advanceAndThen(Function0<? extends T> f) {
        boolean $i$f$advanceAndThen = false;
        this.advance();
        return (T)f.invoke();
    }

    private final void advance() {
        int n;
        JsonParser jsonParser;
        if (this.charCode == -1) {
            return;
        }
        int n2 = this.charCode;
        switch (n2) {
            case 13: {
                jsonParser = this;
                int n3 = jsonParser.line;
                jsonParser.line = n3 + 1;
                this.col = 0;
                this.wasCR = true;
                break;
            }
            case 10: {
                if (this.wasCR) break;
                jsonParser = this;
                int n4 = jsonParser.line;
                jsonParser.line = n4 + 1;
                this.col = 0;
                this.wasCR = false;
                break;
            }
            default: {
                jsonParser = this;
                int n5 = jsonParser.col;
                jsonParser.col = n5 + 1;
                this.wasCR = false;
            }
        }
        jsonParser = this;
        ++jsonParser.index;
        Object object = StringsKt.getOrNull((CharSequence)this.content, (int)jsonParser.index);
        if (object == null) {
            n = -1;
        } else {
            char c = ((Character)object).charValue();
            n = c;
        }
        this.charCode = n;
        object = this;
        int n6 = ((JsonParser)object).offset;
        ((JsonParser)object).offset = n6 + 1;
    }

    private final Void error(String text2) {
        throw new JsonSyntaxException(this.offset, this.line, this.col, text2);
    }
}

