/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.LocalNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u001a,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001\u001a\u001e\u0010$\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&\u001a*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&\u001a \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010.\u001a\u00020/\"\b\b\u0000\u00100*\u000201*\u0002H02\u0006\u00102\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u00104\u001a\n\u00105\u001a\u000206*\u000207\u001ae\u00108\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u000201*\u0002092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u00020\u00050;2\u0006\u0010<\u001a\u00020\u00052 \u00102\u001a\u001c\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H0\u0012\u0006\u0012\u0004\u0018\u0001H0\u0012\u0004\u0012\u0002H00=2\n\b\u0002\u0010>\u001a\u0004\u0018\u0001H0\u00a2\u0006\u0002\u0010?\u001a\u0010\u0010@\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030(H\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020-\u001a+\u0010A\u001a\u0002H0\"\b\b\u0000\u00100*\u000201*\u0002H02\u0006\u00102\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010B\u00a8\u0006C"}, d2={"argumentsWithVarargAsSingleArray", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "additionalReceiver", "arguments", "", "varargParameterIndex", "", "defineProperty", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "receiver", "name", "", "value", "Lkotlin/Function0;", "getter", "setter", "isFunctionTypeInvoke", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "jsAssignment", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "left", "right", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "prototypeOf", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "classNameRef", "translateCall", "transformer", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "translateCallArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "translateFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "addSourceInfoIfNeed", "", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "asBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "toJsNode", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "tr", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "data", "Lkotlin/Function3;", "implicitElse", "(Lorg/jetbrains/kotlin/ir/expressions/IrWhen;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lkotlin/jvm/functions/Function3;Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "validWithNullArgs", "withSource", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "backend.js"})
public final class JsAstUtilsKt {
    @NotNull
    public static final JsVars jsVar(@NotNull JsName name2, @Nullable IrExpression initializer2, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrExpression irExpression = initializer2;
        JsExpression jsInitializer = irExpression == null ? null : (JsExpression)irExpression.accept(new IrElementToJsExpressionTransformer(), context2);
        return new JsVars(new JsVars.JsVar(name2, jsInitializer));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends JsNode> T toJsNode(@NotNull IrWhen $this$toJsNode, @NotNull BaseIrElementToJsNodeTransformer<? extends T, ? super JsGenerationContext> tr, @NotNull JsGenerationContext data, @NotNull Function3<? super JsExpression, ? super T, ? super T, ? extends T> node, @Nullable T implicitElse) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsNode, (String)"<this>");
        Intrinsics.checkNotNullParameter(tr, (String)"tr");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        List<IrBranch> $this$foldRight$iv = $this$toJsNode.getBranches();
        boolean $i$f$foldRight = false;
        Object accumulator$iv = implicitElse;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator<IrBranch> iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsNode jsNode;
                T t = accumulator$iv;
                IrBranch br = iterator$iv.previous();
                boolean bl = false;
                JsNode body2 = (JsNode)br.getResult().accept((IrElementVisitor)tr, data);
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(br)) {
                    jsNode = body2;
                } else {
                    void n;
                    JsExpression condition = (JsExpression)br.getCondition().accept(new IrElementToJsExpressionTransformer(), data);
                    jsNode = (JsNode)node.invoke((Object)condition, (Object)body2, (Object)n);
                }
                accumulator$iv = jsNode;
            }
        }
        return accumulator$iv;
    }

    public static /* synthetic */ JsNode toJsNode$default(IrWhen irWhen, BaseIrElementToJsNodeTransformer baseIrElementToJsNodeTransformer, JsGenerationContext jsGenerationContext, Function3 function3, JsNode jsNode, int n, Object object) {
        if ((n & 8) != 0) {
            jsNode = null;
        }
        return JsAstUtilsKt.toJsNode(irWhen, baseIrElementToJsNodeTransformer, jsGenerationContext, function3, jsNode);
    }

    @NotNull
    public static final JsBinaryOperation jsAssignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    @NotNull
    public static final JsNameRef prototypeOf(@NotNull JsExpression classNameRef) {
        Intrinsics.checkNotNullParameter((Object)classNameRef, (String)"classNameRef");
        return new JsNameRef(Namer.INSTANCE.getPROTOTYPE_NAME(), classNameRef);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsFunction translateFunction(@NotNull IrFunction declaration2, @Nullable JsName name2, @NotNull JsGenerationContext context2) {
        Object it;
        Object $this$mapTo$iv$iv;
        LocalNameGenerator localNameGenerator;
        Object object;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String jsFun = AnnotationUtilsKt.getJsFunAnnotation(declaration2);
        if (jsFun != null) {
            List<JsStatement> list2 = JsCodeKt.parseJsCode(jsFun);
            Intrinsics.checkNotNull(list2);
            JsFunction function2 = (JsFunction)((JsExpressionStatement)kotlin.collections.CollectionsKt.single(list2)).getExpression();
            function2.setName(name2);
            return function2;
        }
        LocalNameGenerator localNameGenerator2 = context2.getLocalNames();
        if (localNameGenerator2 == null) {
            LocalNameGenerator localNameGenerator3 = new LocalNameGenerator(context2.getStaticContext().getGlobalNameScope());
            boolean bl = false;
            boolean bl2 = false;
            it2 = localNameGenerator3;
            boolean bl3 = false;
            IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, (IrElementVisitorVoid)it2);
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull(declaration2);
            if (irClass2 != null && (object = irClass2.getThisReceiver()) != null) {
                IrElementVisitorVoidKt.acceptVoid((IrElement)object, (IrElementVisitorVoid)it2);
            }
            localNameGenerator = localNameGenerator3;
        } else {
            localNameGenerator = localNameGenerator2;
        }
        LocalNameGenerator localNameGenerator4 = localNameGenerator;
        JsGenerationContext functionContext = context2.newDeclaration(declaration2, localNameGenerator4);
        Iterable $this$map$iv = declaration2.getValueParameters();
        boolean $i$f$map22 = false;
        it2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it3;
            Object item$iv$iv = object.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsName jsName = functionContext.getNameForValueDeclaration((IrDeclarationWithName)it3);
            collection.add(jsName);
        }
        List functionParams = (List)destination$iv$iv;
        destination$iv$iv = declaration2.getBody();
        $this$mapTo$iv$iv = destination$iv$iv == null ? null : (JsStatement)destination$iv$iv.accept(new IrElementToJsStatementTransformer(), functionContext);
        JsBlock $i$f$map22 = $this$mapTo$iv$iv instanceof JsBlock ? (JsBlock)$this$mapTo$iv$iv : null;
        JsBlock body2 = $i$f$map22 == null ? new JsBlock() : $i$f$map22;
        $this$mapTo$iv$iv = name2;
        JsFunction function3 = new JsFunction(JsGenerationContextKt.getEmptyScope(), body2, Intrinsics.stringPlus((String)"member function ", (Object)($this$mapTo$iv$iv == null ? "annon" : $this$mapTo$iv$iv)));
        function3.setName(name2);
        $this$mapTo$iv$iv = declaration2.getExtensionReceiverParameter();
        if ($this$mapTo$iv$iv != null) {
            destination$iv$iv = $this$mapTo$iv$iv;
            boolean bl = false;
            boolean bl4 = false;
            it = destination$iv$iv;
            boolean bl5 = false;
            JsAstUtilsKt.translateFunction$addParameter(function3, functionContext.getNameForValueDeclaration((IrDeclarationWithName)it));
        }
        Iterable $this$forEach$iv = functionParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JsName)element$iv;
            boolean bl = false;
            JsAstUtilsKt.translateFunction$addParameter(function3, (JsName)it);
        }
        if (AdditionalIrUtilsKt.isSuspend(declaration2)) {
            JsAstUtilsKt.translateFunction$addParameter(function3, new JsName(Namer.INSTANCE.getCONTINUATION()));
        }
        return function3;
    }

    private static final boolean isFunctionTypeInvoke(JsExpression receiver, IrCall call2) {
        IrSimpleFunction irSimpleFunction;
        if (receiver == null || receiver instanceof JsThisRef) {
            return false;
        }
        IrAnnotationContainer irAnnotationContainer = call2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irAnnotationContainer instanceof IrSimpleFunction ? (IrSimpleFunction)irAnnotationContainer : null;
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction simpleFunction = irSimpleFunction;
        IrValueParameter irValueParameter = simpleFunction.getDispatchReceiverParameter();
        IrAnnotationContainer irAnnotationContainer2 = irAnnotationContainer = irValueParameter == null ? null : irValueParameter.getType();
        if (irAnnotationContainer == null) {
            return false;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        if (call2.getOrigin() == JsStatementOrigins.EXPLICIT_INVOKE.INSTANCE) {
            return false;
        }
        return Intrinsics.areEqual((Object)simpleFunction.getName(), (Object)OperatorNameConventions.INVOKE) && IrTypeUtilsKt.isFunctionTypeOrSubtype((IrType)receiverType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression translateCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context2, @NotNull IrElementToJsExpressionTransformer transformer2) {
        JsExpression jsExpression;
        JsNameRef ref;
        Object nameRef;
        Object property2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
        IrSimpleFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
        Function2<IrCall, JsGenerationContext, JsExpression> function22 = context2.getStaticContext().getIntrinsics().get(function2.getSymbol());
        if (function22 != null) {
            Function2<IrCall, JsGenerationContext, JsExpression> function23 = function22;
            boolean bl = false;
            boolean bl2 = false;
            Function2<IrCall, JsGenerationContext, JsExpression> it = function23;
            boolean bl3 = false;
            return (JsExpression)it.invoke((Object)expression2, (Object)context2);
        }
        IrExpression irExpression = expression2.getDispatchReceiver();
        JsExpression jsDispatchReceiver = irExpression == null ? null : (JsExpression)irExpression.accept(transformer2, context2);
        IrExpression irExpression2 = expression2.getExtensionReceiver();
        JsExpression jsExtensionReceiver = irExpression2 == null ? null : (JsExpression)irExpression2.accept(transformer2, context2);
        List arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context2, transformer2);
        if (AnnotationUtilsKt.getJsName(function2) == null) {
            IrPropertySymbol it = function2.getCorrespondingPropertySymbol();
            Object object = property2 = it == null ? null : (IrProperty)it.getOwner();
            if (property2 != null && IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property2)) {
                JsExpression jsExpression2;
                nameRef = new JsNameRef(context2.getNameForProperty((IrProperty)property2), jsDispatchReceiver);
                IrSimpleFunction bl3 = function2;
                if (Intrinsics.areEqual((Object)bl3, (Object)((IrProperty)property2).getGetter())) {
                    jsExpression2 = (JsExpression)nameRef;
                } else if (Intrinsics.areEqual((Object)bl3, (Object)((IrProperty)property2).getSetter())) {
                    jsExpression2 = JsAstUtilsKt.jsAssignment((JsExpression)nameRef, (JsExpression)kotlin.collections.CollectionsKt.single(arguments2));
                } else {
                    String string2 = "Function must be an accessor of corresponding property";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return jsExpression2;
            }
        }
        if (JsAstUtilsKt.isFunctionTypeInvoke(jsDispatchReceiver, expression2) || AnnotationUtilsKt.isJsNativeInvoke(expression2.getSymbol().getOwner())) {
            Object object;
            property2 = jsDispatchReceiver;
            if (property2 == null) {
                JsExpression jsExpression3 = jsExtensionReceiver;
                object = jsExpression3;
                Intrinsics.checkNotNull((Object)jsExpression3);
            } else {
                object = property2;
            }
            return new JsInvocation((JsExpression)object, arguments2);
        }
        property2 = expression2.getSuperQualifierSymbol();
        if (property2 != null) {
            List list2;
            Pair pair;
            nameRef = property2;
            boolean bl3 = false;
            boolean bl = false;
            Object superQualifier = nameRef;
            boolean bl4 = false;
            if (IrUtilsKt.isInterface((IrClass)superQualifier.getOwner())) {
                IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(function2, false, null, 3, null);
                Intrinsics.checkNotNull((Object)irOverridableDeclaration);
                IrSimpleFunction impl = (IrSimpleFunction)irOverridableDeclaration;
                pair = new Pair((Object)impl, (Object)IrUtilsKt.getParentAsClass(impl));
            } else {
                pair = new Pair((Object)function2, (Object)superQualifier.getOwner());
            }
            Pair pair2 = pair;
            IrSimpleFunction target = (IrSimpleFunction)pair2.component1();
            IrClass klass = (IrClass)pair2.component2();
            JsNameRef jsNameRef = context2.getNameForClass(klass).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"context.getNameForClass(klass).makeRef()");
            JsNameRef qualifierName = jsNameRef;
            JsName targetName = context2.getNameForMemberFunction(target);
            JsNameRef qPrototype = new JsNameRef(targetName, (JsExpression)JsAstUtilsKt.prototypeOf(qualifierName));
            JsNameRef callRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)qPrototype);
            JsExpression jsExpression4 = callRef;
            JsExpression jsExpression5 = jsDispatchReceiver;
            if (jsExpression5 == null) {
                list2 = arguments2;
            } else {
                void receiver;
                JsExpression jsExpression6 = jsExpression5;
                boolean bl5 = false;
                boolean bl6 = false;
                JsExpression jsExpression7 = jsExpression6;
                JsExpression jsExpression8 = jsExpression4;
                boolean bl7 = false;
                List list3 = kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.listOf((Object)receiver), (Iterable)arguments2);
                jsExpression4 = jsExpression8;
                List list4 = list3;
                list2 = list4 == null ? arguments2 : list4;
            }
            List list5 = list2;
            JsExpression jsExpression9 = jsExpression4;
            return new JsInvocation(jsExpression9, list5);
        }
        int varargParameterIndex = JsAstUtilsKt.varargParameterIndex(function2);
        boolean isExternalVararg = IrUtilsKt.isEffectivelyExternal(function2) && varargParameterIndex != -1;
        JsExpression jsExpression10 = jsDispatchReceiver;
        JsName symbolName = jsExpression10 == null ? context2.getNameForStaticFunction(function2) : context2.getNameForMemberFunction(function2);
        JsExpression superQualifier = jsDispatchReceiver;
        JsNameRef jsNameRef = ref = superQualifier == null ? new JsNameRef(symbolName) : new JsNameRef(symbolName, jsDispatchReceiver);
        if (isExternalVararg) {
            JsInvocation jsInvocation;
            JsExpression argumentsAsSingleArray = JsAstUtilsKt.argumentsWithVarargAsSingleArray(expression2, context2, jsExtensionReceiver, arguments2, varargParameterIndex);
            if (jsDispatchReceiver != null) {
                if (argumentsAsSingleArray instanceof JsArrayLiteral) {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef(symbolName, jsDispatchReceiver), ((JsArrayLiteral)argumentsAsSingleArray).getExpressions());
                } else {
                    JsName receiverName = new JsName("$externalVarargReceiverTmp");
                    JsNameRef jsNameRef2 = receiverName.makeRef();
                    Intrinsics.checkNotNullExpressionValue((Object)jsNameRef2, (String)"receiverName.makeRef()");
                    JsNameRef receiverRef = jsNameRef2;
                    JsStatement[] klass = new JsStatement[2];
                    klass[0] = new JsVars(new JsVars.JsVar(receiverName, jsDispatchReceiver));
                    Object targetName = new JsExpression[]{receiverRef, argumentsAsSingleArray};
                    klass[1] = new JsReturn(new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef(symbolName, (JsExpression)receiverRef)), kotlin.collections.CollectionsKt.listOf((Object[])targetName)));
                    JsFunction iifeFun = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(klass), "VarargIIFE");
                    targetName = jsDispatchReceiver instanceof JsNameRef ? (JsNameRef)jsDispatchReceiver : null;
                    boolean iifeFunHasContext = (targetName == null ? null : ((JsNameRef)targetName).getQualifier()) instanceof JsThisRef;
                    if (iifeFunHasContext) {
                        targetName = new JsExpression[]{new JsThisRef()};
                        JsInvocation jsInvocation2 = new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)iifeFun), (JsExpression[])targetName);
                        jsInvocation = jsInvocation2;
                    } else {
                        jsInvocation = new JsInvocation((JsExpression)iifeFun, new JsExpression[0]);
                    }
                }
            } else if (argumentsAsSingleArray instanceof JsArrayLiteral) {
                jsInvocation = new JsInvocation((JsExpression)new JsNameRef(symbolName), ((JsArrayLiteral)argumentsAsSingleArray).getExpressions());
            } else {
                Object[] receiverName = new JsExpression[]{new JsNullLiteral(), argumentsAsSingleArray};
                JsInvocation jsInvocation3 = new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef(symbolName)), kotlin.collections.CollectionsKt.listOf((Object[])receiverName));
                jsInvocation = jsInvocation3;
            }
            jsExpression = jsInvocation;
        } else {
            JsInvocation alternativeResult;
            JsInvocation jsInvocation;
            JsInvocation defaultResult = new JsInvocation((JsExpression)ref, kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.listOfNotNull((Object)jsExtensionReceiver), (Iterable)arguments2));
            if (jsDispatchReceiver != null && jsExtensionReceiver == null && context2.getStaticContext().getBackendContext().getLegacyPropertyAccess()) {
                IrProperty property3;
                IrPropertySymbol iifeFun = function2.getCorrespondingPropertySymbol();
                IrProperty irProperty2 = property3 = iifeFun == null ? null : (IrProperty)iifeFun.getOwner();
                if (property3 != null) {
                    JsName jsName;
                    JsName propertyName = context2.getNameForProperty(property3);
                    Object[] targetName = new JsExpression[]{jsDispatchReceiver, new JsStringLiteral(symbolName.getIdent()), new JsStringLiteral(propertyName.getIdent())};
                    List args = kotlin.collections.CollectionsKt.mutableListOf((Object[])targetName);
                    IrSimpleFunction irSimpleFunction = function2;
                    if (Intrinsics.areEqual((Object)irSimpleFunction, (Object)property3.getGetter())) {
                        jsName = context2.getNameForStaticFunction((IrSimpleFunction)context2.getStaticContext().getBackendContext().getIntrinsics().getSafePropertyGet().getOwner());
                    } else if (Intrinsics.areEqual((Object)irSimpleFunction, (Object)property3.getSetter())) {
                        Collection collection = args;
                        boolean bl = false;
                        kotlin.collections.CollectionsKt.addAll((Collection)collection, (Iterable)arguments2);
                        jsName = context2.getNameForStaticFunction((IrSimpleFunction)context2.getStaticContext().getBackendContext().getIntrinsics().getSafePropertySet().getOwner());
                    } else {
                        String string3 = "Function must be an accessor of corresponding property";
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    JsName fnName = jsName;
                    jsInvocation = new JsInvocation((JsExpression)fnName.makeRef(), args);
                } else {
                    jsInvocation = null;
                }
            } else {
                jsInvocation = null;
            }
            JsInvocation jsInvocation4 = alternativeResult = jsInvocation;
            jsExpression = jsInvocation4 == null ? defaultResult : jsInvocation4;
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression argumentsWithVarargAsSingleArray(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext context2, @Nullable JsExpression additionalReceiver, @NotNull List<? extends JsExpression> arguments2, int varargParameterIndex) {
        boolean bl;
        boolean $i$f$all22;
        Iterable $this$all$iv;
        Iterable iterable;
        List concatElements;
        block19: {
            Collection $this$forEachIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
            List arraysForConcat = null;
            boolean bl2 = false;
            arraysForConcat = new ArrayList();
            CollectionsKt.addIfNotNull(arraysForConcat, additionalReceiver);
            boolean bl3 = false;
            concatElements = new ArrayList();
            iterable = arguments2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void argument2;
                int n = index$iv++;
                boolean bl4 = false;
                if (n < 0) {
                    kotlin.collections.CollectionsKt.throwIndexOverflow();
                }
                JsExpression jsExpression = (JsExpression)item$iv;
                int index2 = n;
                boolean bl5 = false;
                int n2 = index2;
                if (n2 == varargParameterIndex) {
                    JsExpression jsExpression2;
                    JsArrayLiteral jsArrayLiteral;
                    JsArrayLiteral jsArrayLiteral2;
                    IrExpression valueArgument = expression2.getValueArgument(varargParameterIndex);
                    Collection collection = arraysForConcat;
                    boolean bl6 = false;
                    if (!collection.isEmpty()) {
                        concatElements.add(new JsArrayLiteral(arraysForConcat));
                    }
                    boolean bl7 = false;
                    arraysForConcat = new ArrayList();
                    JsExpression[] jsExpressionArray = argument2;
                    if (jsExpressionArray instanceof JsArrayLiteral) {
                        jsArrayLiteral2 = (JsArrayLiteral)argument2;
                    } else if (jsExpressionArray instanceof JsNew) {
                        List<JsExpression> list2 = ((JsNew)argument2).getArguments();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"argument.arguments");
                        Object object = kotlin.collections.CollectionsKt.firstOrNull(list2);
                        jsArrayLiteral2 = object instanceof JsArrayLiteral ? (JsArrayLiteral)object : null;
                    } else {
                        jsArrayLiteral2 = jsArrayLiteral = null;
                    }
                    if (jsArrayLiteral == null) {
                        if (valueArgument instanceof IrCall && Intrinsics.areEqual((Object)((IrCall)valueArgument).getSymbol(), (Object)context2.getStaticContext().getBackendContext().getIntrinsics().getArrayConcat())) {
                            jsExpression2 = argument2;
                        } else {
                            jsExpressionArray = new JsExpression[]{argument2};
                            jsExpression2 = new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)new JsNameRef("slice", (JsExpression)new JsArrayLiteral())), jsExpressionArray);
                        }
                    } else {
                        jsExpression2 = jsArrayLiteral;
                    }
                    JsExpression varargArgument = jsExpression2;
                    concatElements.add(varargArgument);
                    continue;
                }
                arraysForConcat.add(argument2);
            }
            $this$forEachIndexed$iv = arraysForConcat;
            $i$f$forEachIndexed = false;
            if (!$this$forEachIndexed$iv.isEmpty()) {
                concatElements.add(new JsArrayLiteral(arraysForConcat));
            }
            if (concatElements.isEmpty()) {
                return new JsArrayLiteral();
            }
            $this$all$iv = concatElements;
            $i$f$all22 = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl8 = false;
                    if (it instanceof JsArrayLiteral) continue;
                    bl = false;
                    break block19;
                }
                bl = true;
            }
        }
        if (bl) {
            void $this$fold$iv;
            void initial$iv;
            $this$all$iv = concatElements;
            $i$f$all22 = false;
            List $i$f$all22 = new ArrayList();
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void arrayLiteral;
                JsExpression jsExpression = (JsExpression)element$iv;
                void aggregatedArrayExpressions = accumulator$iv;
                boolean bl9 = false;
                JsArrayLiteral cfr_ignored_0 = (JsArrayLiteral)arrayLiteral;
                List<JsExpression> list3 = ((JsArrayLiteral)arrayLiteral).getExpressions();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"arrayLiteral.expressions");
                aggregatedArrayExpressions.addAll((Collection)list3);
                accumulator$iv = aggregatedArrayExpressions;
            }
            iterable = accumulator$iv;
            boolean bl10 = false;
            boolean bl11 = false;
            Iterable it = iterable;
            boolean bl12 = false;
            return new JsArrayLiteral((List<JsExpression>)it);
        }
        int n = concatElements.size();
        return n == 1 ? (JsExpression)concatElements.get(0) : (JsExpression)new JsInvocation((JsExpression)new JsNameRef("concat", (JsExpression)kotlin.collections.CollectionsKt.first((List)concatElements)), kotlin.collections.CollectionsKt.drop((Iterable)concatElements, (int)1));
    }

    public static final int varargParameterIndex(@NotNull IrFunction $this$varargParameterIndex) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$varargParameterIndex, (String)"<this>");
            List<IrValueParameter> $this$indexOfFirst$iv = $this$varargParameterIndex.getValueParameters();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<IrValueParameter> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                IrValueParameter item$iv;
                IrValueParameter it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getVarargElementType() != null) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsExpression> translateCallArguments(@NotNull IrMemberAccessExpression<IrFunctionSymbol> expression2, @NotNull JsGenerationContext context2, @NotNull IrElementToJsExpressionTransformer transformer2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        ListIterator iterator$iv;
        Iterable $this$dropLastWhile$iv;
        void $this$mapIndexedTo$iv$iv;
        List $this$mapIndexed$iv;
        int n;
        void $this$onEach$iv;
        JsExpression jsExpression;
        Collection collection;
        int item$iv;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
        int size = expression2.getValueArgumentsCount();
        int varargParameterIndex = JsAstUtilsKt.varargParameterIndex(IrResolveUtilsKt.getRealOverrideTarget(expression2.getSymbol().getOwner()));
        boolean validWithNullArgs = JsAstUtilsKt.validWithNullArgs(expression2);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)size);
        Collection destination$iv = new ArrayList(size);
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            void index2;
            int n2 = item$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv;
            boolean bl = false;
            IrExpression argument2 = expression2.getValueArgument((int)index2);
            Object object = argument2;
            jsExpression = object == null ? null : (JsExpression)object.accept(transformer2, context2);
            collection.add(jsExpression);
        }
        $this$mapTo$iv = destination$iv;
        boolean $i$f$onEach = false;
        void $i$f$mapTo22 = $this$onEach$iv;
        boolean bl = false;
        item$iv = 0;
        void $this$apply$iv = $i$f$mapTo22;
        boolean bl2 = false;
        for (Object element$iv : $this$apply$iv) {
            JsExpression result2 = (JsExpression)element$iv;
            boolean bl3 = false;
            if (result2 != null) continue;
            n = 0;
            boolean bl4 = false;
            if (!_Assertions.ENABLED || validWithNullArgs) continue;
            boolean bl5 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        $this$onEach$iv = $i$f$mapTo22;
        boolean $i$f$mapIndexed = false;
        $i$f$mapTo22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void result3;
            void index3;
            boolean isEmptyExternalVararg;
            int element$iv = index$iv$iv++;
            boolean bl6 = false;
            if (element$iv < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            JsExpression bl3 = (JsExpression)item$iv$iv2;
            n = element$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            boolean bl8 = isEmptyExternalVararg = validWithNullArgs && varargParameterIndex == index3 && result3 instanceof JsArrayLiteral && ((JsArrayLiteral)result3).getExpressions().isEmpty();
            jsExpression = isEmptyExternalVararg && index3 == size - 1 ? (JsExpression)null : result3;
            collection.add(jsExpression);
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsExpression it = (JsExpression)iterator$iv.previous();
                boolean bl9 = false;
                if (it == null) continue;
                list2 = kotlin.collections.CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$map = false;
        iterator$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl10 = false;
            void var16_29 = it;
            jsExpression = var16_29 == null ? (JsExpression)new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(1)) : var16_29;
            collection.add(jsExpression);
        }
        List arguments2 = (List)destination$iv$iv;
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isSuspend(expression2.getSymbol()) ? kotlin.collections.CollectionsKt.plus((Collection)arguments2, (Object)context2.getContinuation()) : arguments2;
    }

    private static final boolean validWithNullArgs(IrMemberAccessExpression<?> $this$validWithNullArgs) {
        return $this$validWithNullArgs instanceof IrFunctionAccessExpression && IrUtilsKt.isExternalOrInheritedFromExternal(((IrFunctionSymbol)((IrFunctionAccessExpression)$this$validWithNullArgs).getSymbol()).getOwner());
    }

    @NotNull
    public static final JsBlock asBlock(@NotNull JsStatement $this$asBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$asBlock, (String)"<this>");
        JsBlock jsBlock = $this$asBlock instanceof JsBlock ? (JsBlock)$this$asBlock : null;
        return jsBlock == null ? new JsBlock($this$asBlock) : jsBlock;
    }

    @NotNull
    public static final JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name2, @NotNull Function0<? extends JsExpression> value2) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        JsNameRef objectDefineProperty = new JsNameRef("defineProperty", (JsExpression)Namer.INSTANCE.getJS_OBJECT());
        JsExpression[] jsExpressionArray = new JsExpression[]{receiver, new JsStringLiteral(name2), (JsExpression)value2.invoke()};
        return new JsInvocation((JsExpression)objectDefineProperty, jsExpressionArray);
    }

    @NotNull
    public static final JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name2, @Nullable JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return JsAstUtilsKt.defineProperty(receiver, name2, (Function0<? extends JsExpression>)((Function0)new Function0<JsExpression>(getter2, setter2){
            final /* synthetic */ JsExpression $getter;
            final /* synthetic */ JsExpression $setter;
            {
                this.$getter = $getter;
                this.$setter = $setter;
                super(0);
            }

            @NotNull
            public final JsExpression invoke() {
                JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(true);
                JsExpression jsExpression = this.$getter;
                JsExpression jsExpression2 = this.$setter;
                boolean bl = false;
                boolean bl2 = false;
                JsObjectLiteral $this$invoke_u24lambda_u2d0 = jsObjectLiteral;
                boolean bl3 = false;
                JsObjectLiteral jsObjectLiteral2 = $this$invoke_u24lambda_u2d0;
                Collection<JsPropertyInitializer> collection = jsObjectLiteral2.getPropertyInitializers();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
                collection = collection;
                JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsStringLiteral("configurable"), new JsBooleanLiteral(true));
                boolean bl4 = false;
                collection.add(jsPropertyInitializer);
                if (jsExpression != null) {
                    jsObjectLiteral2 = $this$invoke_u24lambda_u2d0;
                    collection = jsObjectLiteral2.getPropertyInitializers();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
                    jsPropertyInitializer = new JsPropertyInitializer(new JsStringLiteral("get"), jsExpression);
                    bl4 = false;
                    collection.add(jsPropertyInitializer);
                }
                if (jsExpression2 != null) {
                    jsObjectLiteral2 = $this$invoke_u24lambda_u2d0;
                    collection = jsObjectLiteral2.getPropertyInitializers();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"propertyInitializers");
                    jsPropertyInitializer = new JsPropertyInitializer(new JsStringLiteral("set"), jsExpression2);
                    bl4 = false;
                    collection.add(jsPropertyInitializer);
                }
                return jsObjectLiteral;
            }
        }));
    }

    public static /* synthetic */ JsInvocation defineProperty$default(JsExpression jsExpression, String string2, JsExpression jsExpression2, JsExpression jsExpression3, int n, Object object) {
        if ((n & 8) != 0) {
            jsExpression3 = null;
        }
        return JsAstUtilsKt.defineProperty(jsExpression, string2, jsExpression2, jsExpression3);
    }

    @NotNull
    public static final <T extends JsNode> T withSource(@NotNull T $this$withSource, @NotNull IrElement node, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter($this$withSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        T $this$addSourceInfoIfNeed$iv = $this$withSource;
        boolean $i$f$addSourceInfoIfNeed = false;
        if (context2.getStaticContext().getGenSourcemaps() && node.getStartOffset() != -1 && node.getEndOffset() != -1) {
            IrFileEntry irFileEntry;
            IrFile irFile = context2.getCurrentFile();
            IrFileEntry irFileEntry2 = irFileEntry = irFile == null ? null : irFile.getFileEntry();
            if (irFileEntry != null) {
                Object object;
                IrFileEntry fileEntry$iv = irFileEntry;
                String path$iv = fileEntry$iv.getName();
                int startLine$iv = fileEntry$iv.getLineNumber(node.getStartOffset());
                int startColumn$iv = fileEntry$iv.getColumnNumber(node.getStartOffset());
                if ($this$addSourceInfoIfNeed$iv instanceof JsExpressionStatement) {
                    JsExpression jsExpression = ((JsExpressionStatement)$this$addSourceInfoIfNeed$iv).getExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"this.expression");
                    object = jsExpression;
                } else {
                    object = $this$addSourceInfoIfNeed$iv;
                }
                T locationTarget$iv = object;
                locationTarget$iv.setSource(new JsLocation(path$iv, startLine$iv, startColumn$iv));
            }
        }
        return $this$withSource;
    }

    private static final <T extends JsNode> void addSourceInfoIfNeed(T $this$addSourceInfoIfNeed, IrElement node, JsGenerationContext context2) {
        Object object;
        IrFileEntry irFileEntry;
        boolean $i$f$addSourceInfoIfNeed = false;
        if (!context2.getStaticContext().getGenSourcemaps()) {
            return;
        }
        if (node.getStartOffset() == -1 || node.getEndOffset() == -1) {
            return;
        }
        IrFile irFile = context2.getCurrentFile();
        IrFileEntry irFileEntry2 = irFileEntry = irFile == null ? null : irFile.getFileEntry();
        if (irFileEntry == null) {
            return;
        }
        IrFileEntry fileEntry = irFileEntry;
        String path2 = fileEntry.getName();
        int startLine = fileEntry.getLineNumber(node.getStartOffset());
        int startColumn = fileEntry.getColumnNumber(node.getStartOffset());
        if ($this$addSourceInfoIfNeed instanceof JsExpressionStatement) {
            JsExpression jsExpression = ((JsExpressionStatement)$this$addSourceInfoIfNeed).getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"this.expression");
            object = jsExpression;
        } else {
            object = $this$addSourceInfoIfNeed;
        }
        T locationTarget = object;
        locationTarget.setSource(new JsLocation(path2, startLine, startColumn));
    }

    private static final void translateFunction$addParameter(JsFunction $this$translateFunction_u24addParameter, JsName parameter) {
        $this$translateFunction_u24addParameter.getParameters().add(new JsParameter(parameter));
    }
}

