/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.SerializedMapping;
import org.jetbrains.kotlin.ir.backend.js.SerializedMappings;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcData;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedIcDataForFile;
import org.jetbrains.kotlin.ir.backend.js.ic.SerializedOrder;
import org.jetbrains.kotlin.ir.serialization.SerializedCarriers;
import org.jetbrains.kotlin.library.SerializedIrFile;
import org.jetbrains.kotlin.library.impl.IrArrayMemoryReader;
import org.jetbrains.kotlin.library.impl.IrFileReadersKt;
import org.jetbrains.kotlin.library.impl.IrMemoryArrayWriter;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\u00042\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"keyBytes", "", "Lorg/jetbrains/kotlin/ir/backend/js/SerializedMappings;", "readIcData", "Lorg/jetbrains/kotlin/ir/backend/js/ic/SerializedIcData;", "Ljava/io/File;", "valueBytes", "writeTo", "", "dir", "ir.serialization.js"})
public final class DataKt {
    public static final void writeTo(@NotNull SerializedIcData $this$writeTo, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.exists()) {
            String string2 = Intrinsics.stringPlus((String)"Directory doesn't exist: ", (Object)dir.getAbsolutePath());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (!dir.isDirectory()) {
            String string3 = Intrinsics.stringPlus((String)"Not a directory: ", (Object)dir.getAbsolutePath());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Iterable $this$forEach$iv = $this$writeTo.getFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileId;
            SerializedIcDataForFile it = (SerializedIcDataForFile)element$iv;
            boolean bl = false;
            String fqnPath = it.getFile().getFqName();
            int n = it.getFile().getPath().hashCode();
            int n2 = 36;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toString(n, CharsKt.checkRadix((int)n2)), (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String irFileDirectory = "ic-" + fqnPath + '.' + fileId + ".file";
            File fileDir = new File(dir, irFileDirectory);
            if (!fileDir.exists() && !fileDir.mkdirs()) {
                String string4 = Intrinsics.stringPlus((String)"Failed to create output dir for file ", (Object)fileDir.getAbsolutePath());
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            FilesKt.writeBytes((File)new File(fileDir, "file.fileData"), (byte[])it.getFile().getFileData());
            File file2 = new File(fileDir, "file.path");
            String string5 = it.getFile().getPath();
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string6.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            FilesKt.writeBytes((File)file2, (byte[])byArray);
            FilesKt.writeBytes((File)new File(fileDir, "file.declarations"), (byte[])it.getFile().getDeclarations());
            FilesKt.writeBytes((File)new File(fileDir, "file.types"), (byte[])it.getFile().getTypes());
            FilesKt.writeBytes((File)new File(fileDir, "file.signatures"), (byte[])it.getFile().getSignatures());
            FilesKt.writeBytes((File)new File(fileDir, "file.strings"), (byte[])it.getFile().getStrings());
            FilesKt.writeBytes((File)new File(fileDir, "file.bodies"), (byte[])it.getFile().getBodies());
            FilesKt.writeBytes((File)new File(fileDir, "carriers.signatures"), (byte[])it.getCarriers().getSignatures());
            FilesKt.writeBytes((File)new File(fileDir, "carriers.declarationCarriers"), (byte[])it.getCarriers().getDeclarationCarriers());
            FilesKt.writeBytes((File)new File(fileDir, "carriers.bodyCarriers"), (byte[])it.getCarriers().getBodyCarriers());
            FilesKt.writeBytes((File)new File(fileDir, "carriers.removedOn"), (byte[])it.getCarriers().getRemovedOn());
            FilesKt.writeBytes((File)new File(fileDir, "mappings.keys"), (byte[])DataKt.keyBytes(it.getMappings()));
            FilesKt.writeBytes((File)new File(fileDir, "mappings.values"), (byte[])DataKt.valueBytes(it.getMappings()));
            FilesKt.writeBytes((File)new File(fileDir, "order.topLevelSignatures"), (byte[])it.getOrder().getTopLevelSignatures());
            FilesKt.writeBytes((File)new File(fileDir, "order.containerSignatures"), (byte[])it.getOrder().getContainerSignatures());
            FilesKt.writeBytes((File)new File(fileDir, "order.declarationSignatures"), (byte[])it.getOrder().getDeclarationSignatures());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] keyBytes(SerializedMappings $this$keyBytes) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$keyBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = it.getKeys();
            collection.add(byArray);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new IrMemoryArrayWriter(list2).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] valueBytes(SerializedMappings $this$valueBytes) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$valueBytes.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializedMapping serializedMapping = (SerializedMapping)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = it.getValues();
            collection.add(byArray);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new IrMemoryArrayWriter(list2).writeIntoMemory();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SerializedIcData readIcData(@NotNull File $this$readIcData) {
        void $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readIcData, (String)"<this>");
        if (!$this$readIcData.isDirectory()) {
            String string2 = Intrinsics.stringPlus((String)"Directory doesn't exist: ", (Object)$this$readIcData.getAbsolutePath());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        File[] fileArray = $this$readIcData.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl2 = false;
            if (!((File)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<SerializedIcDataForFile> collection = (List)destination$iv$iv;
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<SerializedMapping> collection2;
            void $this$mapTo$iv$iv2;
            void fileDir;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = FilesKt.readBytes((File)new File((File)fileDir, "file.fileData"));
            it = fileDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"fileDir.name");
            CharSequence charSequence = (CharSequence)it;
            it = new char[1];
            it[0] = 46;
            String string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)charSequence, (char[])it, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            it = FilesKt.readBytes((File)new File((File)fileDir, "file.path"));
            Charset bl2 = Charsets.UTF_8;
            boolean bl3 = false;
            boolean bl4 = false;
            SerializedIrFile file3 = new SerializedIrFile(byArray, string3, new String((byte[])it, bl2), FilesKt.readBytes((File)new File((File)fileDir, "file.types")), FilesKt.readBytes((File)new File((File)fileDir, "file.signatures")), FilesKt.readBytes((File)new File((File)fileDir, "file.strings")), FilesKt.readBytes((File)new File((File)fileDir, "file.bodies")), FilesKt.readBytes((File)new File((File)fileDir, "file.declarations")));
            SerializedCarriers carriers = new SerializedCarriers(FilesKt.readBytes((File)new File((File)fileDir, "carriers.signatures")), FilesKt.readBytes((File)new File((File)fileDir, "carriers.declarationCarriers")), FilesKt.readBytes((File)new File((File)fileDir, "carriers.bodyCarriers")), FilesKt.readBytes((File)new File((File)fileDir, "carriers.removedOn")));
            byte[][] mappingKeys = IrFileReadersKt.toArray(new IrArrayMemoryReader(FilesKt.readBytes((File)new File((File)fileDir, "mappings.keys"))));
            byte[][] mappingValues = IrFileReadersKt.toArray(new IrArrayMemoryReader(FilesKt.readBytes((File)new File((File)fileDir, "mappings.values"))));
            bl4 = ((Object[])mappingKeys).length == ((Object[])mappingValues).length;
            boolean bl5 = false;
            boolean bl6 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean bl7 = false;
                String string4 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string4));
            }
            Iterable $this$map$iv2 = ArraysKt.zip((Object[])((Object[])mappingKeys), (Object[])((Object[])mappingValues));
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void $dstr$k$v;
                Pair pair = (Pair)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl8 = false;
                byte[] k = (byte[])$dstr$k$v.component1();
                byte[] v = (byte[])$dstr$k$v.component2();
                SerializedMapping serializedMapping = new SerializedMapping(k, v);
                collection2.add(serializedMapping);
            }
            collection2 = (List)destination$iv$iv2;
            List list2 = collection2;
            SerializedMappings mappings = new SerializedMappings(list2);
            SerializedOrder order2 = new SerializedOrder(FilesKt.readBytes((File)new File((File)fileDir, "order.topLevelSignatures")), FilesKt.readBytes((File)new File((File)fileDir, "order.containerSignatures")), FilesKt.readBytes((File)new File((File)fileDir, "order.declarationSignatures")));
            SerializedIcDataForFile serializedIcDataForFile = new SerializedIcDataForFile(file3, carriers, mappings, order2);
            collection.add(serializedIcDataForFile);
        }
        collection = (List)destination$iv$iv;
        Collection collection3 = collection;
        return new SerializedIcData(collection3);
    }
}

