/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.extensions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.extensions.FirExtension;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedExtension;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotations;
import org.jetbrains.kotlin.fir.extensions.PluginServicesInitialization;
import org.jetbrains.kotlin.fir.extensions.predicate.DeclarationPredicate;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u000e2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u001a\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u000e2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u001e\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00172\n\u0010\u0018\u001a\u00060\u0007j\u0002`\bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\"\u0010\u001b\u001a\u00020\u001a2\n\u0010\u0018\u001a\u00060\u0007j\u0002`\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017H\u0016R\u001e\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\"\u0010\u0011\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotationsImpl;", "Lorg/jetbrains/kotlin/fir/extensions/FirRegisteredPluginAnnotations;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "annotations", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/extensions/AnnotationFqn;", "getAnnotations", "()Ljava/util/Set;", "annotationsForPredicateCache", "", "Lorg/jetbrains/kotlin/fir/extensions/predicate/DeclarationPredicate;", "", "metaAnnotations", "getMetaAnnotations", "userDefinedAnnotations", "Lcom/google/common/collect/Multimap;", "collectAnnotations", "predicate", "getAnnotationsForPredicate", "getAnnotationsWithMetaAnnotation", "", "metaAnnotation", "initialize", "", "registerUserDefinedAnnotation", "annotationClasses", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "resolve"})
final class FirRegisteredPluginAnnotationsImpl
extends FirRegisteredPluginAnnotations {
    @NotNull
    private final Set<FqName> annotations;
    @NotNull
    private final Set<FqName> metaAnnotations;
    @NotNull
    private final Multimap<FqName, FqName> userDefinedAnnotations;
    @NotNull
    private final Map<DeclarationPredicate, Set<FqName>> annotationsForPredicateCache;

    public FirRegisteredPluginAnnotationsImpl(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        super(session2);
        boolean bl = false;
        this.annotations = new LinkedHashSet();
        bl = false;
        this.metaAnnotations = new LinkedHashSet();
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashMultimap, (String)"create()");
        this.userDefinedAnnotations = (Multimap)linkedHashMultimap;
        boolean bl2 = false;
        this.annotationsForPredicateCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Set<FqName> getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public Set<FqName> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    @Override
    @NotNull
    public Collection<FqName> getAnnotationsWithMetaAnnotation(@NotNull FqName metaAnnotation) {
        Intrinsics.checkNotNullParameter((Object)metaAnnotation, (String)"metaAnnotation");
        Collection collection = this.userDefinedAnnotations.get((Object)metaAnnotation);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"userDefinedAnnotations[metaAnnotation]");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerUserDefinedAnnotation(@NotNull FqName metaAnnotation, @NotNull Collection<? extends FirRegularClass> annotationClasses) {
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean $i$f$all;
        block5: {
            Intrinsics.checkNotNullParameter((Object)metaAnnotation, (String)"metaAnnotation");
            Intrinsics.checkNotNullParameter(annotationClasses, (String)"annotationClasses");
            Iterable $this$all$iv = annotationClasses;
            $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    FirRegularClass it = (FirRegularClass)element$iv2;
                    boolean bl2 = false;
                    if (it.getClassKind() == ClassKind.ANNOTATION_CLASS) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        $i$f$all = false;
        boolean bl3 = false;
        bl3 = false;
        boolean element$iv2 = false;
        if (!$this$all$iv) {
            boolean it = false;
            String element$iv2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(element$iv2.toString());
        }
        Iterable $this$map$iv = annotationClasses;
        boolean $i$f$map = false;
        Iterable element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirRegularClass firRegularClass = (FirRegularClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            FqName fqName2 = it.getSymbol().getClassId().asSingleFqName();
            collection.add(fqName2);
        }
        List annotations2 = (List)destination$iv$iv;
        FirRegisteredPluginAnnotationsImpl firRegisteredPluginAnnotationsImpl = this;
        Collection collection = firRegisteredPluginAnnotationsImpl.getAnnotations();
        boolean bl5 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)annotations2);
        this.userDefinedAnnotations.putAll((Object)metaAnnotation, (Iterable)annotations2);
    }

    @Override
    @NotNull
    public Set<FqName> getAnnotationsForPredicate(@NotNull DeclarationPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Set set = this.annotationsForPredicateCache.computeIfAbsent(predicate, this::collectAnnotations);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"annotationsForPredicateC\u2026te, ::collectAnnotations)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<FqName> collectAnnotations(DeclarationPredicate predicate) {
        void destination$iv;
        void $this$flatMapTo$iv;
        if (predicate.getMetaAnnotations().isEmpty()) {
            return predicate.getAnnotations();
        }
        Iterable iterable = predicate.getMetaAnnotations();
        boolean bl = false;
        Iterable iterable2 = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FqName it = (FqName)element$iv;
            boolean bl2 = false;
            Iterable list$iv = this.getAnnotationsWithMetaAnnotation(it);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Set result2 = (Set)destination$iv;
        if (result2.isEmpty()) {
            return predicate.getAnnotations();
        }
        iterable = result2;
        iterable2 = predicate.getAnnotations();
        boolean bl3 = false;
        CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
        return result2;
    }

    @Override
    @PluginServicesInitialization
    public void initialize() {
        for (FirExtension extension : FirExtensionServiceKt.getExtensionService(this.getSession()).getAllExtensions()) {
            if (!(extension instanceof FirPredicateBasedExtension)) continue;
            DeclarationPredicate predicate = ((FirPredicateBasedExtension)extension).getPredicate();
            FirRegisteredPluginAnnotationsImpl firRegisteredPluginAnnotationsImpl = this;
            Collection collection = firRegisteredPluginAnnotationsImpl.getAnnotations();
            Iterable iterable = predicate.getAnnotations();
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            firRegisteredPluginAnnotationsImpl = this;
            collection = firRegisteredPluginAnnotationsImpl.getMetaAnnotations();
            iterable = predicate.getMetaAnnotations();
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }
}

