/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDelegationInInterfaceSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/psi/KtClass;", "()V", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkPsi", "Lorg/jetbrains/kotlin/fir/FirPsiSourceElement;", "psi", "isApplicable", "", "checkers"})
public final class FirDelegationInInterfaceSyntaxChecker
extends FirDeclarationSyntaxChecker<FirRegularClass, KtClass> {
    @NotNull
    public static final FirDelegationInInterfaceSyntaxChecker INSTANCE = new FirDelegationInInterfaceSyntaxChecker();

    private FirDelegationInInterfaceSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirRegularClass element, @NotNull FirSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FirClass $this$isInterface$iv = element;
        boolean $i$f$isInterface = false;
        return $this$isInterface$iv.getClassKind() == ClassKind.INTERFACE;
    }

    @Override
    public void checkPsi(@NotNull FirRegularClass element, @NotNull FirPsiSourceElement source, @NotNull KtClass psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeRef superTypeRef : element.getSuperTypeRefs()) {
            FirSourceElement superSource;
            FirSourceElement firSourceElement = superTypeRef.getSource();
            if (firSourceElement == null || !(((firSourceElement = FirSourceElementKt.getPsi(superSource = firSourceElement)) == null ? null : firSourceElement.getParent()) instanceof KtDelegatedSuperTypeEntry)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, superSource, FirErrors.INSTANCE.getDELEGATION_IN_INTERFACE(), context2, null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirRegularClass element, @NotNull FirSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeRef superTypeRef : element.getSuperTypeRefs()) {
            FirSourceElement superSource;
            FirSourceElement firSourceElement = superTypeRef.getSource();
            if (firSourceElement == null || !Intrinsics.areEqual((Object)((firSourceElement = (LighterASTNode)(superSource = firSourceElement).getTreeStructure().getParent((Object)superSource.getLighterASTNode())) == null ? null : firSourceElement.getTokenType()), (Object)KtNodeTypes.DELEGATED_SUPER_TYPE_ENTRY)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, superSource, FirErrors.INSTANCE.getDELEGATION_IN_INTERFACE(), context2, null, 8, null);
        }
    }
}

