/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkAccessorForDelegatedProperty", "property", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkGetter", "checkSetter", "isLegallyAbstract", "", "checkers"})
public final class FirPropertyAccessorChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyAccessorChecker INSTANCE = new FirPropertyAccessorChecker();

    private FirPropertyAccessorChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkGetter(declaration2, context2, reporter);
        this.checkSetter(declaration2, context2, reporter);
    }

    private final void checkGetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor getter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)getter2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)getter2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
            boolean bl = false;
            boolean bl2 = false;
            FirAnnotationContainer it$iv = firAnnotationContainer3;
            boolean bl3 = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            FirTypeRef getterReturnTypeRef;
            CheckerContext it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl = false;
            INSTANCE.checkAccessorForDelegatedProperty(property2, getter2, context2, reporter);
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)visibility2, (Object)$this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn$default(reporter, getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && INSTANCE.isLegallyAbstract(property2, context2)) {
                DiagnosticReporterKt.reportOn$default(reporter, getter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), context2, null, 8, null);
            }
            if ((($i$f$getVisibility = (getterReturnTypeRef = getter2.getReturnTypeRef()).getSource()) == null ? null : $i$f$getVisibility.getKind()) instanceof FirFakeSourceElementKind) {
                return;
            }
            ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
            if (propertyType instanceof ConeClassErrorType || getterReturnType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)getterReturnType, (Object)FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
                List<String> list3;
                FirAnnotationContainer firAnnotationContainer4;
                FirSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
                boolean $i$f$withSuppressedDiagnostics2 = false;
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer4 = (FirElement)getterReturnTypeRef instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)getterReturnTypeRef) : null;
                if (firAnnotationContainer4 == null) {
                    list3 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer6 = firAnnotationContainer4;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer6;
                    boolean bl6 = false;
                    list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv2 = list3;
                if (arguments$iv2 != null) {
                    CheckerContext it2 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    boolean bl7 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), propertyType, getterReturnType, context2, null, 32, null);
                } else {
                    CheckerContext it3 = context2;
                    boolean bl8 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), propertyType, getterReturnType, context2, null, 32, null);
                }
            }
        } else {
            FirTypeRef getterReturnTypeRef;
            CheckerContext it = context2;
            boolean bl = false;
            INSTANCE.checkAccessorForDelegatedProperty(property2, getter2, context2, reporter);
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility3 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)visibility3, (Object)$this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn$default(reporter, getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && INSTANCE.isLegallyAbstract(property2, context2)) {
                DiagnosticReporterKt.reportOn$default(reporter, getter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), context2, null, 8, null);
            }
            if ((($i$f$getVisibility = (getterReturnTypeRef = getter2.getReturnTypeRef()).getSource()) == null ? null : $i$f$getVisibility.getKind()) instanceof FirFakeSourceElementKind) {
                return;
            }
            ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
            if (propertyType instanceof ConeClassErrorType || getterReturnType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)getterReturnType, (Object)FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
                List<String> list4;
                FirAnnotationContainer firAnnotationContainer7;
                FirSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
                boolean $i$f$withSuppressedDiagnostics3 = false;
                FirAnnotationContainer firAnnotationContainer8 = firAnnotationContainer7 = (FirElement)getterReturnTypeRef instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)getterReturnTypeRef) : null;
                if (firAnnotationContainer7 == null) {
                    list4 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer9 = firAnnotationContainer7;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer9;
                    boolean bl11 = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv3 = list4;
                if (arguments$iv3 != null) {
                    CheckerContext it4 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                    boolean bl12 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), propertyType, getterReturnType, context2, null, 32, null);
                } else {
                    CheckerContext it5 = context2;
                    boolean bl13 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), propertyType, getterReturnType, context2, null, 32, null);
                }
            }
        }
    }

    private final void checkSetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor setter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)setter2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)setter2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
            boolean bl = false;
            boolean bl2 = false;
            FirAnnotationContainer it$iv = firAnnotationContainer3;
            boolean bl3 = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            boolean bl;
            FirValueParameter valueSetterParameter;
            CheckerContext it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl4 = false;
            if (property2.isVal()) {
                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), context2, null, 8, null);
            }
            INSTANCE.checkAccessorForDelegatedProperty(property2, setter2, context2, reporter);
            FirMemberDeclaration $this$visibility$iv = setter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            Integer visibilityCompareResult = visibility2.compareTo($this$visibility$iv.getStatus().getVisibility());
            if (visibilityCompareResult == null || visibilityCompareResult > 0) {
                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
                boolean isLegallyAbstract = INSTANCE.isLegallyAbstract(property2, context2);
                FirMemberDeclaration $this$visibility$iv2 = setter2;
                boolean $i$f$getVisibility2 = false;
                if (Intrinsics.areEqual((Object)((FirPropertyAccessor)$this$visibility$iv2).getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    $this$visibility$iv2 = property2;
                    $i$f$getVisibility2 = false;
                    if (!Intrinsics.areEqual((Object)$this$visibility$iv2.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                        if (isLegallyAbstract) {
                            DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), context2, null, 8, null);
                        } else {
                            FirMemberDeclaration $this$isOpen$iv = property2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
                                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), context2, null, 8, null);
                            }
                        }
                    }
                }
                if (isLegallyAbstract && setter2.getBody() != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), context2, null, 8, null);
                }
            }
            if ((valueSetterParameter = (FirValueParameter)CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            FirSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)valueSetterType, (Object)propertyType)) {
                boolean bl5;
                List<String> list3;
                FirAnnotationContainer firAnnotationContainer4;
                boolean $i$f$withSuppressedDiagnostics2 = false;
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer4 = (FirElement)valueSetterParameter instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)valueSetterParameter) : null;
                if (firAnnotationContainer4 == null) {
                    list3 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer6 = firAnnotationContainer4;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer6;
                    bl = false;
                    list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv2 = list3;
                if (arguments$iv2 != null) {
                    CheckerContext it2 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    bl5 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2, null, 32, null);
                } else {
                    CheckerContext it3 = context2;
                    bl5 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2, null, 32, null);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                List<String> list4;
                FirAnnotationContainer firAnnotationContainer7;
                FirElement element$iv = setter2.getReturnTypeRef();
                boolean $i$f$withSuppressedDiagnostics3 = false;
                FirAnnotationContainer firAnnotationContainer8 = firAnnotationContainer7 = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
                if (firAnnotationContainer7 == null) {
                    list4 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer9 = firAnnotationContainer7;
                    boolean it$iv = false;
                    bl = false;
                    FirAnnotationContainer it$iv2 = firAnnotationContainer9;
                    $i$a$-let-DiagnosticReporterKt$withSuppressedDiagnostics$arguments$1$iv = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv2);
                }
                List<String> arguments$iv3 = list4;
                if (arguments$iv3 != null) {
                    CheckerContext it4 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                    boolean bl8 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2, null, 8, null);
                } else {
                    CheckerContext it5 = context2;
                    boolean bl9 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2, null, 8, null);
                }
            }
        } else {
            FirElement element$iv;
            FirValueParameter valueSetterParameter;
            CheckerContext it = context2;
            boolean bl = false;
            if (property2.isVal()) {
                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), context2, null, 8, null);
            }
            INSTANCE.checkAccessorForDelegatedProperty(property2, setter2, context2, reporter);
            FirMemberDeclaration $this$visibility$iv = setter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility3 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            Integer visibilityCompareResult = visibility3.compareTo($this$visibility$iv.getStatus().getVisibility());
            if (visibilityCompareResult == null || visibilityCompareResult > 0) {
                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
                boolean isLegallyAbstract = INSTANCE.isLegallyAbstract(property2, context2);
                FirMemberDeclaration $this$visibility$iv3 = setter2;
                boolean $i$f$getVisibility3 = false;
                if (Intrinsics.areEqual((Object)((FirPropertyAccessor)$this$visibility$iv3).getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    $this$visibility$iv3 = property2;
                    $i$f$getVisibility3 = false;
                    if (!Intrinsics.areEqual((Object)$this$visibility$iv3.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                        if (isLegallyAbstract) {
                            DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), context2, null, 8, null);
                        } else {
                            FirMemberDeclaration $this$isOpen$iv = property2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
                                DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), context2, null, 8, null);
                            }
                        }
                    }
                }
                if (isLegallyAbstract && setter2.getBody() != null) {
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), context2, null, 8, null);
                }
            }
            if ((valueSetterParameter = (FirValueParameter)CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            FirSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)valueSetterType, (Object)propertyType)) {
                boolean bl10;
                List<String> list5;
                boolean $i$f$withSuppressedDiagnostics4 = false;
                FirElement firElement = element$iv = (FirElement)valueSetterParameter instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)valueSetterParameter) : null;
                if (element$iv == null) {
                    list5 = null;
                } else {
                    FirAnnotationContainer $i$f$withSuppressedDiagnostics3 = element$iv;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    FirAnnotationContainer it$iv = $i$f$withSuppressedDiagnostics3;
                    boolean bl13 = false;
                    list5 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv4 = list5;
                if (arguments$iv4 != null) {
                    CheckerContext it6 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv4, arguments$iv4.contains("infos"), arguments$iv4.contains("warnings"), arguments$iv4.contains("errors"));
                    bl10 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2, null, 32, null);
                } else {
                    CheckerContext it7 = context2;
                    bl10 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2, null, 32, null);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                List<String> list6;
                FirElement firElement;
                element$iv = setter2.getReturnTypeRef();
                boolean $i$f$withSuppressedDiagnostics5 = false;
                FirElement firElement2 = firElement = element$iv instanceof FirAnnotationContainer ? element$iv : null;
                if (firElement == null) {
                    list6 = null;
                } else {
                    FirElement firElement3 = firElement;
                    boolean bl14 = false;
                    boolean bl15 = false;
                    FirElement it$iv = firElement3;
                    boolean bl16 = false;
                    list6 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer((FirAnnotationContainer)it$iv);
                }
                List<String> arguments$iv5 = list6;
                if (arguments$iv5 != null) {
                    CheckerContext it8 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv5, arguments$iv5.contains("infos"), arguments$iv5.contains("warnings"), arguments$iv5.contains("errors"));
                    boolean bl17 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2, null, 8, null);
                } else {
                    CheckerContext it9 = context2;
                    boolean bl18 = false;
                    DiagnosticReporterKt.reportOn$default(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2, null, 8, null);
                }
            }
        }
    }

    private final void checkAccessorForDelegatedProperty(FirProperty property2, FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter) {
        FirSourceElement firSourceElement;
        if (property2.getDelegateFieldSymbol() != null && accessor.getBody() != null && !Intrinsics.areEqual((Object)((firSourceElement = accessor.getSource()) == null ? null : firSourceElement.getKind()), (Object)FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            DiagnosticReporterKt.reportOn$default(reporter, accessor.getSource(), FirErrors.INSTANCE.getACCESSOR_FOR_DELEGATED_PROPERTY(), context2, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLegallyAbstract(FirProperty property2, CheckerContext context2) {
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() != Modality.ABSTRACT) return false;
        boolean bl = true;
        if (!bl) return false;
        FirClass<?> firClass2 = FirHelpersKt.findClosestClassOrObject(context2);
        boolean bl2 = false;
        boolean bl3 = false;
        FirClass<?> it = firClass2;
        boolean bl4 = false;
        if (!(it instanceof FirRegularClass)) return false;
        FirRegularClass $this$canHaveAbstractDeclaration$iv = (FirRegularClass)it;
        boolean $i$f$getCanHaveAbstractDeclaration = false;
        FirRegularClass $this$isAbstract$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isAbstract2 = false;
        if ($this$isAbstract$iv$iv.getStatus().getModality() == Modality.ABSTRACT) {
            return true;
        }
        boolean bl5 = false;
        if (bl5) return true;
        FirRegularClass $this$isSealed$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isSealed = false;
        if ($this$isSealed$iv$iv.getStatus().getModality() == Modality.SEALED) {
            return true;
        }
        boolean bl6 = false;
        if (bl6) return true;
        FirClass $this$isEnumClass$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isEnumClass = false;
        if ($this$isEnumClass$iv$iv.getClassKind() != ClassKind.ENUM_CLASS) return false;
        return true;
    }
}

