/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.type;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.type.MapPsiToAsmDesc;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/type/MapPsiToAsmDesc;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "classDesc", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "error", "message", "methodDesc", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "primitive", "kotlin.jvm.PlatformType", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "typeDesc", "type", "Lcom/intellij/psi/PsiType;", "unknownSignature", "util"})
public final class MapPsiToAsmDesc {
    @NotNull
    public static final MapPsiToAsmDesc INSTANCE = new MapPsiToAsmDesc();
    @NotNull
    private static final Logger LOG;

    private MapPsiToAsmDesc() {
    }

    @NotNull
    public final String typeDesc(@NotNull PsiType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        PsiType psiType2 = type2;
        if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.VOID)) {
            Type type3 = Type.VOID_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"VOID_TYPE");
            Object object2 = this.primitive(type3);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"primitive(VOID_TYPE)");
            object = object2;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.BOOLEAN)) {
            Type type4 = Type.BOOLEAN_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"BOOLEAN_TYPE");
            String string2 = this.primitive(type4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primitive(BOOLEAN_TYPE)");
            object = string2;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.CHAR)) {
            Type type5 = Type.CHAR_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"CHAR_TYPE");
            String string3 = this.primitive(type5);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"primitive(CHAR_TYPE)");
            object = string3;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.INT)) {
            Type type6 = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"INT_TYPE");
            String string4 = this.primitive(type6);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"primitive(INT_TYPE)");
            object = string4;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.BYTE)) {
            Type type7 = Type.BYTE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"BYTE_TYPE");
            String string5 = this.primitive(type7);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"primitive(BYTE_TYPE)");
            object = string5;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.SHORT)) {
            Type type8 = Type.SHORT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type8, (String)"SHORT_TYPE");
            String string6 = this.primitive(type8);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"primitive(SHORT_TYPE)");
            object = string6;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.LONG)) {
            Type type9 = Type.LONG_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type9, (String)"LONG_TYPE");
            String string7 = this.primitive(type9);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"primitive(LONG_TYPE)");
            object = string7;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.FLOAT)) {
            Type type10 = Type.FLOAT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type10, (String)"FLOAT_TYPE");
            String string8 = this.primitive(type10);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"primitive(FLOAT_TYPE)");
            object = string8;
        } else if (Intrinsics.areEqual((Object)psiType2, (Object)PsiType.DOUBLE)) {
            Type type11 = Type.DOUBLE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type11, (String)"DOUBLE_TYPE");
            String string9 = this.primitive(type11);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"primitive(DOUBLE_TYPE)");
            object = string9;
        } else if (psiType2 instanceof PsiArrayType) {
            PsiType psiType3 = ((PsiArrayType)type2).getComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"type.componentType");
            object = Intrinsics.stringPlus((String)"[", (Object)this.typeDesc(psiType3));
        } else if (psiType2 instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)type2).resolve();
            PsiClass psiClass = resolved;
            if (psiClass instanceof PsiTypeParameter) {
                Object object3 = ((PsiTypeParameter)resolved).getSuperTypes();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"resolved.superTypes");
                PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])object3);
                if (psiClassType == null) {
                    object = "Ljava/lang/Object;";
                } else {
                    PsiClassType psiClassType2 = psiClassType;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiClassType it = psiClassType2;
                    boolean bl3 = false;
                    object3 = INSTANCE.typeDesc((PsiType)it);
                    object = object3 == null ? "Ljava/lang/Object;" : object3;
                }
            } else {
                object = psiClass != null ? this.classDesc(resolved) : this.unknownSignature();
            }
        } else {
            object = this.error("Unexpected type " + type2 + " of class " + type2.getClass());
        }
        return object;
    }

    private final String classDesc(PsiClass psiClass) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$classDesc_u24lambda_u2d2 = stringBuilder2;
        boolean bl5 = false;
        $this$classDesc_u24lambda_u2d2.append("L");
        List classes2 = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)psiClass, (Function1)classDesc.1.classes.1.INSTANCE)));
        String string2 = ((PsiClass)CollectionsKt.first((List)classes2)).getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classes.first().qualifiedName!!");
        $this$classDesc_u24lambda_u2d2.append(StringsKt.replace$default((String)string3, (String)".", (String)"/", (boolean)false, (int)4, null));
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)classes2, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiClass it = (PsiClass)element$iv;
            boolean bl6 = false;
            $this$classDesc_u24lambda_u2d2.append("$");
            String string4 = it.getName();
            Intrinsics.checkNotNull((Object)string4);
            $this$classDesc_u24lambda_u2d2.append(string4);
        }
        $this$classDesc_u24lambda_u2d2.append(";");
        String string5 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        return string5;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String methodDesc(@NotNull PsiMethod psiMethod) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$methodDesc_u24lambda_u2d5 = stringBuilder2;
        boolean bl5 = false;
        $this$methodDesc_u24lambda_u2d5.append("(");
        PsiType psiType2 = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"psiMethod.parameterList.parameters");
        PsiType $this$forEach$iv = psiType2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiParameter it = (PsiParameter)element$iv;
            boolean bl6 = false;
            PsiType psiType3 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"it.type");
            $this$methodDesc_u24lambda_u2d5.append(INSTANCE.typeDesc(psiType3));
        }
        $this$methodDesc_u24lambda_u2d5.append(")");
        StringBuilder stringBuilder3 = $this$methodDesc_u24lambda_u2d5;
        psiType2 = psiMethod.getReturnType();
        if (psiType2 == null) {
            string2 = "V";
        } else {
            void it;
            Object element$iv;
            PsiType psiType4 = psiType2;
            int n = 0;
            int n2 = 0;
            element$iv = psiType4;
            StringBuilder stringBuilder4 = stringBuilder3;
            boolean bl7 = false;
            String string3 = INSTANCE.typeDesc((PsiType)it);
            stringBuilder3 = stringBuilder4;
            String string4 = string3;
            string2 = string4 == null ? "V" : string4;
        }
        stringBuilder3.append(string2);
        String string5 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        return string5;
    }

    private final String unknownSignature() {
        return "";
    }

    private final String error(String message2) {
        LOG.error(message2);
        return this.unknownSignature();
    }

    private final String primitive(Type asmType) {
        return asmType.getDescriptor();
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(this::class.java)");
        LOG = logger;
    }
}

