/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionRenderer;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SubpackagesScope;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.renderer.AnnotationArgumentsRenderingPolicy;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.OverrideRenderingPolicy;
import org.jetbrains.kotlin.renderer.PropertyAccessorRenderingPolicy;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.util.DescriptorValidator;
import org.jetbrains.kotlin.utils.Printer;

public class RecursiveDescriptorComparator {
    private static final DescriptorRenderer DEFAULT_RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)options -> {
        options.setWithDefinedIn(false);
        options.setExcludedAnnotationClasses(Collections.singleton(new FqName("org.jetbrains.kotlin.jvm.compiler.annotation.ExpectLoadError")));
        options.setOverrideRenderingPolicy(OverrideRenderingPolicy.RENDER_OPEN_OVERRIDE);
        options.setIncludePropertyConstant(true);
        options.setClassifierNamePolicy(ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE);
        options.setVerbose(true);
        options.setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy.UNLESS_EMPTY);
        options.setModifiers(DescriptorRendererModifier.ALL);
        return Unit.INSTANCE;
    }));
    public static final Configuration DONT_INCLUDE_METHODS_OF_OBJECT = new Configuration(false, false, false, false, false, descriptor2 -> true, DescriptorValidator.ValidationVisitor.errorTypesForbidden(), DEFAULT_RENDERER);
    public static final Configuration RECURSIVE = new Configuration(false, false, true, false, false, descriptor2 -> true, DescriptorValidator.ValidationVisitor.errorTypesForbidden(), DEFAULT_RENDERER);
    public static final Configuration RECURSIVE_ALL = new Configuration(true, true, true, false, true, descriptor2 -> true, DescriptorValidator.ValidationVisitor.errorTypesForbidden(), DEFAULT_RENDERER);
    public static final Predicate<DeclarationDescriptor> SKIP_BUILT_INS_PACKAGES = descriptor2 -> {
        if (descriptor2 instanceof PackageViewDescriptor) {
            return !StandardNames.BUILT_INS_PACKAGE_FQ_NAME.equals(((PackageViewDescriptor)descriptor2).getFqName());
        }
        return true;
    };
    private static final ImmutableSet<String> KOTLIN_ANY_METHOD_NAMES = ImmutableSet.of((Object)"equals", (Object)"hashCode", (Object)"toString");
    private final Configuration conf;

    public RecursiveDescriptorComparator(@NotNull Configuration conf) {
        if (conf == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(0);
        }
        this.conf = conf;
    }

    public String serializeRecursively(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        this.appendDeclarationRecursively(declarationDescriptor, DescriptorUtils.getContainingModule(declarationDescriptor), new Printer((Appendable)result2, 1), true);
        return result2.toString();
    }

    private void appendDeclarationRecursively(@NotNull DeclarationDescriptor descriptor2, @NotNull ModuleDescriptor module2, @NotNull Printer printer, boolean topLevel) {
        if (descriptor2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(2);
        }
        if (module2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(3);
        }
        if (printer == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(4);
        }
        if (!this.isFromModule(descriptor2, module2)) {
            return;
        }
        boolean isEnumEntry = DescriptorUtils.isEnumEntry(descriptor2);
        boolean isClassOrPackage = (descriptor2 instanceof ClassOrPackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) && !isEnumEntry;
        StringBuilder content = new StringBuilder();
        if (isClassOrPackage) {
            Printer child = new Printer((Appendable)content, printer);
            if (!topLevel) {
                child.pushIndent();
            }
            if (descriptor2 instanceof ClassDescriptor) {
                ClassDescriptor klass = (ClassDescriptor)descriptor2;
                this.appendSubDescriptors(descriptor2, module2, klass.getDefaultType().getMemberScope(), klass.getConstructors(), child);
                MemberScope staticScope = klass.getStaticScope();
                if (!DescriptorUtils.getAllDescriptors(staticScope).isEmpty()) {
                    child.println(new Object[0]);
                    child.println("// Static members");
                    this.appendSubDescriptors(descriptor2, module2, staticScope, Collections.emptyList(), child);
                }
            } else if (descriptor2 instanceof PackageFragmentDescriptor) {
                this.appendSubDescriptors(descriptor2, module2, ((PackageFragmentDescriptor)descriptor2).getMemberScope(), Collections.emptyList(), child);
            } else if (descriptor2 instanceof PackageViewDescriptor) {
                this.appendSubDescriptors(descriptor2, module2, this.getPackageScopeInModule((PackageViewDescriptor)descriptor2, module2), Collections.emptyList(), child);
            }
            if (!topLevel) {
                if (child.isEmpty() && (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor)) {
                    return;
                }
                printer.println(new Object[0]);
            }
        }
        this.printDescriptor(descriptor2, printer);
        if (isClassOrPackage) {
            if (!topLevel) {
                printer.printlnWithNoIndent(" {");
                printer.printWithNoIndent(content);
                printer.println("}");
            } else {
                printer.println(new Object[0]);
                printer.println(new Object[0]);
                printer.printWithNoIndent(StringsKt.trimStart((CharSequence)content, (char[])Printer.LINE_SEPARATOR.toCharArray()));
            }
        } else if (this.conf.checkPropertyAccessors && descriptor2 instanceof PropertyDescriptor) {
            PropertySetterDescriptor setter2;
            printer.printlnWithNoIndent(new Object[0]);
            printer.pushIndent();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
            if (getter2 != null) {
                printer.println(this.conf.renderer.render(getter2));
            }
            if ((setter2 = propertyDescriptor.getSetter()) != null) {
                printer.println(this.conf.renderer.render(setter2));
            }
            printer.popIndent();
        } else {
            printer.printlnWithNoIndent(new Object[0]);
        }
        if (isEnumEntry) {
            printer.println(new Object[0]);
        }
    }

    private void printDescriptor(@NotNull DeclarationDescriptor descriptor2, @NotNull Printer printer) {
        if (descriptor2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(6);
        }
        boolean isPrimaryConstructor = this.conf.checkPrimaryConstructors && descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary();
        boolean isRecord = descriptor2 instanceof JavaClassDescriptor && ((JavaClassDescriptor)descriptor2).isRecord();
        boolean isRecordComponent = descriptor2 instanceof JavaMethodDescriptor && ((JavaMethodDescriptor)descriptor2).isForRecordComponent();
        StringBuilder prefix = new StringBuilder();
        if (isPrimaryConstructor) {
            prefix.append("/*primary*/ ");
        }
        if (isRecord) {
            prefix.append("/*record*/ ");
        }
        if (isRecordComponent) {
            prefix.append("/*record component*/ ");
        }
        printer.print(prefix.toString(), this.conf.renderer.render(descriptor2));
        if (descriptor2 instanceof FunctionDescriptor && this.conf.checkFunctionContracts) {
            RecursiveDescriptorComparator.printEffectsIfAny((FunctionDescriptor)descriptor2, printer);
        }
    }

    private static void printEffectsIfAny(FunctionDescriptor functionDescriptor, Printer printer) {
        AbstractContractProvider contractProvider = functionDescriptor.getUserData(ContractProviderKey.INSTANCE);
        if (contractProvider == null) {
            return;
        }
        ContractDescription contractDescription = contractProvider.getContractDescription();
        if (contractDescription == null || contractDescription.getEffects().isEmpty()) {
            return;
        }
        printer.println(new Object[0]);
        printer.pushIndent();
        for (EffectDeclaration effect : contractDescription.getEffects()) {
            StringBuilder sb = new StringBuilder();
            ContractDescriptionRenderer renderer = new ContractDescriptionRenderer(sb);
            effect.accept(renderer, Unit.INSTANCE);
            printer.println(sb.toString());
        }
        printer.popIndent();
    }

    @NotNull
    private MemberScope getPackageScopeInModule(@NotNull PackageViewDescriptor descriptor2, @NotNull ModuleDescriptor module2) {
        if (descriptor2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(7);
        }
        if (module2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(8);
        }
        ArrayList<MemberScope> scopes = new ArrayList<MemberScope>();
        for (PackageFragmentDescriptor fragment : descriptor2.getFragments()) {
            if (!this.isFromModule(fragment, module2)) continue;
            scopes.add(fragment.getMemberScope());
        }
        scopes.add(new SubpackagesScope(module2, descriptor2.getFqName()));
        MemberScope memberScope2 = ChainedMemberScope.Companion.create("test", scopes);
        if (memberScope2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(9);
        }
        return memberScope2;
    }

    private boolean isFromModule(@NotNull DeclarationDescriptor descriptor2, @NotNull ModuleDescriptor module2) {
        if (descriptor2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(10);
        }
        if (module2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(11);
        }
        if (this.conf.renderDeclarationsFromOtherModules) {
            return true;
        }
        if (descriptor2 instanceof PackageViewDescriptor) {
            for (PackageFragmentDescriptor fragment : ((PackageViewDescriptor)descriptor2).getFragments()) {
                if (!module2.equals(DescriptorUtils.getContainingModule(fragment))) continue;
                return true;
            }
        }
        if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect() && !TargetPlatformKt.isCommon(module2.getPlatform())) {
            return false;
        }
        return module2.equals(DescriptorUtils.getContainingModule(descriptor2));
    }

    private boolean shouldSkip(@NotNull DeclarationDescriptor subDescriptor) {
        if (subDescriptor == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(12);
        }
        boolean isFunctionFromAny = subDescriptor.getContainingDeclaration() instanceof ClassDescriptor && subDescriptor instanceof FunctionDescriptor && KOTLIN_ANY_METHOD_NAMES.contains((Object)subDescriptor.getName().asString());
        return isFunctionFromAny && !this.conf.includeMethodsOfKotlinAny || !this.conf.recursiveFilter.test(subDescriptor);
    }

    private void appendSubDescriptors(@NotNull DeclarationDescriptor descriptor2, @NotNull ModuleDescriptor module2, @NotNull MemberScope memberScope2, @NotNull Collection<? extends DeclarationDescriptor> extraSubDescriptors, @NotNull Printer printer) {
        if (descriptor2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(13);
        }
        if (module2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(14);
        }
        if (memberScope2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(15);
        }
        if (extraSubDescriptors == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(16);
        }
        if (printer == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(17);
        }
        if (!this.isFromModule(descriptor2, module2)) {
            return;
        }
        ArrayList subDescriptors = Lists.newArrayList();
        subDescriptors.addAll(DescriptorUtils.getAllDescriptors(memberScope2));
        subDescriptors.addAll(extraSubDescriptors);
        subDescriptors.sort(MemberComparator.INSTANCE);
        for (DeclarationDescriptor subDescriptor : subDescriptors) {
            if (this.shouldSkip(subDescriptor)) continue;
            this.appendDeclarationRecursively(subDescriptor, module2, printer, false);
        }
    }

    private static void compareDescriptorWithFile(@NotNull DeclarationDescriptor actual, @NotNull Configuration configuration2, @NotNull File txtFile, @NotNull Assertions assertions) {
        if (actual == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(18);
        }
        if (configuration2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(19);
        }
        if (txtFile == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(20);
        }
        if (assertions == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(21);
        }
        RecursiveDescriptorComparator.doCompareDescriptors(null, actual, configuration2, txtFile, assertions);
    }

    public static void compareDescriptors(@NotNull DeclarationDescriptor expected, @NotNull DeclarationDescriptor actual, @NotNull Configuration configuration2, @Nullable File txtFile, @NotNull Assertions assertions) {
        if (expected == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(22);
        }
        if (actual == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(23);
        }
        if (configuration2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(24);
        }
        if (assertions == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(25);
        }
        if (expected == actual) {
            throw new IllegalArgumentException("Don't invoke this method with expected == actual.Invoke compareDescriptorWithFile() instead.");
        }
        RecursiveDescriptorComparator.doCompareDescriptors(expected, actual, configuration2, txtFile, assertions);
    }

    public static void validateAndCompareDescriptorWithFile(@NotNull DeclarationDescriptor actual, @NotNull Configuration configuration2, @NotNull File txtFile, @NotNull Assertions assertions) {
        if (actual == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(26);
        }
        if (configuration2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(27);
        }
        if (txtFile == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(28);
        }
        if (assertions == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(29);
        }
        DescriptorValidator.validate(configuration2.validationStrategy, actual);
        RecursiveDescriptorComparator.compareDescriptorWithFile(actual, configuration2, txtFile, assertions);
    }

    public static void validateAndCompareDescriptors(@NotNull DeclarationDescriptor expected, @NotNull DeclarationDescriptor actual, @NotNull Configuration configuration2, @Nullable File txtFile, @NotNull Assertions assertions) {
        if (expected == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(30);
        }
        if (actual == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(31);
        }
        if (configuration2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(32);
        }
        if (assertions == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(33);
        }
        DescriptorValidator.validate(configuration2.validationStrategy, expected);
        DescriptorValidator.validate(configuration2.validationStrategy, actual);
        RecursiveDescriptorComparator.compareDescriptors(expected, actual, configuration2, txtFile, assertions);
    }

    private static void doCompareDescriptors(@Nullable DeclarationDescriptor expected, @NotNull DeclarationDescriptor actual, @NotNull Configuration configuration2, @Nullable File txtFile, @NotNull Assertions assertions) {
        if (actual == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(34);
        }
        if (configuration2 == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(35);
        }
        if (assertions == null) {
            RecursiveDescriptorComparator.$$$reportNull$$$0(36);
        }
        RecursiveDescriptorComparator comparator = new RecursiveDescriptorComparator(configuration2);
        String actualSerialized = comparator.serializeRecursively(actual);
        if (expected != null) {
            String expectedSerialized = comparator.serializeRecursively(expected);
            assertions.assertEquals(expectedSerialized, actualSerialized, (Function0<String>)((Function0)() -> "Expected and actual descriptors differ"));
        }
        if (txtFile != null) {
            assertions.assertEqualsToFile(txtFile, actualSerialized, (Function1<? super String, String>)((Function1)s -> s));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/util/RecursiveDescriptorComparator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDescriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberScope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSubDescriptors";
                break;
            }
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "txtFile";
                break;
            }
            case 21: 
            case 25: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertions";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/util/RecursiveDescriptorComparator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScopeInModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "serializeRecursively";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendDeclarationRecursively";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScopeInModule";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFromModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkip";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendSubDescriptors";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compareDescriptorWithFile";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compareDescriptors";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "validateAndCompareDescriptorWithFile";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "validateAndCompareDescriptors";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doCompareDescriptors";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Configuration {
        private final boolean checkPrimaryConstructors;
        private final boolean checkPropertyAccessors;
        private final boolean includeMethodsOfKotlinAny;
        private final boolean renderDeclarationsFromOtherModules;
        private final boolean checkFunctionContracts;
        private final Predicate<DeclarationDescriptor> recursiveFilter;
        private final DescriptorRenderer renderer;
        private final DescriptorValidator.ValidationVisitor validationStrategy;

        public Configuration(boolean checkPrimaryConstructors, boolean checkPropertyAccessors, boolean includeMethodsOfKotlinAny, boolean renderDeclarationsFromOtherModules, boolean checkFunctionContracts, Predicate<DeclarationDescriptor> recursiveFilter, DescriptorValidator.ValidationVisitor validationStrategy, DescriptorRenderer renderer) {
            this.checkPrimaryConstructors = checkPrimaryConstructors;
            this.checkPropertyAccessors = checkPropertyAccessors;
            this.includeMethodsOfKotlinAny = includeMethodsOfKotlinAny;
            this.renderDeclarationsFromOtherModules = renderDeclarationsFromOtherModules;
            this.checkFunctionContracts = checkFunctionContracts;
            this.recursiveFilter = recursiveFilter;
            this.validationStrategy = validationStrategy;
            this.renderer = Configuration.rendererWithPropertyAccessors(renderer, checkPropertyAccessors);
        }

        public Configuration filterRecursion(@NotNull Predicate<DeclarationDescriptor> stepIntoFilter) {
            if (stepIntoFilter == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, stepIntoFilter, this.validationStrategy.withStepIntoFilter(stepIntoFilter), this.renderer);
        }

        public Configuration checkPrimaryConstructors(boolean checkPrimaryConstructors) {
            return new Configuration(checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, this.renderer);
        }

        public Configuration checkPropertyAccessors(boolean checkPropertyAccessors) {
            return new Configuration(this.checkPrimaryConstructors, checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, Configuration.rendererWithPropertyAccessors(this.renderer, checkPropertyAccessors));
        }

        public Configuration checkFunctionContracts(boolean checkFunctionContracts) {
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, checkFunctionContracts, this.recursiveFilter, this.validationStrategy, this.renderer);
        }

        public Configuration includeMethodsOfKotlinAny(boolean includeMethodsOfKotlinAny) {
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, this.renderer);
        }

        public Configuration renderDeclarationsFromOtherModules(boolean renderDeclarationsFromOtherModules) {
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, this.renderer);
        }

        public Configuration withValidationStrategy(@NotNull DescriptorValidator.ValidationVisitor validationStrategy) {
            if (validationStrategy == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, validationStrategy, this.renderer);
        }

        public Configuration withRenderer(@NotNull DescriptorRenderer renderer) {
            if (renderer == null) {
                Configuration.$$$reportNull$$$0(2);
            }
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, renderer);
        }

        public Configuration withRendererOptions(@NotNull Consumer<DescriptorRendererOptions> configure2) {
            if (configure2 == null) {
                Configuration.$$$reportNull$$$0(3);
            }
            return new Configuration(this.checkPrimaryConstructors, this.checkPropertyAccessors, this.includeMethodsOfKotlinAny, this.renderDeclarationsFromOtherModules, this.checkFunctionContracts, this.recursiveFilter, this.validationStrategy, Configuration.newRenderer(this.renderer, configure2));
        }

        @NotNull
        private static DescriptorRenderer rendererWithPropertyAccessors(@NotNull DescriptorRenderer renderer, boolean checkPropertyAccessors) {
            if (renderer == null) {
                Configuration.$$$reportNull$$$0(4);
            }
            return Configuration.newRenderer(renderer, options -> options.setPropertyAccessorRenderingPolicy(checkPropertyAccessors ? PropertyAccessorRenderingPolicy.DEBUG : PropertyAccessorRenderingPolicy.NONE));
        }

        @NotNull
        private static DescriptorRenderer newRenderer(@NotNull DescriptorRenderer renderer, @NotNull Consumer<DescriptorRendererOptions> configure2) {
            if (renderer == null) {
                Configuration.$$$reportNull$$$0(5);
            }
            if (configure2 == null) {
                Configuration.$$$reportNull$$$0(6);
            }
            DescriptorRenderer descriptorRenderer2 = renderer.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)options -> {
                configure2.accept((DescriptorRendererOptions)options);
                return Unit.INSTANCE;
            }));
            if (descriptorRenderer2 == null) {
                Configuration.$$$reportNull$$$0(7);
            }
            return descriptorRenderer2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stepIntoFilter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "validationStrategy";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configure";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "filterRecursion";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withValidationStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withRendererOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "rendererWithPropertyAccessors";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "newRenderer";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

