/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.generators;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.MethodGenerator;
import org.jetbrains.kotlin.generators.TestGenerator;
import org.jetbrains.kotlin.generators.TestGroup;
import org.jetbrains.kotlin.generators.model.AnnotationModel;
import org.jetbrains.kotlin.generators.model.DelegatingTestClassModel;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.model.RunTestMethodModel;
import org.jetbrains.kotlin.generators.model.TestClassModel;
import org.jetbrains.kotlin.generators.model.TestEntityModel;
import org.jetbrains.kotlin.generators.util.GeneratorsFileUtil;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.generators.NewTestGeneratorImplKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.Printer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u000e*\u00020\u000fH\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u000fH\u0002J\u0014\u0010\u0019\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/generators/NewTestGeneratorImpl;", "Lorg/jetbrains/kotlin/generators/TestGenerator;", "()V", "GENERATED_FILES", "Ljava/util/HashSet;", "", "generateAndSave", "Lorg/jetbrains/kotlin/generators/TestGenerator$GenerationResult;", "testClass", "Lorg/jetbrains/kotlin/generators/TestGroup$TestClass;", "Lorg/jetbrains/kotlin/generators/TestGroup;", "dryRun", "", "generateMetadata", "", "Lorg/jetbrains/kotlin/utils/Printer;", "testDataSource", "Lorg/jetbrains/kotlin/generators/model/TestEntityModel;", "generateNestedAnnotation", "isNested", "generateParameterAnnotations", "testClassModel", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "generateSuppressAllWarnings", "generateTestAnnotation", "generateTestDataPath", "TestGeneratorInstance", "tests-common-new"})
public final class NewTestGeneratorImpl
extends TestGenerator {
    @NotNull
    public static final NewTestGeneratorImpl INSTANCE = new NewTestGeneratorImpl();
    @NotNull
    private static final HashSet<String> GENERATED_FILES = new HashSet();

    private NewTestGeneratorImpl() {
        super(NewTestGeneratorImplKt.access$getMETHOD_GENERATORS$p());
    }

    private final void generateMetadata(Printer $this$generateMetadata, TestEntityModel testDataSource) {
        String dataString = testDataSource.getDataString();
        if (dataString != null) {
            Object[] objectArray = new Object[]{"@TestMetadata(\"", dataString, "\")"};
            $this$generateMetadata.println(objectArray);
        }
    }

    private final void generateTestAnnotation(Printer $this$generateTestAnnotation) {
        Object[] objectArray = new Object[]{"@Test"};
        $this$generateTestAnnotation.println(objectArray);
    }

    private final void generateNestedAnnotation(Printer $this$generateNestedAnnotation, boolean isNested) {
        if (isNested) {
            Object[] objectArray = new Object[]{"@Nested"};
            $this$generateNestedAnnotation.println(objectArray);
        }
    }

    private final void generateTestDataPath(Printer $this$generateTestDataPath, TestClassModel testClassModel) {
        String dataPathRoot = testClassModel.getDataPathRoot();
        if (dataPathRoot != null) {
            Object[] objectArray = new Object[]{"@TestDataPath(\"", dataPathRoot, "\")"};
            $this$generateTestDataPath.println(objectArray);
        }
    }

    private final void generateParameterAnnotations(Printer $this$generateParameterAnnotations, TestClassModel testClassModel) {
        for (AnnotationModel annotationModel : testClassModel.getAnnotations()) {
            annotationModel.generate($this$generateParameterAnnotations);
            $this$generateParameterAnnotations.println(new Object[0]);
        }
    }

    private final void generateSuppressAllWarnings(Printer $this$generateSuppressAllWarnings) {
        Object[] objectArray = new Object[]{"@SuppressWarnings(\"all\")"};
        $this$generateSuppressAllWarnings.println(objectArray);
    }

    @NotNull
    public TestGenerator.GenerationResult generateAndSave(@NotNull TestGroup.TestClass testClass, boolean dryRun) {
        Intrinsics.checkNotNullParameter((Object)testClass, (String)"testClass");
        TestGeneratorInstance generatorInstance = new TestGeneratorInstance(testClass.getBaseDir(), testClass.getSuiteTestClassName(), testClass.getBaseTestClassName(), testClass.getTestModels(), this.getMethodGenerators());
        return generatorInstance.generateAndSave(dryRun);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\u00020\u0019\"\b\b\u0000\u0010\"*\u00020 *\b\u0012\u0004\u0012\u0002H\"0\f2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010$\u001a\u00020\u0019\"\b\b\u0000\u0010\"*\u00020 *\b\u0012\u0004\u0012\u0002H\"0\f2\u0006\u0010#\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/test/generators/NewTestGeneratorImpl$TestGeneratorInstance;", "", "baseDir", "", "suiteTestClassFqName", "baseTestClassFqName", "testClassModels", "", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "methodGenerators", "", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "Lorg/jetbrains/kotlin/generators/MethodGenerator;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;Ljava/util/Map;)V", "baseTestClassName", "baseTestClassPackage", "suiteClassName", "suiteClassPackage", "testSourceFilePath", "generate", "generateAndSave", "Lorg/jetbrains/kotlin/generators/TestGenerator$GenerationResult;", "dryRun", "", "generateTestClass", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "testClassModel", "isNested", "generateTestMethod", "methodModel", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "hackyGenerateBody", "T", "method", "hackyGenerateSignature", "tests-common-new"})
    private static final class TestGeneratorInstance {
        @NotNull
        private final Collection<TestClassModel> testClassModels;
        @NotNull
        private final Map<MethodModel.Kind, MethodGenerator<?>> methodGenerators;
        @NotNull
        private final String baseTestClassPackage;
        @NotNull
        private final String baseTestClassName;
        @NotNull
        private final String suiteClassPackage;
        @NotNull
        private final String suiteClassName;
        @NotNull
        private final String testSourceFilePath;

        public TestGeneratorInstance(@NotNull String baseDir, @NotNull String suiteTestClassFqName, @NotNull String baseTestClassFqName, @NotNull Collection<? extends TestClassModel> testClassModels, @NotNull Map<MethodModel.Kind, ? extends MethodGenerator<?>> methodGenerators) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)suiteTestClassFqName, (String)"suiteTestClassFqName");
            Intrinsics.checkNotNullParameter((Object)baseTestClassFqName, (String)"baseTestClassFqName");
            Intrinsics.checkNotNullParameter(testClassModels, (String)"testClassModels");
            Intrinsics.checkNotNullParameter(methodGenerators, (String)"methodGenerators");
            this.testClassModels = testClassModels;
            this.methodGenerators = methodGenerators;
            this.baseTestClassPackage = StringsKt.substringBeforeLast((String)baseTestClassFqName, (char)'.', (String)"");
            this.baseTestClassName = StringsKt.substringAfterLast((String)baseTestClassFqName, (char)'.', (String)baseTestClassFqName);
            this.suiteClassPackage = StringsKt.substringBeforeLast((String)suiteTestClassFqName, (char)'.', (String)this.baseTestClassPackage);
            this.suiteClassName = StringsKt.substringAfterLast((String)suiteTestClassFqName, (char)'.', (String)suiteTestClassFqName);
            this.testSourceFilePath = baseDir + '/' + StringsKt.replace$default((String)this.suiteClassPackage, (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + this.suiteClassName + ".java";
            if (!GENERATED_FILES.add(this.testSourceFilePath)) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Same test file already generated in current session: ", (Object)this.testSourceFilePath));
            }
        }

        @NotNull
        public final TestGenerator.GenerationResult generateAndSave(boolean dryRun) throws IOException {
            String generatedCode = this.generate();
            File testSourceFile = new File(this.testSourceFilePath);
            boolean changed = GeneratorsFileUtil.INSTANCE.isFileContentChangedIgnoringLineSeparators(testSourceFile, generatedCode);
            if (!dryRun) {
                GeneratorsFileUtil.writeFileIfContentChanged$default((File)testSourceFile, (String)generatedCode, (boolean)false, (boolean)false, (int)8, null);
            }
            return new TestGenerator.GenerationResult(changed, this.testSourceFilePath);
        }

        /*
         * WARNING - void declaration
         */
        private final String generate() {
            void destination$iv;
            void $this$flatMapTo$iv;
            StringBuilder out = new StringBuilder();
            Printer p = new Printer(out);
            String copyright = FilesKt.readText$default((File)new File("license/COPYRIGHT_HEADER.txt"), null, (int)1, null);
            Object object = new Object[]{copyright};
            p.println((Object[])object);
            p.println(new Object[0]);
            object = new Object[]{"package " + this.suiteClassPackage + ';'};
            p.println((Object[])object);
            p.println(new Object[0]);
            object = new Object[]{"import com.intellij.testFramework.TestDataPath;"};
            p.println((Object[])object);
            object = new Object[]{"import " + KtTestUtil.class.getCanonicalName() + ';'};
            p.println((Object[])object);
            Object object2 = this.testClassModels;
            boolean bl = false;
            Object[] objectArray = (Object[])new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                TestClassModel classModel = (TestClassModel)element$iv;
                boolean bl2 = false;
                Iterable list$iv = classModel.getImports();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            for (Class clazz : (Set)destination$iv) {
                objectArray = new Object[]{"import " + clazz.getName() + ';'};
                p.println(objectArray);
            }
            if (!Intrinsics.areEqual((Object)this.suiteClassPackage, (Object)this.baseTestClassPackage)) {
                object = new Object[]{"import " + this.baseTestClassPackage + '.' + this.baseTestClassName + ';'};
                p.println((Object[])object);
            }
            object = new Object[]{"import " + TestMetadata.class.getCanonicalName() + ';'};
            p.println((Object[])object);
            object = new Object[]{"import " + Nested.class.getCanonicalName() + ';'};
            p.println((Object[])object);
            object = new Object[]{"import " + Test.class.getCanonicalName() + ';'};
            p.println((Object[])object);
            p.println(new Object[0]);
            object = new Object[]{"import java.io.File;"};
            p.println((Object[])object);
            object = new Object[]{"import java.util.regex.Pattern;"};
            p.println((Object[])object);
            p.println(new Object[0]);
            object = new Object[]{"/** This class is generated by {@link ", "GenerateNewCompilerTests.kt", "}. DO NOT MODIFY MANUALLY */"};
            p.println((Object[])object);
            INSTANCE.generateSuppressAllWarnings(p);
            TestClassModel model = null;
            if (this.testClassModels.size() == 1) {
                object2 = (TestClassModel)CollectionsKt.single((Iterable)this.testClassModels);
                model = (TestClassModel)new DelegatingTestClassModel(this, (TestClassModel)object2){
                    final /* synthetic */ TestGeneratorInstance this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    @NotNull
                    public String getName() {
                        return TestGeneratorInstance.access$getSuiteClassName$p(this.this$0);
                    }
                };
            } else {
                model = new TestClassModel(this){
                    final /* synthetic */ TestGeneratorInstance this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public Collection<TestClassModel> getInnerTestClasses() {
                        return TestGeneratorInstance.access$getTestClassModels$p(this.this$0);
                    }

                    @NotNull
                    public Collection<MethodModel> getMethods() {
                        return CollectionsKt.emptyList();
                    }

                    public boolean isEmpty() {
                        return false;
                    }

                    @NotNull
                    public String getName() {
                        return TestGeneratorInstance.access$getSuiteClassName$p(this.this$0);
                    }

                    @Nullable
                    public String getDataString() {
                        return null;
                    }

                    @Nullable
                    public String getDataPathRoot() {
                        return null;
                    }

                    @NotNull
                    public Collection<AnnotationModel> getAnnotations() {
                        return CollectionsKt.emptyList();
                    }

                    @NotNull
                    public Set<Class<?>> getImports() {
                        return super.getImports();
                    }
                };
            }
            this.generateTestClass(p, model, false);
            object2 = out.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"out.toString()");
            return object2;
        }

        private final void generateTestClass(Printer p, TestClassModel testClassModel, boolean isNested) {
            INSTANCE.generateNestedAnnotation(p, isNested);
            INSTANCE.generateMetadata(p, (TestEntityModel)testClassModel);
            INSTANCE.generateTestDataPath(p, testClassModel);
            INSTANCE.generateParameterAnnotations(p, testClassModel);
            String extendsClause = !isNested ? Intrinsics.stringPlus((String)" extends ", (Object)this.baseTestClassName) : "";
            Object[] objectArray = new Object[]{"public class " + testClassModel.getName() + extendsClause + " {"};
            p.println(objectArray);
            p.pushIndent();
            Collection testMethods = testClassModel.getMethods();
            Collection innerTestClasses = testClassModel.getInnerTestClasses();
            boolean first = true;
            for (MethodModel methodModel : testMethods) {
                if (methodModel instanceof RunTestMethodModel || !methodModel.shouldBeGenerated()) continue;
                if (first) {
                    first = false;
                } else {
                    p.println(new Object[0]);
                }
                this.generateTestMethod(p, methodModel);
            }
            for (TestClassModel innerTestClass : innerTestClasses) {
                if (innerTestClass.isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    p.println(new Object[0]);
                }
                this.generateTestClass(p, innerTestClass, true);
            }
            p.popIndent();
            Object[] objectArray2 = new Object[]{"}"};
            p.println(objectArray2);
        }

        private final void generateTestMethod(Printer p, MethodModel methodModel) {
            MethodGenerator generator2 = (MethodGenerator)MapsKt.getValue(this.methodGenerators, (Object)methodModel.getKind());
            INSTANCE.generateTestAnnotation(p);
            INSTANCE.generateMetadata(p, (TestEntityModel)methodModel);
            this.hackyGenerateSignature(generator2, methodModel, p);
            Object[] objectArray = new Object[]{" {"};
            p.printWithNoIndent(objectArray);
            p.println(new Object[0]);
            p.pushIndent();
            this.hackyGenerateBody(generator2, methodModel, p);
            p.popIndent();
            objectArray = new Object[]{"}"};
            p.println(objectArray);
        }

        private final <T extends MethodModel> void hackyGenerateBody(MethodGenerator<? super T> $this$hackyGenerateBody, MethodModel method, Printer p) {
            $this$hackyGenerateBody.generateBody(method, p);
        }

        private final <T extends MethodModel> void hackyGenerateSignature(MethodGenerator<? super T> $this$hackyGenerateSignature, MethodModel method, Printer p) {
            $this$hackyGenerateSignature.generateSignature(method, p);
        }

        public static final /* synthetic */ String access$getSuiteClassName$p(TestGeneratorInstance $this) {
            return $this.suiteClassName;
        }

        public static final /* synthetic */ Collection access$getTestClassModels$p(TestGeneratorInstance $this) {
            return $this.testClassModels;
        }
    }
}

