/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumperImpl;
import org.jetbrains.kotlin.util.SmartPrinter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\r*\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J,\u0010\u001b\u001a\u00020\r*\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\"\u001a\u00020\r*\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010'\u001a\u00020\r*\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0002J\u001c\u0010*\u001a\u00020\r*\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020&H\u0002J$\u0010+\u001a\u00020\r*\u00020\u00162\u0006\u0010#\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directivesContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectivesContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumperImpl;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "printInfo", "Lorg/jetbrains/kotlin/util/SmartPrinter;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "counter", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler$SymbolCounter;", "processClass", "fqName", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "processFunction", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "processFunctions", "name", "Lorg/jetbrains/kotlin/name/Name;", "processProperties", "processProperty", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "SymbolCounter", "tests-common-new"})
public final class FirScopeDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumperImpl dumper;

    public FirScopeDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumperImpl(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectivesContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module2, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List<String> fqNames = module2.getDirectives().get(FirDiagnosticsDirectives.INSTANCE.getSCOPE_DUMP());
        if (fqNames.isEmpty()) {
            return;
        }
        SmartPrinter printer = new SmartPrinter(this.dumper.builderForModule(module2), "  ");
        for (String fqName2 : fqNames) {
            this.processClass(printer, fqName2, info.getSession(), info.getFirAnalyzerFacade().getScopeSession(), module2);
        }
    }

    private final void processClass(SmartPrinter $this$processClass, String fqName2, FirSession session2, ScopeSession scopeSession, TestModule module2) {
        Object[] objectArray;
        Object object = new String[]{"."};
        ClassId classId = ClassId.topLevel(FqName.fromSegments(StringsKt.split$default((CharSequence)fqName2, (String[])object, (boolean)false, (int)0, (int)6, null)));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName.fromSegments(fqName.split(\".\")))");
        ClassId classId2 = classId;
        object = MainSessionComponentsKt.getSymbolProvider(session2).getClassLikeSymbolByFqName(classId2);
        if (object == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(fqName2, module2){
                final /* synthetic */ String $fqName;
                final /* synthetic */ TestModule $module;
                {
                    this.$fqName = $fqName;
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Class " + this.$fqName + " not found in module " + this.$module.getName();
                }
            }));
            throw null;
        }
        Object symbol2 = object;
        Object e = ((AbstractFirBasedSymbol)symbol2).getFir();
        Object[] objectArray2 = objectArray = e instanceof FirRegularClass ? (Object[])e : null;
        if (objectArray == null) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(fqName2, symbol2){
                final /* synthetic */ String $fqName;
                final /* synthetic */ FirClassLikeSymbol<?> $symbol;
                {
                    this.$fqName = $fqName;
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$fqName + " is not a class but " + FirRendererKt.render$default((FirElement)this.$symbol.getFir(), null, 1, null);
                }
            }));
            throw null;
        }
        Object[] firClass2 = objectArray;
        objectArray = new Object[]{Intrinsics.stringPlus((String)fqName2, (Object)": ")};
        $this$processClass.println(objectArray);
        FirTypeScope scope2 = FirKotlinScopeProviderKt.unsubstitutedScope((FirClass)firClass2, session2, scopeSession, true);
        Set<Name> names2 = scope2.getCallableNames();
        SmartPrinter $this$withIndent$iv = $this$processClass;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        boolean bl = false;
        for (Name name2 : names2) {
            this.processFunctions($this$processClass, name2, scope2);
            this.processProperties($this$processClass, name2, scope2);
        }
        $this$withIndent$iv.popIndent();
        $this$processClass.println(new Object[0]);
    }

    private final void processFunctions(SmartPrinter $this$processFunctions, Name name2, FirTypeScope scope2) {
        List<FirNamedFunctionSymbol> functions2 = FirScopeKt.getFunctions(scope2, name2);
        for (FirNamedFunctionSymbol function2 : functions2) {
            this.processFunction($this$processFunctions, function2, scope2, new SymbolCounter());
            $this$processFunctions.println(new Object[0]);
        }
    }

    private final void processFunction(SmartPrinter $this$processFunction, FirNamedFunctionSymbol symbol2, FirTypeScope scope2, SymbolCounter counter) {
        this.printInfo($this$processFunction, (FirCallableMemberDeclaration)symbol2.getFir(), counter);
        scope2.processDirectOverriddenFunctionsWithBaseScope(symbol2, (Function2<? super FirNamedFunctionSymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirNamedFunctionSymbol, FirTypeScope, ProcessorAction>($this$processFunction, this, counter){
            final /* synthetic */ SmartPrinter $this_processFunction;
            final /* synthetic */ FirScopeDumpHandler this$0;
            final /* synthetic */ SymbolCounter $counter;
            {
                this.$this_processFunction = $receiver;
                this.this$0 = $receiver2;
                this.$counter = $counter;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol overriden, @NotNull FirTypeScope baseScope) {
                void $this$withIndent$iv;
                Intrinsics.checkNotNullParameter((Object)overriden, (String)"overriden");
                Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
                SmartPrinter smartPrinter = this.$this_processFunction;
                FirScopeDumpHandler firScopeDumpHandler = this.this$0;
                SmartPrinter smartPrinter2 = this.$this_processFunction;
                SymbolCounter symbolCounter = this.$counter;
                boolean $i$f$withIndent = false;
                $this$withIndent$iv.pushIndent();
                boolean bl = false;
                FirScopeDumpHandler.access$processFunction(firScopeDumpHandler, smartPrinter2, overriden, baseScope, symbolCounter);
                $this$withIndent$iv.popIndent();
                return ProcessorAction.NEXT;
            }
        }));
    }

    private final void processProperties(SmartPrinter $this$processProperties, Name name2, FirTypeScope scope2) {
        List<FirVariableSymbol<?>> properties2 = FirScopeKt.getProperties(scope2, name2);
        for (FirVariableSymbol<?> property2 : properties2) {
            if (!(property2 instanceof FirPropertySymbol)) continue;
            this.processProperty($this$processProperties, (FirPropertySymbol)property2, scope2, new SymbolCounter());
            $this$processProperties.println(new Object[0]);
        }
    }

    private final void processProperty(SmartPrinter $this$processProperty, FirPropertySymbol symbol2, FirTypeScope scope2, SymbolCounter counter) {
        this.printInfo($this$processProperty, (FirCallableMemberDeclaration)symbol2.getFir(), counter);
        SmartPrinter $this$withIndent$iv = $this$processProperty;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        boolean bl = false;
        scope2.processDirectOverriddenPropertiesWithBaseScope(symbol2, (Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction>)((Function2)new Function2<FirPropertySymbol, FirTypeScope, ProcessorAction>(this, $this$processProperty, counter){
            final /* synthetic */ FirScopeDumpHandler this$0;
            final /* synthetic */ SmartPrinter $this_processProperty;
            final /* synthetic */ SymbolCounter $counter;
            {
                this.this$0 = $receiver;
                this.$this_processProperty = $receiver2;
                this.$counter = $counter;
                super(2);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirPropertySymbol overriden, @NotNull FirTypeScope baseScope) {
                Intrinsics.checkNotNullParameter((Object)overriden, (String)"overriden");
                Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
                FirScopeDumpHandler.access$processProperty(this.this$0, this.$this_processProperty, overriden, baseScope, this.$counter);
                return ProcessorAction.NEXT;
            }
        }));
        $this$withIndent$iv.popIndent();
    }

    private final void printInfo(SmartPrinter $this$printInfo, FirCallableMemberDeclaration<?> declaration2, SymbolCounter counter) {
        Object[] objectArray = new Object[]{"" + '[' + declaration2.getOrigin() + "]: "};
        $this$printInfo.print(objectArray);
        objectArray = new Object[1];
        Object object = FirRendererKt.render(declaration2, FirRenderer.RenderMode.Companion.getNoBodies());
        boolean bl = false;
        String string2 = object;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        objectArray[0] = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        $this$printInfo.print(objectArray);
        objectArray = new Object[1];
        object = declaration2.getDispatchReceiverType();
        objectArray[0] = Intrinsics.stringPlus((String)" from ", (Object)(object == null ? null : TypeRendererKt.render((ConeKotlinType)object)));
        $this$printInfo.print(objectArray);
        objectArray = new Object[]{" [id: " + counter.getIndex((AbstractFirBasedSymbol)declaration2.getSymbol()) + ']'};
        $this$printInfo.println(objectArray);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        File expectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles()), ".overrides.txt");
        String actualDump = this.dumper.generateResultingDump();
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
    }

    public static final /* synthetic */ void access$processFunction(FirScopeDumpHandler $this, SmartPrinter $receiver, FirNamedFunctionSymbol symbol2, FirTypeScope scope2, SymbolCounter counter) {
        $this.processFunction($receiver, symbol2, scope2, counter);
    }

    public static final /* synthetic */ void access$processProperty(FirScopeDumpHandler $this, SmartPrinter $receiver, FirPropertySymbol symbol2, FirTypeScope scope2, SymbolCounter counter) {
        $this.processProperty($receiver, symbol2, scope2, counter);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirScopeDumpHandler$SymbolCounter;", "", "()V", "counter", "", "map", "", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "getIndex", "symbol", "tests-common-new"})
    private static final class SymbolCounter {
        @NotNull
        private final Map<AbstractFirBasedSymbol<?>, Integer> map;
        private int counter;

        public SymbolCounter() {
            boolean bl = false;
            this.map = new LinkedHashMap();
        }

        public final int getIndex(@NotNull AbstractFirBasedSymbol<?> symbol2) {
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            Integer n = this.map.computeIfAbsent(symbol2, arg_0 -> SymbolCounter.getIndex$lambda-0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"map.computeIfAbsent(symbol) { counter++ }");
            return ((Number)n).intValue();
        }

        private static final Integer getIndex$lambda-0(SymbolCounter this$0, AbstractFirBasedSymbol it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            SymbolCounter symbolCounter = this$0;
            int n = symbolCounter.counter;
            symbolCounter.counter = n + 1;
            return n;
        }
    }
}

