/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirFailingTestSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "suppressIfNeeded", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "tests-common-new"})
public final class FirFailingTestSuppressor
extends AfterAnalysisChecker {
    public FirFailingTestSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        Object v0;
        File failFile;
        block1: {
            Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
            File testFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
            File file2 = testFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"testFile.parentFile");
            failFile = FilesKt.resolve((File)file2, (String)Intrinsics.stringPlus((String)FilesKt.getNameWithoutExtension((File)testFile), (Object)".fail"));
            Iterable $this$firstOrNull$iv = failedAssertions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WrappedException it = (WrappedException)element$iv;
                boolean bl = false;
                if (!(it instanceof WrappedException.FromFacade.Frontend || it instanceof WrappedException.FromFrontendHandler)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        WrappedException exceptionFromFir = v0;
        return failFile.exists() && exceptionFromFir != null ? CollectionsKt.emptyList() : (failFile.exists() && exceptionFromFir == null ? CollectionsKt.plus((Collection)failedAssertions, (Object)this.wrap((Throwable)((Object)new AssertionError((Object)Intrinsics.stringPlus((String)"Fail file exists but no exception was throw. Please remove ", (Object)failFile.getName()))))) : failedAssertions);
    }
}

